"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from datetime import date
from jsonpath import JSONPath
from meitner import errors, models, utils
from meitner._hooks import HookContext
from meitner.types import OptionalNullable, UNSET
from meitner.utils import get_security_from_env
from meitner.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Awaitable, Dict, List, Mapping, Optional, Union


class EmployeePlacements(BaseSDK):
    def list(
        self,
        *,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.EmployeePlacementListResponse]:
        r"""List EmployeePlacements

        Returns a paginated list of all `EmployeePlacements` in your organization.

        :param limit: The maximum number of EmployeePlacements to return (default: 50) when listing EmployeePlacements
        :param offset: The number of EmployeePlacements to skip before starting to return results (default: 0) when listing EmployeePlacements
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeePlacementListRequest(
            limit=limit,
            offset=offset,
        )

        req = self._build_request(
            method="GET",
            path="/employee-placement",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeePlacementList",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.EmployeePlacementListResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return None
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return None
            next_offset = offset + len(results[0])

            return self.list(
                limit=limit,
                offset=next_offset,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.EmployeePlacementListResponse(
                result=unmarshal_json_response(models.EmployeePlacementList, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def list_async(
        self,
        *,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.EmployeePlacementListResponse]:
        r"""List EmployeePlacements

        Returns a paginated list of all `EmployeePlacements` in your organization.

        :param limit: The maximum number of EmployeePlacements to return (default: 50) when listing EmployeePlacements
        :param offset: The number of EmployeePlacements to skip before starting to return results (default: 0) when listing EmployeePlacements
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeePlacementListRequest(
            limit=limit,
            offset=offset,
        )

        req = self._build_request_async(
            method="GET",
            path="/employee-placement",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeePlacementList",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Awaitable[Optional[models.EmployeePlacementListResponse]]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            async def empty_result():
                return None

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return empty_result()
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return empty_result()
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return empty_result()
            next_offset = offset + len(results[0])

            return self.list_async(
                limit=limit,
                offset=next_offset,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.EmployeePlacementListResponse(
                result=unmarshal_json_response(models.EmployeePlacementList, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def create(
        self,
        *,
        employee_id: str,
        school_id: str,
        start_date: date,
        external: Optional[
            Union[
                models.EmployeePlacementCreateExternal,
                models.EmployeePlacementCreateExternalTypedDict,
            ]
        ] = None,
        signature: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        roles: Optional[List[models.EmployeePlacementRole]] = None,
        end_date: OptionalNullable[date] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EmployeePlacement:
        r"""Create a new EmployeePlacement

        Create a new EmployeePlacement

        :param employee_id: The ID of the employee the placement belongs to
        :param school_id: The ID of the school the placement belongs to
        :param start_date: The start date of the placement for the employee
        :param external: External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included.
        :param signature: The signature of the employee
        :param title: The title of the employee
        :param roles: The roles of the employee
        :param end_date: The end date of the placement for the employee
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeePlacementCreate(
            external=utils.get_pydantic_model(
                external, Optional[models.EmployeePlacementCreateExternal]
            ),
            employee_id=employee_id,
            school_id=school_id,
            signature=signature,
            title=title,
            roles=roles,
            start_date=start_date,
            end_date=end_date,
        )

        req = self._build_request(
            method="POST",
            path="/employee-placement",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.EmployeePlacementCreate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeePlacementCreate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.EmployeePlacement, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.EmployeePlacementCreate422ResponseBodyErrorData, http_res
            )
            raise errors.EmployeePlacementCreate422ResponseBodyError(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        employee_id: str,
        school_id: str,
        start_date: date,
        external: Optional[
            Union[
                models.EmployeePlacementCreateExternal,
                models.EmployeePlacementCreateExternalTypedDict,
            ]
        ] = None,
        signature: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        roles: Optional[List[models.EmployeePlacementRole]] = None,
        end_date: OptionalNullable[date] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EmployeePlacement:
        r"""Create a new EmployeePlacement

        Create a new EmployeePlacement

        :param employee_id: The ID of the employee the placement belongs to
        :param school_id: The ID of the school the placement belongs to
        :param start_date: The start date of the placement for the employee
        :param external: External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included.
        :param signature: The signature of the employee
        :param title: The title of the employee
        :param roles: The roles of the employee
        :param end_date: The end date of the placement for the employee
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeePlacementCreate(
            external=utils.get_pydantic_model(
                external, Optional[models.EmployeePlacementCreateExternal]
            ),
            employee_id=employee_id,
            school_id=school_id,
            signature=signature,
            title=title,
            roles=roles,
            start_date=start_date,
            end_date=end_date,
        )

        req = self._build_request_async(
            method="POST",
            path="/employee-placement",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.EmployeePlacementCreate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeePlacementCreate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.EmployeePlacement, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.EmployeePlacementCreate422ResponseBodyErrorData, http_res
            )
            raise errors.EmployeePlacementCreate422ResponseBodyError(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def search(
        self,
        *,
        or_condition: bool,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        equals: OptionalNullable[
            Union[
                models.EmployeePlacementFilterEquals,
                models.EmployeePlacementFilterEqualsTypedDict,
            ]
        ] = UNSET,
        not_equals: OptionalNullable[
            Union[
                models.EmployeePlacementFilterNotEquals,
                models.EmployeePlacementFilterNotEqualsTypedDict,
            ]
        ] = UNSET,
        greater_than: OptionalNullable[
            Union[
                models.EmployeePlacementFilterGreaterThan,
                models.EmployeePlacementFilterGreaterThanTypedDict,
            ]
        ] = UNSET,
        smaller_than: OptionalNullable[
            Union[
                models.EmployeePlacementFilterSmallerThan,
                models.EmployeePlacementFilterSmallerThanTypedDict,
            ]
        ] = UNSET,
        greater_or_equal: OptionalNullable[
            Union[
                models.EmployeePlacementFilterGreaterOrEqual,
                models.EmployeePlacementFilterGreaterOrEqualTypedDict,
            ]
        ] = UNSET,
        smaller_or_equal: OptionalNullable[
            Union[
                models.EmployeePlacementFilterSmallerOrEqual,
                models.EmployeePlacementFilterSmallerOrEqualTypedDict,
            ]
        ] = UNSET,
        contains: OptionalNullable[
            Union[
                models.EmployeePlacementFilterContains,
                models.EmployeePlacementFilterContainsTypedDict,
            ]
        ] = UNSET,
        not_contains: OptionalNullable[
            Union[
                models.EmployeePlacementFilterNotContains,
                models.EmployeePlacementFilterNotContainsTypedDict,
            ]
        ] = UNSET,
        like: OptionalNullable[
            Union[
                models.EmployeePlacementFilterLike,
                models.EmployeePlacementFilterLikeTypedDict,
            ]
        ] = UNSET,
        not_like: OptionalNullable[
            Union[
                models.EmployeePlacementFilterNotLike,
                models.EmployeePlacementFilterNotLikeTypedDict,
            ]
        ] = UNSET,
        null: OptionalNullable[
            Union[
                models.EmployeePlacementFilterNull,
                models.EmployeePlacementFilterNullTypedDict,
            ]
        ] = UNSET,
        not_null: OptionalNullable[
            Union[
                models.EmployeePlacementFilterNotNull,
                models.EmployeePlacementFilterNotNullTypedDict,
            ]
        ] = UNSET,
        nested_filters: Optional[
            Union[
                List[models.EmployeePlacementFilter],
                List[models.EmployeePlacementFilterTypedDict],
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.EmployeePlacementSearchResponse]:
        r"""Search EmployeePlacements

        Search for `EmployeePlacements` with filtering capabilities.

        :param or_condition: OrCondition decides if this filter is within an OR-condition or AND-condition
        :param limit: The maximum number of EmployeePlacements to return (default: 50) when searching EmployeePlacements
        :param offset: The number of EmployeePlacements to skip before starting to return results (default: 0) when searching EmployeePlacements
        :param equals: Equality filters for EmployeePlacement
        :param not_equals: Inequality filters for EmployeePlacement
        :param greater_than: Greater than filters for EmployeePlacement
        :param smaller_than: Smaller than filters for EmployeePlacement
        :param greater_or_equal: Greater than or equal filters for EmployeePlacement
        :param smaller_or_equal: Smaller than or equal filters for EmployeePlacement
        :param contains: Contains filters for EmployeePlacement
        :param not_contains: Not contains filters for EmployeePlacement
        :param like: LIKE filters for EmployeePlacement
        :param not_like: NOT LIKE filters for EmployeePlacement
        :param null: Null filters for EmployeePlacement
        :param not_null: Not null filters for EmployeePlacement
        :param nested_filters: NestedFilters of the EmployeePlacement, useful for more complex filters
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeePlacementSearchRequest(
            limit=limit,
            offset=offset,
            employee_placement_filter=models.EmployeePlacementFilter(
                equals=utils.get_pydantic_model(
                    equals, OptionalNullable[models.EmployeePlacementFilterEquals]
                ),
                not_equals=utils.get_pydantic_model(
                    not_equals,
                    OptionalNullable[models.EmployeePlacementFilterNotEquals],
                ),
                greater_than=utils.get_pydantic_model(
                    greater_than,
                    OptionalNullable[models.EmployeePlacementFilterGreaterThan],
                ),
                smaller_than=utils.get_pydantic_model(
                    smaller_than,
                    OptionalNullable[models.EmployeePlacementFilterSmallerThan],
                ),
                greater_or_equal=utils.get_pydantic_model(
                    greater_or_equal,
                    OptionalNullable[models.EmployeePlacementFilterGreaterOrEqual],
                ),
                smaller_or_equal=utils.get_pydantic_model(
                    smaller_or_equal,
                    OptionalNullable[models.EmployeePlacementFilterSmallerOrEqual],
                ),
                contains=utils.get_pydantic_model(
                    contains, OptionalNullable[models.EmployeePlacementFilterContains]
                ),
                not_contains=utils.get_pydantic_model(
                    not_contains,
                    OptionalNullable[models.EmployeePlacementFilterNotContains],
                ),
                like=utils.get_pydantic_model(
                    like, OptionalNullable[models.EmployeePlacementFilterLike]
                ),
                not_like=utils.get_pydantic_model(
                    not_like, OptionalNullable[models.EmployeePlacementFilterNotLike]
                ),
                null=utils.get_pydantic_model(
                    null, OptionalNullable[models.EmployeePlacementFilterNull]
                ),
                not_null=utils.get_pydantic_model(
                    not_null, OptionalNullable[models.EmployeePlacementFilterNotNull]
                ),
                or_condition=or_condition,
                nested_filters=utils.get_pydantic_model(
                    nested_filters, Optional[List[models.EmployeePlacementFilter]]
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/employee-placement/_search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.employee_placement_filter,
                False,
                False,
                "json",
                models.EmployeePlacementFilter,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeePlacementSearch",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.EmployeePlacementSearchResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return None
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return None
            next_offset = offset + len(results[0])

            return self.search(
                or_condition=or_condition,
                limit=limit,
                offset=next_offset,
                equals=equals,
                not_equals=not_equals,
                greater_than=greater_than,
                smaller_than=smaller_than,
                greater_or_equal=greater_or_equal,
                smaller_or_equal=smaller_or_equal,
                contains=contains,
                not_contains=not_contains,
                like=like,
                not_like=not_like,
                null=null,
                not_null=not_null,
                nested_filters=nested_filters,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.EmployeePlacementSearchResponse(
                result=unmarshal_json_response(
                    models.EmployeePlacementSearch, http_res
                ),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.EmployeePlacementSearch422ResponseBodyErrorData, http_res
            )
            raise errors.EmployeePlacementSearch422ResponseBodyError(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def search_async(
        self,
        *,
        or_condition: bool,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        equals: OptionalNullable[
            Union[
                models.EmployeePlacementFilterEquals,
                models.EmployeePlacementFilterEqualsTypedDict,
            ]
        ] = UNSET,
        not_equals: OptionalNullable[
            Union[
                models.EmployeePlacementFilterNotEquals,
                models.EmployeePlacementFilterNotEqualsTypedDict,
            ]
        ] = UNSET,
        greater_than: OptionalNullable[
            Union[
                models.EmployeePlacementFilterGreaterThan,
                models.EmployeePlacementFilterGreaterThanTypedDict,
            ]
        ] = UNSET,
        smaller_than: OptionalNullable[
            Union[
                models.EmployeePlacementFilterSmallerThan,
                models.EmployeePlacementFilterSmallerThanTypedDict,
            ]
        ] = UNSET,
        greater_or_equal: OptionalNullable[
            Union[
                models.EmployeePlacementFilterGreaterOrEqual,
                models.EmployeePlacementFilterGreaterOrEqualTypedDict,
            ]
        ] = UNSET,
        smaller_or_equal: OptionalNullable[
            Union[
                models.EmployeePlacementFilterSmallerOrEqual,
                models.EmployeePlacementFilterSmallerOrEqualTypedDict,
            ]
        ] = UNSET,
        contains: OptionalNullable[
            Union[
                models.EmployeePlacementFilterContains,
                models.EmployeePlacementFilterContainsTypedDict,
            ]
        ] = UNSET,
        not_contains: OptionalNullable[
            Union[
                models.EmployeePlacementFilterNotContains,
                models.EmployeePlacementFilterNotContainsTypedDict,
            ]
        ] = UNSET,
        like: OptionalNullable[
            Union[
                models.EmployeePlacementFilterLike,
                models.EmployeePlacementFilterLikeTypedDict,
            ]
        ] = UNSET,
        not_like: OptionalNullable[
            Union[
                models.EmployeePlacementFilterNotLike,
                models.EmployeePlacementFilterNotLikeTypedDict,
            ]
        ] = UNSET,
        null: OptionalNullable[
            Union[
                models.EmployeePlacementFilterNull,
                models.EmployeePlacementFilterNullTypedDict,
            ]
        ] = UNSET,
        not_null: OptionalNullable[
            Union[
                models.EmployeePlacementFilterNotNull,
                models.EmployeePlacementFilterNotNullTypedDict,
            ]
        ] = UNSET,
        nested_filters: Optional[
            Union[
                List[models.EmployeePlacementFilter],
                List[models.EmployeePlacementFilterTypedDict],
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.EmployeePlacementSearchResponse]:
        r"""Search EmployeePlacements

        Search for `EmployeePlacements` with filtering capabilities.

        :param or_condition: OrCondition decides if this filter is within an OR-condition or AND-condition
        :param limit: The maximum number of EmployeePlacements to return (default: 50) when searching EmployeePlacements
        :param offset: The number of EmployeePlacements to skip before starting to return results (default: 0) when searching EmployeePlacements
        :param equals: Equality filters for EmployeePlacement
        :param not_equals: Inequality filters for EmployeePlacement
        :param greater_than: Greater than filters for EmployeePlacement
        :param smaller_than: Smaller than filters for EmployeePlacement
        :param greater_or_equal: Greater than or equal filters for EmployeePlacement
        :param smaller_or_equal: Smaller than or equal filters for EmployeePlacement
        :param contains: Contains filters for EmployeePlacement
        :param not_contains: Not contains filters for EmployeePlacement
        :param like: LIKE filters for EmployeePlacement
        :param not_like: NOT LIKE filters for EmployeePlacement
        :param null: Null filters for EmployeePlacement
        :param not_null: Not null filters for EmployeePlacement
        :param nested_filters: NestedFilters of the EmployeePlacement, useful for more complex filters
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeePlacementSearchRequest(
            limit=limit,
            offset=offset,
            employee_placement_filter=models.EmployeePlacementFilter(
                equals=utils.get_pydantic_model(
                    equals, OptionalNullable[models.EmployeePlacementFilterEquals]
                ),
                not_equals=utils.get_pydantic_model(
                    not_equals,
                    OptionalNullable[models.EmployeePlacementFilterNotEquals],
                ),
                greater_than=utils.get_pydantic_model(
                    greater_than,
                    OptionalNullable[models.EmployeePlacementFilterGreaterThan],
                ),
                smaller_than=utils.get_pydantic_model(
                    smaller_than,
                    OptionalNullable[models.EmployeePlacementFilterSmallerThan],
                ),
                greater_or_equal=utils.get_pydantic_model(
                    greater_or_equal,
                    OptionalNullable[models.EmployeePlacementFilterGreaterOrEqual],
                ),
                smaller_or_equal=utils.get_pydantic_model(
                    smaller_or_equal,
                    OptionalNullable[models.EmployeePlacementFilterSmallerOrEqual],
                ),
                contains=utils.get_pydantic_model(
                    contains, OptionalNullable[models.EmployeePlacementFilterContains]
                ),
                not_contains=utils.get_pydantic_model(
                    not_contains,
                    OptionalNullable[models.EmployeePlacementFilterNotContains],
                ),
                like=utils.get_pydantic_model(
                    like, OptionalNullable[models.EmployeePlacementFilterLike]
                ),
                not_like=utils.get_pydantic_model(
                    not_like, OptionalNullable[models.EmployeePlacementFilterNotLike]
                ),
                null=utils.get_pydantic_model(
                    null, OptionalNullable[models.EmployeePlacementFilterNull]
                ),
                not_null=utils.get_pydantic_model(
                    not_null, OptionalNullable[models.EmployeePlacementFilterNotNull]
                ),
                or_condition=or_condition,
                nested_filters=utils.get_pydantic_model(
                    nested_filters, Optional[List[models.EmployeePlacementFilter]]
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/employee-placement/_search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.employee_placement_filter,
                False,
                False,
                "json",
                models.EmployeePlacementFilter,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeePlacementSearch",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Awaitable[Optional[models.EmployeePlacementSearchResponse]]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            async def empty_result():
                return None

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return empty_result()
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return empty_result()
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return empty_result()
            next_offset = offset + len(results[0])

            return self.search_async(
                or_condition=or_condition,
                limit=limit,
                offset=next_offset,
                equals=equals,
                not_equals=not_equals,
                greater_than=greater_than,
                smaller_than=smaller_than,
                greater_or_equal=greater_or_equal,
                smaller_or_equal=smaller_or_equal,
                contains=contains,
                not_contains=not_contains,
                like=like,
                not_like=not_like,
                null=null,
                not_null=not_null,
                nested_filters=nested_filters,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.EmployeePlacementSearchResponse(
                result=unmarshal_json_response(
                    models.EmployeePlacementSearch, http_res
                ),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.EmployeePlacementSearch422ResponseBodyErrorData, http_res
            )
            raise errors.EmployeePlacementSearch422ResponseBodyError(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def get(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EmployeePlacement:
        r"""Get a EmployeePlacement

        Retrieves the `EmployeePlacement` with the given ID.

        :param id: The unique identifier of the EmployeePlacement to retrieve
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeePlacementGetRequest(
            id=id,
        )

        req = self._build_request(
            method="GET",
            path="/employee-placement/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeePlacementGet",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.EmployeePlacement, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def get_async(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EmployeePlacement:
        r"""Get a EmployeePlacement

        Retrieves the `EmployeePlacement` with the given ID.

        :param id: The unique identifier of the EmployeePlacement to retrieve
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeePlacementGetRequest(
            id=id,
        )

        req = self._build_request_async(
            method="GET",
            path="/employee-placement/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeePlacementGet",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.EmployeePlacement, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def delete(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a EmployeePlacement

        Delete a EmployeePlacement

        :param id: The unique identifier of the EmployeePlacement to delete
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeePlacementDeleteRequest(
            id=id,
        )

        req = self._build_request(
            method="DELETE",
            path="/employee-placement/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeePlacementDelete",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def delete_async(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a EmployeePlacement

        Delete a EmployeePlacement

        :param id: The unique identifier of the EmployeePlacement to delete
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeePlacementDeleteRequest(
            id=id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/employee-placement/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeePlacementDelete",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def update(
        self,
        *,
        id: str,
        start_date: date,
        external: Optional[
            Union[
                models.EmployeePlacementUpdateExternal,
                models.EmployeePlacementUpdateExternalTypedDict,
            ]
        ] = None,
        signature: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        roles: Optional[List[models.EmployeePlacementRole]] = None,
        end_date: OptionalNullable[date] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EmployeePlacement:
        r"""Update a EmployeePlacement

        Update a EmployeePlacement

        :param id: The unique identifier of the EmployeePlacement to update
        :param start_date: The start date of the placement for the employee
        :param external: External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included.
        :param signature: The signature of the employee
        :param title: The title of the employee
        :param roles: The roles of the employee
        :param end_date: The end date of the placement for the employee
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeePlacementUpdateRequest(
            id=id,
            employee_placement_update=models.EmployeePlacementUpdate(
                external=utils.get_pydantic_model(
                    external, Optional[models.EmployeePlacementUpdateExternal]
                ),
                signature=signature,
                title=title,
                roles=roles,
                start_date=start_date,
                end_date=end_date,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/employee-placement/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.employee_placement_update,
                False,
                False,
                "json",
                models.EmployeePlacementUpdate,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeePlacementUpdate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.EmployeePlacement, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.EmployeePlacementUpdate422ResponseBodyErrorData, http_res
            )
            raise errors.EmployeePlacementUpdate422ResponseBodyError(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def update_async(
        self,
        *,
        id: str,
        start_date: date,
        external: Optional[
            Union[
                models.EmployeePlacementUpdateExternal,
                models.EmployeePlacementUpdateExternalTypedDict,
            ]
        ] = None,
        signature: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        roles: Optional[List[models.EmployeePlacementRole]] = None,
        end_date: OptionalNullable[date] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EmployeePlacement:
        r"""Update a EmployeePlacement

        Update a EmployeePlacement

        :param id: The unique identifier of the EmployeePlacement to update
        :param start_date: The start date of the placement for the employee
        :param external: External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included.
        :param signature: The signature of the employee
        :param title: The title of the employee
        :param roles: The roles of the employee
        :param end_date: The end date of the placement for the employee
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeePlacementUpdateRequest(
            id=id,
            employee_placement_update=models.EmployeePlacementUpdate(
                external=utils.get_pydantic_model(
                    external, Optional[models.EmployeePlacementUpdateExternal]
                ),
                signature=signature,
                title=title,
                roles=roles,
                start_date=start_date,
                end_date=end_date,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/employee-placement/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.employee_placement_update,
                False,
                False,
                "json",
                models.EmployeePlacementUpdate,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeePlacementUpdate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.EmployeePlacement, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.EmployeePlacementUpdate422ResponseBodyErrorData, http_res
            )
            raise errors.EmployeePlacementUpdate422ResponseBodyError(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)
