"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from datetime import date
from jsonpath import JSONPath
from meitner import errors, models, utils
from meitner._hooks import HookContext
from meitner.types import OptionalNullable, UNSET
from meitner.utils import get_security_from_env
from meitner.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Awaitable, Dict, List, Mapping, Optional, Union


class Employees(BaseSDK):
    def list(
        self,
        *,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.EmployeeListResponse]:
        r"""List Employees

        Returns a paginated list of all `Employees` in your organization.

        :param limit: The maximum number of Employees to return (default: 50) when listing Employees
        :param offset: The number of Employees to skip before starting to return results (default: 0) when listing Employees
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeeListRequest(
            limit=limit,
            offset=offset,
        )

        req = self._build_request(
            method="GET",
            path="/employee",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeeList",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.EmployeeListResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return None
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return None
            next_offset = offset + len(results[0])

            return self.list(
                limit=limit,
                offset=next_offset,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.EmployeeListResponse(
                result=unmarshal_json_response(models.EmployeeList, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def list_async(
        self,
        *,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.EmployeeListResponse]:
        r"""List Employees

        Returns a paginated list of all `Employees` in your organization.

        :param limit: The maximum number of Employees to return (default: 50) when listing Employees
        :param offset: The number of Employees to skip before starting to return results (default: 0) when listing Employees
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeeListRequest(
            limit=limit,
            offset=offset,
        )

        req = self._build_request_async(
            method="GET",
            path="/employee",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeeList",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Awaitable[Optional[models.EmployeeListResponse]]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            async def empty_result():
                return None

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return empty_result()
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return empty_result()
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return empty_result()
            next_offset = offset + len(results[0])

            return self.list_async(
                limit=limit,
                offset=next_offset,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.EmployeeListResponse(
                result=unmarshal_json_response(models.EmployeeList, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def create(
        self,
        *,
        identity_number: str,
        first_name: str,
        last_name: str,
        external: Optional[
            Union[models.EmployeeCreateExternal, models.EmployeeCreateExternalTypedDict]
        ] = None,
        gender: OptionalNullable[models.EmployeeCreateGender] = UNSET,
        identity_temporary: Optional[bool] = False,
        date_of_birth: OptionalNullable[date] = UNSET,
        address: Optional[
            Union[models.EmployeeCreateAddress, models.EmployeeCreateAddressTypedDict]
        ] = None,
        email_address1: OptionalNullable[str] = UNSET,
        email_address2: OptionalNullable[str] = UNSET,
        phone_number1: OptionalNullable[str] = UNSET,
        phone_number2: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Employee:
        r"""Create a new Employee

        Create a new Employee

        :param identity_number: The identity number of the employee, must be unique within the organization.
        :param first_name: The first name of the employee
        :param last_name: The last name of the employee
        :param external: ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee placement, the Source-field is not included.
        :param gender: The gender of the employee
        :param identity_temporary: If the identity number is temporary for the employee
        :param date_of_birth: The date of birth of the employee
        :param address: The address of the employee
        :param email_address1: The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization. Can be used to login to the system if password-authentication is enabled for the organization.
        :param email_address2: The secondary email address of the employee, will not be used within the system, but will be displayed for contact information.
        :param phone_number1: The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization.
        :param phone_number2: The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeeCreate(
            external=utils.get_pydantic_model(
                external, Optional[models.EmployeeCreateExternal]
            ),
            gender=gender,
            identity_number=identity_number,
            identity_temporary=identity_temporary,
            first_name=first_name,
            last_name=last_name,
            date_of_birth=date_of_birth,
            address=utils.get_pydantic_model(
                address, Optional[models.EmployeeCreateAddress]
            ),
            email_address1=email_address1,
            email_address2=email_address2,
            phone_number1=phone_number1,
            phone_number2=phone_number2,
        )

        req = self._build_request(
            method="POST",
            path="/employee",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.EmployeeCreate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeeCreate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.Employee, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.EmployeeCreate422ResponseBodyErrorData, http_res
            )
            raise errors.EmployeeCreate422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        identity_number: str,
        first_name: str,
        last_name: str,
        external: Optional[
            Union[models.EmployeeCreateExternal, models.EmployeeCreateExternalTypedDict]
        ] = None,
        gender: OptionalNullable[models.EmployeeCreateGender] = UNSET,
        identity_temporary: Optional[bool] = False,
        date_of_birth: OptionalNullable[date] = UNSET,
        address: Optional[
            Union[models.EmployeeCreateAddress, models.EmployeeCreateAddressTypedDict]
        ] = None,
        email_address1: OptionalNullable[str] = UNSET,
        email_address2: OptionalNullable[str] = UNSET,
        phone_number1: OptionalNullable[str] = UNSET,
        phone_number2: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Employee:
        r"""Create a new Employee

        Create a new Employee

        :param identity_number: The identity number of the employee, must be unique within the organization.
        :param first_name: The first name of the employee
        :param last_name: The last name of the employee
        :param external: ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee placement, the Source-field is not included.
        :param gender: The gender of the employee
        :param identity_temporary: If the identity number is temporary for the employee
        :param date_of_birth: The date of birth of the employee
        :param address: The address of the employee
        :param email_address1: The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization. Can be used to login to the system if password-authentication is enabled for the organization.
        :param email_address2: The secondary email address of the employee, will not be used within the system, but will be displayed for contact information.
        :param phone_number1: The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization.
        :param phone_number2: The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeeCreate(
            external=utils.get_pydantic_model(
                external, Optional[models.EmployeeCreateExternal]
            ),
            gender=gender,
            identity_number=identity_number,
            identity_temporary=identity_temporary,
            first_name=first_name,
            last_name=last_name,
            date_of_birth=date_of_birth,
            address=utils.get_pydantic_model(
                address, Optional[models.EmployeeCreateAddress]
            ),
            email_address1=email_address1,
            email_address2=email_address2,
            phone_number1=phone_number1,
            phone_number2=phone_number2,
        )

        req = self._build_request_async(
            method="POST",
            path="/employee",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.EmployeeCreate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeeCreate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.Employee, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.EmployeeCreate422ResponseBodyErrorData, http_res
            )
            raise errors.EmployeeCreate422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def search(
        self,
        *,
        or_condition: bool,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        equals: OptionalNullable[
            Union[models.EmployeeFilterEquals, models.EmployeeFilterEqualsTypedDict]
        ] = UNSET,
        not_equals: OptionalNullable[
            Union[
                models.EmployeeFilterNotEquals, models.EmployeeFilterNotEqualsTypedDict
            ]
        ] = UNSET,
        greater_than: OptionalNullable[
            Union[
                models.EmployeeFilterGreaterThan,
                models.EmployeeFilterGreaterThanTypedDict,
            ]
        ] = UNSET,
        smaller_than: OptionalNullable[
            Union[
                models.EmployeeFilterSmallerThan,
                models.EmployeeFilterSmallerThanTypedDict,
            ]
        ] = UNSET,
        greater_or_equal: OptionalNullable[
            Union[
                models.EmployeeFilterGreaterOrEqual,
                models.EmployeeFilterGreaterOrEqualTypedDict,
            ]
        ] = UNSET,
        smaller_or_equal: OptionalNullable[
            Union[
                models.EmployeeFilterSmallerOrEqual,
                models.EmployeeFilterSmallerOrEqualTypedDict,
            ]
        ] = UNSET,
        contains: OptionalNullable[
            Union[models.EmployeeFilterContains, models.EmployeeFilterContainsTypedDict]
        ] = UNSET,
        not_contains: OptionalNullable[
            Union[
                models.EmployeeFilterNotContains,
                models.EmployeeFilterNotContainsTypedDict,
            ]
        ] = UNSET,
        like: OptionalNullable[
            Union[models.EmployeeFilterLike, models.EmployeeFilterLikeTypedDict]
        ] = UNSET,
        not_like: OptionalNullable[
            Union[models.EmployeeFilterNotLike, models.EmployeeFilterNotLikeTypedDict]
        ] = UNSET,
        null: OptionalNullable[
            Union[models.EmployeeFilterNull, models.EmployeeFilterNullTypedDict]
        ] = UNSET,
        not_null: OptionalNullable[
            Union[models.EmployeeFilterNotNull, models.EmployeeFilterNotNullTypedDict]
        ] = UNSET,
        nested_filters: Optional[
            Union[List[models.EmployeeFilter], List[models.EmployeeFilterTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.EmployeeSearchResponse]:
        r"""Search Employees

        Search for `Employees` with filtering capabilities.

        :param or_condition: OrCondition decides if this filter is within an OR-condition or AND-condition
        :param limit: The maximum number of Employees to return (default: 50) when searching Employees
        :param offset: The number of Employees to skip before starting to return results (default: 0) when searching Employees
        :param equals: Equality filters for Employee
        :param not_equals: Inequality filters for Employee
        :param greater_than: Greater than filters for Employee
        :param smaller_than: Smaller than filters for Employee
        :param greater_or_equal: Greater than or equal filters for Employee
        :param smaller_or_equal: Smaller than or equal filters for Employee
        :param contains: Contains filters for Employee
        :param not_contains: Not contains filters for Employee
        :param like: LIKE filters for Employee
        :param not_like: NOT LIKE filters for Employee
        :param null: Null filters for Employee
        :param not_null: Not null filters for Employee
        :param nested_filters: NestedFilters of the Employee, useful for more complex filters
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeeSearchRequest(
            limit=limit,
            offset=offset,
            employee_filter=models.EmployeeFilter(
                equals=utils.get_pydantic_model(
                    equals, OptionalNullable[models.EmployeeFilterEquals]
                ),
                not_equals=utils.get_pydantic_model(
                    not_equals, OptionalNullable[models.EmployeeFilterNotEquals]
                ),
                greater_than=utils.get_pydantic_model(
                    greater_than, OptionalNullable[models.EmployeeFilterGreaterThan]
                ),
                smaller_than=utils.get_pydantic_model(
                    smaller_than, OptionalNullable[models.EmployeeFilterSmallerThan]
                ),
                greater_or_equal=utils.get_pydantic_model(
                    greater_or_equal,
                    OptionalNullable[models.EmployeeFilterGreaterOrEqual],
                ),
                smaller_or_equal=utils.get_pydantic_model(
                    smaller_or_equal,
                    OptionalNullable[models.EmployeeFilterSmallerOrEqual],
                ),
                contains=utils.get_pydantic_model(
                    contains, OptionalNullable[models.EmployeeFilterContains]
                ),
                not_contains=utils.get_pydantic_model(
                    not_contains, OptionalNullable[models.EmployeeFilterNotContains]
                ),
                like=utils.get_pydantic_model(
                    like, OptionalNullable[models.EmployeeFilterLike]
                ),
                not_like=utils.get_pydantic_model(
                    not_like, OptionalNullable[models.EmployeeFilterNotLike]
                ),
                null=utils.get_pydantic_model(
                    null, OptionalNullable[models.EmployeeFilterNull]
                ),
                not_null=utils.get_pydantic_model(
                    not_null, OptionalNullable[models.EmployeeFilterNotNull]
                ),
                or_condition=or_condition,
                nested_filters=utils.get_pydantic_model(
                    nested_filters, Optional[List[models.EmployeeFilter]]
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/employee/_search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.employee_filter, False, False, "json", models.EmployeeFilter
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeeSearch",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.EmployeeSearchResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return None
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return None
            next_offset = offset + len(results[0])

            return self.search(
                or_condition=or_condition,
                limit=limit,
                offset=next_offset,
                equals=equals,
                not_equals=not_equals,
                greater_than=greater_than,
                smaller_than=smaller_than,
                greater_or_equal=greater_or_equal,
                smaller_or_equal=smaller_or_equal,
                contains=contains,
                not_contains=not_contains,
                like=like,
                not_like=not_like,
                null=null,
                not_null=not_null,
                nested_filters=nested_filters,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.EmployeeSearchResponse(
                result=unmarshal_json_response(models.EmployeeSearch, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.EmployeeSearch422ResponseBodyErrorData, http_res
            )
            raise errors.EmployeeSearch422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def search_async(
        self,
        *,
        or_condition: bool,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        equals: OptionalNullable[
            Union[models.EmployeeFilterEquals, models.EmployeeFilterEqualsTypedDict]
        ] = UNSET,
        not_equals: OptionalNullable[
            Union[
                models.EmployeeFilterNotEquals, models.EmployeeFilterNotEqualsTypedDict
            ]
        ] = UNSET,
        greater_than: OptionalNullable[
            Union[
                models.EmployeeFilterGreaterThan,
                models.EmployeeFilterGreaterThanTypedDict,
            ]
        ] = UNSET,
        smaller_than: OptionalNullable[
            Union[
                models.EmployeeFilterSmallerThan,
                models.EmployeeFilterSmallerThanTypedDict,
            ]
        ] = UNSET,
        greater_or_equal: OptionalNullable[
            Union[
                models.EmployeeFilterGreaterOrEqual,
                models.EmployeeFilterGreaterOrEqualTypedDict,
            ]
        ] = UNSET,
        smaller_or_equal: OptionalNullable[
            Union[
                models.EmployeeFilterSmallerOrEqual,
                models.EmployeeFilterSmallerOrEqualTypedDict,
            ]
        ] = UNSET,
        contains: OptionalNullable[
            Union[models.EmployeeFilterContains, models.EmployeeFilterContainsTypedDict]
        ] = UNSET,
        not_contains: OptionalNullable[
            Union[
                models.EmployeeFilterNotContains,
                models.EmployeeFilterNotContainsTypedDict,
            ]
        ] = UNSET,
        like: OptionalNullable[
            Union[models.EmployeeFilterLike, models.EmployeeFilterLikeTypedDict]
        ] = UNSET,
        not_like: OptionalNullable[
            Union[models.EmployeeFilterNotLike, models.EmployeeFilterNotLikeTypedDict]
        ] = UNSET,
        null: OptionalNullable[
            Union[models.EmployeeFilterNull, models.EmployeeFilterNullTypedDict]
        ] = UNSET,
        not_null: OptionalNullable[
            Union[models.EmployeeFilterNotNull, models.EmployeeFilterNotNullTypedDict]
        ] = UNSET,
        nested_filters: Optional[
            Union[List[models.EmployeeFilter], List[models.EmployeeFilterTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.EmployeeSearchResponse]:
        r"""Search Employees

        Search for `Employees` with filtering capabilities.

        :param or_condition: OrCondition decides if this filter is within an OR-condition or AND-condition
        :param limit: The maximum number of Employees to return (default: 50) when searching Employees
        :param offset: The number of Employees to skip before starting to return results (default: 0) when searching Employees
        :param equals: Equality filters for Employee
        :param not_equals: Inequality filters for Employee
        :param greater_than: Greater than filters for Employee
        :param smaller_than: Smaller than filters for Employee
        :param greater_or_equal: Greater than or equal filters for Employee
        :param smaller_or_equal: Smaller than or equal filters for Employee
        :param contains: Contains filters for Employee
        :param not_contains: Not contains filters for Employee
        :param like: LIKE filters for Employee
        :param not_like: NOT LIKE filters for Employee
        :param null: Null filters for Employee
        :param not_null: Not null filters for Employee
        :param nested_filters: NestedFilters of the Employee, useful for more complex filters
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeeSearchRequest(
            limit=limit,
            offset=offset,
            employee_filter=models.EmployeeFilter(
                equals=utils.get_pydantic_model(
                    equals, OptionalNullable[models.EmployeeFilterEquals]
                ),
                not_equals=utils.get_pydantic_model(
                    not_equals, OptionalNullable[models.EmployeeFilterNotEquals]
                ),
                greater_than=utils.get_pydantic_model(
                    greater_than, OptionalNullable[models.EmployeeFilterGreaterThan]
                ),
                smaller_than=utils.get_pydantic_model(
                    smaller_than, OptionalNullable[models.EmployeeFilterSmallerThan]
                ),
                greater_or_equal=utils.get_pydantic_model(
                    greater_or_equal,
                    OptionalNullable[models.EmployeeFilterGreaterOrEqual],
                ),
                smaller_or_equal=utils.get_pydantic_model(
                    smaller_or_equal,
                    OptionalNullable[models.EmployeeFilterSmallerOrEqual],
                ),
                contains=utils.get_pydantic_model(
                    contains, OptionalNullable[models.EmployeeFilterContains]
                ),
                not_contains=utils.get_pydantic_model(
                    not_contains, OptionalNullable[models.EmployeeFilterNotContains]
                ),
                like=utils.get_pydantic_model(
                    like, OptionalNullable[models.EmployeeFilterLike]
                ),
                not_like=utils.get_pydantic_model(
                    not_like, OptionalNullable[models.EmployeeFilterNotLike]
                ),
                null=utils.get_pydantic_model(
                    null, OptionalNullable[models.EmployeeFilterNull]
                ),
                not_null=utils.get_pydantic_model(
                    not_null, OptionalNullable[models.EmployeeFilterNotNull]
                ),
                or_condition=or_condition,
                nested_filters=utils.get_pydantic_model(
                    nested_filters, Optional[List[models.EmployeeFilter]]
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/employee/_search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.employee_filter, False, False, "json", models.EmployeeFilter
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeeSearch",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Awaitable[Optional[models.EmployeeSearchResponse]]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            async def empty_result():
                return None

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return empty_result()
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return empty_result()
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return empty_result()
            next_offset = offset + len(results[0])

            return self.search_async(
                or_condition=or_condition,
                limit=limit,
                offset=next_offset,
                equals=equals,
                not_equals=not_equals,
                greater_than=greater_than,
                smaller_than=smaller_than,
                greater_or_equal=greater_or_equal,
                smaller_or_equal=smaller_or_equal,
                contains=contains,
                not_contains=not_contains,
                like=like,
                not_like=not_like,
                null=null,
                not_null=not_null,
                nested_filters=nested_filters,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.EmployeeSearchResponse(
                result=unmarshal_json_response(models.EmployeeSearch, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.EmployeeSearch422ResponseBodyErrorData, http_res
            )
            raise errors.EmployeeSearch422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def get(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Employee:
        r"""Get a Employee

        Retrieves the `Employee` with the given ID.

        :param id: The unique identifier of the Employee to retrieve
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeeGetRequest(
            id=id,
        )

        req = self._build_request(
            method="GET",
            path="/employee/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeeGet",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Employee, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def get_async(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Employee:
        r"""Get a Employee

        Retrieves the `Employee` with the given ID.

        :param id: The unique identifier of the Employee to retrieve
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeeGetRequest(
            id=id,
        )

        req = self._build_request_async(
            method="GET",
            path="/employee/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeeGet",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Employee, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def delete(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a Employee

        Delete a Employee

        :param id: The unique identifier of the Employee to delete
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeeDeleteRequest(
            id=id,
        )

        req = self._build_request(
            method="DELETE",
            path="/employee/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeeDelete",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def delete_async(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a Employee

        Delete a Employee

        :param id: The unique identifier of the Employee to delete
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeeDeleteRequest(
            id=id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/employee/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeeDelete",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def update(
        self,
        *,
        id: str,
        identity_number: str,
        first_name: str,
        last_name: str,
        external: Optional[
            Union[models.EmployeeUpdateExternal, models.EmployeeUpdateExternalTypedDict]
        ] = None,
        gender: OptionalNullable[models.EmployeeUpdateGender] = UNSET,
        identity_temporary: Optional[bool] = False,
        date_of_birth: OptionalNullable[date] = UNSET,
        address: Optional[
            Union[models.EmployeeUpdateAddress, models.EmployeeUpdateAddressTypedDict]
        ] = None,
        email_address1: OptionalNullable[str] = UNSET,
        email_address2: OptionalNullable[str] = UNSET,
        phone_number1: OptionalNullable[str] = UNSET,
        phone_number2: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Employee:
        r"""Update a Employee

        Update a Employee

        :param id: The unique identifier of the Employee to update
        :param identity_number: The identity number of the employee, must be unique within the organization.
        :param first_name: The first name of the employee
        :param last_name: The last name of the employee
        :param external: ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee placement, the Source-field is not included.
        :param gender: The gender of the employee
        :param identity_temporary: If the identity number is temporary for the employee
        :param date_of_birth: The date of birth of the employee
        :param address: The address of the employee
        :param email_address1: The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization. Can be used to login to the system if password-authentication is enabled for the organization.
        :param email_address2: The secondary email address of the employee, will not be used within the system, but will be displayed for contact information.
        :param phone_number1: The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization.
        :param phone_number2: The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeeUpdateRequest(
            id=id,
            employee_update=models.EmployeeUpdate(
                external=utils.get_pydantic_model(
                    external, Optional[models.EmployeeUpdateExternal]
                ),
                gender=gender,
                identity_number=identity_number,
                identity_temporary=identity_temporary,
                first_name=first_name,
                last_name=last_name,
                date_of_birth=date_of_birth,
                address=utils.get_pydantic_model(
                    address, Optional[models.EmployeeUpdateAddress]
                ),
                email_address1=email_address1,
                email_address2=email_address2,
                phone_number1=phone_number1,
                phone_number2=phone_number2,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/employee/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.employee_update, False, False, "json", models.EmployeeUpdate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeeUpdate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Employee, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.EmployeeUpdate422ResponseBodyErrorData, http_res
            )
            raise errors.EmployeeUpdate422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def update_async(
        self,
        *,
        id: str,
        identity_number: str,
        first_name: str,
        last_name: str,
        external: Optional[
            Union[models.EmployeeUpdateExternal, models.EmployeeUpdateExternalTypedDict]
        ] = None,
        gender: OptionalNullable[models.EmployeeUpdateGender] = UNSET,
        identity_temporary: Optional[bool] = False,
        date_of_birth: OptionalNullable[date] = UNSET,
        address: Optional[
            Union[models.EmployeeUpdateAddress, models.EmployeeUpdateAddressTypedDict]
        ] = None,
        email_address1: OptionalNullable[str] = UNSET,
        email_address2: OptionalNullable[str] = UNSET,
        phone_number1: OptionalNullable[str] = UNSET,
        phone_number2: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Employee:
        r"""Update a Employee

        Update a Employee

        :param id: The unique identifier of the Employee to update
        :param identity_number: The identity number of the employee, must be unique within the organization.
        :param first_name: The first name of the employee
        :param last_name: The last name of the employee
        :param external: ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee placement, the Source-field is not included.
        :param gender: The gender of the employee
        :param identity_temporary: If the identity number is temporary for the employee
        :param date_of_birth: The date of birth of the employee
        :param address: The address of the employee
        :param email_address1: The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization. Can be used to login to the system if password-authentication is enabled for the organization.
        :param email_address2: The secondary email address of the employee, will not be used within the system, but will be displayed for contact information.
        :param phone_number1: The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization.
        :param phone_number2: The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EmployeeUpdateRequest(
            id=id,
            employee_update=models.EmployeeUpdate(
                external=utils.get_pydantic_model(
                    external, Optional[models.EmployeeUpdateExternal]
                ),
                gender=gender,
                identity_number=identity_number,
                identity_temporary=identity_temporary,
                first_name=first_name,
                last_name=last_name,
                date_of_birth=date_of_birth,
                address=utils.get_pydantic_model(
                    address, Optional[models.EmployeeUpdateAddress]
                ),
                email_address1=email_address1,
                email_address2=email_address2,
                phone_number1=phone_number1,
                phone_number2=phone_number2,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/employee/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.employee_update, False, False, "json", models.EmployeeUpdate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="EmployeeUpdate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Employee, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.EmployeeUpdate422ResponseBodyErrorData, http_res
            )
            raise errors.EmployeeUpdate422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)
