"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from meitner.errors import MeitnerError
from meitner.models import error403responsebody as models_error403responsebody
from meitner.types import BaseModel
from typing import Optional


class Error403ResponseBodyData(BaseModel):
    error: models_error403responsebody.Error403ResponseBodyError


@dataclass(frozen=True)
class Error403ResponseBody(MeitnerError):
    r"""Forbidden - Request is authenticated, but the user is not allowed to perform the operation"""

    data: Error403ResponseBodyData = field(hash=False)

    def __init__(
        self,
        data: Error403ResponseBodyData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
