"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from meitner.errors import MeitnerError
from meitner.models import error409responsebody as models_error409responsebody
from meitner.types import BaseModel
from typing import Optional


class Error409ResponseBodyData(BaseModel):
    error: models_error409responsebody.Error409ResponseBodyError


@dataclass(frozen=True)
class Error409ResponseBody(MeitnerError):
    r"""Conflict - The request could not be completed due to a conflict"""

    data: Error409ResponseBodyData = field(hash=False)

    def __init__(
        self,
        data: Error409ResponseBodyData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
