"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from meitner.errors import MeitnerError
from meitner.models import error429responsebody as models_error429responsebody
from meitner.types import BaseModel
from typing import Optional


class Error429ResponseBodyData(BaseModel):
    error: models_error429responsebody.Error429ResponseBodyError


@dataclass(frozen=True)
class Error429ResponseBody(MeitnerError):
    r"""Too Many Requests - When the rate limit has been exceeded"""

    data: Error429ResponseBodyData = field(hash=False)

    def __init__(
        self,
        data: Error429ResponseBodyData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
