"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from jsonpath import JSONPath
from meitner import errors, models, utils
from meitner._hooks import HookContext
from meitner.types import OptionalNullable, UNSET
from meitner.utils import get_security_from_env
from meitner.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Awaitable, Dict, List, Mapping, Optional, Union


class Groups(BaseSDK):
    def list(
        self,
        *,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.GroupListResponse]:
        r"""List Groups

        Returns a paginated list of all `Groups` in your organization.

        :param limit: The maximum number of Groups to return (default: 50) when listing Groups
        :param offset: The number of Groups to skip before starting to return results (default: 0) when listing Groups
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GroupListRequest(
            limit=limit,
            offset=offset,
        )

        req = self._build_request(
            method="GET",
            path="/group",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GroupList",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.GroupListResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return None
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return None
            next_offset = offset + len(results[0])

            return self.list(
                limit=limit,
                offset=next_offset,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.GroupListResponse(
                result=unmarshal_json_response(models.GroupList, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def list_async(
        self,
        *,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.GroupListResponse]:
        r"""List Groups

        Returns a paginated list of all `Groups` in your organization.

        :param limit: The maximum number of Groups to return (default: 50) when listing Groups
        :param offset: The number of Groups to skip before starting to return results (default: 0) when listing Groups
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GroupListRequest(
            limit=limit,
            offset=offset,
        )

        req = self._build_request_async(
            method="GET",
            path="/group",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GroupList",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Awaitable[Optional[models.GroupListResponse]]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            async def empty_result():
                return None

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return empty_result()
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return empty_result()
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return empty_result()
            next_offset = offset + len(results[0])

            return self.list_async(
                limit=limit,
                offset=next_offset,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.GroupListResponse(
                result=unmarshal_json_response(models.GroupList, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def create(
        self,
        *,
        school_id: str,
        title: str,
        external: Optional[
            Union[models.GroupCreateExternal, models.GroupCreateExternalTypedDict]
        ] = None,
        category: Optional[models.CategoryRequestBody] = "Education",
        types: Optional[List[models.GroupType]] = None,
        moderator_i_ds: Optional[List[str]] = None,
        member_i_ds: Optional[List[str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Group:
        r"""Create a new Group

        Create a new Group

        :param school_id: The ID of the school the group belongs to
        :param title: The title of the group, must be unique within the school.
        :param external: External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee, the Source-field is not included.
        :param category: If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.
        :param types: The types of the group
        :param moderator_i_ds: The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.
        :param member_i_ds: The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GroupCreate(
            external=utils.get_pydantic_model(
                external, Optional[models.GroupCreateExternal]
            ),
            school_id=school_id,
            category=category,
            title=title,
            types=types,
            moderator_i_ds=moderator_i_ds,
            member_i_ds=member_i_ds,
        )

        req = self._build_request(
            method="POST",
            path="/group",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.GroupCreate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GroupCreate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.Group, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.GroupCreate422ResponseBodyErrorData, http_res
            )
            raise errors.GroupCreate422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        school_id: str,
        title: str,
        external: Optional[
            Union[models.GroupCreateExternal, models.GroupCreateExternalTypedDict]
        ] = None,
        category: Optional[models.CategoryRequestBody] = "Education",
        types: Optional[List[models.GroupType]] = None,
        moderator_i_ds: Optional[List[str]] = None,
        member_i_ds: Optional[List[str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Group:
        r"""Create a new Group

        Create a new Group

        :param school_id: The ID of the school the group belongs to
        :param title: The title of the group, must be unique within the school.
        :param external: External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee, the Source-field is not included.
        :param category: If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.
        :param types: The types of the group
        :param moderator_i_ds: The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.
        :param member_i_ds: The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GroupCreate(
            external=utils.get_pydantic_model(
                external, Optional[models.GroupCreateExternal]
            ),
            school_id=school_id,
            category=category,
            title=title,
            types=types,
            moderator_i_ds=moderator_i_ds,
            member_i_ds=member_i_ds,
        )

        req = self._build_request_async(
            method="POST",
            path="/group",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.GroupCreate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GroupCreate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.Group, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.GroupCreate422ResponseBodyErrorData, http_res
            )
            raise errors.GroupCreate422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def search(
        self,
        *,
        or_condition: bool,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        equals: OptionalNullable[
            Union[models.GroupFilterEquals, models.GroupFilterEqualsTypedDict]
        ] = UNSET,
        not_equals: OptionalNullable[
            Union[models.GroupFilterNotEquals, models.GroupFilterNotEqualsTypedDict]
        ] = UNSET,
        greater_than: OptionalNullable[
            Union[models.GroupFilterGreaterThan, models.GroupFilterGreaterThanTypedDict]
        ] = UNSET,
        smaller_than: OptionalNullable[
            Union[models.GroupFilterSmallerThan, models.GroupFilterSmallerThanTypedDict]
        ] = UNSET,
        greater_or_equal: OptionalNullable[
            Union[
                models.GroupFilterGreaterOrEqual,
                models.GroupFilterGreaterOrEqualTypedDict,
            ]
        ] = UNSET,
        smaller_or_equal: OptionalNullable[
            Union[
                models.GroupFilterSmallerOrEqual,
                models.GroupFilterSmallerOrEqualTypedDict,
            ]
        ] = UNSET,
        contains: OptionalNullable[
            Union[models.GroupFilterContains, models.GroupFilterContainsTypedDict]
        ] = UNSET,
        not_contains: OptionalNullable[
            Union[models.GroupFilterNotContains, models.GroupFilterNotContainsTypedDict]
        ] = UNSET,
        like: OptionalNullable[
            Union[models.GroupFilterLike, models.GroupFilterLikeTypedDict]
        ] = UNSET,
        not_like: OptionalNullable[
            Union[models.GroupFilterNotLike, models.GroupFilterNotLikeTypedDict]
        ] = UNSET,
        null: OptionalNullable[
            Union[models.GroupFilterNull, models.GroupFilterNullTypedDict]
        ] = UNSET,
        not_null: OptionalNullable[
            Union[models.GroupFilterNotNull, models.GroupFilterNotNullTypedDict]
        ] = UNSET,
        nested_filters: Optional[
            Union[List[models.GroupFilter], List[models.GroupFilterTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.GroupSearchResponse]:
        r"""Search Groups

        Search for `Groups` with filtering capabilities.

        :param or_condition: OrCondition decides if this filter is within an OR-condition or AND-condition
        :param limit: The maximum number of Groups to return (default: 50) when searching Groups
        :param offset: The number of Groups to skip before starting to return results (default: 0) when searching Groups
        :param equals: Equality filters for Group
        :param not_equals: Inequality filters for Group
        :param greater_than: Greater than filters for Group
        :param smaller_than: Smaller than filters for Group
        :param greater_or_equal: Greater than or equal filters for Group
        :param smaller_or_equal: Smaller than or equal filters for Group
        :param contains: Contains filters for Group
        :param not_contains: Not contains filters for Group
        :param like: LIKE filters for Group
        :param not_like: NOT LIKE filters for Group
        :param null: Null filters for Group
        :param not_null: Not null filters for Group
        :param nested_filters: NestedFilters of the Group, useful for more complex filters
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GroupSearchRequest(
            limit=limit,
            offset=offset,
            group_filter=models.GroupFilter(
                equals=utils.get_pydantic_model(
                    equals, OptionalNullable[models.GroupFilterEquals]
                ),
                not_equals=utils.get_pydantic_model(
                    not_equals, OptionalNullable[models.GroupFilterNotEquals]
                ),
                greater_than=utils.get_pydantic_model(
                    greater_than, OptionalNullable[models.GroupFilterGreaterThan]
                ),
                smaller_than=utils.get_pydantic_model(
                    smaller_than, OptionalNullable[models.GroupFilterSmallerThan]
                ),
                greater_or_equal=utils.get_pydantic_model(
                    greater_or_equal, OptionalNullable[models.GroupFilterGreaterOrEqual]
                ),
                smaller_or_equal=utils.get_pydantic_model(
                    smaller_or_equal, OptionalNullable[models.GroupFilterSmallerOrEqual]
                ),
                contains=utils.get_pydantic_model(
                    contains, OptionalNullable[models.GroupFilterContains]
                ),
                not_contains=utils.get_pydantic_model(
                    not_contains, OptionalNullable[models.GroupFilterNotContains]
                ),
                like=utils.get_pydantic_model(
                    like, OptionalNullable[models.GroupFilterLike]
                ),
                not_like=utils.get_pydantic_model(
                    not_like, OptionalNullable[models.GroupFilterNotLike]
                ),
                null=utils.get_pydantic_model(
                    null, OptionalNullable[models.GroupFilterNull]
                ),
                not_null=utils.get_pydantic_model(
                    not_null, OptionalNullable[models.GroupFilterNotNull]
                ),
                or_condition=or_condition,
                nested_filters=utils.get_pydantic_model(
                    nested_filters, Optional[List[models.GroupFilter]]
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/group/_search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.group_filter, False, False, "json", models.GroupFilter
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GroupSearch",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.GroupSearchResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return None
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return None
            next_offset = offset + len(results[0])

            return self.search(
                or_condition=or_condition,
                limit=limit,
                offset=next_offset,
                equals=equals,
                not_equals=not_equals,
                greater_than=greater_than,
                smaller_than=smaller_than,
                greater_or_equal=greater_or_equal,
                smaller_or_equal=smaller_or_equal,
                contains=contains,
                not_contains=not_contains,
                like=like,
                not_like=not_like,
                null=null,
                not_null=not_null,
                nested_filters=nested_filters,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.GroupSearchResponse(
                result=unmarshal_json_response(models.GroupSearch, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.GroupSearch422ResponseBodyErrorData, http_res
            )
            raise errors.GroupSearch422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def search_async(
        self,
        *,
        or_condition: bool,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        equals: OptionalNullable[
            Union[models.GroupFilterEquals, models.GroupFilterEqualsTypedDict]
        ] = UNSET,
        not_equals: OptionalNullable[
            Union[models.GroupFilterNotEquals, models.GroupFilterNotEqualsTypedDict]
        ] = UNSET,
        greater_than: OptionalNullable[
            Union[models.GroupFilterGreaterThan, models.GroupFilterGreaterThanTypedDict]
        ] = UNSET,
        smaller_than: OptionalNullable[
            Union[models.GroupFilterSmallerThan, models.GroupFilterSmallerThanTypedDict]
        ] = UNSET,
        greater_or_equal: OptionalNullable[
            Union[
                models.GroupFilterGreaterOrEqual,
                models.GroupFilterGreaterOrEqualTypedDict,
            ]
        ] = UNSET,
        smaller_or_equal: OptionalNullable[
            Union[
                models.GroupFilterSmallerOrEqual,
                models.GroupFilterSmallerOrEqualTypedDict,
            ]
        ] = UNSET,
        contains: OptionalNullable[
            Union[models.GroupFilterContains, models.GroupFilterContainsTypedDict]
        ] = UNSET,
        not_contains: OptionalNullable[
            Union[models.GroupFilterNotContains, models.GroupFilterNotContainsTypedDict]
        ] = UNSET,
        like: OptionalNullable[
            Union[models.GroupFilterLike, models.GroupFilterLikeTypedDict]
        ] = UNSET,
        not_like: OptionalNullable[
            Union[models.GroupFilterNotLike, models.GroupFilterNotLikeTypedDict]
        ] = UNSET,
        null: OptionalNullable[
            Union[models.GroupFilterNull, models.GroupFilterNullTypedDict]
        ] = UNSET,
        not_null: OptionalNullable[
            Union[models.GroupFilterNotNull, models.GroupFilterNotNullTypedDict]
        ] = UNSET,
        nested_filters: Optional[
            Union[List[models.GroupFilter], List[models.GroupFilterTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.GroupSearchResponse]:
        r"""Search Groups

        Search for `Groups` with filtering capabilities.

        :param or_condition: OrCondition decides if this filter is within an OR-condition or AND-condition
        :param limit: The maximum number of Groups to return (default: 50) when searching Groups
        :param offset: The number of Groups to skip before starting to return results (default: 0) when searching Groups
        :param equals: Equality filters for Group
        :param not_equals: Inequality filters for Group
        :param greater_than: Greater than filters for Group
        :param smaller_than: Smaller than filters for Group
        :param greater_or_equal: Greater than or equal filters for Group
        :param smaller_or_equal: Smaller than or equal filters for Group
        :param contains: Contains filters for Group
        :param not_contains: Not contains filters for Group
        :param like: LIKE filters for Group
        :param not_like: NOT LIKE filters for Group
        :param null: Null filters for Group
        :param not_null: Not null filters for Group
        :param nested_filters: NestedFilters of the Group, useful for more complex filters
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GroupSearchRequest(
            limit=limit,
            offset=offset,
            group_filter=models.GroupFilter(
                equals=utils.get_pydantic_model(
                    equals, OptionalNullable[models.GroupFilterEquals]
                ),
                not_equals=utils.get_pydantic_model(
                    not_equals, OptionalNullable[models.GroupFilterNotEquals]
                ),
                greater_than=utils.get_pydantic_model(
                    greater_than, OptionalNullable[models.GroupFilterGreaterThan]
                ),
                smaller_than=utils.get_pydantic_model(
                    smaller_than, OptionalNullable[models.GroupFilterSmallerThan]
                ),
                greater_or_equal=utils.get_pydantic_model(
                    greater_or_equal, OptionalNullable[models.GroupFilterGreaterOrEqual]
                ),
                smaller_or_equal=utils.get_pydantic_model(
                    smaller_or_equal, OptionalNullable[models.GroupFilterSmallerOrEqual]
                ),
                contains=utils.get_pydantic_model(
                    contains, OptionalNullable[models.GroupFilterContains]
                ),
                not_contains=utils.get_pydantic_model(
                    not_contains, OptionalNullable[models.GroupFilterNotContains]
                ),
                like=utils.get_pydantic_model(
                    like, OptionalNullable[models.GroupFilterLike]
                ),
                not_like=utils.get_pydantic_model(
                    not_like, OptionalNullable[models.GroupFilterNotLike]
                ),
                null=utils.get_pydantic_model(
                    null, OptionalNullable[models.GroupFilterNull]
                ),
                not_null=utils.get_pydantic_model(
                    not_null, OptionalNullable[models.GroupFilterNotNull]
                ),
                or_condition=or_condition,
                nested_filters=utils.get_pydantic_model(
                    nested_filters, Optional[List[models.GroupFilter]]
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/group/_search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.group_filter, False, False, "json", models.GroupFilter
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GroupSearch",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Awaitable[Optional[models.GroupSearchResponse]]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            async def empty_result():
                return None

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return empty_result()
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return empty_result()
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return empty_result()
            next_offset = offset + len(results[0])

            return self.search_async(
                or_condition=or_condition,
                limit=limit,
                offset=next_offset,
                equals=equals,
                not_equals=not_equals,
                greater_than=greater_than,
                smaller_than=smaller_than,
                greater_or_equal=greater_or_equal,
                smaller_or_equal=smaller_or_equal,
                contains=contains,
                not_contains=not_contains,
                like=like,
                not_like=not_like,
                null=null,
                not_null=not_null,
                nested_filters=nested_filters,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.GroupSearchResponse(
                result=unmarshal_json_response(models.GroupSearch, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.GroupSearch422ResponseBodyErrorData, http_res
            )
            raise errors.GroupSearch422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def get(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Group:
        r"""Get a Group

        Retrieves the `Group` with the given ID.

        :param id: The unique identifier of the Group to retrieve
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GroupGetRequest(
            id=id,
        )

        req = self._build_request(
            method="GET",
            path="/group/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GroupGet",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Group, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def get_async(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Group:
        r"""Get a Group

        Retrieves the `Group` with the given ID.

        :param id: The unique identifier of the Group to retrieve
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GroupGetRequest(
            id=id,
        )

        req = self._build_request_async(
            method="GET",
            path="/group/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GroupGet",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Group, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def delete(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a Group

        Delete a Group

        :param id: The unique identifier of the Group to delete
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GroupDeleteRequest(
            id=id,
        )

        req = self._build_request(
            method="DELETE",
            path="/group/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GroupDelete",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def delete_async(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a Group

        Delete a Group

        :param id: The unique identifier of the Group to delete
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GroupDeleteRequest(
            id=id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/group/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GroupDelete",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def update(
        self,
        *,
        id: str,
        title: str,
        external: Optional[
            Union[models.GroupUpdateExternal, models.GroupUpdateExternalTypedDict]
        ] = None,
        types: Optional[List[models.GroupType]] = None,
        moderator_i_ds: Optional[List[str]] = None,
        member_i_ds: Optional[List[str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Group:
        r"""Update a Group

        Update a Group

        :param id: The unique identifier of the Group to update
        :param title: The title of the group, must be unique within the school.
        :param external: External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee, the Source-field is not included.
        :param types: The types of the group
        :param moderator_i_ds: The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.
        :param member_i_ds: The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GroupUpdateRequest(
            id=id,
            group_update=models.GroupUpdate(
                external=utils.get_pydantic_model(
                    external, Optional[models.GroupUpdateExternal]
                ),
                title=title,
                types=types,
                moderator_i_ds=moderator_i_ds,
                member_i_ds=member_i_ds,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/group/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.group_update, False, False, "json", models.GroupUpdate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GroupUpdate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Group, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.GroupUpdate422ResponseBodyErrorData, http_res
            )
            raise errors.GroupUpdate422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def update_async(
        self,
        *,
        id: str,
        title: str,
        external: Optional[
            Union[models.GroupUpdateExternal, models.GroupUpdateExternalTypedDict]
        ] = None,
        types: Optional[List[models.GroupType]] = None,
        moderator_i_ds: Optional[List[str]] = None,
        member_i_ds: Optional[List[str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Group:
        r"""Update a Group

        Update a Group

        :param id: The unique identifier of the Group to update
        :param title: The title of the group, must be unique within the school.
        :param external: External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee, the Source-field is not included.
        :param types: The types of the group
        :param moderator_i_ds: The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.
        :param member_i_ds: The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GroupUpdateRequest(
            id=id,
            group_update=models.GroupUpdate(
                external=utils.get_pydantic_model(
                    external, Optional[models.GroupUpdateExternal]
                ),
                title=title,
                types=types,
                moderator_i_ds=moderator_i_ds,
                member_i_ds=member_i_ds,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/group/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.group_update, False, False, "json", models.GroupUpdate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GroupUpdate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Group, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.GroupUpdate422ResponseBodyErrorData, http_res
            )
            raise errors.GroupUpdate422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)
