"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from jsonpath import JSONPath
from meitner import errors, models, utils
from meitner._hooks import HookContext
from meitner.types import OptionalNullable, UNSET
from meitner.utils import get_security_from_env
from meitner.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Awaitable, Dict, List, Mapping, Optional, Union


class Guardians(BaseSDK):
    def list(
        self,
        *,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.GuardianListResponse]:
        r"""List Guardians

        Returns a paginated list of all `Guardians` in your organization.

        :param limit: The maximum number of Guardians to return (default: 50) when listing Guardians
        :param offset: The number of Guardians to skip before starting to return results (default: 0) when listing Guardians
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GuardianListRequest(
            limit=limit,
            offset=offset,
        )

        req = self._build_request(
            method="GET",
            path="/guardian",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GuardianList",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.GuardianListResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return None
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return None
            next_offset = offset + len(results[0])

            return self.list(
                limit=limit,
                offset=next_offset,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.GuardianListResponse(
                result=unmarshal_json_response(models.GuardianList, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def list_async(
        self,
        *,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.GuardianListResponse]:
        r"""List Guardians

        Returns a paginated list of all `Guardians` in your organization.

        :param limit: The maximum number of Guardians to return (default: 50) when listing Guardians
        :param offset: The number of Guardians to skip before starting to return results (default: 0) when listing Guardians
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GuardianListRequest(
            limit=limit,
            offset=offset,
        )

        req = self._build_request_async(
            method="GET",
            path="/guardian",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GuardianList",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Awaitable[Optional[models.GuardianListResponse]]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            async def empty_result():
                return None

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return empty_result()
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return empty_result()
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return empty_result()
            next_offset = offset + len(results[0])

            return self.list_async(
                limit=limit,
                offset=next_offset,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.GuardianListResponse(
                result=unmarshal_json_response(models.GuardianList, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def create(
        self,
        *,
        identity_number: str,
        first_name: str,
        last_name: str,
        external: Optional[
            Union[models.GuardianCreateExternal, models.GuardianCreateExternalTypedDict]
        ] = None,
        identity_temporary: Optional[bool] = False,
        address: Optional[
            Union[models.GuardianCreateAddress, models.GuardianCreateAddressTypedDict]
        ] = None,
        email_address1: OptionalNullable[str] = UNSET,
        email_address2: OptionalNullable[str] = UNSET,
        phone_number1: OptionalNullable[str] = UNSET,
        phone_number2: OptionalNullable[str] = UNSET,
        student_i_ds: Optional[List[str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Guardian:
        r"""Create a new Guardian

        Create a new Guardian

        :param identity_number: The identity number of the guardian, must be unique within the organization.
        :param first_name: The first name of the guardian
        :param last_name: The last name of the guardian
        :param external: ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included.
        :param identity_temporary: If the identity number is temporary for the guardian
        :param address: The address of the guardian
        :param email_address1: The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization. Can be used to login to the system if password-authentication is enabled for the organization.
        :param email_address2: The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information.
        :param phone_number1: The primary phone number of the guardian, will be used for communication with the guardian from the system.
        :param phone_number2: The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information.
        :param student_i_ds: The IDs of the students the guardian is responsible for.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GuardianCreate(
            external=utils.get_pydantic_model(
                external, Optional[models.GuardianCreateExternal]
            ),
            identity_number=identity_number,
            identity_temporary=identity_temporary,
            first_name=first_name,
            last_name=last_name,
            address=utils.get_pydantic_model(
                address, Optional[models.GuardianCreateAddress]
            ),
            email_address1=email_address1,
            email_address2=email_address2,
            phone_number1=phone_number1,
            phone_number2=phone_number2,
            student_i_ds=student_i_ds,
        )

        req = self._build_request(
            method="POST",
            path="/guardian",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.GuardianCreate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GuardianCreate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.Guardian, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.GuardianCreate422ResponseBodyErrorData, http_res
            )
            raise errors.GuardianCreate422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        identity_number: str,
        first_name: str,
        last_name: str,
        external: Optional[
            Union[models.GuardianCreateExternal, models.GuardianCreateExternalTypedDict]
        ] = None,
        identity_temporary: Optional[bool] = False,
        address: Optional[
            Union[models.GuardianCreateAddress, models.GuardianCreateAddressTypedDict]
        ] = None,
        email_address1: OptionalNullable[str] = UNSET,
        email_address2: OptionalNullable[str] = UNSET,
        phone_number1: OptionalNullable[str] = UNSET,
        phone_number2: OptionalNullable[str] = UNSET,
        student_i_ds: Optional[List[str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Guardian:
        r"""Create a new Guardian

        Create a new Guardian

        :param identity_number: The identity number of the guardian, must be unique within the organization.
        :param first_name: The first name of the guardian
        :param last_name: The last name of the guardian
        :param external: ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included.
        :param identity_temporary: If the identity number is temporary for the guardian
        :param address: The address of the guardian
        :param email_address1: The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization. Can be used to login to the system if password-authentication is enabled for the organization.
        :param email_address2: The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information.
        :param phone_number1: The primary phone number of the guardian, will be used for communication with the guardian from the system.
        :param phone_number2: The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information.
        :param student_i_ds: The IDs of the students the guardian is responsible for.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GuardianCreate(
            external=utils.get_pydantic_model(
                external, Optional[models.GuardianCreateExternal]
            ),
            identity_number=identity_number,
            identity_temporary=identity_temporary,
            first_name=first_name,
            last_name=last_name,
            address=utils.get_pydantic_model(
                address, Optional[models.GuardianCreateAddress]
            ),
            email_address1=email_address1,
            email_address2=email_address2,
            phone_number1=phone_number1,
            phone_number2=phone_number2,
            student_i_ds=student_i_ds,
        )

        req = self._build_request_async(
            method="POST",
            path="/guardian",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.GuardianCreate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GuardianCreate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.Guardian, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.GuardianCreate422ResponseBodyErrorData, http_res
            )
            raise errors.GuardianCreate422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def search(
        self,
        *,
        or_condition: bool,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        equals: OptionalNullable[
            Union[models.GuardianFilterEquals, models.GuardianFilterEqualsTypedDict]
        ] = UNSET,
        not_equals: OptionalNullable[
            Union[
                models.GuardianFilterNotEquals, models.GuardianFilterNotEqualsTypedDict
            ]
        ] = UNSET,
        greater_than: OptionalNullable[
            Union[
                models.GuardianFilterGreaterThan,
                models.GuardianFilterGreaterThanTypedDict,
            ]
        ] = UNSET,
        smaller_than: OptionalNullable[
            Union[
                models.GuardianFilterSmallerThan,
                models.GuardianFilterSmallerThanTypedDict,
            ]
        ] = UNSET,
        greater_or_equal: OptionalNullable[
            Union[
                models.GuardianFilterGreaterOrEqual,
                models.GuardianFilterGreaterOrEqualTypedDict,
            ]
        ] = UNSET,
        smaller_or_equal: OptionalNullable[
            Union[
                models.GuardianFilterSmallerOrEqual,
                models.GuardianFilterSmallerOrEqualTypedDict,
            ]
        ] = UNSET,
        contains: OptionalNullable[
            Union[models.GuardianFilterContains, models.GuardianFilterContainsTypedDict]
        ] = UNSET,
        not_contains: OptionalNullable[
            Union[
                models.GuardianFilterNotContains,
                models.GuardianFilterNotContainsTypedDict,
            ]
        ] = UNSET,
        like: OptionalNullable[
            Union[models.GuardianFilterLike, models.GuardianFilterLikeTypedDict]
        ] = UNSET,
        not_like: OptionalNullable[
            Union[models.GuardianFilterNotLike, models.GuardianFilterNotLikeTypedDict]
        ] = UNSET,
        null: OptionalNullable[
            Union[models.GuardianFilterNull, models.GuardianFilterNullTypedDict]
        ] = UNSET,
        not_null: OptionalNullable[
            Union[models.GuardianFilterNotNull, models.GuardianFilterNotNullTypedDict]
        ] = UNSET,
        nested_filters: Optional[
            Union[List[models.GuardianFilter], List[models.GuardianFilterTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.GuardianSearchResponse]:
        r"""Search Guardians

        Search for `Guardians` with filtering capabilities.

        :param or_condition: OrCondition decides if this filter is within an OR-condition or AND-condition
        :param limit: The maximum number of Guardians to return (default: 50) when searching Guardians
        :param offset: The number of Guardians to skip before starting to return results (default: 0) when searching Guardians
        :param equals: Equality filters for Guardian
        :param not_equals: Inequality filters for Guardian
        :param greater_than: Greater than filters for Guardian
        :param smaller_than: Smaller than filters for Guardian
        :param greater_or_equal: Greater than or equal filters for Guardian
        :param smaller_or_equal: Smaller than or equal filters for Guardian
        :param contains: Contains filters for Guardian
        :param not_contains: Not contains filters for Guardian
        :param like: LIKE filters for Guardian
        :param not_like: NOT LIKE filters for Guardian
        :param null: Null filters for Guardian
        :param not_null: Not null filters for Guardian
        :param nested_filters: NestedFilters of the Guardian, useful for more complex filters
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GuardianSearchRequest(
            limit=limit,
            offset=offset,
            guardian_filter=models.GuardianFilter(
                equals=utils.get_pydantic_model(
                    equals, OptionalNullable[models.GuardianFilterEquals]
                ),
                not_equals=utils.get_pydantic_model(
                    not_equals, OptionalNullable[models.GuardianFilterNotEquals]
                ),
                greater_than=utils.get_pydantic_model(
                    greater_than, OptionalNullable[models.GuardianFilterGreaterThan]
                ),
                smaller_than=utils.get_pydantic_model(
                    smaller_than, OptionalNullable[models.GuardianFilterSmallerThan]
                ),
                greater_or_equal=utils.get_pydantic_model(
                    greater_or_equal,
                    OptionalNullable[models.GuardianFilterGreaterOrEqual],
                ),
                smaller_or_equal=utils.get_pydantic_model(
                    smaller_or_equal,
                    OptionalNullable[models.GuardianFilterSmallerOrEqual],
                ),
                contains=utils.get_pydantic_model(
                    contains, OptionalNullable[models.GuardianFilterContains]
                ),
                not_contains=utils.get_pydantic_model(
                    not_contains, OptionalNullable[models.GuardianFilterNotContains]
                ),
                like=utils.get_pydantic_model(
                    like, OptionalNullable[models.GuardianFilterLike]
                ),
                not_like=utils.get_pydantic_model(
                    not_like, OptionalNullable[models.GuardianFilterNotLike]
                ),
                null=utils.get_pydantic_model(
                    null, OptionalNullable[models.GuardianFilterNull]
                ),
                not_null=utils.get_pydantic_model(
                    not_null, OptionalNullable[models.GuardianFilterNotNull]
                ),
                or_condition=or_condition,
                nested_filters=utils.get_pydantic_model(
                    nested_filters, Optional[List[models.GuardianFilter]]
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/guardian/_search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.guardian_filter, False, False, "json", models.GuardianFilter
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GuardianSearch",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.GuardianSearchResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return None
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return None
            next_offset = offset + len(results[0])

            return self.search(
                or_condition=or_condition,
                limit=limit,
                offset=next_offset,
                equals=equals,
                not_equals=not_equals,
                greater_than=greater_than,
                smaller_than=smaller_than,
                greater_or_equal=greater_or_equal,
                smaller_or_equal=smaller_or_equal,
                contains=contains,
                not_contains=not_contains,
                like=like,
                not_like=not_like,
                null=null,
                not_null=not_null,
                nested_filters=nested_filters,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.GuardianSearchResponse(
                result=unmarshal_json_response(models.GuardianSearch, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.GuardianSearch422ResponseBodyErrorData, http_res
            )
            raise errors.GuardianSearch422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def search_async(
        self,
        *,
        or_condition: bool,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        equals: OptionalNullable[
            Union[models.GuardianFilterEquals, models.GuardianFilterEqualsTypedDict]
        ] = UNSET,
        not_equals: OptionalNullable[
            Union[
                models.GuardianFilterNotEquals, models.GuardianFilterNotEqualsTypedDict
            ]
        ] = UNSET,
        greater_than: OptionalNullable[
            Union[
                models.GuardianFilterGreaterThan,
                models.GuardianFilterGreaterThanTypedDict,
            ]
        ] = UNSET,
        smaller_than: OptionalNullable[
            Union[
                models.GuardianFilterSmallerThan,
                models.GuardianFilterSmallerThanTypedDict,
            ]
        ] = UNSET,
        greater_or_equal: OptionalNullable[
            Union[
                models.GuardianFilterGreaterOrEqual,
                models.GuardianFilterGreaterOrEqualTypedDict,
            ]
        ] = UNSET,
        smaller_or_equal: OptionalNullable[
            Union[
                models.GuardianFilterSmallerOrEqual,
                models.GuardianFilterSmallerOrEqualTypedDict,
            ]
        ] = UNSET,
        contains: OptionalNullable[
            Union[models.GuardianFilterContains, models.GuardianFilterContainsTypedDict]
        ] = UNSET,
        not_contains: OptionalNullable[
            Union[
                models.GuardianFilterNotContains,
                models.GuardianFilterNotContainsTypedDict,
            ]
        ] = UNSET,
        like: OptionalNullable[
            Union[models.GuardianFilterLike, models.GuardianFilterLikeTypedDict]
        ] = UNSET,
        not_like: OptionalNullable[
            Union[models.GuardianFilterNotLike, models.GuardianFilterNotLikeTypedDict]
        ] = UNSET,
        null: OptionalNullable[
            Union[models.GuardianFilterNull, models.GuardianFilterNullTypedDict]
        ] = UNSET,
        not_null: OptionalNullable[
            Union[models.GuardianFilterNotNull, models.GuardianFilterNotNullTypedDict]
        ] = UNSET,
        nested_filters: Optional[
            Union[List[models.GuardianFilter], List[models.GuardianFilterTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.GuardianSearchResponse]:
        r"""Search Guardians

        Search for `Guardians` with filtering capabilities.

        :param or_condition: OrCondition decides if this filter is within an OR-condition or AND-condition
        :param limit: The maximum number of Guardians to return (default: 50) when searching Guardians
        :param offset: The number of Guardians to skip before starting to return results (default: 0) when searching Guardians
        :param equals: Equality filters for Guardian
        :param not_equals: Inequality filters for Guardian
        :param greater_than: Greater than filters for Guardian
        :param smaller_than: Smaller than filters for Guardian
        :param greater_or_equal: Greater than or equal filters for Guardian
        :param smaller_or_equal: Smaller than or equal filters for Guardian
        :param contains: Contains filters for Guardian
        :param not_contains: Not contains filters for Guardian
        :param like: LIKE filters for Guardian
        :param not_like: NOT LIKE filters for Guardian
        :param null: Null filters for Guardian
        :param not_null: Not null filters for Guardian
        :param nested_filters: NestedFilters of the Guardian, useful for more complex filters
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GuardianSearchRequest(
            limit=limit,
            offset=offset,
            guardian_filter=models.GuardianFilter(
                equals=utils.get_pydantic_model(
                    equals, OptionalNullable[models.GuardianFilterEquals]
                ),
                not_equals=utils.get_pydantic_model(
                    not_equals, OptionalNullable[models.GuardianFilterNotEquals]
                ),
                greater_than=utils.get_pydantic_model(
                    greater_than, OptionalNullable[models.GuardianFilterGreaterThan]
                ),
                smaller_than=utils.get_pydantic_model(
                    smaller_than, OptionalNullable[models.GuardianFilterSmallerThan]
                ),
                greater_or_equal=utils.get_pydantic_model(
                    greater_or_equal,
                    OptionalNullable[models.GuardianFilterGreaterOrEqual],
                ),
                smaller_or_equal=utils.get_pydantic_model(
                    smaller_or_equal,
                    OptionalNullable[models.GuardianFilterSmallerOrEqual],
                ),
                contains=utils.get_pydantic_model(
                    contains, OptionalNullable[models.GuardianFilterContains]
                ),
                not_contains=utils.get_pydantic_model(
                    not_contains, OptionalNullable[models.GuardianFilterNotContains]
                ),
                like=utils.get_pydantic_model(
                    like, OptionalNullable[models.GuardianFilterLike]
                ),
                not_like=utils.get_pydantic_model(
                    not_like, OptionalNullable[models.GuardianFilterNotLike]
                ),
                null=utils.get_pydantic_model(
                    null, OptionalNullable[models.GuardianFilterNull]
                ),
                not_null=utils.get_pydantic_model(
                    not_null, OptionalNullable[models.GuardianFilterNotNull]
                ),
                or_condition=or_condition,
                nested_filters=utils.get_pydantic_model(
                    nested_filters, Optional[List[models.GuardianFilter]]
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/guardian/_search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.guardian_filter, False, False, "json", models.GuardianFilter
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GuardianSearch",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Awaitable[Optional[models.GuardianSearchResponse]]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            async def empty_result():
                return None

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return empty_result()
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return empty_result()
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return empty_result()
            next_offset = offset + len(results[0])

            return self.search_async(
                or_condition=or_condition,
                limit=limit,
                offset=next_offset,
                equals=equals,
                not_equals=not_equals,
                greater_than=greater_than,
                smaller_than=smaller_than,
                greater_or_equal=greater_or_equal,
                smaller_or_equal=smaller_or_equal,
                contains=contains,
                not_contains=not_contains,
                like=like,
                not_like=not_like,
                null=null,
                not_null=not_null,
                nested_filters=nested_filters,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.GuardianSearchResponse(
                result=unmarshal_json_response(models.GuardianSearch, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.GuardianSearch422ResponseBodyErrorData, http_res
            )
            raise errors.GuardianSearch422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def get(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Guardian:
        r"""Get a Guardian

        Retrieves the `Guardian` with the given ID.

        :param id: The unique identifier of the Guardian to retrieve
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GuardianGetRequest(
            id=id,
        )

        req = self._build_request(
            method="GET",
            path="/guardian/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GuardianGet",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Guardian, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def get_async(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Guardian:
        r"""Get a Guardian

        Retrieves the `Guardian` with the given ID.

        :param id: The unique identifier of the Guardian to retrieve
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GuardianGetRequest(
            id=id,
        )

        req = self._build_request_async(
            method="GET",
            path="/guardian/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GuardianGet",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Guardian, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def delete(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a Guardian

        Delete a Guardian

        :param id: The unique identifier of the Guardian to delete
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GuardianDeleteRequest(
            id=id,
        )

        req = self._build_request(
            method="DELETE",
            path="/guardian/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GuardianDelete",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def delete_async(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a Guardian

        Delete a Guardian

        :param id: The unique identifier of the Guardian to delete
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GuardianDeleteRequest(
            id=id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/guardian/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GuardianDelete",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def update(
        self,
        *,
        id: str,
        identity_number: str,
        first_name: str,
        last_name: str,
        external: Optional[
            Union[models.GuardianUpdateExternal, models.GuardianUpdateExternalTypedDict]
        ] = None,
        identity_temporary: Optional[bool] = False,
        address: Optional[
            Union[models.GuardianUpdateAddress, models.GuardianUpdateAddressTypedDict]
        ] = None,
        email_address1: OptionalNullable[str] = UNSET,
        email_address2: OptionalNullable[str] = UNSET,
        phone_number1: OptionalNullable[str] = UNSET,
        phone_number2: OptionalNullable[str] = UNSET,
        student_i_ds: Optional[List[str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Guardian:
        r"""Update a Guardian

        Update a Guardian

        :param id: The unique identifier of the Guardian to update
        :param identity_number: The identity number of the guardian, must be unique within the organization.
        :param first_name: The first name of the guardian
        :param last_name: The last name of the guardian
        :param external: ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included.
        :param identity_temporary: If the identity number is temporary for the guardian
        :param address: The address of the guardian
        :param email_address1: The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization. Can be used to login to the system if password-authentication is enabled for the organization.
        :param email_address2: The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information.
        :param phone_number1: The primary phone number of the guardian, will be used for communication with the guardian from the system.
        :param phone_number2: The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information.
        :param student_i_ds: The IDs of the students the guardian is responsible for.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GuardianUpdateRequest(
            id=id,
            guardian_update=models.GuardianUpdate(
                external=utils.get_pydantic_model(
                    external, Optional[models.GuardianUpdateExternal]
                ),
                identity_number=identity_number,
                identity_temporary=identity_temporary,
                first_name=first_name,
                last_name=last_name,
                address=utils.get_pydantic_model(
                    address, Optional[models.GuardianUpdateAddress]
                ),
                email_address1=email_address1,
                email_address2=email_address2,
                phone_number1=phone_number1,
                phone_number2=phone_number2,
                student_i_ds=student_i_ds,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/guardian/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.guardian_update, False, False, "json", models.GuardianUpdate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GuardianUpdate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Guardian, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.GuardianUpdate422ResponseBodyErrorData, http_res
            )
            raise errors.GuardianUpdate422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def update_async(
        self,
        *,
        id: str,
        identity_number: str,
        first_name: str,
        last_name: str,
        external: Optional[
            Union[models.GuardianUpdateExternal, models.GuardianUpdateExternalTypedDict]
        ] = None,
        identity_temporary: Optional[bool] = False,
        address: Optional[
            Union[models.GuardianUpdateAddress, models.GuardianUpdateAddressTypedDict]
        ] = None,
        email_address1: OptionalNullable[str] = UNSET,
        email_address2: OptionalNullable[str] = UNSET,
        phone_number1: OptionalNullable[str] = UNSET,
        phone_number2: OptionalNullable[str] = UNSET,
        student_i_ds: Optional[List[str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Guardian:
        r"""Update a Guardian

        Update a Guardian

        :param id: The unique identifier of the Guardian to update
        :param identity_number: The identity number of the guardian, must be unique within the organization.
        :param first_name: The first name of the guardian
        :param last_name: The last name of the guardian
        :param external: ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included.
        :param identity_temporary: If the identity number is temporary for the guardian
        :param address: The address of the guardian
        :param email_address1: The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization. Can be used to login to the system if password-authentication is enabled for the organization.
        :param email_address2: The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information.
        :param phone_number1: The primary phone number of the guardian, will be used for communication with the guardian from the system.
        :param phone_number2: The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information.
        :param student_i_ds: The IDs of the students the guardian is responsible for.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GuardianUpdateRequest(
            id=id,
            guardian_update=models.GuardianUpdate(
                external=utils.get_pydantic_model(
                    external, Optional[models.GuardianUpdateExternal]
                ),
                identity_number=identity_number,
                identity_temporary=identity_temporary,
                first_name=first_name,
                last_name=last_name,
                address=utils.get_pydantic_model(
                    address, Optional[models.GuardianUpdateAddress]
                ),
                email_address1=email_address1,
                email_address2=email_address2,
                phone_number1=phone_number1,
                phone_number2=phone_number2,
                student_i_ds=student_i_ds,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/guardian/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.guardian_update, False, False, "json", models.GuardianUpdate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GuardianUpdate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Guardian, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.GuardianUpdate422ResponseBodyErrorData, http_res
            )
            raise errors.GuardianUpdate422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)
