"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .auditeventfilter import AuditEventFilter, AuditEventFilterTypedDict
from .auditeventsearch import AuditEventSearch, AuditEventSearchTypedDict
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Awaitable, Callable, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class AuditEventSearchRequestTypedDict(TypedDict):
    audit_event_filter: AuditEventFilterTypedDict
    r"""Request body"""
    limit: NotRequired[int]
    r"""The maximum number of AuditEvents to return (default: 50) when searching AuditEvents"""
    offset: NotRequired[int]
    r"""The number of AuditEvents to skip before starting to return results (default: 0) when searching AuditEvents"""


class AuditEventSearchRequest(BaseModel):
    audit_event_filter: Annotated[
        AuditEventFilter,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Request body"""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of AuditEvents to return (default: 50) when searching AuditEvents"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of AuditEvents to skip before starting to return results (default: 0) when searching AuditEvents"""


class AuditEventSearchResponseTypedDict(TypedDict):
    result: AuditEventSearchTypedDict


class AuditEventSearchResponse(BaseModel):
    next: Union[
        Callable[[], Optional[AuditEventSearchResponse]],
        Callable[[], Awaitable[Optional[AuditEventSearchResponse]]],
    ]

    result: AuditEventSearch
