"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import date, datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EmployeeMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: datetime
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class EmployeeMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


EmployeeGender = Literal[
    "Female",
    "Male",
    "Other",
]
r"""The gender of the employee"""


class EmployeeAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class EmployeeAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeTypedDict(TypedDict):
    r"""Employee holds the personal information about an employee in the organization."""

    id: str
    r"""Unique identifier for the Employee"""
    identity_number: str
    r"""The identity number of the employee, must be unique within the organization."""
    first_name: str
    r"""The first name of the employee"""
    last_name: str
    r"""The last name of the employee"""
    meta: NotRequired[EmployeeMetaTypedDict]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[EmployeeGender]]
    r"""The gender of the employee"""
    identity_temporary: NotRequired[bool]
    r"""If the identity number is temporary for the employee"""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[EmployeeAddressTypedDict]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class Employee(BaseModel):
    r"""Employee holds the personal information about an employee in the organization."""

    id: str
    r"""Unique identifier for the Employee"""

    identity_number: Annotated[str, pydantic.Field(alias="identityNumber")]
    r"""The identity number of the employee, must be unique within the organization."""

    first_name: Annotated[str, pydantic.Field(alias="firstName")]
    r"""The first name of the employee"""

    last_name: Annotated[str, pydantic.Field(alias="lastName")]
    r"""The last name of the employee"""

    meta: Optional[EmployeeMeta] = None
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: OptionalNullable[EmployeeGender] = UNSET
    r"""The gender of the employee"""

    identity_temporary: Annotated[
        Optional[bool], pydantic.Field(alias="identityTemporary")
    ] = False
    r"""If the identity number is temporary for the employee"""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: Optional[EmployeeAddress] = None
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "gender",
            "identityTemporary",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "external",
            "gender",
            "dateOfBirth",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
