"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .gender import Gender
from datetime import date, datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EmployeeFilterEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class EmployeeFilterEqualsMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeeFilterEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


EmployeeFilterEqualsGender = Literal[
    "Female",
    "Male",
    "Other",
]
r"""The gender of the employee"""


class EmployeeFilterEqualsAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class EmployeeFilterEqualsAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterEqualsTypedDict(TypedDict):
    r"""Equality filters for Employee"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Employee"""
    meta: NotRequired[Nullable[EmployeeFilterEqualsMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeFilterEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[EmployeeFilterEqualsGender]]
    r"""The gender of the employee"""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the employee, must be unique within the organization."""
    identity_temporary: NotRequired[Nullable[bool]]
    r"""If the identity number is temporary for the employee"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the employee"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the employee"""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeFilterEqualsAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeFilterEquals(BaseModel):
    r"""Equality filters for Employee"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Employee"""

    meta: OptionalNullable[EmployeeFilterEqualsMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeFilterEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: OptionalNullable[EmployeeFilterEqualsGender] = UNSET
    r"""The gender of the employee"""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the employee, must be unique within the organization."""

    identity_temporary: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="identityTemporary")
    ] = UNSET
    r"""If the identity number is temporary for the employee"""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the employee"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the employee"""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeFilterEqualsAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class EmployeeFilterNotEqualsMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeeFilterNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


EmployeeFilterNotEqualsGender = Literal[
    "Female",
    "Male",
    "Other",
]
r"""The gender of the employee"""


class EmployeeFilterNotEqualsAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class EmployeeFilterNotEqualsAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for Employee"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Employee"""
    meta: NotRequired[Nullable[EmployeeFilterNotEqualsMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeFilterNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[EmployeeFilterNotEqualsGender]]
    r"""The gender of the employee"""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the employee, must be unique within the organization."""
    identity_temporary: NotRequired[Nullable[bool]]
    r"""If the identity number is temporary for the employee"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the employee"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the employee"""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeFilterNotEqualsAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeFilterNotEquals(BaseModel):
    r"""Inequality filters for Employee"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Employee"""

    meta: OptionalNullable[EmployeeFilterNotEqualsMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeFilterNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: OptionalNullable[EmployeeFilterNotEqualsGender] = UNSET
    r"""The gender of the employee"""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the employee, must be unique within the organization."""

    identity_temporary: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="identityTemporary")
    ] = UNSET
    r"""If the identity number is temporary for the employee"""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the employee"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the employee"""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeFilterNotEqualsAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeeFilterGreaterThanMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeFilterGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeFilterGreaterThanAddressTypedDict(TypedDict):
    r"""The address of the employee"""


class EmployeeFilterGreaterThanAddress(BaseModel):
    r"""The address of the employee"""


class EmployeeFilterGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for Employee"""

    meta: NotRequired[Nullable[EmployeeFilterGreaterThanMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeFilterGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeFilterGreaterThanAddressTypedDict]]
    r"""The address of the employee"""


class EmployeeFilterGreaterThan(BaseModel):
    r"""Greater than filters for Employee"""

    meta: OptionalNullable[EmployeeFilterGreaterThanMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeFilterGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeFilterGreaterThanAddress] = UNSET
    r"""The address of the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeeFilterSmallerThanMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeFilterSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeFilterSmallerThanAddressTypedDict(TypedDict):
    r"""The address of the employee"""


class EmployeeFilterSmallerThanAddress(BaseModel):
    r"""The address of the employee"""


class EmployeeFilterSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for Employee"""

    meta: NotRequired[Nullable[EmployeeFilterSmallerThanMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeFilterSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeFilterSmallerThanAddressTypedDict]]
    r"""The address of the employee"""


class EmployeeFilterSmallerThan(BaseModel):
    r"""Smaller than filters for Employee"""

    meta: OptionalNullable[EmployeeFilterSmallerThanMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeFilterSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeFilterSmallerThanAddress] = UNSET
    r"""The address of the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeeFilterGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeFilterGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeFilterGreaterOrEqualAddressTypedDict(TypedDict):
    r"""The address of the employee"""


class EmployeeFilterGreaterOrEqualAddress(BaseModel):
    r"""The address of the employee"""


class EmployeeFilterGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for Employee"""

    meta: NotRequired[Nullable[EmployeeFilterGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeFilterGreaterOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeFilterGreaterOrEqualAddressTypedDict]]
    r"""The address of the employee"""


class EmployeeFilterGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for Employee"""

    meta: OptionalNullable[EmployeeFilterGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeFilterGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeFilterGreaterOrEqualAddress] = UNSET
    r"""The address of the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeeFilterSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeFilterSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeFilterSmallerOrEqualAddressTypedDict(TypedDict):
    r"""The address of the employee"""


class EmployeeFilterSmallerOrEqualAddress(BaseModel):
    r"""The address of the employee"""


class EmployeeFilterSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for Employee"""

    meta: NotRequired[Nullable[EmployeeFilterSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeFilterSmallerOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeFilterSmallerOrEqualAddressTypedDict]]
    r"""The address of the employee"""


class EmployeeFilterSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for Employee"""

    meta: OptionalNullable[EmployeeFilterSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeFilterSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeFilterSmallerOrEqualAddress] = UNSET
    r"""The address of the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class EmployeeFilterContainsMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class EmployeeFilterContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class EmployeeFilterContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class EmployeeFilterContainsAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[List[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[List[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[List[str]]
    r"""The city of the address"""
    country_code: NotRequired[List[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[List[str]]
    r"""The municipality code of the address"""


class EmployeeFilterContainsAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        Optional[List[str]], pydantic.Field(alias="postalAddress")
    ] = None
    r"""The postal address of the address"""

    postal_code: Annotated[Optional[List[str]], pydantic.Field(alias="postalCode")] = (
        None
    )
    r"""The postal code of the address"""

    postal_city: Annotated[Optional[List[str]], pydantic.Field(alias="postalCity")] = (
        None
    )
    r"""The city of the address"""

    country_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="countryCode")
    ] = None
    r"""The country code of the address"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""The municipality code of the address"""


class EmployeeFilterContainsTypedDict(TypedDict):
    r"""Contains filters for Employee"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Employee"""
    meta: NotRequired[Nullable[EmployeeFilterContainsMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeFilterContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[List[Gender]]
    r"""The gender of the employee"""
    identity_number: NotRequired[List[str]]
    r"""The identity number of the employee, must be unique within the organization."""
    identity_temporary: NotRequired[List[bool]]
    r"""If the identity number is temporary for the employee"""
    first_name: NotRequired[List[str]]
    r"""The first name of the employee"""
    last_name: NotRequired[List[str]]
    r"""The last name of the employee"""
    date_of_birth: NotRequired[List[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeFilterContainsAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[List[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[List[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[List[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[List[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeFilterContains(BaseModel):
    r"""Contains filters for Employee"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Employee"""

    meta: OptionalNullable[EmployeeFilterContainsMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeFilterContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: Optional[List[Gender]] = None
    r"""The gender of the employee"""

    identity_number: Annotated[
        Optional[List[str]], pydantic.Field(alias="identityNumber")
    ] = None
    r"""The identity number of the employee, must be unique within the organization."""

    identity_temporary: Annotated[
        Optional[List[bool]], pydantic.Field(alias="identityTemporary")
    ] = None
    r"""If the identity number is temporary for the employee"""

    first_name: Annotated[Optional[List[str]], pydantic.Field(alias="firstName")] = None
    r"""The first name of the employee"""

    last_name: Annotated[Optional[List[str]], pydantic.Field(alias="lastName")] = None
    r"""The last name of the employee"""

    date_of_birth: Annotated[
        Optional[List[date]], pydantic.Field(alias="dateOfBirth")
    ] = None
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeFilterContainsAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress1")
    ] = None
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress2")
    ] = None
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber1")
    ] = None
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber2")
    ] = None
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class EmployeeFilterNotContainsMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class EmployeeFilterNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class EmployeeFilterNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class EmployeeFilterNotContainsAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[List[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[List[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[List[str]]
    r"""The city of the address"""
    country_code: NotRequired[List[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[List[str]]
    r"""The municipality code of the address"""


class EmployeeFilterNotContainsAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        Optional[List[str]], pydantic.Field(alias="postalAddress")
    ] = None
    r"""The postal address of the address"""

    postal_code: Annotated[Optional[List[str]], pydantic.Field(alias="postalCode")] = (
        None
    )
    r"""The postal code of the address"""

    postal_city: Annotated[Optional[List[str]], pydantic.Field(alias="postalCity")] = (
        None
    )
    r"""The city of the address"""

    country_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="countryCode")
    ] = None
    r"""The country code of the address"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""The municipality code of the address"""


class EmployeeFilterNotContainsTypedDict(TypedDict):
    r"""Not contains filters for Employee"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Employee"""
    meta: NotRequired[Nullable[EmployeeFilterNotContainsMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeFilterNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[List[Gender]]
    r"""The gender of the employee"""
    identity_number: NotRequired[List[str]]
    r"""The identity number of the employee, must be unique within the organization."""
    identity_temporary: NotRequired[List[bool]]
    r"""If the identity number is temporary for the employee"""
    first_name: NotRequired[List[str]]
    r"""The first name of the employee"""
    last_name: NotRequired[List[str]]
    r"""The last name of the employee"""
    date_of_birth: NotRequired[List[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeFilterNotContainsAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[List[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[List[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[List[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[List[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeFilterNotContains(BaseModel):
    r"""Not contains filters for Employee"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Employee"""

    meta: OptionalNullable[EmployeeFilterNotContainsMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeFilterNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: Optional[List[Gender]] = None
    r"""The gender of the employee"""

    identity_number: Annotated[
        Optional[List[str]], pydantic.Field(alias="identityNumber")
    ] = None
    r"""The identity number of the employee, must be unique within the organization."""

    identity_temporary: Annotated[
        Optional[List[bool]], pydantic.Field(alias="identityTemporary")
    ] = None
    r"""If the identity number is temporary for the employee"""

    first_name: Annotated[Optional[List[str]], pydantic.Field(alias="firstName")] = None
    r"""The first name of the employee"""

    last_name: Annotated[Optional[List[str]], pydantic.Field(alias="lastName")] = None
    r"""The last name of the employee"""

    date_of_birth: Annotated[
        Optional[List[date]], pydantic.Field(alias="dateOfBirth")
    ] = None
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeFilterNotContainsAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress1")
    ] = None
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress2")
    ] = None
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber1")
    ] = None
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber2")
    ] = None
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""


class EmployeeFilterLikeMeta(BaseModel):
    r"""Metadata information for the Employee"""


class EmployeeFilterLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeeFilterLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterLikeAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class EmployeeFilterLikeAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterLikeTypedDict(TypedDict):
    r"""LIKE filters for Employee"""

    meta: NotRequired[Nullable[EmployeeFilterLikeMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeFilterLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the employee, must be unique within the organization."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the employee"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the employee"""
    address: NotRequired[Nullable[EmployeeFilterLikeAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeFilterLike(BaseModel):
    r"""LIKE filters for Employee"""

    meta: OptionalNullable[EmployeeFilterLikeMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeFilterLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the employee, must be unique within the organization."""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the employee"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the employee"""

    address: OptionalNullable[EmployeeFilterLikeAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""


class EmployeeFilterNotLikeMeta(BaseModel):
    r"""Metadata information for the Employee"""


class EmployeeFilterNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeeFilterNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNotLikeAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class EmployeeFilterNotLikeAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for Employee"""

    meta: NotRequired[Nullable[EmployeeFilterNotLikeMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeFilterNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the employee, must be unique within the organization."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the employee"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the employee"""
    address: NotRequired[Nullable[EmployeeFilterNotLikeAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeFilterNotLike(BaseModel):
    r"""NOT LIKE filters for Employee"""

    meta: OptionalNullable[EmployeeFilterNotLikeMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeFilterNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the employee, must be unique within the organization."""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the employee"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the employee"""

    address: OptionalNullable[EmployeeFilterNotLikeAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class EmployeeFilterNullMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class EmployeeFilterNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNullAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[bool]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[bool]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[bool]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[bool]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""The municipality code of the address"""


class EmployeeFilterNullAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNullTypedDict(TypedDict):
    r"""Null filters for Employee"""

    meta: NotRequired[Nullable[EmployeeFilterNullMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeFilterNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[bool]]
    r"""The gender of the employee"""
    date_of_birth: NotRequired[Nullable[bool]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeFilterNullAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[bool]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[bool]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[bool]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[bool]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeFilterNull(BaseModel):
    r"""Null filters for Employee"""

    meta: OptionalNullable[EmployeeFilterNullMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeFilterNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: OptionalNullable[bool] = UNSET
    r"""The gender of the employee"""

    date_of_birth: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeFilterNullAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class EmployeeFilterNotNullMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class EmployeeFilterNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNotNullAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[bool]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[bool]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[bool]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[bool]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""The municipality code of the address"""


class EmployeeFilterNotNullAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterNotNullTypedDict(TypedDict):
    r"""Not null filters for Employee"""

    meta: NotRequired[Nullable[EmployeeFilterNotNullMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeFilterNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[bool]]
    r"""The gender of the employee"""
    date_of_birth: NotRequired[Nullable[bool]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeFilterNotNullAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[bool]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[bool]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[bool]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[bool]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeFilterNotNull(BaseModel):
    r"""Not null filters for Employee"""

    meta: OptionalNullable[EmployeeFilterNotNullMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeFilterNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: OptionalNullable[bool] = UNSET
    r"""The gender of the employee"""

    date_of_birth: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeFilterNotNullAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeFilterTypedDict(TypedDict):
    r"""Filter object for Employee"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[EmployeeFilterEqualsTypedDict]]
    r"""Equality filters for Employee"""
    not_equals: NotRequired[Nullable[EmployeeFilterNotEqualsTypedDict]]
    r"""Inequality filters for Employee"""
    greater_than: NotRequired[Nullable[EmployeeFilterGreaterThanTypedDict]]
    r"""Greater than filters for Employee"""
    smaller_than: NotRequired[Nullable[EmployeeFilterSmallerThanTypedDict]]
    r"""Smaller than filters for Employee"""
    greater_or_equal: NotRequired[Nullable[EmployeeFilterGreaterOrEqualTypedDict]]
    r"""Greater than or equal filters for Employee"""
    smaller_or_equal: NotRequired[Nullable[EmployeeFilterSmallerOrEqualTypedDict]]
    r"""Smaller than or equal filters for Employee"""
    contains: NotRequired[Nullable[EmployeeFilterContainsTypedDict]]
    r"""Contains filters for Employee"""
    not_contains: NotRequired[Nullable[EmployeeFilterNotContainsTypedDict]]
    r"""Not contains filters for Employee"""
    like: NotRequired[Nullable[EmployeeFilterLikeTypedDict]]
    r"""LIKE filters for Employee"""
    not_like: NotRequired[Nullable[EmployeeFilterNotLikeTypedDict]]
    r"""NOT LIKE filters for Employee"""
    null: NotRequired[Nullable[EmployeeFilterNullTypedDict]]
    r"""Null filters for Employee"""
    not_null: NotRequired[Nullable[EmployeeFilterNotNullTypedDict]]
    r"""Not null filters for Employee"""
    nested_filters: NotRequired[List[EmployeeFilterTypedDict]]
    r"""NestedFilters of the Employee, useful for more complex filters"""


class EmployeeFilter(BaseModel):
    r"""Filter object for Employee"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[EmployeeFilterEquals] = UNSET
    r"""Equality filters for Employee"""

    not_equals: Annotated[
        OptionalNullable[EmployeeFilterNotEquals], pydantic.Field(alias="notEquals")
    ] = UNSET
    r"""Inequality filters for Employee"""

    greater_than: Annotated[
        OptionalNullable[EmployeeFilterGreaterThan], pydantic.Field(alias="greaterThan")
    ] = UNSET
    r"""Greater than filters for Employee"""

    smaller_than: Annotated[
        OptionalNullable[EmployeeFilterSmallerThan], pydantic.Field(alias="smallerThan")
    ] = UNSET
    r"""Smaller than filters for Employee"""

    greater_or_equal: Annotated[
        OptionalNullable[EmployeeFilterGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for Employee"""

    smaller_or_equal: Annotated[
        OptionalNullable[EmployeeFilterSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for Employee"""

    contains: OptionalNullable[EmployeeFilterContains] = UNSET
    r"""Contains filters for Employee"""

    not_contains: Annotated[
        OptionalNullable[EmployeeFilterNotContains], pydantic.Field(alias="notContains")
    ] = UNSET
    r"""Not contains filters for Employee"""

    like: OptionalNullable[EmployeeFilterLike] = UNSET
    r"""LIKE filters for Employee"""

    not_like: Annotated[
        OptionalNullable[EmployeeFilterNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for Employee"""

    null: OptionalNullable[EmployeeFilterNull] = UNSET
    r"""Null filters for Employee"""

    not_null: Annotated[
        OptionalNullable[EmployeeFilterNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for Employee"""

    nested_filters: Annotated[
        Optional[List[EmployeeFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the Employee, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
