"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .employeeplacementrole import EmployeePlacementRole
from datetime import date, datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EmployeePlacementFilterEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class EmployeePlacementFilterEqualsMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeePlacementFilterEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


EqualsRoles = Literal[
    "Admin",
    "CareTeam",
    "Manager",
    "OtherPersonnel",
    "Scheduler",
    "Teacher",
]
r"""The roles of the employee"""


class EmployeePlacementFilterEqualsTypedDict(TypedDict):
    r"""Equality filters for EmployeePlacement"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the EmployeePlacement"""
    meta: NotRequired[Nullable[EmployeePlacementFilterEqualsMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementFilterEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    employee_id: NotRequired[Nullable[str]]
    r"""The ID of the employee the placement belongs to"""
    school_id: NotRequired[Nullable[str]]
    r"""The ID of the school the placement belongs to"""
    signature: NotRequired[Nullable[str]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[str]]
    r"""The title of the employee"""
    roles: NotRequired[Nullable[EqualsRoles]]
    r"""The roles of the employee"""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementFilterEquals(BaseModel):
    r"""Equality filters for EmployeePlacement"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementFilterEqualsMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementFilterEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    employee_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="employeeID")
    ] = UNSET
    r"""The ID of the employee the placement belongs to"""

    school_id: Annotated[OptionalNullable[str], pydantic.Field(alias="schoolID")] = (
        UNSET
    )
    r"""The ID of the school the placement belongs to"""

    signature: OptionalNullable[str] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[str] = UNSET
    r"""The title of the employee"""

    roles: OptionalNullable[EqualsRoles] = UNSET
    r"""The roles of the employee"""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "employeeID",
            "schoolID",
            "signature",
            "title",
            "roles",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "employeeID",
            "schoolID",
            "signature",
            "title",
            "roles",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class EmployeePlacementFilterNotEqualsMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeePlacementFilterNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


NotEqualsRoles = Literal[
    "Admin",
    "CareTeam",
    "Manager",
    "OtherPersonnel",
    "Scheduler",
    "Teacher",
]
r"""The roles of the employee"""


class EmployeePlacementFilterNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for EmployeePlacement"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the EmployeePlacement"""
    meta: NotRequired[Nullable[EmployeePlacementFilterNotEqualsMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementFilterNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    employee_id: NotRequired[Nullable[str]]
    r"""The ID of the employee the placement belongs to"""
    school_id: NotRequired[Nullable[str]]
    r"""The ID of the school the placement belongs to"""
    signature: NotRequired[Nullable[str]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[str]]
    r"""The title of the employee"""
    roles: NotRequired[Nullable[NotEqualsRoles]]
    r"""The roles of the employee"""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementFilterNotEquals(BaseModel):
    r"""Inequality filters for EmployeePlacement"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementFilterNotEqualsMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementFilterNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    employee_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="employeeID")
    ] = UNSET
    r"""The ID of the employee the placement belongs to"""

    school_id: Annotated[OptionalNullable[str], pydantic.Field(alias="schoolID")] = (
        UNSET
    )
    r"""The ID of the school the placement belongs to"""

    signature: OptionalNullable[str] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[str] = UNSET
    r"""The title of the employee"""

    roles: OptionalNullable[NotEqualsRoles] = UNSET
    r"""The roles of the employee"""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "employeeID",
            "schoolID",
            "signature",
            "title",
            "roles",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "employeeID",
            "schoolID",
            "signature",
            "title",
            "roles",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeePlacementFilterGreaterThanMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementFilterGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementFilterGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementFilterGreaterThanMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementFilterGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementFilterGreaterThan(BaseModel):
    r"""Greater than filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementFilterGreaterThanMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementFilterGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeePlacementFilterSmallerThanMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementFilterSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementFilterSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementFilterSmallerThanMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementFilterSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementFilterSmallerThan(BaseModel):
    r"""Smaller than filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementFilterSmallerThanMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementFilterSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeePlacementFilterGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementFilterGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementFilterGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementFilterGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[
        Nullable[EmployeePlacementFilterGreaterOrEqualExternalTypedDict]
    ]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementFilterGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementFilterGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementFilterGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeePlacementFilterSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementFilterSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementFilterSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementFilterSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[
        Nullable[EmployeePlacementFilterSmallerOrEqualExternalTypedDict]
    ]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementFilterSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementFilterSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementFilterSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class EmployeePlacementFilterContainsMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class EmployeePlacementFilterContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class EmployeePlacementFilterContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class EmployeePlacementFilterContainsTypedDict(TypedDict):
    r"""Contains filters for EmployeePlacement"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the EmployeePlacement"""
    meta: NotRequired[Nullable[EmployeePlacementFilterContainsMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementFilterContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    employee_id: NotRequired[List[str]]
    r"""The ID of the employee the placement belongs to"""
    school_id: NotRequired[List[str]]
    r"""The ID of the school the placement belongs to"""
    signature: NotRequired[List[str]]
    r"""The signature of the employee"""
    title: NotRequired[List[str]]
    r"""The title of the employee"""
    roles: NotRequired[List[EmployeePlacementRole]]
    r"""The roles of the employee"""
    start_date: NotRequired[List[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[List[date]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[List[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class EmployeePlacementFilterContains(BaseModel):
    r"""Contains filters for EmployeePlacement"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementFilterContainsMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementFilterContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    employee_id: Annotated[Optional[List[str]], pydantic.Field(alias="employeeID")] = (
        None
    )
    r"""The ID of the employee the placement belongs to"""

    school_id: Annotated[Optional[List[str]], pydantic.Field(alias="schoolID")] = None
    r"""The ID of the school the placement belongs to"""

    signature: Optional[List[str]] = None
    r"""The signature of the employee"""

    title: Optional[List[str]] = None
    r"""The title of the employee"""

    roles: Optional[List[EmployeePlacementRole]] = None
    r"""The roles of the employee"""

    start_date: Annotated[Optional[List[date]], pydantic.Field(alias="startDate")] = (
        None
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[Optional[List[date]], pydantic.Field(alias="endDate")] = None
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        Optional[List[str]], pydantic.Field(alias="archiveYear")
    ] = None
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "employeeID",
            "schoolID",
            "signature",
            "title",
            "roles",
            "startDate",
            "endDate",
            "archiveYear",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class EmployeePlacementFilterNotContainsMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class EmployeePlacementFilterNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class EmployeePlacementFilterNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class EmployeePlacementFilterNotContainsTypedDict(TypedDict):
    r"""Not contains filters for EmployeePlacement"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the EmployeePlacement"""
    meta: NotRequired[Nullable[EmployeePlacementFilterNotContainsMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementFilterNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    employee_id: NotRequired[List[str]]
    r"""The ID of the employee the placement belongs to"""
    school_id: NotRequired[List[str]]
    r"""The ID of the school the placement belongs to"""
    signature: NotRequired[List[str]]
    r"""The signature of the employee"""
    title: NotRequired[List[str]]
    r"""The title of the employee"""
    roles: NotRequired[List[EmployeePlacementRole]]
    r"""The roles of the employee"""
    start_date: NotRequired[List[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[List[date]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[List[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class EmployeePlacementFilterNotContains(BaseModel):
    r"""Not contains filters for EmployeePlacement"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementFilterNotContainsMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementFilterNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    employee_id: Annotated[Optional[List[str]], pydantic.Field(alias="employeeID")] = (
        None
    )
    r"""The ID of the employee the placement belongs to"""

    school_id: Annotated[Optional[List[str]], pydantic.Field(alias="schoolID")] = None
    r"""The ID of the school the placement belongs to"""

    signature: Optional[List[str]] = None
    r"""The signature of the employee"""

    title: Optional[List[str]] = None
    r"""The title of the employee"""

    roles: Optional[List[EmployeePlacementRole]] = None
    r"""The roles of the employee"""

    start_date: Annotated[Optional[List[date]], pydantic.Field(alias="startDate")] = (
        None
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[Optional[List[date]], pydantic.Field(alias="endDate")] = None
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        Optional[List[str]], pydantic.Field(alias="archiveYear")
    ] = None
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "employeeID",
            "schoolID",
            "signature",
            "title",
            "roles",
            "startDate",
            "endDate",
            "archiveYear",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""


class EmployeePlacementFilterLikeMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""


class EmployeePlacementFilterLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeePlacementFilterLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterLikeTypedDict(TypedDict):
    r"""LIKE filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementFilterLikeMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementFilterLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    signature: NotRequired[Nullable[str]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[str]]
    r"""The title of the employee"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class EmployeePlacementFilterLike(BaseModel):
    r"""LIKE filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementFilterLikeMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementFilterLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    signature: OptionalNullable[str] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[str] = UNSET
    r"""The title of the employee"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "signature", "title", "archiveYear"]
        nullable_fields = ["meta", "external", "signature", "title", "archiveYear"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""


class EmployeePlacementFilterNotLikeMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""


class EmployeePlacementFilterNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeePlacementFilterNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementFilterNotLikeMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementFilterNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    signature: NotRequired[Nullable[str]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[str]]
    r"""The title of the employee"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class EmployeePlacementFilterNotLike(BaseModel):
    r"""NOT LIKE filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementFilterNotLikeMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementFilterNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    signature: OptionalNullable[str] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[str] = UNSET
    r"""The title of the employee"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "signature", "title", "archiveYear"]
        nullable_fields = ["meta", "external", "signature", "title", "archiveYear"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterNullMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class EmployeePlacementFilterNullMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class EmployeePlacementFilterNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterNullTypedDict(TypedDict):
    r"""Null filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementFilterNullMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementFilterNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    signature: NotRequired[Nullable[bool]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[bool]]
    r"""The title of the employee"""
    roles: NotRequired[Nullable[bool]]
    r"""The roles of the employee"""
    end_date: NotRequired[Nullable[bool]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[Nullable[bool]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[bool]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementFilterNull(BaseModel):
    r"""Null filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementFilterNullMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementFilterNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    signature: OptionalNullable[bool] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[bool] = UNSET
    r"""The title of the employee"""

    roles: OptionalNullable[bool] = UNSET
    r"""The roles of the employee"""

    end_date: Annotated[OptionalNullable[bool], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "signature",
            "title",
            "roles",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "meta",
            "external",
            "signature",
            "title",
            "roles",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class EmployeePlacementFilterNotNullMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class EmployeePlacementFilterNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterNotNullTypedDict(TypedDict):
    r"""Not null filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementFilterNotNullMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementFilterNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    signature: NotRequired[Nullable[bool]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[bool]]
    r"""The title of the employee"""
    roles: NotRequired[Nullable[bool]]
    r"""The roles of the employee"""
    end_date: NotRequired[Nullable[bool]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[Nullable[bool]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[bool]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementFilterNotNull(BaseModel):
    r"""Not null filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementFilterNotNullMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementFilterNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    signature: OptionalNullable[bool] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[bool] = UNSET
    r"""The title of the employee"""

    roles: OptionalNullable[bool] = UNSET
    r"""The roles of the employee"""

    end_date: Annotated[OptionalNullable[bool], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "signature",
            "title",
            "roles",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "meta",
            "external",
            "signature",
            "title",
            "roles",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementFilterTypedDict(TypedDict):
    r"""Filter object for EmployeePlacement"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[EmployeePlacementFilterEqualsTypedDict]]
    r"""Equality filters for EmployeePlacement"""
    not_equals: NotRequired[Nullable[EmployeePlacementFilterNotEqualsTypedDict]]
    r"""Inequality filters for EmployeePlacement"""
    greater_than: NotRequired[Nullable[EmployeePlacementFilterGreaterThanTypedDict]]
    r"""Greater than filters for EmployeePlacement"""
    smaller_than: NotRequired[Nullable[EmployeePlacementFilterSmallerThanTypedDict]]
    r"""Smaller than filters for EmployeePlacement"""
    greater_or_equal: NotRequired[
        Nullable[EmployeePlacementFilterGreaterOrEqualTypedDict]
    ]
    r"""Greater than or equal filters for EmployeePlacement"""
    smaller_or_equal: NotRequired[
        Nullable[EmployeePlacementFilterSmallerOrEqualTypedDict]
    ]
    r"""Smaller than or equal filters for EmployeePlacement"""
    contains: NotRequired[Nullable[EmployeePlacementFilterContainsTypedDict]]
    r"""Contains filters for EmployeePlacement"""
    not_contains: NotRequired[Nullable[EmployeePlacementFilterNotContainsTypedDict]]
    r"""Not contains filters for EmployeePlacement"""
    like: NotRequired[Nullable[EmployeePlacementFilterLikeTypedDict]]
    r"""LIKE filters for EmployeePlacement"""
    not_like: NotRequired[Nullable[EmployeePlacementFilterNotLikeTypedDict]]
    r"""NOT LIKE filters for EmployeePlacement"""
    null: NotRequired[Nullable[EmployeePlacementFilterNullTypedDict]]
    r"""Null filters for EmployeePlacement"""
    not_null: NotRequired[Nullable[EmployeePlacementFilterNotNullTypedDict]]
    r"""Not null filters for EmployeePlacement"""
    nested_filters: NotRequired[List[EmployeePlacementFilterTypedDict]]
    r"""NestedFilters of the EmployeePlacement, useful for more complex filters"""


class EmployeePlacementFilter(BaseModel):
    r"""Filter object for EmployeePlacement"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[EmployeePlacementFilterEquals] = UNSET
    r"""Equality filters for EmployeePlacement"""

    not_equals: Annotated[
        OptionalNullable[EmployeePlacementFilterNotEquals],
        pydantic.Field(alias="notEquals"),
    ] = UNSET
    r"""Inequality filters for EmployeePlacement"""

    greater_than: Annotated[
        OptionalNullable[EmployeePlacementFilterGreaterThan],
        pydantic.Field(alias="greaterThan"),
    ] = UNSET
    r"""Greater than filters for EmployeePlacement"""

    smaller_than: Annotated[
        OptionalNullable[EmployeePlacementFilterSmallerThan],
        pydantic.Field(alias="smallerThan"),
    ] = UNSET
    r"""Smaller than filters for EmployeePlacement"""

    greater_or_equal: Annotated[
        OptionalNullable[EmployeePlacementFilterGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for EmployeePlacement"""

    smaller_or_equal: Annotated[
        OptionalNullable[EmployeePlacementFilterSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for EmployeePlacement"""

    contains: OptionalNullable[EmployeePlacementFilterContains] = UNSET
    r"""Contains filters for EmployeePlacement"""

    not_contains: Annotated[
        OptionalNullable[EmployeePlacementFilterNotContains],
        pydantic.Field(alias="notContains"),
    ] = UNSET
    r"""Not contains filters for EmployeePlacement"""

    like: OptionalNullable[EmployeePlacementFilterLike] = UNSET
    r"""LIKE filters for EmployeePlacement"""

    not_like: Annotated[
        OptionalNullable[EmployeePlacementFilterNotLike],
        pydantic.Field(alias="notLike"),
    ] = UNSET
    r"""NOT LIKE filters for EmployeePlacement"""

    null: OptionalNullable[EmployeePlacementFilterNull] = UNSET
    r"""Null filters for EmployeePlacement"""

    not_null: Annotated[
        OptionalNullable[EmployeePlacementFilterNotNull],
        pydantic.Field(alias="notNull"),
    ] = UNSET
    r"""Not null filters for EmployeePlacement"""

    nested_filters: Annotated[
        Optional[List[EmployeePlacementFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the EmployeePlacement, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
