"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .employeeplacementfilter import (
    EmployeePlacementFilter,
    EmployeePlacementFilterTypedDict,
)
from .employeeplacementsearch import (
    EmployeePlacementSearch,
    EmployeePlacementSearchTypedDict,
)
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Awaitable, Callable, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class EmployeePlacementSearchRequestTypedDict(TypedDict):
    employee_placement_filter: EmployeePlacementFilterTypedDict
    r"""Request body"""
    limit: NotRequired[int]
    r"""The maximum number of EmployeePlacements to return (default: 50) when searching EmployeePlacements"""
    offset: NotRequired[int]
    r"""The number of EmployeePlacements to skip before starting to return results (default: 0) when searching EmployeePlacements"""


class EmployeePlacementSearchRequest(BaseModel):
    employee_placement_filter: Annotated[
        EmployeePlacementFilter,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Request body"""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of EmployeePlacements to return (default: 50) when searching EmployeePlacements"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of EmployeePlacements to skip before starting to return results (default: 0) when searching EmployeePlacements"""


class EmployeePlacementSearchResponseTypedDict(TypedDict):
    result: EmployeePlacementSearchTypedDict


class EmployeePlacementSearchResponse(BaseModel):
    next: Union[
        Callable[[], Optional[EmployeePlacementSearchResponse]],
        Callable[[], Awaitable[Optional[EmployeePlacementSearchResponse]]],
    ]

    result: EmployeePlacementSearch
