"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .employeefilter import EmployeeFilter, EmployeeFilterTypedDict
from .employeesearch import EmployeeSearch, EmployeeSearchTypedDict
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Awaitable, Callable, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class EmployeeSearchRequestTypedDict(TypedDict):
    employee_filter: EmployeeFilterTypedDict
    r"""Request body"""
    limit: NotRequired[int]
    r"""The maximum number of Employees to return (default: 50) when searching Employees"""
    offset: NotRequired[int]
    r"""The number of Employees to skip before starting to return results (default: 0) when searching Employees"""


class EmployeeSearchRequest(BaseModel):
    employee_filter: Annotated[
        EmployeeFilter,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Request body"""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of Employees to return (default: 50) when searching Employees"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of Employees to skip before starting to return results (default: 0) when searching Employees"""


class EmployeeSearchResponseTypedDict(TypedDict):
    result: EmployeeSearchTypedDict


class EmployeeSearchResponse(BaseModel):
    next: Union[
        Callable[[], Optional[EmployeeSearchResponse]],
        Callable[[], Awaitable[Optional[EmployeeSearchResponse]]],
    ]

    result: EmployeeSearch
