"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .grouptype import GroupType
from meitner.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GroupCreateExternalTypedDict(TypedDict):
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee, the Source-field is not included."""

    source_id: str
    r"""The ID of the external source"""


class GroupCreateExternal(BaseModel):
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee, the Source-field is not included."""

    source_id: Annotated[str, pydantic.Field(alias="sourceID")]
    r"""The ID of the external source"""


CategoryRequestBody = Literal[
    "Education",
    "Other",
]
r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

"""


class GroupCreateTypedDict(TypedDict):
    r"""Request body"""

    school_id: str
    r"""The ID of the school the group belongs to"""
    title: str
    r"""The title of the group, must be unique within the school."""
    external: NotRequired[GroupCreateExternalTypedDict]
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee, the Source-field is not included."""
    category: NotRequired[CategoryRequestBody]
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """
    types: NotRequired[List[GroupType]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[List[str]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[List[str]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupCreate(BaseModel):
    r"""Request body"""

    school_id: Annotated[str, pydantic.Field(alias="schoolID")]
    r"""The ID of the school the group belongs to"""

    title: str
    r"""The title of the group, must be unique within the school."""

    external: Optional[GroupCreateExternal] = None
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee, the Source-field is not included."""

    category: Optional[CategoryRequestBody] = "Education"
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """

    types: Optional[List[GroupType]] = None
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        Optional[List[str]], pydantic.Field(alias="moderatorIDs")
    ] = None
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="memberIDs")] = (
        None
    )
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """
