"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .grouptype import GroupType
from meitner.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GroupUpdateExternalTypedDict(TypedDict):
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee, the Source-field is not included."""

    source_id: str
    r"""The ID of the external source"""


class GroupUpdateExternal(BaseModel):
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee, the Source-field is not included."""

    source_id: Annotated[str, pydantic.Field(alias="sourceID")]
    r"""The ID of the external source"""


class GroupUpdateTypedDict(TypedDict):
    r"""Request body"""

    title: str
    r"""The title of the group, must be unique within the school."""
    external: NotRequired[GroupUpdateExternalTypedDict]
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee, the Source-field is not included."""
    types: NotRequired[List[GroupType]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[List[str]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[List[str]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupUpdate(BaseModel):
    r"""Request body"""

    title: str
    r"""The title of the group, must be unique within the school."""

    external: Optional[GroupUpdateExternal] = None
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee, the Source-field is not included."""

    types: Optional[List[GroupType]] = None
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        Optional[List[str]], pydantic.Field(alias="moderatorIDs")
    ] = None
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="memberIDs")] = (
        None
    )
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """
