"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GuardianCreateExternalTypedDict(TypedDict):
    r"""ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included."""

    source_id: str
    r"""The ID of the external source"""


class GuardianCreateExternal(BaseModel):
    r"""ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included."""

    source_id: Annotated[str, pydantic.Field(alias="sourceID")]
    r"""The ID of the external source"""


class GuardianCreateAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class GuardianCreateAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianCreateTypedDict(TypedDict):
    r"""Request body"""

    identity_number: str
    r"""The identity number of the guardian, must be unique within the organization."""
    first_name: str
    r"""The first name of the guardian"""
    last_name: str
    r"""The last name of the guardian"""
    external: NotRequired[GuardianCreateExternalTypedDict]
    r"""ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included."""
    identity_temporary: NotRequired[bool]
    r"""If the identity number is temporary for the guardian"""
    address: NotRequired[GuardianCreateAddressTypedDict]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[List[str]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianCreate(BaseModel):
    r"""Request body"""

    identity_number: Annotated[str, pydantic.Field(alias="identityNumber")]
    r"""The identity number of the guardian, must be unique within the organization."""

    first_name: Annotated[str, pydantic.Field(alias="firstName")]
    r"""The first name of the guardian"""

    last_name: Annotated[str, pydantic.Field(alias="lastName")]
    r"""The last name of the guardian"""

    external: Optional[GuardianCreateExternal] = None
    r"""ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included."""

    identity_temporary: Annotated[
        Optional[bool], pydantic.Field(alias="identityTemporary")
    ] = False
    r"""If the identity number is temporary for the guardian"""

    address: Optional[GuardianCreateAddress] = None
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="studentIDs")] = (
        None
    )
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "external",
            "identityTemporary",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = [
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
