"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .guardianfilter import GuardianFilter, GuardianFilterTypedDict
from .guardiansearch import GuardianSearch, GuardianSearchTypedDict
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Awaitable, Callable, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class GuardianSearchRequestTypedDict(TypedDict):
    guardian_filter: GuardianFilterTypedDict
    r"""Request body"""
    limit: NotRequired[int]
    r"""The maximum number of Guardians to return (default: 50) when searching Guardians"""
    offset: NotRequired[int]
    r"""The number of Guardians to skip before starting to return results (default: 0) when searching Guardians"""


class GuardianSearchRequest(BaseModel):
    guardian_filter: Annotated[
        GuardianFilter,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Request body"""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of Guardians to return (default: 50) when searching Guardians"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of Guardians to skip before starting to return results (default: 0) when searching Guardians"""


class GuardianSearchResponseTypedDict(TypedDict):
    result: GuardianSearchTypedDict


class GuardianSearchResponse(BaseModel):
    next: Union[
        Callable[[], Optional[GuardianSearchResponse]],
        Callable[[], Awaitable[Optional[GuardianSearchResponse]]],
    ]

    result: GuardianSearch
