"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SchoolCreateExternalTypedDict(TypedDict):
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the school, the Source-field is not included."""

    source_id: str
    r"""The ID of the external source"""


class SchoolCreateExternal(BaseModel):
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the school, the Source-field is not included."""

    source_id: Annotated[str, pydantic.Field(alias="sourceID")]
    r"""The ID of the external source"""


SchoolCreateSchoolType = Literal[
    "GR",
    "GY",
    "FS",
]
r"""Type of schooling provided at the school"""


class SchoolCreateTypedDict(TypedDict):
    r"""Request body"""

    title: str
    r"""The title of the school"""
    school_type: SchoolCreateSchoolType
    r"""Type of schooling provided at the school"""
    external: NotRequired[SchoolCreateExternalTypedDict]
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the school, the Source-field is not included."""
    unit_code: NotRequired[Nullable[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""


class SchoolCreate(BaseModel):
    r"""Request body"""

    title: str
    r"""The title of the school"""

    school_type: Annotated[SchoolCreateSchoolType, pydantic.Field(alias="schoolType")]
    r"""Type of schooling provided at the school"""

    external: Optional[SchoolCreateExternal] = None
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the school, the Source-field is not included."""

    unit_code: Annotated[OptionalNullable[str], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["external", "unitCode", "csnSchoolCode", "municipalityCode"]
        nullable_fields = ["unitCode", "csnSchoolCode", "municipalityCode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
