"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .schooltype import SchoolType
from datetime import datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SchoolFilterEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class SchoolFilterEqualsMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class SchoolFilterEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


SchoolFilterEqualsSchoolType = Literal[
    "GR",
    "GY",
    "FS",
]
r"""Type of schooling provided at the school"""


class SchoolFilterEqualsTypedDict(TypedDict):
    r"""Equality filters for School"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the School"""
    meta: NotRequired[Nullable[SchoolFilterEqualsMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolFilterEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    title: NotRequired[Nullable[str]]
    r"""The title of the school"""
    unit_code: NotRequired[Nullable[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""
    school_type: NotRequired[Nullable[SchoolFilterEqualsSchoolType]]
    r"""Type of schooling provided at the school"""


class SchoolFilterEquals(BaseModel):
    r"""Equality filters for School"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the School"""

    meta: OptionalNullable[SchoolFilterEqualsMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolFilterEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the school"""

    unit_code: Annotated[OptionalNullable[str], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    school_type: Annotated[
        OptionalNullable[SchoolFilterEqualsSchoolType],
        pydantic.Field(alias="schoolType"),
    ] = UNSET
    r"""Type of schooling provided at the school"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
            "schoolType",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
            "schoolType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class SchoolFilterNotEqualsMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class SchoolFilterNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


SchoolFilterNotEqualsSchoolType = Literal[
    "GR",
    "GY",
    "FS",
]
r"""Type of schooling provided at the school"""


class SchoolFilterNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for School"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the School"""
    meta: NotRequired[Nullable[SchoolFilterNotEqualsMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolFilterNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    title: NotRequired[Nullable[str]]
    r"""The title of the school"""
    unit_code: NotRequired[Nullable[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""
    school_type: NotRequired[Nullable[SchoolFilterNotEqualsSchoolType]]
    r"""Type of schooling provided at the school"""


class SchoolFilterNotEquals(BaseModel):
    r"""Inequality filters for School"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the School"""

    meta: OptionalNullable[SchoolFilterNotEqualsMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolFilterNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the school"""

    unit_code: Annotated[OptionalNullable[str], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    school_type: Annotated[
        OptionalNullable[SchoolFilterNotEqualsSchoolType],
        pydantic.Field(alias="schoolType"),
    ] = UNSET
    r"""Type of schooling provided at the school"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
            "schoolType",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
            "schoolType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class SchoolFilterGreaterThanMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolFilterGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolFilterGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for School"""

    meta: NotRequired[Nullable[SchoolFilterGreaterThanMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolFilterGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolFilterGreaterThan(BaseModel):
    r"""Greater than filters for School"""

    meta: OptionalNullable[SchoolFilterGreaterThanMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolFilterGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class SchoolFilterSmallerThanMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolFilterSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolFilterSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for School"""

    meta: NotRequired[Nullable[SchoolFilterSmallerThanMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolFilterSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolFilterSmallerThan(BaseModel):
    r"""Smaller than filters for School"""

    meta: OptionalNullable[SchoolFilterSmallerThanMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolFilterSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class SchoolFilterGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolFilterGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolFilterGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for School"""

    meta: NotRequired[Nullable[SchoolFilterGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolFilterGreaterOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolFilterGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for School"""

    meta: OptionalNullable[SchoolFilterGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolFilterGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class SchoolFilterSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolFilterSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolFilterSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for School"""

    meta: NotRequired[Nullable[SchoolFilterSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolFilterSmallerOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolFilterSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for School"""

    meta: OptionalNullable[SchoolFilterSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolFilterSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class SchoolFilterContainsMeta(BaseModel):
    r"""Metadata information for the School"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class SchoolFilterContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class SchoolFilterContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class SchoolFilterContainsTypedDict(TypedDict):
    r"""Contains filters for School"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the School"""
    meta: NotRequired[Nullable[SchoolFilterContainsMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolFilterContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    title: NotRequired[List[str]]
    r"""The title of the school"""
    unit_code: NotRequired[List[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[List[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[List[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""
    school_type: NotRequired[List[SchoolType]]
    r"""Type of schooling provided at the school"""


class SchoolFilterContains(BaseModel):
    r"""Contains filters for School"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the School"""

    meta: OptionalNullable[SchoolFilterContainsMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolFilterContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    title: Optional[List[str]] = None
    r"""The title of the school"""

    unit_code: Annotated[Optional[List[str]], pydantic.Field(alias="unitCode")] = None
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="csnSchoolCode")
    ] = None
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    school_type: Annotated[
        Optional[List[SchoolType]], pydantic.Field(alias="schoolType")
    ] = None
    r"""Type of schooling provided at the school"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
            "schoolType",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class SchoolFilterNotContainsMeta(BaseModel):
    r"""Metadata information for the School"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class SchoolFilterNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class SchoolFilterNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class SchoolFilterNotContainsTypedDict(TypedDict):
    r"""Not contains filters for School"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the School"""
    meta: NotRequired[Nullable[SchoolFilterNotContainsMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolFilterNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    title: NotRequired[List[str]]
    r"""The title of the school"""
    unit_code: NotRequired[List[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[List[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[List[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""
    school_type: NotRequired[List[SchoolType]]
    r"""Type of schooling provided at the school"""


class SchoolFilterNotContains(BaseModel):
    r"""Not contains filters for School"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the School"""

    meta: OptionalNullable[SchoolFilterNotContainsMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolFilterNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    title: Optional[List[str]] = None
    r"""The title of the school"""

    unit_code: Annotated[Optional[List[str]], pydantic.Field(alias="unitCode")] = None
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="csnSchoolCode")
    ] = None
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    school_type: Annotated[
        Optional[List[SchoolType]], pydantic.Field(alias="schoolType")
    ] = None
    r"""Type of schooling provided at the school"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
            "schoolType",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""


class SchoolFilterLikeMeta(BaseModel):
    r"""Metadata information for the School"""


class SchoolFilterLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class SchoolFilterLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterLikeTypedDict(TypedDict):
    r"""LIKE filters for School"""

    meta: NotRequired[Nullable[SchoolFilterLikeMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolFilterLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    title: NotRequired[Nullable[str]]
    r"""The title of the school"""
    unit_code: NotRequired[Nullable[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""


class SchoolFilterLike(BaseModel):
    r"""LIKE filters for School"""

    meta: OptionalNullable[SchoolFilterLikeMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolFilterLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the school"""

    unit_code: Annotated[OptionalNullable[str], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""


class SchoolFilterNotLikeMeta(BaseModel):
    r"""Metadata information for the School"""


class SchoolFilterNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class SchoolFilterNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for School"""

    meta: NotRequired[Nullable[SchoolFilterNotLikeMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolFilterNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    title: NotRequired[Nullable[str]]
    r"""The title of the school"""
    unit_code: NotRequired[Nullable[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""


class SchoolFilterNotLike(BaseModel):
    r"""NOT LIKE filters for School"""

    meta: OptionalNullable[SchoolFilterNotLikeMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolFilterNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the school"""

    unit_code: Annotated[OptionalNullable[str], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterNullMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class SchoolFilterNullMeta(BaseModel):
    r"""Metadata information for the School"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class SchoolFilterNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterNullTypedDict(TypedDict):
    r"""Null filters for School"""

    meta: NotRequired[Nullable[SchoolFilterNullMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolFilterNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    unit_code: NotRequired[Nullable[bool]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[bool]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""


class SchoolFilterNull(BaseModel):
    r"""Null filters for School"""

    meta: OptionalNullable[SchoolFilterNullMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolFilterNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    unit_code: Annotated[OptionalNullable[bool], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "meta",
            "external",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class SchoolFilterNotNullMeta(BaseModel):
    r"""Metadata information for the School"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class SchoolFilterNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterNotNullTypedDict(TypedDict):
    r"""Not null filters for School"""

    meta: NotRequired[Nullable[SchoolFilterNotNullMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolFilterNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    unit_code: NotRequired[Nullable[bool]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[bool]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""


class SchoolFilterNotNull(BaseModel):
    r"""Not null filters for School"""

    meta: OptionalNullable[SchoolFilterNotNullMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolFilterNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    unit_code: Annotated[OptionalNullable[bool], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "meta",
            "external",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolFilterTypedDict(TypedDict):
    r"""Filter object for School"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[SchoolFilterEqualsTypedDict]]
    r"""Equality filters for School"""
    not_equals: NotRequired[Nullable[SchoolFilterNotEqualsTypedDict]]
    r"""Inequality filters for School"""
    greater_than: NotRequired[Nullable[SchoolFilterGreaterThanTypedDict]]
    r"""Greater than filters for School"""
    smaller_than: NotRequired[Nullable[SchoolFilterSmallerThanTypedDict]]
    r"""Smaller than filters for School"""
    greater_or_equal: NotRequired[Nullable[SchoolFilterGreaterOrEqualTypedDict]]
    r"""Greater than or equal filters for School"""
    smaller_or_equal: NotRequired[Nullable[SchoolFilterSmallerOrEqualTypedDict]]
    r"""Smaller than or equal filters for School"""
    contains: NotRequired[Nullable[SchoolFilterContainsTypedDict]]
    r"""Contains filters for School"""
    not_contains: NotRequired[Nullable[SchoolFilterNotContainsTypedDict]]
    r"""Not contains filters for School"""
    like: NotRequired[Nullable[SchoolFilterLikeTypedDict]]
    r"""LIKE filters for School"""
    not_like: NotRequired[Nullable[SchoolFilterNotLikeTypedDict]]
    r"""NOT LIKE filters for School"""
    null: NotRequired[Nullable[SchoolFilterNullTypedDict]]
    r"""Null filters for School"""
    not_null: NotRequired[Nullable[SchoolFilterNotNullTypedDict]]
    r"""Not null filters for School"""
    nested_filters: NotRequired[List[SchoolFilterTypedDict]]
    r"""NestedFilters of the School, useful for more complex filters"""


class SchoolFilter(BaseModel):
    r"""Filter object for School"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[SchoolFilterEquals] = UNSET
    r"""Equality filters for School"""

    not_equals: Annotated[
        OptionalNullable[SchoolFilterNotEquals], pydantic.Field(alias="notEquals")
    ] = UNSET
    r"""Inequality filters for School"""

    greater_than: Annotated[
        OptionalNullable[SchoolFilterGreaterThan], pydantic.Field(alias="greaterThan")
    ] = UNSET
    r"""Greater than filters for School"""

    smaller_than: Annotated[
        OptionalNullable[SchoolFilterSmallerThan], pydantic.Field(alias="smallerThan")
    ] = UNSET
    r"""Smaller than filters for School"""

    greater_or_equal: Annotated[
        OptionalNullable[SchoolFilterGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for School"""

    smaller_or_equal: Annotated[
        OptionalNullable[SchoolFilterSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for School"""

    contains: OptionalNullable[SchoolFilterContains] = UNSET
    r"""Contains filters for School"""

    not_contains: Annotated[
        OptionalNullable[SchoolFilterNotContains], pydantic.Field(alias="notContains")
    ] = UNSET
    r"""Not contains filters for School"""

    like: OptionalNullable[SchoolFilterLike] = UNSET
    r"""LIKE filters for School"""

    not_like: Annotated[
        OptionalNullable[SchoolFilterNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for School"""

    null: OptionalNullable[SchoolFilterNull] = UNSET
    r"""Null filters for School"""

    not_null: Annotated[
        OptionalNullable[SchoolFilterNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for School"""

    nested_filters: Annotated[
        Optional[List[SchoolFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the School, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
