"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .schoolfilter import SchoolFilter, SchoolFilterTypedDict
from .schoolsearch import SchoolSearch, SchoolSearchTypedDict
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Awaitable, Callable, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class SchoolSearchRequestTypedDict(TypedDict):
    school_filter: SchoolFilterTypedDict
    r"""Request body"""
    limit: NotRequired[int]
    r"""The maximum number of Schools to return (default: 50) when searching Schools"""
    offset: NotRequired[int]
    r"""The number of Schools to skip before starting to return results (default: 0) when searching Schools"""


class SchoolSearchRequest(BaseModel):
    school_filter: Annotated[
        SchoolFilter,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Request body"""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of Schools to return (default: 50) when searching Schools"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of Schools to skip before starting to return results (default: 0) when searching Schools"""


class SchoolSearchResponseTypedDict(TypedDict):
    result: SchoolSearchTypedDict


class SchoolSearchResponse(BaseModel):
    next: Union[
        Callable[[], Optional[SchoolSearchResponse]],
        Callable[[], Awaitable[Optional[SchoolSearchResponse]]],
    ]

    result: SchoolSearch
