"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import date, datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class StudentPlacementMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: datetime
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class StudentPlacementMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentPlacementExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


StudentPlacementSchoolType1 = Literal[
    "GR",
    "GRAN",
    "GY",
    "GYAN",
    "FS",
]
r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""


StudentPlacementSchoolYear = Literal[
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
]
r"""The school year the student is placed in"""


class StudentPlacementTypedDict(TypedDict):
    r"""StudentPlacement holds the placement information about a student in a specific school."""

    id: str
    r"""Unique identifier for the StudentPlacement"""
    student_id: str
    r"""The ID of the student the placement belongs to"""
    school_id: str
    r"""The ID of the school the student is placed in"""
    school_type: StudentPlacementSchoolType1
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""
    start_date: date
    r"""The start date of the placement"""
    meta: NotRequired[StudentPlacementMetaTypedDict]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    school_year: NotRequired[Nullable[StudentPlacementSchoolYear]]
    r"""The school year the student is placed in"""
    has_childcare: NotRequired[bool]
    r"""Whether the student has childcare"""
    mother_tongue: NotRequired[Nullable[str]]
    r"""The mother tongue of the student"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacement(BaseModel):
    r"""StudentPlacement holds the placement information about a student in a specific school."""

    id: str
    r"""Unique identifier for the StudentPlacement"""

    student_id: Annotated[str, pydantic.Field(alias="studentID")]
    r"""The ID of the student the placement belongs to"""

    school_id: Annotated[str, pydantic.Field(alias="schoolID")]
    r"""The ID of the school the student is placed in"""

    school_type: Annotated[
        StudentPlacementSchoolType1, pydantic.Field(alias="schoolType")
    ]
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""

    start_date: Annotated[date, pydantic.Field(alias="startDate")]
    r"""The start date of the placement"""

    meta: Optional[StudentPlacementMeta] = None
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    school_year: Annotated[
        OptionalNullable[StudentPlacementSchoolYear], pydantic.Field(alias="schoolYear")
    ] = UNSET
    r"""The school year the student is placed in"""

    has_childcare: Annotated[Optional[bool], pydantic.Field(alias="hasChildcare")] = (
        False
    )
    r"""Whether the student has childcare"""

    mother_tongue: Annotated[
        OptionalNullable[str], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "external",
            "schoolYear",
            "motherTongue",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
