"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .schoolyear import SchoolYear
from .studentplacementschooltype import StudentPlacementSchoolType
from datetime import date, datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class StudentPlacementFilterEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class StudentPlacementFilterEqualsMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentPlacementFilterEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


StudentPlacementFilterEqualsSchoolType = Literal[
    "GR",
    "GRAN",
    "GY",
    "GYAN",
    "FS",
]
r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""


EqualsSchoolYear = Literal[
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
]
r"""The school year the student is placed in"""


class StudentPlacementFilterEqualsTypedDict(TypedDict):
    r"""Equality filters for StudentPlacement"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the StudentPlacement"""
    meta: NotRequired[Nullable[StudentPlacementFilterEqualsMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementFilterEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    student_id: NotRequired[Nullable[str]]
    r"""The ID of the student the placement belongs to"""
    school_id: NotRequired[Nullable[str]]
    r"""The ID of the school the student is placed in"""
    school_type: NotRequired[Nullable[StudentPlacementFilterEqualsSchoolType]]
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""
    school_year: NotRequired[Nullable[EqualsSchoolYear]]
    r"""The school year the student is placed in"""
    has_childcare: NotRequired[Nullable[bool]]
    r"""Whether the student has childcare"""
    mother_tongue: NotRequired[Nullable[str]]
    r"""The mother tongue of the student"""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementFilterEquals(BaseModel):
    r"""Equality filters for StudentPlacement"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the StudentPlacement"""

    meta: OptionalNullable[StudentPlacementFilterEqualsMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementFilterEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    student_id: Annotated[OptionalNullable[str], pydantic.Field(alias="studentID")] = (
        UNSET
    )
    r"""The ID of the student the placement belongs to"""

    school_id: Annotated[OptionalNullable[str], pydantic.Field(alias="schoolID")] = (
        UNSET
    )
    r"""The ID of the school the student is placed in"""

    school_type: Annotated[
        OptionalNullable[StudentPlacementFilterEqualsSchoolType],
        pydantic.Field(alias="schoolType"),
    ] = UNSET
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""

    school_year: Annotated[
        OptionalNullable[EqualsSchoolYear], pydantic.Field(alias="schoolYear")
    ] = UNSET
    r"""The school year the student is placed in"""

    has_childcare: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="hasChildcare")
    ] = UNSET
    r"""Whether the student has childcare"""

    mother_tongue: Annotated[
        OptionalNullable[str], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student"""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "studentID",
            "schoolID",
            "schoolType",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "studentID",
            "schoolID",
            "schoolType",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class StudentPlacementFilterNotEqualsMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentPlacementFilterNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


StudentPlacementFilterNotEqualsSchoolType = Literal[
    "GR",
    "GRAN",
    "GY",
    "GYAN",
    "FS",
]
r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""


NotEqualsSchoolYear = Literal[
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
]
r"""The school year the student is placed in"""


class StudentPlacementFilterNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for StudentPlacement"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the StudentPlacement"""
    meta: NotRequired[Nullable[StudentPlacementFilterNotEqualsMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementFilterNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    student_id: NotRequired[Nullable[str]]
    r"""The ID of the student the placement belongs to"""
    school_id: NotRequired[Nullable[str]]
    r"""The ID of the school the student is placed in"""
    school_type: NotRequired[Nullable[StudentPlacementFilterNotEqualsSchoolType]]
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""
    school_year: NotRequired[Nullable[NotEqualsSchoolYear]]
    r"""The school year the student is placed in"""
    has_childcare: NotRequired[Nullable[bool]]
    r"""Whether the student has childcare"""
    mother_tongue: NotRequired[Nullable[str]]
    r"""The mother tongue of the student"""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementFilterNotEquals(BaseModel):
    r"""Inequality filters for StudentPlacement"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the StudentPlacement"""

    meta: OptionalNullable[StudentPlacementFilterNotEqualsMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementFilterNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    student_id: Annotated[OptionalNullable[str], pydantic.Field(alias="studentID")] = (
        UNSET
    )
    r"""The ID of the student the placement belongs to"""

    school_id: Annotated[OptionalNullable[str], pydantic.Field(alias="schoolID")] = (
        UNSET
    )
    r"""The ID of the school the student is placed in"""

    school_type: Annotated[
        OptionalNullable[StudentPlacementFilterNotEqualsSchoolType],
        pydantic.Field(alias="schoolType"),
    ] = UNSET
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""

    school_year: Annotated[
        OptionalNullable[NotEqualsSchoolYear], pydantic.Field(alias="schoolYear")
    ] = UNSET
    r"""The school year the student is placed in"""

    has_childcare: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="hasChildcare")
    ] = UNSET
    r"""Whether the student has childcare"""

    mother_tongue: Annotated[
        OptionalNullable[str], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student"""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "studentID",
            "schoolID",
            "schoolType",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "studentID",
            "schoolID",
            "schoolType",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentPlacementFilterGreaterThanMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementFilterGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementFilterGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementFilterGreaterThanMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementFilterGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementFilterGreaterThan(BaseModel):
    r"""Greater than filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementFilterGreaterThanMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementFilterGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentPlacementFilterSmallerThanMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementFilterSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementFilterSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementFilterSmallerThanMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementFilterSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementFilterSmallerThan(BaseModel):
    r"""Smaller than filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementFilterSmallerThanMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementFilterSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentPlacementFilterGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementFilterGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementFilterGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementFilterGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[
        Nullable[StudentPlacementFilterGreaterOrEqualExternalTypedDict]
    ]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementFilterGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementFilterGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementFilterGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentPlacementFilterSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementFilterSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementFilterSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementFilterSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[
        Nullable[StudentPlacementFilterSmallerOrEqualExternalTypedDict]
    ]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementFilterSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementFilterSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementFilterSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class StudentPlacementFilterContainsMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class StudentPlacementFilterContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class StudentPlacementFilterContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class StudentPlacementFilterContainsTypedDict(TypedDict):
    r"""Contains filters for StudentPlacement"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the StudentPlacement"""
    meta: NotRequired[Nullable[StudentPlacementFilterContainsMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementFilterContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    student_id: NotRequired[List[str]]
    r"""The ID of the student the placement belongs to"""
    school_id: NotRequired[List[str]]
    r"""The ID of the school the student is placed in"""
    school_type: NotRequired[List[StudentPlacementSchoolType]]
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""
    school_year: NotRequired[List[SchoolYear]]
    r"""The school year the student is placed in"""
    has_childcare: NotRequired[List[bool]]
    r"""Whether the student has childcare"""
    mother_tongue: NotRequired[List[str]]
    r"""The mother tongue of the student"""
    start_date: NotRequired[List[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[List[date]]
    r"""The end date of the placement"""
    archive_year: NotRequired[List[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class StudentPlacementFilterContains(BaseModel):
    r"""Contains filters for StudentPlacement"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the StudentPlacement"""

    meta: OptionalNullable[StudentPlacementFilterContainsMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementFilterContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    student_id: Annotated[Optional[List[str]], pydantic.Field(alias="studentID")] = None
    r"""The ID of the student the placement belongs to"""

    school_id: Annotated[Optional[List[str]], pydantic.Field(alias="schoolID")] = None
    r"""The ID of the school the student is placed in"""

    school_type: Annotated[
        Optional[List[StudentPlacementSchoolType]], pydantic.Field(alias="schoolType")
    ] = None
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""

    school_year: Annotated[
        Optional[List[SchoolYear]], pydantic.Field(alias="schoolYear")
    ] = None
    r"""The school year the student is placed in"""

    has_childcare: Annotated[
        Optional[List[bool]], pydantic.Field(alias="hasChildcare")
    ] = None
    r"""Whether the student has childcare"""

    mother_tongue: Annotated[
        Optional[List[str]], pydantic.Field(alias="motherTongue")
    ] = None
    r"""The mother tongue of the student"""

    start_date: Annotated[Optional[List[date]], pydantic.Field(alias="startDate")] = (
        None
    )
    r"""The start date of the placement"""

    end_date: Annotated[Optional[List[date]], pydantic.Field(alias="endDate")] = None
    r"""The end date of the placement"""

    archive_year: Annotated[
        Optional[List[str]], pydantic.Field(alias="archiveYear")
    ] = None
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "studentID",
            "schoolID",
            "schoolType",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "startDate",
            "endDate",
            "archiveYear",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class StudentPlacementFilterNotContainsMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class StudentPlacementFilterNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class StudentPlacementFilterNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class StudentPlacementFilterNotContainsTypedDict(TypedDict):
    r"""Not contains filters for StudentPlacement"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the StudentPlacement"""
    meta: NotRequired[Nullable[StudentPlacementFilterNotContainsMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementFilterNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    student_id: NotRequired[List[str]]
    r"""The ID of the student the placement belongs to"""
    school_id: NotRequired[List[str]]
    r"""The ID of the school the student is placed in"""
    school_type: NotRequired[List[StudentPlacementSchoolType]]
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""
    school_year: NotRequired[List[SchoolYear]]
    r"""The school year the student is placed in"""
    has_childcare: NotRequired[List[bool]]
    r"""Whether the student has childcare"""
    mother_tongue: NotRequired[List[str]]
    r"""The mother tongue of the student"""
    start_date: NotRequired[List[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[List[date]]
    r"""The end date of the placement"""
    archive_year: NotRequired[List[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class StudentPlacementFilterNotContains(BaseModel):
    r"""Not contains filters for StudentPlacement"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the StudentPlacement"""

    meta: OptionalNullable[StudentPlacementFilterNotContainsMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementFilterNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    student_id: Annotated[Optional[List[str]], pydantic.Field(alias="studentID")] = None
    r"""The ID of the student the placement belongs to"""

    school_id: Annotated[Optional[List[str]], pydantic.Field(alias="schoolID")] = None
    r"""The ID of the school the student is placed in"""

    school_type: Annotated[
        Optional[List[StudentPlacementSchoolType]], pydantic.Field(alias="schoolType")
    ] = None
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""

    school_year: Annotated[
        Optional[List[SchoolYear]], pydantic.Field(alias="schoolYear")
    ] = None
    r"""The school year the student is placed in"""

    has_childcare: Annotated[
        Optional[List[bool]], pydantic.Field(alias="hasChildcare")
    ] = None
    r"""Whether the student has childcare"""

    mother_tongue: Annotated[
        Optional[List[str]], pydantic.Field(alias="motherTongue")
    ] = None
    r"""The mother tongue of the student"""

    start_date: Annotated[Optional[List[date]], pydantic.Field(alias="startDate")] = (
        None
    )
    r"""The start date of the placement"""

    end_date: Annotated[Optional[List[date]], pydantic.Field(alias="endDate")] = None
    r"""The end date of the placement"""

    archive_year: Annotated[
        Optional[List[str]], pydantic.Field(alias="archiveYear")
    ] = None
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "studentID",
            "schoolID",
            "schoolType",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "startDate",
            "endDate",
            "archiveYear",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""


class StudentPlacementFilterLikeMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""


class StudentPlacementFilterLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentPlacementFilterLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterLikeTypedDict(TypedDict):
    r"""LIKE filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementFilterLikeMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementFilterLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    mother_tongue: NotRequired[Nullable[str]]
    r"""The mother tongue of the student"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class StudentPlacementFilterLike(BaseModel):
    r"""LIKE filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementFilterLikeMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementFilterLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    mother_tongue: Annotated[
        OptionalNullable[str], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "motherTongue", "archiveYear"]
        nullable_fields = ["meta", "external", "motherTongue", "archiveYear"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""


class StudentPlacementFilterNotLikeMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""


class StudentPlacementFilterNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentPlacementFilterNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementFilterNotLikeMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementFilterNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    mother_tongue: NotRequired[Nullable[str]]
    r"""The mother tongue of the student"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class StudentPlacementFilterNotLike(BaseModel):
    r"""NOT LIKE filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementFilterNotLikeMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementFilterNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    mother_tongue: Annotated[
        OptionalNullable[str], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "motherTongue", "archiveYear"]
        nullable_fields = ["meta", "external", "motherTongue", "archiveYear"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterNullMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class StudentPlacementFilterNullMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class StudentPlacementFilterNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterNullTypedDict(TypedDict):
    r"""Null filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementFilterNullMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementFilterNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    school_year: NotRequired[Nullable[bool]]
    r"""The school year the student is placed in"""
    mother_tongue: NotRequired[Nullable[bool]]
    r"""The mother tongue of the student"""
    end_date: NotRequired[Nullable[bool]]
    r"""The end date of the placement"""
    archive_year: NotRequired[Nullable[bool]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[bool]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementFilterNull(BaseModel):
    r"""Null filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementFilterNullMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementFilterNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    school_year: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="schoolYear")
    ] = UNSET
    r"""The school year the student is placed in"""

    mother_tongue: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student"""

    end_date: Annotated[OptionalNullable[bool], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archive_year: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "schoolYear",
            "motherTongue",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "meta",
            "external",
            "schoolYear",
            "motherTongue",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class StudentPlacementFilterNotNullMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class StudentPlacementFilterNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterNotNullTypedDict(TypedDict):
    r"""Not null filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementFilterNotNullMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementFilterNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    school_year: NotRequired[Nullable[bool]]
    r"""The school year the student is placed in"""
    mother_tongue: NotRequired[Nullable[bool]]
    r"""The mother tongue of the student"""
    end_date: NotRequired[Nullable[bool]]
    r"""The end date of the placement"""
    archive_year: NotRequired[Nullable[bool]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[bool]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementFilterNotNull(BaseModel):
    r"""Not null filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementFilterNotNullMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementFilterNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    school_year: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="schoolYear")
    ] = UNSET
    r"""The school year the student is placed in"""

    mother_tongue: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student"""

    end_date: Annotated[OptionalNullable[bool], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archive_year: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "schoolYear",
            "motherTongue",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "meta",
            "external",
            "schoolYear",
            "motherTongue",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementFilterTypedDict(TypedDict):
    r"""Filter object for StudentPlacement"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[StudentPlacementFilterEqualsTypedDict]]
    r"""Equality filters for StudentPlacement"""
    not_equals: NotRequired[Nullable[StudentPlacementFilterNotEqualsTypedDict]]
    r"""Inequality filters for StudentPlacement"""
    greater_than: NotRequired[Nullable[StudentPlacementFilterGreaterThanTypedDict]]
    r"""Greater than filters for StudentPlacement"""
    smaller_than: NotRequired[Nullable[StudentPlacementFilterSmallerThanTypedDict]]
    r"""Smaller than filters for StudentPlacement"""
    greater_or_equal: NotRequired[
        Nullable[StudentPlacementFilterGreaterOrEqualTypedDict]
    ]
    r"""Greater than or equal filters for StudentPlacement"""
    smaller_or_equal: NotRequired[
        Nullable[StudentPlacementFilterSmallerOrEqualTypedDict]
    ]
    r"""Smaller than or equal filters for StudentPlacement"""
    contains: NotRequired[Nullable[StudentPlacementFilterContainsTypedDict]]
    r"""Contains filters for StudentPlacement"""
    not_contains: NotRequired[Nullable[StudentPlacementFilterNotContainsTypedDict]]
    r"""Not contains filters for StudentPlacement"""
    like: NotRequired[Nullable[StudentPlacementFilterLikeTypedDict]]
    r"""LIKE filters for StudentPlacement"""
    not_like: NotRequired[Nullable[StudentPlacementFilterNotLikeTypedDict]]
    r"""NOT LIKE filters for StudentPlacement"""
    null: NotRequired[Nullable[StudentPlacementFilterNullTypedDict]]
    r"""Null filters for StudentPlacement"""
    not_null: NotRequired[Nullable[StudentPlacementFilterNotNullTypedDict]]
    r"""Not null filters for StudentPlacement"""
    nested_filters: NotRequired[List[StudentPlacementFilterTypedDict]]
    r"""NestedFilters of the StudentPlacement, useful for more complex filters"""


class StudentPlacementFilter(BaseModel):
    r"""Filter object for StudentPlacement"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[StudentPlacementFilterEquals] = UNSET
    r"""Equality filters for StudentPlacement"""

    not_equals: Annotated[
        OptionalNullable[StudentPlacementFilterNotEquals],
        pydantic.Field(alias="notEquals"),
    ] = UNSET
    r"""Inequality filters for StudentPlacement"""

    greater_than: Annotated[
        OptionalNullable[StudentPlacementFilterGreaterThan],
        pydantic.Field(alias="greaterThan"),
    ] = UNSET
    r"""Greater than filters for StudentPlacement"""

    smaller_than: Annotated[
        OptionalNullable[StudentPlacementFilterSmallerThan],
        pydantic.Field(alias="smallerThan"),
    ] = UNSET
    r"""Smaller than filters for StudentPlacement"""

    greater_or_equal: Annotated[
        OptionalNullable[StudentPlacementFilterGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for StudentPlacement"""

    smaller_or_equal: Annotated[
        OptionalNullable[StudentPlacementFilterSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for StudentPlacement"""

    contains: OptionalNullable[StudentPlacementFilterContains] = UNSET
    r"""Contains filters for StudentPlacement"""

    not_contains: Annotated[
        OptionalNullable[StudentPlacementFilterNotContains],
        pydantic.Field(alias="notContains"),
    ] = UNSET
    r"""Not contains filters for StudentPlacement"""

    like: OptionalNullable[StudentPlacementFilterLike] = UNSET
    r"""LIKE filters for StudentPlacement"""

    not_like: Annotated[
        OptionalNullable[StudentPlacementFilterNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for StudentPlacement"""

    null: OptionalNullable[StudentPlacementFilterNull] = UNSET
    r"""Null filters for StudentPlacement"""

    not_null: Annotated[
        OptionalNullable[StudentPlacementFilterNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for StudentPlacement"""

    nested_filters: Annotated[
        Optional[List[StudentPlacementFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the StudentPlacement, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
