"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .studentplacementfilter import (
    StudentPlacementFilter,
    StudentPlacementFilterTypedDict,
)
from .studentplacementsearch import (
    StudentPlacementSearch,
    StudentPlacementSearchTypedDict,
)
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Awaitable, Callable, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class StudentPlacementSearchRequestTypedDict(TypedDict):
    student_placement_filter: StudentPlacementFilterTypedDict
    r"""Request body"""
    limit: NotRequired[int]
    r"""The maximum number of StudentPlacements to return (default: 50) when searching StudentPlacements"""
    offset: NotRequired[int]
    r"""The number of StudentPlacements to skip before starting to return results (default: 0) when searching StudentPlacements"""


class StudentPlacementSearchRequest(BaseModel):
    student_placement_filter: Annotated[
        StudentPlacementFilter,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Request body"""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of StudentPlacements to return (default: 50) when searching StudentPlacements"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of StudentPlacements to skip before starting to return results (default: 0) when searching StudentPlacements"""


class StudentPlacementSearchResponseTypedDict(TypedDict):
    result: StudentPlacementSearchTypedDict


class StudentPlacementSearchResponse(BaseModel):
    next: Union[
        Callable[[], Optional[StudentPlacementSearchResponse]],
        Callable[[], Awaitable[Optional[StudentPlacementSearchResponse]]],
    ]

    result: StudentPlacementSearch
