"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import date
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class StudentPlacementUpdateExternalTypedDict(TypedDict):
    r"""ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the student placement, the Source-field is not included."""

    source_id: str
    r"""The ID of the external source"""


class StudentPlacementUpdateExternal(BaseModel):
    r"""ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the student placement, the Source-field is not included."""

    source_id: Annotated[str, pydantic.Field(alias="sourceID")]
    r"""The ID of the external source"""


StudentPlacementUpdateSchoolType = Literal[
    "GR",
    "GRAN",
    "GY",
    "GYAN",
    "FS",
]
r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""


StudentPlacementUpdateSchoolYear = Literal[
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
]
r"""The school year the student is placed in"""


class StudentPlacementUpdateTypedDict(TypedDict):
    r"""Request body"""

    school_type: StudentPlacementUpdateSchoolType
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""
    start_date: date
    r"""The start date of the placement"""
    external: NotRequired[StudentPlacementUpdateExternalTypedDict]
    r"""ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the student placement, the Source-field is not included."""
    school_year: NotRequired[Nullable[StudentPlacementUpdateSchoolYear]]
    r"""The school year the student is placed in"""
    has_childcare: NotRequired[bool]
    r"""Whether the student has childcare"""
    mother_tongue: NotRequired[Nullable[str]]
    r"""The mother tongue of the student"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""


class StudentPlacementUpdate(BaseModel):
    r"""Request body"""

    school_type: Annotated[
        StudentPlacementUpdateSchoolType, pydantic.Field(alias="schoolType")
    ]
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""

    start_date: Annotated[date, pydantic.Field(alias="startDate")]
    r"""The start date of the placement"""

    external: Optional[StudentPlacementUpdateExternal] = None
    r"""ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the student placement, the Source-field is not included."""

    school_year: Annotated[
        OptionalNullable[StudentPlacementUpdateSchoolYear],
        pydantic.Field(alias="schoolYear"),
    ] = UNSET
    r"""The school year the student is placed in"""

    has_childcare: Annotated[Optional[bool], pydantic.Field(alias="hasChildcare")] = (
        False
    )
    r"""Whether the student has childcare"""

    mother_tongue: Annotated[
        OptionalNullable[str], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "external",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "endDate",
        ]
        nullable_fields = ["schoolYear", "motherTongue", "endDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
