BASE_WEB_URL = {
    "pubmlst": "https://pubmlst.org/bigsdb",
    "pasteur": "https://bigsdb.pasteur.fr/cgi-bin/bigsdb/bigsdb.pl",
}

BASE_API_URL = {
    "pubmlst": "https://rest.pubmlst.org",
    "pasteur": "https://bigsdb.pasteur.fr/api",
}

# As of 2025/01/28, not all databases are available from the https://rest.pubmlst.org/db endpoint.
# This is a static lists taken from the "Database Registrations" section under "My Account"
AVAILABLE_DATABASES = {
    "pubmlst": {
        "achromobacter": "Achromobacter",
        "abaumannii": "Acinetobacter baumannii",
        "aeromonas": "Aeromonas",
        "aactinomycetemcomitans": "Aggregatibacter actinomycetemcomitans",
        "aphagocytophilum": "Anaplasma phagocytophilum",
        "arcobacter": "Arcobacter",
        "afumigatus": "Aspergillus fumigatus",
        "aparagallinarum": "Avibacterium paragallinarum",
        "bcereus": "Bacillus cereus",
        "blicheniformis": "Bacillus licheniformis",
        "bsubtilis": "Bacillus subtilis",
        "bfragilis": "Bacteroides fragilis",
        "bbacilliformis": "Bartonella bacilliformis",
        "bhenselae": "Bartonella henselae",
        "bwashoensis": "Bartonella washoensis",
        "blastocystis": "Blastocystis",
        "borrelia": "Borrelia",
        "brachyspira": "Brachyspira",
        "brucella": "Brucella",
        "bcc": "Burkholderia cepacia complex",
        "bmallei": "Burkholderia mallei",
        "bpseudomallei": "Burkholderia pseudomallei",
        "campylobacter": "Campylobacter jejuni/coli",
        "campylobacter_nonjejuni": "Campylobacter non jejuni/coli",
        "calbicans": "Candida albicans",
        "cglabrata": "Candida glabrata",
        "ckrusei": "Candida krusei",
        "ctropicalis": "Candida tropicalis",
        "liberibacter": "Candidatus Liberibacter solanacearum",
        "cmaltaromaticum": "Carnobacterium maltaromaticum",
        "chlamydiales": "Chlamydiales",
        "cfreundii": "Citrobacter spp.",
        "csinensis": "Clonorchis sinensis",
        "cdifficile": "Clostridioides difficile",
        "cbotulinum": "Clostridium botulinum",
        "cchauvoei": "Clostridium chauvoei",
        "cperfringens": "Clostridium perfringens",
        "csepticum": "Clostridium septicum",
        "cronobacter": "Cronobacter",
        "pacnes": "Cutibacterium acnes",
        "dnodosus": "Dichelobacter nodosus",
        "edwardsiella": "Edwardsiella",
        "ecloacae": "Enterobacter cloacae",
        "efaecalis": "Enterococcus faecalis",
        "efaecium": "Enterococcus faecium",
        "escherichia": "Escherichia",
        "fpsychrophilum": "Flavobacterium psychrophilum",
        "gallibacterium": "Gallibacterium anatis",
        "geotrichum": "Geotrichum",
        "hparasuis": "Glaesserella parasuis",
        "hinfluenzae": "Haemophilus influenzae",
        "hcinaedi": "Helicobacter cinaedi",
        "helicobacter": "Helicobacter pylori",
        "hsuis": "Helicobacter suis",
        "kaerogenes": "Klebsiella aerogenes",
        "koxytoca": "Klebsiella oxytoca species complex",
        "kseptempunctata": "Kudoa septempunctata",
        "lsalivarius": "Lactobacillus salivarius",
        "lgarvieae": "Lactococcus garvieae",
        "llactis_phage": "Lactococcus lactis 936-like bacteriophage",
        "leptospira": "Leptospira spp.",
        "mcanis": "Macrococcus canis",
        "mcaseolyticus": "Macrococcus caseolyticus",
        "msciuri": "Mammaliicoccus sciuri",
        "mhaemolytica": "Mannheimia haemolytica",
        "mplutonius": "Melissococcus plutonius",
        "mycobacteria": "Mycobacteria",
        "mabscessus": "Mycobacteroides abscessus complex",
        "magalactiae": "Mycoplasma agalactiae",
        "manserisalpingitidis": "Mycoplasma anserisalpingitidis",
        "mbovis": "Mycoplasma bovis",
        "mflocculare": "Mycoplasma flocculare",
        "mgallisepticum": "Mycoplasma gallisepticum",
        "mgenitalium": "Mycoplasma genitalium",
        "mhominis": "Mycoplasma hominis",
        "mhyopneumoniae": "Mycoplasma hyopneumoniae",
        "mhyorhinis": "Mycoplasma hyorhinis",
        "mhyosynoviae": "Mycoplasma hyosynoviae",
        "miowae": "Mycoplasma iowae",
        "mpneumoniae": "Mycoplasma pneumoniae",
        "msynoviae": "Mycoplasma synoviae",
        "neisseria": "Neisseria",
        "oralstrep": "Oral Streptococcus",
        "otsutsugamushi": "Orientia tsutsugamushi",
        "orhinotracheale": "Ornithobacterium rhinotracheale",
        "plarvae": "Paenibacillus larvae",
        "pmultocida": "Pasteurella multocida",
        "ppentosaceus": "Pediococcus pentosaceus",
        "pdamselae": "Photobacterium damselae",
        "psalmonis": "Piscirickettsia salmonis",
        "plasmid": "Plasmid",
        "pgingivalis": "Porphyromonas gingivalis",
        "proteus": "Proteus",
        "providencia": "Providencia",
        "paeruginosa": "Pseudomonas aeruginosa",
        "pfluorescens": "Pseudomonas fluorescens",
        "pputida": "Pseudomonas putida",
        "rhodococcus": "Rhodococcus",
        "ranatipestifer": "Riemerella anatipestifer",
        "salmonella": "Salmonella",
        "sparasitica": "Saprolegnia parasitica",
        "serratia": "Serratia",
        "shewanella": "Shewanella",
        "sinorhizobium": "Sinorhizobium",
        "saureus": "Staphylococcus aureus",
        "schromogenes": "Staphylococcus chromogenes",
        "sepidermidis": "Staphylococcus epidermidis",
        "shaemolyticus": "Staphylococcus haemolyticus",
        "shominis": "Staphylococcus hominis",
        "spseudintermedius": "Staphylococcus pseudintermedius",
        "smaltophilia": "Stenotrophomonas maltophilia",
        "sagalactiae": "Streptococcus agalactiae",
        "sbsec": "Streptococcus bovis/equinus complex",
        "scanis": "Streptococcus canis",
        "sdysgalactiae": "Streptococcus dysgalactiae",
        "sgallolyticus": "Streptococcus gallolyticus",
        "siniae": "Streptococcus iniae",
        "smitis": "Streptococcus mitis",
        "spneumoniae": "Streptococcus pneumoniae",
        "spyogenes": "Streptococcus pyogenes",
        "ssuis": "Streptococcus suis",
        "sthermophilus": "Streptococcus thermophilus",
        "suberis": "Streptococcus uberis",
        "szooepidemicus": "Streptococcus zooepidemicus",
        "streptomyces": "Streptomyces",
        "taylorella": "Taylorella",
        "tenacibaculum": "Tenacibaculum",
        "tpallidum": "Treponema pallidum",
        "tvaginalis": "Trichomonas vaginalis",
        "ureaplasma": "Ureaplasma",
        "vcholerae": "Vibrio cholerae",
        "vparahaemolyticus": "Vibrio parahaemolyticus",
        "vtapetis": "Vibrio tapetis",
        "vibrio": "Vibrio",
        "vvulnificus": "Vibrio vulnificus",
        "wolbachia": "Wolbachia",
        "xcitri": "Xanthomonas citri",
        "xfastidiosa": "Xylella fastidiosa",
        "yruckeri": "Yersinia ruckeri",
        "yersinia": "Yersinia",
    },
    "pasteur": {
        "bordetella": "Bordetella",
        "perfringens": "Clostridium perfringens",
        "diphtheria": "Corynebacterium",
        "elizabethkingia": "Elizabethkingia",
        "ecoli": "Escherichia coli",
        "kingella": "Kingella kingae",
        "klebsiella": "Klebsiella",
        "leptospira": "Leptospira",
        "listeria": "Listeria",
        "mycoabscessus": "Mycobacterium abscessus",
        "epidermidis": "Staphylococcus epidermidis",
        "staphlugdunensis": "Staphylococcus lugdunensis",
        "streptothermophilus": "Streptococcus thermophilus",
        "yersinia": "Yersinia",
    },
}
