# Advanced Features Examples

Advanced Axon capabilities.

## Examples

- `09_memory_compaction_demo.py` - Basic compaction
- `21_audit_logging.py` - Compliance audit trails
- `22_privacy_detection.py` - PII detection
- `23_structured_logging.py` - JSON logging
- `24_advanced_compaction.py` - Advanced compaction strategies
- `25_transactional_operations.py` - Two-phase commit (2PC)

## Features

- **Audit Logging** - GDPR/HIPAA compliance
- **PII Detection** - Automatic sensitive data identification
- **Structured Logging** - JSON logs with correlation IDs
- **Compaction Strategies** - Count, semantic, importance, time, hybrid
- **Transactions** - ACID guarantees across tiers

## Prerequisites

Some examples require OpenAI API key for summarization.

## Quick Start

```bash
python examples/advanced-features/21_audit_logging.py
```
