# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserScramCredentialArgs', 'UserScramCredential']

@pulumi.input_type
class UserScramCredentialArgs:
    def __init__(__self__, *,
                 scram_mechanism: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 password_wo_version: Optional[pulumi.Input[_builtins.str]] = None,
                 scram_iterations: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a UserScramCredential resource.
        :param pulumi.Input[_builtins.str] scram_mechanism: The SCRAM mechanism used to generate the credential (SCRAM-SHA-256, SCRAM-SHA-512)
        :param pulumi.Input[_builtins.str] username: The name of the credential
        :param pulumi.Input[_builtins.str] password: The password of the credential (deprecated, use password_wo instead)
        :param pulumi.Input[_builtins.str] password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The write-only password of the credential
        :param pulumi.Input[_builtins.str] password_wo_version: Version identifier for the write-only password to track changes
        :param pulumi.Input[_builtins.int] scram_iterations: The number of SCRAM iterations used when generating the credential
        """
        pulumi.set(__self__, "scram_mechanism", scram_mechanism)
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if scram_iterations is not None:
            pulumi.set(__self__, "scram_iterations", scram_iterations)

    @_builtins.property
    @pulumi.getter(name="scramMechanism")
    def scram_mechanism(self) -> pulumi.Input[_builtins.str]:
        """
        The SCRAM mechanism used to generate the credential (SCRAM-SHA-256, SCRAM-SHA-512)
        """
        return pulumi.get(self, "scram_mechanism")

    @scram_mechanism.setter
    def scram_mechanism(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scram_mechanism", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the credential
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the credential (deprecated, use password_wo instead)
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The write-only password of the credential
        """
        return pulumi.get(self, "password_wo")

    @password_wo.setter
    def password_wo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_wo", value)

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version identifier for the write-only password to track changes
        """
        return pulumi.get(self, "password_wo_version")

    @password_wo_version.setter
    def password_wo_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_wo_version", value)

    @_builtins.property
    @pulumi.getter(name="scramIterations")
    def scram_iterations(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of SCRAM iterations used when generating the credential
        """
        return pulumi.get(self, "scram_iterations")

    @scram_iterations.setter
    def scram_iterations(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scram_iterations", value)


@pulumi.input_type
class _UserScramCredentialState:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 password_wo_version: Optional[pulumi.Input[_builtins.str]] = None,
                 scram_iterations: Optional[pulumi.Input[_builtins.int]] = None,
                 scram_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserScramCredential resources.
        :param pulumi.Input[_builtins.str] password: The password of the credential (deprecated, use password_wo instead)
        :param pulumi.Input[_builtins.str] password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The write-only password of the credential
        :param pulumi.Input[_builtins.str] password_wo_version: Version identifier for the write-only password to track changes
        :param pulumi.Input[_builtins.int] scram_iterations: The number of SCRAM iterations used when generating the credential
        :param pulumi.Input[_builtins.str] scram_mechanism: The SCRAM mechanism used to generate the credential (SCRAM-SHA-256, SCRAM-SHA-512)
        :param pulumi.Input[_builtins.str] username: The name of the credential
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if scram_iterations is not None:
            pulumi.set(__self__, "scram_iterations", scram_iterations)
        if scram_mechanism is not None:
            pulumi.set(__self__, "scram_mechanism", scram_mechanism)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the credential (deprecated, use password_wo instead)
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The write-only password of the credential
        """
        return pulumi.get(self, "password_wo")

    @password_wo.setter
    def password_wo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_wo", value)

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version identifier for the write-only password to track changes
        """
        return pulumi.get(self, "password_wo_version")

    @password_wo_version.setter
    def password_wo_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_wo_version", value)

    @_builtins.property
    @pulumi.getter(name="scramIterations")
    def scram_iterations(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of SCRAM iterations used when generating the credential
        """
        return pulumi.get(self, "scram_iterations")

    @scram_iterations.setter
    def scram_iterations(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scram_iterations", value)

    @_builtins.property
    @pulumi.getter(name="scramMechanism")
    def scram_mechanism(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SCRAM mechanism used to generate the credential (SCRAM-SHA-256, SCRAM-SHA-512)
        """
        return pulumi.get(self, "scram_mechanism")

    @scram_mechanism.setter
    def scram_mechanism(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scram_mechanism", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the credential
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("kafka:index/userScramCredential:UserScramCredential")
class UserScramCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 password_wo_version: Optional[pulumi.Input[_builtins.str]] = None,
                 scram_iterations: Optional[pulumi.Input[_builtins.int]] = None,
                 scram_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        SCRAM credentials can be imported using the format `username|scram_mechanism|password`:

        ```sh
        $ pulumi import kafka:index/userScramCredential:UserScramCredential example 'my-user|SCRAM-SHA-256|my-password'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] password: The password of the credential (deprecated, use password_wo instead)
        :param pulumi.Input[_builtins.str] password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The write-only password of the credential
        :param pulumi.Input[_builtins.str] password_wo_version: Version identifier for the write-only password to track changes
        :param pulumi.Input[_builtins.int] scram_iterations: The number of SCRAM iterations used when generating the credential
        :param pulumi.Input[_builtins.str] scram_mechanism: The SCRAM mechanism used to generate the credential (SCRAM-SHA-256, SCRAM-SHA-512)
        :param pulumi.Input[_builtins.str] username: The name of the credential
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserScramCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        SCRAM credentials can be imported using the format `username|scram_mechanism|password`:

        ```sh
        $ pulumi import kafka:index/userScramCredential:UserScramCredential example 'my-user|SCRAM-SHA-256|my-password'
        ```

        :param str resource_name: The name of the resource.
        :param UserScramCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserScramCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 password_wo_version: Optional[pulumi.Input[_builtins.str]] = None,
                 scram_iterations: Optional[pulumi.Input[_builtins.int]] = None,
                 scram_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserScramCredentialArgs.__new__(UserScramCredentialArgs)

            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["password_wo"] = None if password_wo is None else pulumi.Output.secret(password_wo)
            __props__.__dict__["password_wo_version"] = password_wo_version
            __props__.__dict__["scram_iterations"] = scram_iterations
            if scram_mechanism is None and not opts.urn:
                raise TypeError("Missing required property 'scram_mechanism'")
            __props__.__dict__["scram_mechanism"] = scram_mechanism
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "passwordWo"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(UserScramCredential, __self__).__init__(
            'kafka:index/userScramCredential:UserScramCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            password_wo: Optional[pulumi.Input[_builtins.str]] = None,
            password_wo_version: Optional[pulumi.Input[_builtins.str]] = None,
            scram_iterations: Optional[pulumi.Input[_builtins.int]] = None,
            scram_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserScramCredential':
        """
        Get an existing UserScramCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] password: The password of the credential (deprecated, use password_wo instead)
        :param pulumi.Input[_builtins.str] password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The write-only password of the credential
        :param pulumi.Input[_builtins.str] password_wo_version: Version identifier for the write-only password to track changes
        :param pulumi.Input[_builtins.int] scram_iterations: The number of SCRAM iterations used when generating the credential
        :param pulumi.Input[_builtins.str] scram_mechanism: The SCRAM mechanism used to generate the credential (SCRAM-SHA-256, SCRAM-SHA-512)
        :param pulumi.Input[_builtins.str] username: The name of the credential
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserScramCredentialState.__new__(_UserScramCredentialState)

        __props__.__dict__["password"] = password
        __props__.__dict__["password_wo"] = password_wo
        __props__.__dict__["password_wo_version"] = password_wo_version
        __props__.__dict__["scram_iterations"] = scram_iterations
        __props__.__dict__["scram_mechanism"] = scram_mechanism
        __props__.__dict__["username"] = username
        return UserScramCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the credential (deprecated, use password_wo instead)
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The write-only password of the credential
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Version identifier for the write-only password to track changes
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="scramIterations")
    def scram_iterations(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of SCRAM iterations used when generating the credential
        """
        return pulumi.get(self, "scram_iterations")

    @_builtins.property
    @pulumi.getter(name="scramMechanism")
    def scram_mechanism(self) -> pulumi.Output[_builtins.str]:
        """
        The SCRAM mechanism used to generate the credential (SCRAM-SHA-256, SCRAM-SHA-512)
        """
        return pulumi.get(self, "scram_mechanism")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the credential
        """
        return pulumi.get(self, "username")

