# Contributor Code of Conduct

## Principles

These principles guide our data, product, and process decisions, architecture, and approach.

- Open means transparent and participatory.
- We take a modular and modern approach to software development.
- We build open-source software and open-source process.
- We value ease of implementation.
- Fostering community includes building capacity and making our software and processes accessible to participants with diverse backgrounds and skillsets.
- Data (and data science) is as important as software and process. We build open data sets where possible.
- We strive for transparency for algorithms and places we might be introducing bias.

## Community Guidelines

Information on contributing to this project is available in [CONTRIBUTING.md](CONTRIBUTING.md).

When participating in this open source community's conversations and spaces, we ask individuals to follow the following guidelines:

- Embrace a culture of learning, and educate each other. We are all entering this conversation from different starting points and with different backgrounds. There are no dumb questions.
- Take space and give space. We strive to create an equitable environment in which all are welcome and able to participate. We hope individuals feel comfortable voicing their opinions and providing contributions and will do our best to recognize and make space for individuals who may be struggling to find space here. Likewise, we expect individuals to recognize when they are taking up significant space and take a step back to allow room for others.
- Be respectful.
- Default to positive. Assume others' contributions are legitimate and valuable and that they are made with good intention.
- Accept responsibility and apologize to those affected by our mistakes, and learn from the experience.
- Focus on what is best not just for us as individuals, but for the overall community.

## Enforcement Responsibilities

[Project maintainers](MAINTAINERS.md) are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any behavior that they deem inappropriate, threatening, offensive, or harmful.

Project maintainers have the right and responsibility to remove, edit, or reject contributions, comments, code, wiki edits, issues, and other contributions that are not aligned with this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project email address, posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.

## Acknowledgements

This Code of Conduct was adapted from these resources:

- The [Contributor Covenant](https://www.contributor-covenant.org), version 2.1, available [here](https://www.contributor-covenant.org/version/2/1/code_of_conduct.html)
- The [United States Digital Service](https://usds.gov) [Justice40](https://thejustice40.com) open source [repository](https://github.com/usds/justice40-tool)
