class ASRService:
    def __init__(self, handler):
        self.handler = handler

    def transcribe(self, audio_url: str, source_lang: str):
        payload = {
            "pipelineTasks": [
                {
                    "taskType": "asr",
                    "config": {
                        "language": {"sourceLanguage": source_lang},
                        "serviceId": "bhashini/ai4bharat/conformer-multilingual-asr"
                    }
                }
            ],
            "inputData": {"audio": [{"audioUri": audio_url}]}
        }
        result = self.handler.post(payload)
        return result.get("pipelineResponse", [{}])[0].get("output", [{}])[0].get("source", "")
