class TTSService:
    def __init__(self, handler):
        self.handler = handler

    def synthesize(self, text: str, source_lang: str, gender: str = "male", format_: str = "wav"):
        payload = {
            "pipelineTasks": [
                {
                    "taskType": "tts",
                    "config": {
                        "language": {"sourceLanguage": source_lang},
                        "serviceId": "ai4bharat/indic-tts-coqui-indo_aryan-gpu--t4",
                        "gender": gender,
                        "audioFormat": format_
                    }
                }
            ],
            "inputData": {"input": [{"source": text}]}
        }
        result = self.handler.post(payload)
        return result.get("pipelineResponse", [{}])[0].get("audio", [{}])[0].get("audioUri", "")
