/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { aws_ec2, aws_eks } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface IWindowsEKSClusterProps {
    vpc: aws_ec2.IVpc;
    /**
       * The Windows EKS Cluster parameters
       * @default - 'No default'.
       */
    eksSsmParameters?: IWindowsEKSClusterParameters;
}
export interface IWindowsEKSClusterParameters {
    /**
       * The name of the SSM Object that contains the EKS Cluster name
       * @default - 'windows-eks-cluster-name'.
       */
    clusterNamePointer?: string;
    /**
       * The SSM namespace to read/write parameters to
       * @default - 'cdk-skylight/compute/eks'.
       */
    namespace?: string;
}
export declare class WindowsEKSCluster extends Construct {
    readonly eksCluster: aws_eks.Cluster;
    constructor(scope: Construct, id: string, props: IWindowsEKSClusterProps);
}
