import json

workflows_data = json.loads(r'''{"standataConfig":{"categories":{"properties":["atomic_forces","average_potential_profile","band_gaps","band_structure","charge_density_profile","density_of_states","dielectric_tensor","fermi_energy","final_structure","phonon_dispersions","phonon_dos","potential_profile","pressure","reaction_energy_barrier","reaction_energy_profile","stress_tensor","surface_energy","total_energy","total_energy_contributions","total_force","zero_point_energy"],"tags":["default","variable-cell_relaxation"],"application":["espresso","nwchem","python","shell","vasp"]},"entities":[{"filename":"espresso/band_gap_dos_hse.json","categories":["atomic_forces","band_gaps","density_of_states","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/band_gap.json","categories":["atomic_forces","band_gaps","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/band_structure_dos.json","categories":["atomic_forces","band_gaps","band_structure","density_of_states","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/band_structure_hse.json","categories":["atomic_forces","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/band_structure_magn.json","categories":["atomic_forces","band_structure","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/band_structure_soc.json","categories":["atomic_forces","band_structure","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/band_structure.json","categories":["atomic_forces","band_structure","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/dielectric_tensor.json","categories":["atomic_forces","band_gaps","dielectric_tensor","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/dos.json","categories":["atomic_forces","band_gaps","density_of_states","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/electronic_density_mesh.json","categories":["atomic_forces","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/esm_relax.json","categories":["atomic_forces","charge_density_profile","espresso","fermi_energy","potential_profile","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/esm.json","categories":["atomic_forces","charge_density_profile","espresso","fermi_energy","potential_profile","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/fixed_cell_relaxation.json","categories":["atomic_forces","espresso","fermi_energy","final_structure","pressure","stress_tensor","total_energy","total_force"]},{"filename":"espresso/gw_band_structure_band_gap_full_frequency.json","categories":["atomic_forces","band_gaps","band_structure","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/gw_band_structure_band_gap_plasmon_pole.json","categories":["atomic_forces","band_gaps","band_structure","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/kpoint_convergence.json","categories":["atomic_forces","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_force"]},{"filename":"espresso/neb.json","categories":["espresso","reaction_energy_barrier","reaction_energy_profile"]},{"filename":"espresso/phonon_dispersions.json","categories":["atomic_forces","espresso","fermi_energy","phonon_dispersions","phonon_dos","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/phonon_dos_dispersion.json","categories":["atomic_forces","espresso","fermi_energy","phonon_dispersions","phonon_dos","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/phonon_dos.json","categories":["atomic_forces","espresso","fermi_energy","phonon_dos","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/phonon_map.json","categories":["atomic_forces","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/recalculate_bands.json","categories":["band_structure","espresso"]},{"filename":"espresso/surface_energy.json","categories":["atomic_forces","espresso","fermi_energy","pressure","stress_tensor","surface_energy","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/total_energy.json","categories":["atomic_forces","default","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/valence_band_offset.json","categories":["atomic_forces","average_potential_profile","band_gaps","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"]},{"filename":"espresso/variable_cell_relaxation.json","categories":["atomic_forces","espresso","fermi_energy","final_structure","pressure","stress_tensor","total_energy","total_force","variable-cell_relaxation"]},{"filename":"espresso/zero_point_energy.json","categories":["atomic_forces","espresso","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","zero_point_energy"]},{"filename":"nwchem/total_energy.json","categories":["nwchem","total_energy","total_energy_contributions"]},{"filename":"python/ml/classification_workflow.json","categories":["python"]},{"filename":"python/ml/clustering_workflow.json","categories":["python"]},{"filename":"python/ml/regression_workflow.json","categories":["python"]},{"filename":"python/python_script.json","categories":["python"]},{"filename":"shell/batch_espresso_pwscf.json","categories":["shell"]},{"filename":"shell/hello_world.json","categories":["shell"]},{"filename":"vasp/band_gap.json","categories":["atomic_forces","band_gaps","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","vasp"]},{"filename":"vasp/band_structure_dos.json","categories":["atomic_forces","band_structure","density_of_states","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","vasp"]},{"filename":"vasp/band_structure.json","categories":["atomic_forces","band_structure","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","vasp"]},{"filename":"vasp/dos.json","categories":["atomic_forces","density_of_states","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","vasp"]},{"filename":"vasp/fixed_cell_relaxation.json","categories":["atomic_forces","fermi_energy","final_structure","pressure","stress_tensor","total_energy","total_force","vasp"]},{"filename":"vasp/kpoint_convergence.json","categories":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","vasp"]},{"filename":"vasp/neb.json","categories":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","vasp"]},{"filename":"vasp/recalculate_bands.json","categories":["band_structure","vasp"]},{"filename":"vasp/surface_energy.json","categories":["atomic_forces","fermi_energy","pressure","stress_tensor","surface_energy","total_energy","total_energy_contributions","total_force","vasp"]},{"filename":"vasp/total_energy.json","categories":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","vasp"]},{"filename":"vasp/variable_cell_relaxation.json","categories":["atomic_forces","fermi_energy","final_structure","pressure","stress_tensor","total_energy","total_force","variable-cell_relaxation","vasp"]},{"filename":"vasp/zero_point_energy.json","categories":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_force","vasp","zero_point_energy"]}]},"filesMapByName":{"espresso/band_gap_dos_hse.json":{"name":"Band Gap + DoS - HSE","subworkflows":[{"_id":"f1341a29-777d-5ca3-8933-78a5e0d3f6f2","name":"HSE Band Gap","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","band_gaps","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","density_of_states"],"model":{"type":"dft","subtype":"hybrid","functional":{"slug":"hse06"},"method":{"type":"pseudopotential","subtype":"us","data":{}},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf_hse","head":true,"results":[{"name":"atomic_forces"},{"name":"band_gaps"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"f494cdb2-304f-5da2-b979-ce3fbba3a6c4","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_scf_hse.in"}],"results":["atomic_forces","band_gaps","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf_hse","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    ecutfock = 100\n    occupations = 'smearing'\n    degauss = 0.005\n    input_dft='hse',\n    nqx1 = {% if kgrid.dimensions[0]%2 == 0 %}{{kgrid.dimensions[0]/2}}{% else %}{{(kgrid.dimensions[0]+1)/2}}{% endif %}, nqx2 = {% if kgrid.dimensions[1]%2 == 0 %}{{kgrid.dimensions[1]/2}}{% else %}{{(kgrid.dimensions[1]+1)/2}}{% endif %}, nqx3 = {% if kgrid.dimensions[2]%2 == 0 %}{{kgrid.dimensions[2]/2}}{% else %}{{(kgrid.dimensions[2]+1)/2}}{% endif %}\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{% if d%2 == 0 %}{{d}} {% else %}{{d+1}} {% endif %}{% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf_hse.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    ecutfock = 100\n    occupations = 'smearing'\n    degauss = 0.005\n    input_dft='hse',\n    nqx1 = 1, nqx2 = 1, nqx3 = 1\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"3c8ffaf7-d01d-57e3-a0ae-118b3ecfc651"},{"type":"execution","name":"projwfc","head":false,"results":[{"name":"density_of_states"}],"monitors":[{"name":"standard_output"}],"flowchartId":"3c8ffaf7-d01d-57e3-a0ae-118b3ecfc651","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"projwfc.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"projwfc.in"}],"results":["density_of_states"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"projwfc.x","name":"projwfc","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&PROJWFC\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    degauss = 0.01\n    deltaE = 0.05\n/\n","name":"projwfc.in","contextProviders":[],"applicationName":"espresso","executableName":"projwfc.x","rendered":"&PROJWFC\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    degauss = 0.01\n    deltaE = 0.05\n/\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"HSE Band Gap","type":"subworkflow","_id":"f1341a29-777d-5ca3-8933-78a5e0d3f6f2","status":"idle","statusTrack":[],"flowchartId":"f7a0860d-6f9e-59e3-b600-07bbf986998a","tags":[],"head":true}],"properties":["atomic_forces","band_gaps","density_of_states","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"ab28e7cf-a363-5223-ae0b-a60c82bb4f9a","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/band_gap.json":{"name":"Band Gap","subworkflows":[{"_id":"233bb8cf-3b4a-5378-84d9-a6a95a2ab43d","name":"Band Gap","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","fermi_energy","band_gaps"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"7b4c726e-3c46-501a-9a3a-ca19e06de5f0"},{"type":"execution","name":"pw_nscf","head":false,"results":[{"name":"fermi_energy"},{"name":"band_gaps"}],"monitors":[{"name":"standard_output"}],"flowchartId":"7b4c726e-3c46-501a-9a3a-ca19e06de5f0","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_nscf.in"}],"results":["fermi_energy","band_gaps"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pw.x","name":"pw_nscf","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&CONTROL\n    calculation = 'nscf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{input.RESTART_MODE}}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n{%- if subworkflowContext.NO_SYMMETRY_NO_INVERSION %}\n    nosym = .true.\n    noinv = .true.\n{%- endif %}\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_nscf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'nscf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Band Gap","type":"subworkflow","_id":"233bb8cf-3b4a-5378-84d9-a6a95a2ab43d","status":"idle","statusTrack":[],"flowchartId":"db3b83ea-0ef5-594c-89a8-bde38dbc6105","tags":[],"head":true}],"properties":["atomic_forces","band_gaps","fermi_energy","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"cd826954-8c96-59f7-b2de-f36ce2d86105","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/band_structure_dos.json":{"name":"Band Structure + Density of States","subworkflows":[{"_id":"fa594399-6b98-5d79-986c-0713601dc06c","name":"Band Structure + Density of States","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","band_structure","fermi_energy","band_gaps","density_of_states"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"d618df45-5af3-5da5-8882-d74a27e00b04"},{"type":"execution","name":"pw_bands","head":false,"results":[{"name":"band_structure"}],"monitors":[{"name":"standard_output"}],"flowchartId":"d618df45-5af3-5da5-8882-d74a27e00b04","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_bands.in"}],"results":["band_structure"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pw.x","name":"pw_bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{input.RESTART_MODE}}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS crystal_b\n{{kpath.length}}\n{% for point in kpath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"pw_bands.in","contextProviders":[{"name":"KPathFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS crystal_b\n11\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"}],"next":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2"},{"type":"execution","name":"bands","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"bands.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"bands.in"}],"monitors":["standard_output"],"applicationName":"espresso","executableName":"bands.x","name":"bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&BANDS\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    filband = {% raw %}'{{ JOB_WORK_DIR }}/bands.dat'{% endraw %}\n    no_overlap = .true.\n/\n","name":"bands.in","contextProviders":[],"applicationName":"espresso","executableName":"bands.x","rendered":"&BANDS\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    filband = '{{ JOB_WORK_DIR }}/bands.dat'\n    no_overlap = .true.\n/\n","schemaVersion":"2022.8.16"}],"next":"7b4c726e-3c46-501a-9a3a-ca19e06de5f0"},{"type":"execution","name":"pw_nscf","head":false,"results":[{"name":"fermi_energy"},{"name":"band_gaps"}],"monitors":[{"name":"standard_output"}],"flowchartId":"7b4c726e-3c46-501a-9a3a-ca19e06de5f0","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_nscf.in"}],"results":["fermi_energy","band_gaps"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pw.x","name":"pw_nscf","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&CONTROL\n    calculation = 'nscf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{input.RESTART_MODE}}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n{%- if subworkflowContext.NO_SYMMETRY_NO_INVERSION %}\n    nosym = .true.\n    noinv = .true.\n{%- endif %}\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_nscf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'nscf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"3c8ffaf7-d01d-57e3-a0ae-118b3ecfc651"},{"type":"execution","name":"projwfc","head":false,"results":[{"name":"density_of_states"}],"monitors":[{"name":"standard_output"}],"flowchartId":"3c8ffaf7-d01d-57e3-a0ae-118b3ecfc651","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"projwfc.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"projwfc.in"}],"results":["density_of_states"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"projwfc.x","name":"projwfc","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&PROJWFC\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    degauss = 0.01\n    deltaE = 0.05\n/\n","name":"projwfc.in","contextProviders":[],"applicationName":"espresso","executableName":"projwfc.x","rendered":"&PROJWFC\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    degauss = 0.01\n    deltaE = 0.05\n/\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Band Structure + Density of States","type":"subworkflow","_id":"fa594399-6b98-5d79-986c-0713601dc06c","status":"idle","statusTrack":[],"flowchartId":"8a098bb9-73b1-5e84-bfc7-b783e02d0f53","tags":[],"head":true}],"properties":["atomic_forces","band_gaps","band_structure","density_of_states","fermi_energy","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"9b36cf93-81b9-5a40-bba3-d25955a9bfa8","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/band_structure_hse.json":{"name":"Band Structure - HSE","subworkflows":[{"_id":"79f2cb6a-7994-5369-8c85-af07c55ad26f","name":"Preliminary SCF Calculation","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}]}]},{"_id":"a2785cc5-2427-5c7a-b30f-7077475b948c","name":"Extract KPOINTS","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"Extract kpoints","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"a716b133-2d04-50b5-b497-100265e3fa24","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"espresso_extract_kpoints.py"},{"name":"requirements.txt","templateName":"requirements_empty.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"espresso_extract_kpoints","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"import json\nimport re\n\ndouble_regex = r'[-+]?\\d*\\.\\d+(?:[eE][-+]?\\d+)?'\nregex = r\"\\s+k\\(\\s+\\d*\\)\\s+=\\s+\\(\\s+({0})\\s+({0})\\s+({0})\\),\\s+wk\\s+=\\s+({0}).+?\\n\".format(double_regex)\n\nwith open(\"pw_scf.out\") as f:\n    text = f.read()\n\npattern = re.compile(regex, re.I | re.MULTILINE)\nmatch = pattern.findall(text[text.rfind(\" cryst. coord.\"):])\nkpoints = [{\"coordinates\": list(map(float, m[:3])), \"weight\": float(m[3])} for m in match]\nprint(json.dumps({\"name\": \"KPOINTS\", \"value\": kpoints, \"scope\": \"global\"}, indent=4))\n","name":"espresso_extract_kpoints.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"import json\nimport re\n\ndouble_regex = r'[-+]?\\d*\\.\\d+(?:[eE][-+]?\\d+)?'\nregex = r\"\\s+k\\(\\s+\\d*\\)\\s+=\\s+\\(\\s+({0})\\s+({0})\\s+({0})\\),\\s+wk\\s+=\\s+({0}).+?\\n\".format(double_regex)\n\nwith open(\"pw_scf.out\") as f:\n    text = f.read()\n\npattern = re.compile(regex, re.I | re.MULTILINE)\nmatch = pattern.findall(text[text.rfind(\" cryst. coord.\"):])\nkpoints = [{\"coordinates\": list(map(float, m[:3])), \"weight\": float(m[3])} for m in match]\nprint(json.dumps({\"name\": \"KPOINTS\", \"value\": kpoints, \"scope\": \"global\"}, indent=4))\n","schemaVersion":"2022.8.16"},{"content":"# ------------------------------------------------------------------ #\n#                                                                    #\n#  Example Python package requirements for the Mat3ra platform       #\n#                                                                    #\n#  Will be used as follows:                                          #\n#                                                                    #\n#    1. A runtime directory for this calculation is created          #\n#    2. This list is used to populate a Python virtual environment   #\n#    3. The virtual environment is activated                         #\n#    4. The Python process running the script included within this   #\n#       job is started                                               #\n#                                                                    #\n#  For more information visit:                                       #\n#   - https://pip.pypa.io/en/stable/reference/pip_install            #\n#   - https://virtualenv.pypa.io/en/stable/                          #\n#                                                                    #\n#  Please add any packages required for this unit below following    #\n#  the requirements.txt specification:                               #\n#  https://pip.pypa.io/en/stable/reference/requirements-file-format/ #\n# ------------------------------------------------------------------ #\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ------------------------------------------------------------------ #\n#                                                                    #\n#  Example Python package requirements for the Mat3ra platform       #\n#                                                                    #\n#  Will be used as follows:                                          #\n#                                                                    #\n#    1. A runtime directory for this calculation is created          #\n#    2. This list is used to populate a Python virtual environment   #\n#    3. The virtual environment is activated                         #\n#    4. The Python process running the script included within this   #\n#       job is started                                               #\n#                                                                    #\n#  For more information visit:                                       #\n#   - https://pip.pypa.io/en/stable/reference/pip_install            #\n#   - https://virtualenv.pypa.io/en/stable/                          #\n#                                                                    #\n#  Please add any packages required for this unit below following    #\n#  the requirements.txt specification:                               #\n#  https://pip.pypa.io/en/stable/reference/requirements-file-format/ #\n# ------------------------------------------------------------------ #\n","schemaVersion":"2022.8.16"}]}]},{"_id":"e47ca302-96f2-5726-9b4c-f34cdfaa7f72","name":"Main HSE Run","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"model":{"type":"dft","subtype":"hybrid","functional":{"slug":"hse06"},"method":{"type":"pseudopotential","subtype":"us","data":{}},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf_bands_hse","head":true,"results":[{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"pressure"},{"name":"fermi_energy"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"08bd7e4a-2454-53b7-8cc9-9a95975f7e6f","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_scf_bands_hse.in"}],"results":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf_bands_hse","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n    input_dft = 'hse',\n    {% for d in qgrid.dimensions -%}\n    nqx{{loop.index}} = {{d}}\n    {% endfor %}\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS crystal\n{{ '{{' }} {{ explicitKPath.length }} {% raw %} + KPOINTS|length {% endraw %}  {{ '}}' }}\n{% raw %}\n{% for point in KPOINTS -%}\n    {% for d in point.coordinates %}{{ \"%14.9f\"|format(d) }} {% endfor -%}{{ point.weight }}\n{% endfor %}\n{% endraw %}\n{% for point in explicitKPath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}0.0000001\n{% endfor %}\n","name":"pw_scf_bands_hse.in","contextProviders":[{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"},{"name":"QGridFormDataManager"},{"name":"ExplicitKPathFormDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n    input_dft = 'hse',\n    nqx1 = 1\n    nqx2 = 1\n    nqx3 = 1\n    \n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS crystal\n{{ 101  + KPOINTS|length   }}\n\n{% for point in KPOINTS -%}\n    {% for d in point.coordinates %}{{ \"%14.9f\"|format(d) }} {% endfor -%}{{ point.weight }}\n{% endfor %}\n\n   0.000000000    0.000000000    0.000000000 0.0000001\n   0.050000000    0.000000000    0.050000000 0.0000001\n   0.100000000    0.000000000    0.100000000 0.0000001\n   0.150000000    0.000000000    0.150000000 0.0000001\n   0.200000000    0.000000000    0.200000000 0.0000001\n   0.250000000    0.000000000    0.250000000 0.0000001\n   0.300000000    0.000000000    0.300000000 0.0000001\n   0.350000000    0.000000000    0.350000000 0.0000001\n   0.400000000    0.000000000    0.400000000 0.0000001\n   0.450000000    0.000000000    0.450000000 0.0000001\n   0.500000000    0.000000000    0.500000000 0.0000001\n   0.500000000    0.025000000    0.525000000 0.0000001\n   0.500000000    0.050000000    0.550000000 0.0000001\n   0.500000000    0.075000000    0.575000000 0.0000001\n   0.500000000    0.100000000    0.600000000 0.0000001\n   0.500000000    0.125000000    0.625000000 0.0000001\n   0.500000000    0.150000000    0.650000000 0.0000001\n   0.500000000    0.175000000    0.675000000 0.0000001\n   0.500000000    0.200000000    0.700000000 0.0000001\n   0.500000000    0.225000000    0.725000000 0.0000001\n   0.500000000    0.250000000    0.750000000 0.0000001\n   0.487500000    0.262500000    0.750000000 0.0000001\n   0.475000000    0.275000000    0.750000000 0.0000001\n   0.462500000    0.287500000    0.750000000 0.0000001\n   0.450000000    0.300000000    0.750000000 0.0000001\n   0.437500000    0.312500000    0.750000000 0.0000001\n   0.425000000    0.325000000    0.750000000 0.0000001\n   0.412500000    0.337500000    0.750000000 0.0000001\n   0.400000000    0.350000000    0.750000000 0.0000001\n   0.387500000    0.362500000    0.750000000 0.0000001\n   0.375000000    0.375000000    0.750000000 0.0000001\n   0.337500000    0.337500000    0.675000000 0.0000001\n   0.300000000    0.300000000    0.600000000 0.0000001\n   0.262500000    0.262500000    0.525000000 0.0000001\n   0.225000000    0.225000000    0.450000000 0.0000001\n   0.187500000    0.187500000    0.375000000 0.0000001\n   0.150000000    0.150000000    0.300000000 0.0000001\n   0.112500000    0.112500000    0.225000000 0.0000001\n   0.075000000    0.075000000    0.150000000 0.0000001\n   0.037500000    0.037500000    0.075000000 0.0000001\n   0.000000000    0.000000000    0.000000000 0.0000001\n   0.050000000    0.050000000    0.050000000 0.0000001\n   0.100000000    0.100000000    0.100000000 0.0000001\n   0.150000000    0.150000000    0.150000000 0.0000001\n   0.200000000    0.200000000    0.200000000 0.0000001\n   0.250000000    0.250000000    0.250000000 0.0000001\n   0.300000000    0.300000000    0.300000000 0.0000001\n   0.350000000    0.350000000    0.350000000 0.0000001\n   0.400000000    0.400000000    0.400000000 0.0000001\n   0.450000000    0.450000000    0.450000000 0.0000001\n   0.500000000    0.500000000    0.500000000 0.0000001\n   0.512500000    0.475000000    0.512500000 0.0000001\n   0.525000000    0.450000000    0.525000000 0.0000001\n   0.537500000    0.425000000    0.537500000 0.0000001\n   0.550000000    0.400000000    0.550000000 0.0000001\n   0.562500000    0.375000000    0.562500000 0.0000001\n   0.575000000    0.350000000    0.575000000 0.0000001\n   0.587500000    0.325000000    0.587500000 0.0000001\n   0.600000000    0.300000000    0.600000000 0.0000001\n   0.612500000    0.275000000    0.612500000 0.0000001\n   0.625000000    0.250000000    0.625000000 0.0000001\n   0.612500000    0.250000000    0.637500000 0.0000001\n   0.600000000    0.250000000    0.650000000 0.0000001\n   0.587500000    0.250000000    0.662500000 0.0000001\n   0.575000000    0.250000000    0.675000000 0.0000001\n   0.562500000    0.250000000    0.687500000 0.0000001\n   0.550000000    0.250000000    0.700000000 0.0000001\n   0.537500000    0.250000000    0.712500000 0.0000001\n   0.525000000    0.250000000    0.725000000 0.0000001\n   0.512500000    0.250000000    0.737500000 0.0000001\n   0.500000000    0.250000000    0.750000000 0.0000001\n   0.500000000    0.275000000    0.725000000 0.0000001\n   0.500000000    0.300000000    0.700000000 0.0000001\n   0.500000000    0.325000000    0.675000000 0.0000001\n   0.500000000    0.350000000    0.650000000 0.0000001\n   0.500000000    0.375000000    0.625000000 0.0000001\n   0.500000000    0.400000000    0.600000000 0.0000001\n   0.500000000    0.425000000    0.575000000 0.0000001\n   0.500000000    0.450000000    0.550000000 0.0000001\n   0.500000000    0.475000000    0.525000000 0.0000001\n   0.500000000    0.500000000    0.500000000 0.0000001\n   0.512500000    0.475000000    0.512500000 0.0000001\n   0.525000000    0.450000000    0.525000000 0.0000001\n   0.537500000    0.425000000    0.537500000 0.0000001\n   0.550000000    0.400000000    0.550000000 0.0000001\n   0.562500000    0.375000000    0.562500000 0.0000001\n   0.575000000    0.350000000    0.575000000 0.0000001\n   0.587500000    0.325000000    0.587500000 0.0000001\n   0.600000000    0.300000000    0.600000000 0.0000001\n   0.612500000    0.275000000    0.612500000 0.0000001\n   0.625000000    0.250000000    0.625000000 0.0000001\n   0.612500000    0.225000000    0.612500000 0.0000001\n   0.600000000    0.200000000    0.600000000 0.0000001\n   0.587500000    0.175000000    0.587500000 0.0000001\n   0.575000000    0.150000000    0.575000000 0.0000001\n   0.562500000    0.125000000    0.562500000 0.0000001\n   0.550000000    0.100000000    0.550000000 0.0000001\n   0.537500000    0.075000000    0.537500000 0.0000001\n   0.525000000    0.050000000    0.525000000 0.0000001\n   0.512500000    0.025000000    0.512500000 0.0000001\n   0.500000000    0.000000000    0.500000000 0.0000001\n\n","schemaVersion":"2022.8.16"}],"next":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2"},{"type":"execution","name":"bands","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"bands.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"bands.in"}],"monitors":["standard_output"],"applicationName":"espresso","executableName":"bands.x","name":"bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&BANDS\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    filband = {% raw %}'{{ JOB_WORK_DIR }}/bands.dat'{% endraw %}\n    no_overlap = .true.\n/\n","name":"bands.in","contextProviders":[],"applicationName":"espresso","executableName":"bands.x","rendered":"&BANDS\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    filband = '{{ JOB_WORK_DIR }}/bands.dat'\n    no_overlap = .true.\n/\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Preliminary SCF Calculation","type":"subworkflow","_id":"79f2cb6a-7994-5369-8c85-af07c55ad26f","status":"idle","statusTrack":[],"flowchartId":"b6a2b27a-0fec-5e0e-8974-073ee9d2ad83","tags":[],"head":true,"next":"65789b0a-cfe2-5062-a53e-89f71112fb57"},{"name":"Extract KPOINTS","type":"subworkflow","_id":"a2785cc5-2427-5c7a-b30f-7077475b948c","status":"idle","statusTrack":[],"flowchartId":"65789b0a-cfe2-5062-a53e-89f71112fb57","tags":[],"head":false,"next":"8f4c63a3-a06a-5f73-88d7-a57d7958b91d"},{"name":"Main HSE Run","type":"subworkflow","_id":"e47ca302-96f2-5726-9b4c-f34cdfaa7f72","status":"idle","statusTrack":[],"flowchartId":"8f4c63a3-a06a-5f73-88d7-a57d7958b91d","tags":[],"head":false}],"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"23b9058b-884c-52d4-82a8-ee162b9761e0","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/band_structure_magn.json":{"name":"Bandstructure with spin magnetism - QE","subworkflows":[{"_id":"354942f1-9f3d-57a9-b5ae-6bdf5b3a60af","name":"Bandstructure with spin magnetism","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","band_structure"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf_magn","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"c229d2a0-3c19-5f13-b3e0-ceb86cb9fbc1","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_scf_magn.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf_magn","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP_WITH_LABELS }}\n    nspin = 2\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n{%- if collinearMagnetization.isTotalMagnetization %}\n    tot_magnetization = {{ collinearMagnetization.totalMagnetization }}\n{%- else %}\n{%- for item in collinearMagnetization.startingMagnetization %}\n    starting_magnetization({{ item.index }}) = {{ item.value }} {% endfor -%}\n{%- endif %}\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES_WITH_LABELS }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf_magn.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"},{"name":"CollinearMagnetizationDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    nspin = 2\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n    starting_magnetization(1) = 0 \n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"ea06c333-0cc7-51d4-bd98-cc53fa0844d1"},{"type":"execution","name":"pw_bands_magn","head":false,"results":[{"name":"band_structure"}],"monitors":[{"name":"standard_output"}],"flowchartId":"ea06c333-0cc7-51d4-bd98-cc53fa0844d1","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_bands_magn.in"}],"results":["band_structure"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pw.x","name":"pw_bands_magn","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{input.RESTART_MODE}}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP_WITH_LABELS }}\n    nspin = 2\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n{%- if collinearMagnetization.isTotalMagnetization %}\n    tot_magnetization = {{ collinearMagnetization.totalMagnetization }}\n{%- else %}\n{%- for item in collinearMagnetization.startingMagnetization %}\n    starting_magnetization({{ item.index }}) = {{ item.value }} {% endfor -%}\n{%- endif %}\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES_WITH_LABELS }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS crystal_b\n{{kpath.length}}\n{% for point in kpath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"pw_bands_magn.in","contextProviders":[{"name":"KPathFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"},{"name":"CollinearMagnetizationDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    nspin = 2\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n    starting_magnetization(1) = 0 \n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS crystal_b\n11\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"}],"next":"a8e4de4b-1f55-50e8-a712-ce0b37c04752"},{"type":"execution","name":"bands_spin_up","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"a8e4de4b-1f55-50e8-a712-ce0b37c04752","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"bands.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"bands_spin_up.in"}],"monitors":["standard_output"],"applicationName":"espresso","executableName":"bands.x","name":"bands_spin_up","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&BANDS\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    filband = {% raw %}'{{ JOB_WORK_DIR }}/bands_up.dat'{% endraw %}\n    spin_component = 1\n    no_overlap = .true.\n/\n","name":"bands_spin_up.in","contextProviders":[],"applicationName":"espresso","executableName":"bands.x","rendered":"&BANDS\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    filband = '{{ JOB_WORK_DIR }}/bands_up.dat'\n    spin_component = 1\n    no_overlap = .true.\n/\n","schemaVersion":"2022.8.16"}],"next":"fd937050-a3f3-5d4d-bb50-d150a93ea5e0"},{"type":"execution","name":"bands_spin_dn","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"fd937050-a3f3-5d4d-bb50-d150a93ea5e0","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"bands.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"bands_spin_dn.in"}],"monitors":["standard_output"],"applicationName":"espresso","executableName":"bands.x","name":"bands_spin_dn","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&BANDS\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    filband = {% raw %}'{{ JOB_WORK_DIR }}/bands_dn.dat'{% endraw %}\n    spin_component = 2\n    no_overlap = .true.\n/\n","name":"bands_spin_dn.in","contextProviders":[],"applicationName":"espresso","executableName":"bands.x","rendered":"&BANDS\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    filband = '{{ JOB_WORK_DIR }}/bands_dn.dat'\n    spin_component = 2\n    no_overlap = .true.\n/\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Bandstructure with spin magnetism","type":"subworkflow","_id":"354942f1-9f3d-57a9-b5ae-6bdf5b3a60af","status":"idle","statusTrack":[],"flowchartId":"41e70bc1-ba00-5871-9289-4d57c7b79452","tags":[],"head":true}],"properties":["atomic_forces","band_structure","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"f2767e1a-fce7-578f-b627-8806d3cd59de","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/band_structure_soc.json":{"name":"Bandstructure with SOC - QE","subworkflows":[{"_id":"153b4a88-5d56-553f-b7d3-40df96968eb4","name":"Bandstructure with SOC","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","band_structure"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"nc-fr","data":{"searchText":"nc-fr"}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf_soc","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"74ec024a-f247-5f15-9c21-cc169bcb62c7","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_scf_soc.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf_soc","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP_WITH_LABELS }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n    noncolin = .true.\n    lspinorb = .true.\n{%- if nonCollinearMagnetization.isStartingMagnetization %}\n{%- for item in nonCollinearMagnetization.startingMagnetization %}\n    starting_magnetization({{ item.index }}) = {{ item.value }} {% endfor -%}\n{%- endif %}\n{%- if nonCollinearMagnetization.isConstrainedMagnetization %}\n    constrained_magnetization = '{{ nonCollinearMagnetization.constrainedMagnetization.constrainType }}'\n    lambda = {{ nonCollinearMagnetization.constrainedMagnetization.lambda }}\n{%- endif %}\n{%- if nonCollinearMagnetization.isConstrainedMagnetization and nonCollinearMagnetization.isFixedMagnetization %}\n    fixed_magnetization(1) = {{ nonCollinearMagnetization.fixedMagnetization.x }}\n    fixed_magnetization(2) = {{ nonCollinearMagnetization.fixedMagnetization.y }}\n    fixed_magnetization(3) = {{ nonCollinearMagnetization.fixedMagnetization.z }}\n{%- endif %}\n{%- if nonCollinearMagnetization.isExistingChargeDensity and nonCollinearMagnetization.lforcet %}\n    lforcet = .true.\n{%- endif %}\n{%- if nonCollinearMagnetization.isExistingChargeDensity and not nonCollinearMagnetization.lforcet %}\n    lforcet = .false.\n{%- endif %}\n{%- if nonCollinearMagnetization.isArbitrarySpinDirection %}\n{%- for item in nonCollinearMagnetization.spinAngles %}\n    angle1({{ item.index }}) = {{ item.angle1 }}\n    angle2({{ item.index }}) = {{ item.angle2 }} {% endfor %}\n{%- endif %}\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n{%- if nonCollinearMagnetization.isExistingChargeDensity %}\n    startingpot = 'file'\n{%- endif %}\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES_WITH_LABELS }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf_soc.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"},{"name":"NonCollinearMagnetizationDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n    noncolin = .true.\n    lspinorb = .true.\n    starting_magnetization(1) = 0 \n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"cee6ae30-cf34-5138-bdc5-5c57c2a6de5b"},{"type":"execution","name":"pw_bands_soc","head":false,"results":[{"name":"band_structure"}],"monitors":[{"name":"standard_output"}],"flowchartId":"cee6ae30-cf34-5138-bdc5-5c57c2a6de5b","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_bands_soc.in"}],"results":["band_structure"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pw.x","name":"pw_bands_soc","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{input.RESTART_MODE}}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP_WITH_LABELS }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n    noncolin = .true.\n    lspinorb = .true.\n{%- if nonCollinearMagnetization.isStartingMagnetization %}\n{%- for item in nonCollinearMagnetization.startingMagnetization %}\n    starting_magnetization({{ item.index }}) = {{ item.value }} {% endfor -%}\n{%- endif %}\n{%- if nonCollinearMagnetization.isConstrainedMagnetization %}\n    constrained_magnetization = '{{ nonCollinearMagnetization.constrainedMagnetization.constrainType }}'\n    lambda = {{ nonCollinearMagnetization.constrainedMagnetization.lambda }}\n{%- endif %}\n{%- if nonCollinearMagnetization.isConstrainedMagnetization and nonCollinearMagnetization.isFixedMagnetization %}\n    fixed_magnetization(1) = {{ nonCollinearMagnetization.fixedMagnetization.x }}\n    fixed_magnetization(2) = {{ nonCollinearMagnetization.fixedMagnetization.y }}\n    fixed_magnetization(3) = {{ nonCollinearMagnetization.fixedMagnetization.z }}\n{%- endif %}\n{%- if nonCollinearMagnetization.isExistingChargeDensity and nonCollinearMagnetization.lforcet %}\n    lforcet = .true.\n{%- endif %}\n{%- if nonCollinearMagnetization.isExistingChargeDensity and not nonCollinearMagnetization.lforcet %}\n    lforcet = .false.\n{%- endif %}\n{%- if nonCollinearMagnetization.isArbitrarySpinDirection %}\n{%- for item in nonCollinearMagnetization.spinAngles %}\n    angle1({{ item.index }}) = {{ item.angle1 }}\n    angle2({{ item.index }}) = {{ item.angle2 }} {% endfor %}\n{%- endif %}\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES_WITH_LABELS }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS crystal_b\n{{kpath.length}}\n{% for point in kpath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"pw_bands_soc.in","contextProviders":[{"name":"KPathFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"},{"name":"NonCollinearMagnetizationDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n    noncolin = .true.\n    lspinorb = .true.\n    starting_magnetization(1) = 0 \n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS crystal_b\n11\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"}],"next":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2"},{"type":"execution","name":"bands","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"bands.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"bands.in"}],"monitors":["standard_output"],"applicationName":"espresso","executableName":"bands.x","name":"bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&BANDS\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    filband = {% raw %}'{{ JOB_WORK_DIR }}/bands.dat'{% endraw %}\n    no_overlap = .true.\n/\n","name":"bands.in","contextProviders":[],"applicationName":"espresso","executableName":"bands.x","rendered":"&BANDS\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    filband = '{{ JOB_WORK_DIR }}/bands.dat'\n    no_overlap = .true.\n/\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Bandstructure with SOC","type":"subworkflow","_id":"153b4a88-5d56-553f-b7d3-40df96968eb4","status":"idle","statusTrack":[],"flowchartId":"872d54a6-679c-5af5-a153-72709fcf46df","tags":[],"head":true}],"properties":["atomic_forces","band_structure","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"b4587b15-eb6f-5316-8497-a79f321b3c76","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/band_structure.json":{"name":"Band Structure","subworkflows":[{"_id":"26d32e68-c2b5-50e9-8933-15f684fcc039","name":"Band Structure","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","band_structure"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"d618df45-5af3-5da5-8882-d74a27e00b04"},{"type":"execution","name":"pw_bands","head":false,"results":[{"name":"band_structure"}],"monitors":[{"name":"standard_output"}],"flowchartId":"d618df45-5af3-5da5-8882-d74a27e00b04","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_bands.in"}],"results":["band_structure"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pw.x","name":"pw_bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{input.RESTART_MODE}}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS crystal_b\n{{kpath.length}}\n{% for point in kpath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"pw_bands.in","contextProviders":[{"name":"KPathFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS crystal_b\n11\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"}],"next":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2"},{"type":"execution","name":"bands","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"bands.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"bands.in"}],"monitors":["standard_output"],"applicationName":"espresso","executableName":"bands.x","name":"bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&BANDS\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    filband = {% raw %}'{{ JOB_WORK_DIR }}/bands.dat'{% endraw %}\n    no_overlap = .true.\n/\n","name":"bands.in","contextProviders":[],"applicationName":"espresso","executableName":"bands.x","rendered":"&BANDS\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    filband = '{{ JOB_WORK_DIR }}/bands.dat'\n    no_overlap = .true.\n/\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Band Structure","type":"subworkflow","_id":"26d32e68-c2b5-50e9-8933-15f684fcc039","status":"idle","statusTrack":[],"flowchartId":"c573187f-a8bb-5084-9fcf-1560bf4a7786","tags":[],"head":true}],"properties":["atomic_forces","band_structure","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"cc901d3d-bf3f-522c-9dec-849ffc06f62a","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/dielectric_tensor.json":{"name":"Dielectric Function","subworkflows":[{"_id":"38340b52-83ad-5862-bc18-c140bdc0cb72","name":"Compute Dielectric Function","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","fermi_energy","band_gaps","dielectric_tensor"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"nc","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"3b230ec3-0791-52f7-a4db-625390b8718f"},{"name":"Set No-Symmetry Flag","type":"assignment","operand":"NO_SYMMETRY_NO_INVERSION","value":true,"input":[],"status":"idle","statusTrack":[],"flowchartId":"3b230ec3-0791-52f7-a4db-625390b8718f","tags":[],"head":false,"next":"7b4c726e-3c46-501a-9a3a-ca19e06de5f0","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"type":"execution","name":"pw_nscf","head":false,"results":[{"name":"fermi_energy"},{"name":"band_gaps"}],"monitors":[{"name":"standard_output"}],"flowchartId":"7b4c726e-3c46-501a-9a3a-ca19e06de5f0","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_nscf.in"}],"results":["fermi_energy","band_gaps"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pw.x","name":"pw_nscf","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&CONTROL\n    calculation = 'nscf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{input.RESTART_MODE}}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n{%- if subworkflowContext.NO_SYMMETRY_NO_INVERSION %}\n    nosym = .true.\n    noinv = .true.\n{%- endif %}\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_nscf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'nscf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"8c2ec8bd-cdbf-54a0-a217-64a7a26eaebb"},{"type":"execution","name":"Compute dielectric function","head":false,"results":[{"name":"dielectric_tensor"}],"monitors":[{"name":"standard_output"}],"flowchartId":"8c2ec8bd-cdbf-54a0-a217-64a7a26eaebb","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"epsilon.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"epsilon.in"}],"results":["dielectric_tensor"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"epsilon.x","name":"dielectric_tensor","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&inputpp\n    calculation = \"eps\"\n    prefix = \"__prefix__\"\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n/\n\n&energy_grid\n    smeartype = \"gauss\"\n    intersmear = 0.2\n    intrasmear = 0.0\n    wmin =  0.0\n    wmax = 30.0\n    nw = 500\n    shift = 0.0\n/\n","name":"epsilon.in","contextProviders":[],"applicationName":"espresso","executableName":"epsilon.x","rendered":"&inputpp\n    calculation = \"eps\"\n    prefix = \"__prefix__\"\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n/\n\n&energy_grid\n    smeartype = \"gauss\"\n    intersmear = 0.2\n    intrasmear = 0.0\n    wmin =  0.0\n    wmax = 30.0\n    nw = 500\n    shift = 0.0\n/\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Compute Dielectric Function","type":"subworkflow","_id":"38340b52-83ad-5862-bc18-c140bdc0cb72","status":"idle","statusTrack":[],"flowchartId":"8408f3c4-1c42-5ffe-bc29-bee11b5a6a05","tags":[],"head":true}],"properties":["atomic_forces","band_gaps","dielectric_tensor","fermi_energy","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"cba28656-925a-59ad-b572-b6dee17a63ce","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/dos.json":{"name":"Density of States","subworkflows":[{"_id":"2cf317f3-3306-5a96-bc9b-e9103ebcd5be","name":"Density of States","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","fermi_energy","band_gaps","density_of_states"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"7b4c726e-3c46-501a-9a3a-ca19e06de5f0"},{"type":"execution","name":"pw_nscf","head":false,"results":[{"name":"fermi_energy"},{"name":"band_gaps"}],"monitors":[{"name":"standard_output"}],"flowchartId":"7b4c726e-3c46-501a-9a3a-ca19e06de5f0","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_nscf.in"}],"results":["fermi_energy","band_gaps"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pw.x","name":"pw_nscf","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&CONTROL\n    calculation = 'nscf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{input.RESTART_MODE}}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n{%- if subworkflowContext.NO_SYMMETRY_NO_INVERSION %}\n    nosym = .true.\n    noinv = .true.\n{%- endif %}\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_nscf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'nscf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"3c8ffaf7-d01d-57e3-a0ae-118b3ecfc651"},{"type":"execution","name":"projwfc","head":false,"results":[{"name":"density_of_states"}],"monitors":[{"name":"standard_output"}],"flowchartId":"3c8ffaf7-d01d-57e3-a0ae-118b3ecfc651","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"projwfc.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"projwfc.in"}],"results":["density_of_states"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"projwfc.x","name":"projwfc","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&PROJWFC\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    degauss = 0.01\n    deltaE = 0.05\n/\n","name":"projwfc.in","contextProviders":[],"applicationName":"espresso","executableName":"projwfc.x","rendered":"&PROJWFC\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    degauss = 0.01\n    deltaE = 0.05\n/\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Density of States","type":"subworkflow","_id":"2cf317f3-3306-5a96-bc9b-e9103ebcd5be","status":"idle","statusTrack":[],"flowchartId":"3e64fdb4-ab5b-52a0-a1d5-51343c49481c","tags":[],"head":true}],"properties":["atomic_forces","band_gaps","density_of_states","fermi_energy","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"b91a64fa-8b98-5aee-a568-9247fb9a00b3","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/electronic_density_mesh.json":{"name":"Electronic Density Mesh","subworkflows":[{"_id":"e2749c5a-fcd9-589c-819b-8b88c5c90924","name":"Electronic Density Mesh","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"e1a6e1e9-7994-5cd0-98d7-ae8909a10061"},{"type":"execution","name":"pp_density","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"e1a6e1e9-7994-5cd0-98d7-ae8909a10061","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"pp.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"pp_density.in"}],"results":[],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pp.x","name":"pp_density","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUTPP\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    filplot = 'pp.dat'\n    plot_num = 0\n/\n&PLOT\n    iflag = 3\n    output_format = 5\n    fileout ='density.xsf'\n/\n","name":"pp_density.in","contextProviders":[],"applicationName":"espresso","executableName":"pp.x","rendered":"&INPUTPP\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    filplot = 'pp.dat'\n    plot_num = 0\n/\n&PLOT\n    iflag = 3\n    output_format = 5\n    fileout ='density.xsf'\n/\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Electronic Density Mesh","type":"subworkflow","_id":"e2749c5a-fcd9-589c-819b-8b88c5c90924","status":"idle","statusTrack":[],"flowchartId":"79e421a1-18aa-5c27-b8a8-9a769c1a89a0","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"67b8445c-14ea-5efb-acbf-7dd7bd9df4b4","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/esm_relax.json":{"name":"Effective Screening Medium (ESM) Relax","subworkflows":[{"_id":"69728792-afeb-50aa-9b4e-6974a90f676a","name":"Effective Screening Medium (ESM) Relax","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor","potential_profile","charge_density_profile"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_esm_relax","head":true,"results":[{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"pressure"},{"name":"fermi_energy"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"},{"name":"potential_profile"},{"name":"charge_density_profile"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"a2bec506-1fdd-5125-a787-85f31cde20c1","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_esm_relax.in"}],"results":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor","potential_profile","charge_density_profile"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_esm_relax","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&CONTROL\n    calculation = 'relax'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n    assume_isolated = 'esm'\n    esm_bc = '{{ boundaryConditions.type }}'\n    fcp_mu = {{ boundaryConditions.targetFermiEnergy }}\n    esm_w = {{ boundaryConditions.offset }}\n    esm_efield = {{ boundaryConditions.electricField }}\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_esm_relax.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"},{"name":"BoundaryConditionsFormDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'relax'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n    assume_isolated = 'esm'\n    esm_bc = 'pbc'\n    fcp_mu = 0\n    esm_w = 0\n    esm_efield = 0\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Effective Screening Medium (ESM) Relax","type":"subworkflow","_id":"69728792-afeb-50aa-9b4e-6974a90f676a","status":"idle","statusTrack":[],"flowchartId":"f0733dc9-f3ad-5a1c-82fc-515edc0276b6","tags":[],"head":true}],"properties":["atomic_forces","charge_density_profile","fermi_energy","potential_profile","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"059da61f-b061-5626-92c4-c103c28b737e","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/esm.json":{"name":"Effective Screening Medium (ESM)","subworkflows":[{"_id":"0de669f6-a455-5dae-b331-19dc85f7090f","name":"Effective Screening Medium (ESM)","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor","potential_profile","charge_density_profile"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_esm","head":true,"results":[{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"pressure"},{"name":"fermi_energy"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"},{"name":"potential_profile"},{"name":"charge_density_profile"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"2f487bc6-c237-53e4-bad5-be60369662cb","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_esm.in"}],"results":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor","potential_profile","charge_density_profile"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_esm","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n    assume_isolated = 'esm'\n    esm_bc = '{{ boundaryConditions.type }}'\n    fcp_mu = {{ boundaryConditions.targetFermiEnergy }}\n    esm_w = {{ boundaryConditions.offset }}\n    esm_efield = {{ boundaryConditions.electricField }}\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_esm.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"},{"name":"BoundaryConditionsFormDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n    assume_isolated = 'esm'\n    esm_bc = 'pbc'\n    fcp_mu = 0\n    esm_w = 0\n    esm_efield = 0\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Effective Screening Medium (ESM)","type":"subworkflow","_id":"0de669f6-a455-5dae-b331-19dc85f7090f","status":"idle","statusTrack":[],"flowchartId":"e7893fdf-0515-58a0-a9e1-0393bdc57d33","tags":[],"head":true}],"properties":["atomic_forces","charge_density_profile","fermi_energy","potential_profile","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"1f17c10d-9554-5f41-994e-fee3fc0d22a7","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/fixed_cell_relaxation.json":{"name":"Fixed-cell Relaxation","subworkflows":[{"_id":"fb75e249-5489-5146-bd8a-786d33330d9c","name":"Fixed-cell Relaxation","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","fermi_energy","pressure","atomic_forces","total_force","stress_tensor","final_structure"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_relax","head":true,"results":[{"name":"total_energy"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"},{"name":"final_structure"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"},{"name":"convergence_ionic"}],"flowchartId":"c42871f6-ab79-5987-b228-c3bd80f16ffd","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_relax.in"}],"monitors":["standard_output","convergence_electronic","convergence_ionic"],"results":["total_energy","fermi_energy","pressure","atomic_forces","total_force","stress_tensor","final_structure"],"applicationName":"espresso","executableName":"pw.x","name":"pw_relax","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&CONTROL\n    calculation = 'relax'\n    nstep = 50\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_relax.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'relax'\n    nstep = 50\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Fixed-cell Relaxation","type":"subworkflow","_id":"fb75e249-5489-5146-bd8a-786d33330d9c","status":"idle","statusTrack":[],"flowchartId":"0de8c4c8-b722-5cd2-ae68-b484262e0a01","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","final_structure","pressure","stress_tensor","total_energy","total_force"],"_id":"10343bab-9cf8-51ed-a0bc-6991cc5ffa8f","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/gw_band_structure_band_gap_full_frequency.json":{"name":"Full Frequency GW Band Structure + Band Gap","subworkflows":[{"_id":"46bcdcc8-628e-518e-b8c3-9bf38d7a2aef","name":"Full Frequency GW Band Structure + Band Gap","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","band_structure","fermi_energy","band_gaps"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{"searchText":".*dojo-oncv.*"}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"d82a9858-3f20-5fcd-baeb-0f1d65e9e22e"},{"type":"execution","name":"gw_bands_full_frequency","head":false,"results":[{"name":"band_structure"},{"name":"fermi_energy"},{"name":"band_gaps"}],"monitors":[{"name":"standard_output"}],"flowchartId":"d82a9858-3f20-5fcd-baeb-0f1d65e9e22e","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"gw.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"gw_bands_full_frequency.in"}],"results":["band_structure","fermi_energy","band_gaps"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"gw.x","name":"gw_bands_full_frequency","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&gw_input\n\n  ! see http://www.sternheimergw.org for more information.\n\n  ! config of the scf run\n  prefix         = '__prefix__'\n  outdir         = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n\n  ! the grid used for the linear response\n  kpt_grid       = {{ kgrid.dimensions|join(', ') }}\n  qpt_grid       = {{ qgrid.dimensions|join(', ') }}\n\n  ! number of bands for which the GW correction is calculated\n  num_band       = 8\n\n  ! configuration of W in the convolution\n  max_freq_coul  = 200\n  num_freq_coul  = 51\n\n  ! configuration for the correlation self energy\n  ecut_corr      = 6.0\n\n  ! configuration for the exchange self energy\n  ecut_exch      = 15.0\n/\n\n&gw_output\n/\n\nFREQUENCIES\n35\n  0.0    0.0\n  0.0    0.3\n  0.0    0.9\n  0.0    1.8\n  0.0    3.0\n  0.0    4.5\n  0.0    6.3\n  0.0    8.4\n  0.0   10.8\n  0.0   13.5\n  0.0   16.5\n  0.0   19.8\n  0.0   23.4\n  0.0   27.3\n  0.0   31.5\n  0.0   36.0\n  0.0   40.8\n  0.0   45.9\n  0.0   51.3\n  0.0   57.0\n  0.0   63.0\n  0.0   69.3\n  0.0   75.9\n  0.0   82.8\n  0.0   90.0\n  0.0   97.5\n  0.0  105.3\n  0.0  113.4\n  0.0  121.8\n  0.0  130.5\n  0.0  139.5\n  0.0  148.8\n  0.0  158.4\n  0.0  168.3\n  0.0  178.5\n/\n\nK_points\n{{ explicitKPath2PIBA.length }}\n{% for point in explicitKPath2PIBA -%}\n{% for coordinate in point.coordinates %}{{ coordinate }}{% endfor %}\n{% endfor %}\n/\n","name":"gw_bands_full_frequency.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QGridFormDataManager"},{"name":"ExplicitKPath2PIBAFormDataManager"}],"applicationName":"espresso","executableName":"gw.x","rendered":"&gw_input\n\n  ! see http://www.sternheimergw.org for more information.\n\n  ! config of the scf run\n  prefix         = '__prefix__'\n  outdir         = '{{ JOB_WORK_DIR }}/outdir'\n\n  ! the grid used for the linear response\n  kpt_grid       = 2, 2, 2\n  qpt_grid       = 1, 1, 1\n\n  ! number of bands for which the GW correction is calculated\n  num_band       = 8\n\n  ! configuration of W in the convolution\n  max_freq_coul  = 200\n  num_freq_coul  = 51\n\n  ! configuration for the correlation self energy\n  ecut_corr      = 6.0\n\n  ! configuration for the exchange self energy\n  ecut_exch      = 15.0\n/\n\n&gw_output\n/\n\nFREQUENCIES\n35\n  0.0    0.0\n  0.0    0.3\n  0.0    0.9\n  0.0    1.8\n  0.0    3.0\n  0.0    4.5\n  0.0    6.3\n  0.0    8.4\n  0.0   10.8\n  0.0   13.5\n  0.0   16.5\n  0.0   19.8\n  0.0   23.4\n  0.0   27.3\n  0.0   31.5\n  0.0   36.0\n  0.0   40.8\n  0.0   45.9\n  0.0   51.3\n  0.0   57.0\n  0.0   63.0\n  0.0   69.3\n  0.0   75.9\n  0.0   82.8\n  0.0   90.0\n  0.0   97.5\n  0.0  105.3\n  0.0  113.4\n  0.0  121.8\n  0.0  130.5\n  0.0  139.5\n  0.0  148.8\n  0.0  158.4\n  0.0  168.3\n  0.0  178.5\n/\n\nK_points\n101\n   0.000000000   0.000000000   0.000000000\n   0.028867513  -0.040824829   0.050000000\n   0.057735027  -0.081649658   0.100000000\n   0.086602540  -0.122474487   0.150000000\n   0.115470054  -0.163299316   0.200000000\n   0.144337567  -0.204124145   0.250000000\n   0.173205081  -0.244948974   0.300000000\n   0.202072594  -0.285773803   0.350000000\n   0.230940108  -0.326598632   0.400000000\n   0.259807621  -0.367423461   0.450000000\n   0.288675135  -0.408248290   0.500000000\n   0.274241378  -0.387835876   0.525000000\n   0.259807621  -0.367423461   0.550000000\n   0.245373864  -0.347011047   0.575000000\n   0.230940108  -0.326598632   0.600000000\n   0.216506351  -0.306186218   0.625000000\n   0.202072594  -0.285773803   0.650000000\n   0.187638837  -0.265361389   0.675000000\n   0.173205081  -0.244948974   0.700000000\n   0.158771324  -0.224536560   0.725000000\n   0.144337567  -0.204124145   0.750000000\n   0.129903811  -0.183711731   0.750000000\n   0.115470054  -0.163299316   0.750000000\n   0.101036297  -0.142886902   0.750000000\n   0.086602540  -0.122474487   0.750000000\n   0.072168784  -0.102062073   0.750000000\n   0.057735027  -0.081649658   0.750000000\n   0.043301270  -0.061237244   0.750000000\n   0.028867513  -0.040824829   0.750000000\n   0.014433757  -0.020412415   0.750000000\n  -0.000000000  -0.000000000   0.750000000\n  -0.000000000  -0.000000000   0.675000000\n  -0.000000000  -0.000000000   0.600000000\n  -0.000000000  -0.000000000   0.525000000\n  -0.000000000  -0.000000000   0.450000000\n  -0.000000000  -0.000000000   0.375000000\n  -0.000000000  -0.000000000   0.300000000\n  -0.000000000  -0.000000000   0.225000000\n  -0.000000000  -0.000000000   0.150000000\n  -0.000000000  -0.000000000   0.075000000\n   0.000000000   0.000000000   0.000000000\n   0.028867513   0.020412415   0.050000000\n   0.057735027   0.040824829   0.100000000\n   0.086602540   0.061237244   0.150000000\n   0.115470054   0.081649658   0.200000000\n   0.144337567   0.102062073   0.250000000\n   0.173205081   0.122474487   0.300000000\n   0.202072594   0.142886902   0.350000000\n   0.230940108   0.163299316   0.400000000\n   0.259807621   0.183711731   0.450000000\n   0.288675135   0.204124145   0.500000000\n   0.295892013   0.163299316   0.512500000\n   0.303108891   0.122474487   0.525000000\n   0.310325770   0.081649658   0.537500000\n   0.317542648   0.040824829   0.550000000\n   0.324759526  -0.000000000   0.562500000\n   0.331976405  -0.040824829   0.575000000\n   0.339193283  -0.081649658   0.587500000\n   0.346410162  -0.122474487   0.600000000\n   0.353627040  -0.163299316   0.612500000\n   0.360843918  -0.204124145   0.625000000\n   0.339193283  -0.204124145   0.637500000\n   0.317542648  -0.204124145   0.650000000\n   0.295892013  -0.204124145   0.662500000\n   0.274241378  -0.204124145   0.675000000\n   0.252590743  -0.204124145   0.687500000\n   0.230940108  -0.204124145   0.700000000\n   0.209289473  -0.204124145   0.712500000\n   0.187638837  -0.204124145   0.725000000\n   0.165988202  -0.204124145   0.737500000\n   0.144337567  -0.204124145   0.750000000\n   0.158771324  -0.163299316   0.725000000\n   0.173205081  -0.122474487   0.700000000\n   0.187638837  -0.081649658   0.675000000\n   0.202072594  -0.040824829   0.650000000\n   0.216506351  -0.000000000   0.625000000\n   0.230940108   0.040824829   0.600000000\n   0.245373864   0.081649658   0.575000000\n   0.259807621   0.122474487   0.550000000\n   0.274241378   0.163299316   0.525000000\n   0.288675135   0.204124145   0.500000000\n   0.295892013   0.163299316   0.512500000\n   0.303108891   0.122474487   0.525000000\n   0.310325770   0.081649658   0.537500000\n   0.317542648   0.040824829   0.550000000\n   0.324759526  -0.000000000   0.562500000\n   0.331976405  -0.040824829   0.575000000\n   0.339193283  -0.081649658   0.587500000\n   0.346410162  -0.122474487   0.600000000\n   0.353627040  -0.163299316   0.612500000\n   0.360843918  -0.204124145   0.625000000\n   0.353627040  -0.224536560   0.612500000\n   0.346410162  -0.244948974   0.600000000\n   0.339193283  -0.265361389   0.587500000\n   0.331976405  -0.285773803   0.575000000\n   0.324759526  -0.306186218   0.562500000\n   0.317542648  -0.326598632   0.550000000\n   0.310325770  -0.347011047   0.537500000\n   0.303108891  -0.367423461   0.525000000\n   0.295892013  -0.387835876   0.512500000\n   0.288675135  -0.408248290   0.500000000\n\n/\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Full Frequency GW Band Structure + Band Gap","type":"subworkflow","_id":"46bcdcc8-628e-518e-b8c3-9bf38d7a2aef","status":"idle","statusTrack":[],"flowchartId":"b1748925-1c8e-5c73-a8ff-ec4da33a49ce","tags":[],"head":true}],"properties":["atomic_forces","band_gaps","band_structure","fermi_energy","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"b2b4871b-30e5-5320-a130-a73027560156","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/gw_band_structure_band_gap_plasmon_pole.json":{"name":"Plasmon-Pole GW Band Structure + Band Gap","subworkflows":[{"_id":"72b79a87-8eef-5fe2-9d6c-6c9c256dd56c","name":"Plasmon-Pole GW Band Structure + Band Gap","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","band_structure","fermi_energy","band_gaps"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{"searchText":".*dojo-oncv.*"}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"f9910952-eca9-5a5f-ae03-a0060ae2fc78"},{"type":"execution","name":"gw_bands_plasmon_pole","head":false,"results":[{"name":"band_structure"},{"name":"fermi_energy"},{"name":"band_gaps"}],"monitors":[{"name":"standard_output"}],"flowchartId":"f9910952-eca9-5a5f-ae03-a0060ae2fc78","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"gw.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"gw_bands_plasmon_pole.in"}],"results":["band_structure","fermi_energy","band_gaps"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"gw.x","name":"gw_bands_plasmon_pole","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&gw_input\n\n  ! see http://www.sternheimergw.org for more information.\n\n  ! config of the scf run\n  prefix         = '__prefix__'\n  outdir         = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n\n  ! the grid used for the linear response\n  kpt_grid       = {{ kgrid.dimensions|join(', ') }}\n  qpt_grid       = {{ qgrid.dimensions|join(', ') }}\n\n  ! truncation (used for both correlation and exchange)\n  truncation     = '2d'\n\n  ! number of bands for which the GW correction is calculated\n  num_band       = 8\n\n  ! configuration of the Coulomb solver\n  thres_coul     = 1.0d-2\n\n  ! configuration of W in the convolution\n  model_coul     = 'godby-needs'\n  max_freq_coul  = 120\n  num_freq_coul  = 35\n\n  ! configuration of the Green solver\n  thres_green    = 1.0d-3\n  max_iter_green = 300\n\n  ! configuration for the correlation self energy\n  ecut_corr      = 5.0\n  max_freq_corr  = 100.0\n  num_freq_corr  = 11\n\n  ! configuration for the exchange self energy\n  ecut_exch      = 20.0\n\n  ! configuration for the output\n  eta            = 0.1\n  min_freq_wind  = -30.0\n  max_freq_wind  =  30.0\n  num_freq_wind  = 601\n/\n\n&gw_output\n/\n\nFREQUENCIES\n2\n  0.0    0.0\n  0.0   10.0\n/\n\nK_points\n{{ explicitKPath2PIBA.length }}\n{% for point in explicitKPath2PIBA -%}\n{% for coordinate in point.coordinates %}{{ coordinate }}{% endfor %}\n{% endfor %}\n/\n","name":"gw_bands_plasmon_pole.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QGridFormDataManager"},{"name":"ExplicitKPath2PIBAFormDataManager"}],"applicationName":"espresso","executableName":"gw.x","rendered":"&gw_input\n\n  ! see http://www.sternheimergw.org for more information.\n\n  ! config of the scf run\n  prefix         = '__prefix__'\n  outdir         = '{{ JOB_WORK_DIR }}/outdir'\n\n  ! the grid used for the linear response\n  kpt_grid       = 2, 2, 2\n  qpt_grid       = 1, 1, 1\n\n  ! truncation (used for both correlation and exchange)\n  truncation     = '2d'\n\n  ! number of bands for which the GW correction is calculated\n  num_band       = 8\n\n  ! configuration of the Coulomb solver\n  thres_coul     = 1.0d-2\n\n  ! configuration of W in the convolution\n  model_coul     = 'godby-needs'\n  max_freq_coul  = 120\n  num_freq_coul  = 35\n\n  ! configuration of the Green solver\n  thres_green    = 1.0d-3\n  max_iter_green = 300\n\n  ! configuration for the correlation self energy\n  ecut_corr      = 5.0\n  max_freq_corr  = 100.0\n  num_freq_corr  = 11\n\n  ! configuration for the exchange self energy\n  ecut_exch      = 20.0\n\n  ! configuration for the output\n  eta            = 0.1\n  min_freq_wind  = -30.0\n  max_freq_wind  =  30.0\n  num_freq_wind  = 601\n/\n\n&gw_output\n/\n\nFREQUENCIES\n2\n  0.0    0.0\n  0.0   10.0\n/\n\nK_points\n101\n   0.000000000   0.000000000   0.000000000\n   0.028867513  -0.040824829   0.050000000\n   0.057735027  -0.081649658   0.100000000\n   0.086602540  -0.122474487   0.150000000\n   0.115470054  -0.163299316   0.200000000\n   0.144337567  -0.204124145   0.250000000\n   0.173205081  -0.244948974   0.300000000\n   0.202072594  -0.285773803   0.350000000\n   0.230940108  -0.326598632   0.400000000\n   0.259807621  -0.367423461   0.450000000\n   0.288675135  -0.408248290   0.500000000\n   0.274241378  -0.387835876   0.525000000\n   0.259807621  -0.367423461   0.550000000\n   0.245373864  -0.347011047   0.575000000\n   0.230940108  -0.326598632   0.600000000\n   0.216506351  -0.306186218   0.625000000\n   0.202072594  -0.285773803   0.650000000\n   0.187638837  -0.265361389   0.675000000\n   0.173205081  -0.244948974   0.700000000\n   0.158771324  -0.224536560   0.725000000\n   0.144337567  -0.204124145   0.750000000\n   0.129903811  -0.183711731   0.750000000\n   0.115470054  -0.163299316   0.750000000\n   0.101036297  -0.142886902   0.750000000\n   0.086602540  -0.122474487   0.750000000\n   0.072168784  -0.102062073   0.750000000\n   0.057735027  -0.081649658   0.750000000\n   0.043301270  -0.061237244   0.750000000\n   0.028867513  -0.040824829   0.750000000\n   0.014433757  -0.020412415   0.750000000\n  -0.000000000  -0.000000000   0.750000000\n  -0.000000000  -0.000000000   0.675000000\n  -0.000000000  -0.000000000   0.600000000\n  -0.000000000  -0.000000000   0.525000000\n  -0.000000000  -0.000000000   0.450000000\n  -0.000000000  -0.000000000   0.375000000\n  -0.000000000  -0.000000000   0.300000000\n  -0.000000000  -0.000000000   0.225000000\n  -0.000000000  -0.000000000   0.150000000\n  -0.000000000  -0.000000000   0.075000000\n   0.000000000   0.000000000   0.000000000\n   0.028867513   0.020412415   0.050000000\n   0.057735027   0.040824829   0.100000000\n   0.086602540   0.061237244   0.150000000\n   0.115470054   0.081649658   0.200000000\n   0.144337567   0.102062073   0.250000000\n   0.173205081   0.122474487   0.300000000\n   0.202072594   0.142886902   0.350000000\n   0.230940108   0.163299316   0.400000000\n   0.259807621   0.183711731   0.450000000\n   0.288675135   0.204124145   0.500000000\n   0.295892013   0.163299316   0.512500000\n   0.303108891   0.122474487   0.525000000\n   0.310325770   0.081649658   0.537500000\n   0.317542648   0.040824829   0.550000000\n   0.324759526  -0.000000000   0.562500000\n   0.331976405  -0.040824829   0.575000000\n   0.339193283  -0.081649658   0.587500000\n   0.346410162  -0.122474487   0.600000000\n   0.353627040  -0.163299316   0.612500000\n   0.360843918  -0.204124145   0.625000000\n   0.339193283  -0.204124145   0.637500000\n   0.317542648  -0.204124145   0.650000000\n   0.295892013  -0.204124145   0.662500000\n   0.274241378  -0.204124145   0.675000000\n   0.252590743  -0.204124145   0.687500000\n   0.230940108  -0.204124145   0.700000000\n   0.209289473  -0.204124145   0.712500000\n   0.187638837  -0.204124145   0.725000000\n   0.165988202  -0.204124145   0.737500000\n   0.144337567  -0.204124145   0.750000000\n   0.158771324  -0.163299316   0.725000000\n   0.173205081  -0.122474487   0.700000000\n   0.187638837  -0.081649658   0.675000000\n   0.202072594  -0.040824829   0.650000000\n   0.216506351  -0.000000000   0.625000000\n   0.230940108   0.040824829   0.600000000\n   0.245373864   0.081649658   0.575000000\n   0.259807621   0.122474487   0.550000000\n   0.274241378   0.163299316   0.525000000\n   0.288675135   0.204124145   0.500000000\n   0.295892013   0.163299316   0.512500000\n   0.303108891   0.122474487   0.525000000\n   0.310325770   0.081649658   0.537500000\n   0.317542648   0.040824829   0.550000000\n   0.324759526  -0.000000000   0.562500000\n   0.331976405  -0.040824829   0.575000000\n   0.339193283  -0.081649658   0.587500000\n   0.346410162  -0.122474487   0.600000000\n   0.353627040  -0.163299316   0.612500000\n   0.360843918  -0.204124145   0.625000000\n   0.353627040  -0.224536560   0.612500000\n   0.346410162  -0.244948974   0.600000000\n   0.339193283  -0.265361389   0.587500000\n   0.331976405  -0.285773803   0.575000000\n   0.324759526  -0.306186218   0.562500000\n   0.317542648  -0.326598632   0.550000000\n   0.310325770  -0.347011047   0.537500000\n   0.303108891  -0.367423461   0.525000000\n   0.295892013  -0.387835876   0.512500000\n   0.288675135  -0.408248290   0.500000000\n\n/\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Plasmon-Pole GW Band Structure + Band Gap","type":"subworkflow","_id":"72b79a87-8eef-5fe2-9d6c-6c9c256dd56c","status":"idle","statusTrack":[],"flowchartId":"911d4cc1-cde5-5097-a7be-0e11f73113a7","tags":[],"head":true}],"properties":["atomic_forces","band_gaps","band_structure","fermi_energy","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"7d083bf3-c506-5294-8f3c-74d49d6d8aa2","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/kpoint_convergence.json":{"name":"K-point Convergence","subworkflows":[{"_id":"ff6a8fbc-2202-5786-9a26-67c843417d0b","name":"K-point Convergence","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","fermi_energy","pressure","atomic_forces","total_force","stress_tensor"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"name":"Init tolerance","type":"assignment","operand":"TOL","value":0.00001,"input":[],"flowchartId":"init-tolerance","status":"idle","statusTrack":[],"tags":[],"head":true,"next":"init-increment","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"name":"Init increment","type":"assignment","operand":"INC","value":1,"input":[],"flowchartId":"init-increment","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"init-result","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"name":"Init result","type":"assignment","operand":"PREV_RESULT","value":0,"input":[],"flowchartId":"init-result","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"init-parameter","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"name":"Init parameter","type":"assignment","operand":"PARAMETER","value":1,"input":[],"flowchartId":"init-parameter","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"pwscf-kpoint-convergence","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"type":"execution","name":"pw_scf_kpt_conv","head":false,"results":[{"name":"total_energy"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"pwscf-kpoint-convergence","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_scf_kpt_conv.in"}],"results":["total_energy","fermi_energy","pressure","atomic_forces","total_force","stress_tensor"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf_kpt_conv","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% raw %}{{PARAMETER | default('1')}} {{PARAMETER | default('1')}} {{PARAMETER | default('1')}} 0 0 0{% endraw %}\n","name":"pw_scf_kpt_conv.in","contextProviders":[{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n{{PARAMETER | default('1')}} {{PARAMETER | default('1')}} {{PARAMETER | default('1')}} 0 0 0\n","schemaVersion":"2022.8.16"}],"next":"store-result"},{"name":"store result","type":"assignment","operand":"RESULT","value":"total_energy","input":[{"name":"total_energy","scope":"pwscf-kpoint-convergence"}],"flowchartId":"store-result","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"check-convergence","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"name":"check convergence","type":"condition","input":[],"results":[],"preProcessors":[],"postProcessors":[],"then":"convergence-is-reached","else":"update-result","statement":"abs((PREV_RESULT-RESULT)/RESULT) < TOL","maxOccurrences":50,"flowchartId":"check-convergence","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"update-result","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"name":"update result","type":"assignment","operand":"PREV_RESULT","value":"RESULT","input":[{"name":"RESULT","scope":"global"}],"flowchartId":"update-result","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"increment-parameter","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"name":"increment parameter","type":"assignment","operand":"PREV_RESULT","value":"PARAMETER+INC","input":[{"name":"INC","scope":"global"},{"name":"PARAMETER","scope":"global"}],"flowchartId":"increment-parameter","next":"pwscf-kpoint-convergence","status":"idle","statusTrack":[],"tags":[],"head":false,"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"name":"exit","type":"assignment","operand":"PARAMETER","value":"PARAMETER","input":[{"name":"PARAMETER","scope":"global"}],"flowchartId":"convergence-is-reached","status":"idle","statusTrack":[],"tags":[],"head":false,"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}}]}],"units":[{"name":"K-point Convergence","type":"subworkflow","_id":"ff6a8fbc-2202-5786-9a26-67c843417d0b","status":"idle","statusTrack":[],"flowchartId":"a34eec2c-cdb2-537d-88c0-ed1d7b205879","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_force"],"_id":"e8141224-dcea-576b-a556-80f65ab2e230","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/neb.json":{"name":"Nudged Elastic Band (NEB)","subworkflows":[{"isMultiMaterial":true,"_id":"c9034468-df28-5357-8912-02226f919042","name":"Nudged Elastic Band (NEB)","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["reaction_energy_barrier","reaction_energy_profile"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"neb","head":true,"results":[{"name":"reaction_energy_barrier"},{"name":"reaction_energy_profile"}],"monitors":[{"name":"standard_output"}],"flowchartId":"9f273ca0-d240-5b1f-89a9-64dd579304ac","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"neb.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"neb.in"}],"results":["reaction_energy_barrier","reaction_energy_profile"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"neb.x","name":"neb","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"BEGIN\nBEGIN_PATH_INPUT\n&PATH\n  restart_mode      = 'from_scratch'\n  string_method     = 'neb',\n  nstep_path        = 50,\n  ds                = 2.D0,\n  opt_scheme        = \"broyden\",\n  num_of_images     = {{ 2 + (input.INTERMEDIATE_IMAGES.length or neb.nImages) }},\n  k_max             = 0.3D0,\n  k_min             = 0.2D0,\n  CI_scheme         = \"auto\",\n  path_thr          = 0.1D0,\n/\nEND_PATH_INPUT\nBEGIN_ENGINE_INPUT\n&CONTROL\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.03\n    nspin = 2\n    starting_magnetization = 0.5\n/\n&ELECTRONS\n    conv_thr    = 1.D-8\n    mixing_beta = 0.3\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nBEGIN_POSITIONS\nFIRST_IMAGE\nATOMIC_POSITIONS crystal\n{{ input.FIRST_IMAGE }}\n{%- for IMAGE in input.INTERMEDIATE_IMAGES %}\nINTERMEDIATE_IMAGE\nATOMIC_POSITIONS crystal\n{{ IMAGE }}\n{%- endfor %}\nLAST_IMAGE\nATOMIC_POSITIONS crystal\n{{ input.LAST_IMAGE }}\nEND_POSITIONS\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\nEND_ENGINE_INPUT\nEND\n","name":"neb.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"NEBFormDataManager"},{"name":"QENEBInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"neb.x","rendered":"BEGIN\nBEGIN_PATH_INPUT\n&PATH\n  restart_mode      = 'from_scratch'\n  string_method     = 'neb',\n  nstep_path        = 50,\n  ds                = 2.D0,\n  opt_scheme        = \"broyden\",\n  num_of_images     = 3,\n  k_max             = 0.3D0,\n  k_min             = 0.2D0,\n  CI_scheme         = \"auto\",\n  path_thr          = 0.1D0,\n/\nEND_PATH_INPUT\nBEGIN_ENGINE_INPUT\n&CONTROL\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.03\n    nspin = 2\n    starting_magnetization = 0.5\n/\n&ELECTRONS\n    conv_thr    = 1.D-8\n    mixing_beta = 0.3\n/\nATOMIC_SPECIES\nSi 28.0855 \nBEGIN_POSITIONS\nFIRST_IMAGE\nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nLAST_IMAGE\nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nEND_POSITIONS\nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \nEND_ENGINE_INPUT\nEND\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Nudged Elastic Band (NEB)","type":"subworkflow","_id":"c9034468-df28-5357-8912-02226f919042","status":"idle","statusTrack":[],"flowchartId":"134c70e2-aeaf-543d-aded-1585cd71b800","tags":[],"head":true}],"properties":["reaction_energy_barrier","reaction_energy_profile"],"_id":"6dc0a5af-7ec5-50e4-b663-42fc5ddf0ef1","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/phonon_dispersions.json":{"name":"Phonon Dispersions","subworkflows":[{"_id":"bfb69b48-8fbf-5a0d-8949-448f20754766","name":"Phonon Dispersions","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","phonon_dos","phonon_dispersions"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"13bcafce-56ef-5b47-b079-317495eb6933"},{"type":"execution","name":"ph_grid","head":false,"results":[{"name":"phonon_dos"}],"monitors":[{"name":"standard_output"}],"flowchartId":"13bcafce-56ef-5b47-b079-317495eb6933","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"ph.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"ph_grid.in"}],"results":["phonon_dos"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"ph.x","name":"ph_grid","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUTPH\n    tr2_ph = 1.0d-12\n    asr = .true.\n    search_sym = .false.\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    fildyn = 'dyn'\n    ldisp = .true.\n    {% for d in qgrid.dimensions -%}\n    nq{{loop.index}} = {{d}}\n    {% endfor %}\n/\n","name":"ph_grid.in","contextProviders":[{"name":"QGridFormDataManager"}],"applicationName":"espresso","executableName":"ph.x","rendered":"&INPUTPH\n    tr2_ph = 1.0d-12\n    asr = .true.\n    search_sym = .false.\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    fildyn = 'dyn'\n    ldisp = .true.\n    nq1 = 1\n    nq2 = 1\n    nq3 = 1\n    \n/\n","schemaVersion":"2022.8.16"}],"next":"3b4507a7-9244-540b-abe0-66bceab700f5"},{"type":"execution","name":"q2r","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"3b4507a7-9244-540b-abe0-66bceab700f5","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"q2r.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"q2r.in"}],"results":[],"monitors":["standard_output"],"applicationName":"espresso","executableName":"q2r.x","name":"q2r","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUT\n    fildyn = 'dyn'\n    zasr = 'simple'\n    flfrc = 'force_constants.fc'\n/\n","name":"q2r.in","contextProviders":[],"applicationName":"espresso","executableName":"q2r.x","rendered":"&INPUT\n    fildyn = 'dyn'\n    zasr = 'simple'\n    flfrc = 'force_constants.fc'\n/\n","schemaVersion":"2022.8.16"}],"next":"a7fded20-889b-54fc-bbb0-456e82689ab1"},{"type":"execution","name":"matdyn_path","head":false,"results":[{"name":"phonon_dispersions"}],"monitors":[{"name":"standard_output"}],"flowchartId":"a7fded20-889b-54fc-bbb0-456e82689ab1","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"matdyn.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"matdyn_path.in"}],"monitors":["standard_output"],"results":["phonon_dispersions"],"applicationName":"espresso","executableName":"matdyn.x","name":"matdyn_path","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUT\n    asr = 'simple'\n    flfrc ='force_constants.fc'\n    flfrq ='frequencies.freq'\n    flvec ='normal_modes.out'\n    q_in_band_form = .true.\n /\n{{ipath.length}}\n{% for point in ipath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"matdyn_path.in","contextProviders":[{"name":"IPathFormDataManager"}],"applicationName":"espresso","executableName":"matdyn.x","rendered":"&INPUT\n    asr = 'simple'\n    flfrc ='force_constants.fc'\n    flfrq ='frequencies.freq'\n    flvec ='normal_modes.out'\n    q_in_band_form = .true.\n /\n11\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Phonon Dispersions","type":"subworkflow","_id":"bfb69b48-8fbf-5a0d-8949-448f20754766","status":"idle","statusTrack":[],"flowchartId":"2cd13237-d089-5d5e-8372-1db8bb8e383f","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","phonon_dispersions","phonon_dos","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"8623c689-9ba3-5454-a3c8-0c6c49c402b4","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/phonon_dos_dispersion.json":{"name":"Phonon Density of States + Dispersions","subworkflows":[{"_id":"291d25cd-378a-5be7-9d85-c8013a4b165b","name":"Phonon Density of States + Dispersions","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","phonon_dos","phonon_dispersions"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"13bcafce-56ef-5b47-b079-317495eb6933"},{"type":"execution","name":"ph_grid","head":false,"results":[{"name":"phonon_dos"}],"monitors":[{"name":"standard_output"}],"flowchartId":"13bcafce-56ef-5b47-b079-317495eb6933","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"ph.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"ph_grid.in"}],"results":["phonon_dos"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"ph.x","name":"ph_grid","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUTPH\n    tr2_ph = 1.0d-12\n    asr = .true.\n    search_sym = .false.\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    fildyn = 'dyn'\n    ldisp = .true.\n    {% for d in qgrid.dimensions -%}\n    nq{{loop.index}} = {{d}}\n    {% endfor %}\n/\n","name":"ph_grid.in","contextProviders":[{"name":"QGridFormDataManager"}],"applicationName":"espresso","executableName":"ph.x","rendered":"&INPUTPH\n    tr2_ph = 1.0d-12\n    asr = .true.\n    search_sym = .false.\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    fildyn = 'dyn'\n    ldisp = .true.\n    nq1 = 1\n    nq2 = 1\n    nq3 = 1\n    \n/\n","schemaVersion":"2022.8.16"}],"next":"3b4507a7-9244-540b-abe0-66bceab700f5"},{"type":"execution","name":"q2r","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"3b4507a7-9244-540b-abe0-66bceab700f5","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"q2r.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"q2r.in"}],"results":[],"monitors":["standard_output"],"applicationName":"espresso","executableName":"q2r.x","name":"q2r","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUT\n    fildyn = 'dyn'\n    zasr = 'simple'\n    flfrc = 'force_constants.fc'\n/\n","name":"q2r.in","contextProviders":[],"applicationName":"espresso","executableName":"q2r.x","rendered":"&INPUT\n    fildyn = 'dyn'\n    zasr = 'simple'\n    flfrc = 'force_constants.fc'\n/\n","schemaVersion":"2022.8.16"}],"next":"8fe6a24b-c994-55a2-a448-88657292e8c2"},{"type":"execution","name":"matdyn_grid","head":false,"results":[{"name":"phonon_dos"}],"monitors":[{"name":"standard_output"}],"flowchartId":"8fe6a24b-c994-55a2-a448-88657292e8c2","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"matdyn.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"matdyn_grid.in"}],"monitors":["standard_output"],"results":["phonon_dos"],"applicationName":"espresso","executableName":"matdyn.x","name":"matdyn_grid","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUT\n    asr = 'simple'\n    flfrc = 'force_constants.fc'\n    flfrq = 'frequencies.freq'\n    dos = .true.\n    fldos = 'phonon_dos.out'\n    deltaE = 1.d0\n    {% for d in igrid.dimensions -%}\n    nk{{loop.index}} = {{d}}\n    {% endfor %}\n /\n","name":"matdyn_grid.in","contextProviders":[{"name":"IGridFormDataManager"}],"applicationName":"espresso","executableName":"matdyn.x","rendered":"&INPUT\n    asr = 'simple'\n    flfrc = 'force_constants.fc'\n    flfrq = 'frequencies.freq'\n    dos = .true.\n    fldos = 'phonon_dos.out'\n    deltaE = 1.d0\n    nk1 = 3\n    nk2 = 3\n    nk3 = 3\n    \n /\n","schemaVersion":"2022.8.16"}],"next":"a7fded20-889b-54fc-bbb0-456e82689ab1"},{"type":"execution","name":"matdyn_path","head":false,"results":[{"name":"phonon_dispersions"}],"monitors":[{"name":"standard_output"}],"flowchartId":"a7fded20-889b-54fc-bbb0-456e82689ab1","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"matdyn.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"matdyn_path.in"}],"monitors":["standard_output"],"results":["phonon_dispersions"],"applicationName":"espresso","executableName":"matdyn.x","name":"matdyn_path","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUT\n    asr = 'simple'\n    flfrc ='force_constants.fc'\n    flfrq ='frequencies.freq'\n    flvec ='normal_modes.out'\n    q_in_band_form = .true.\n /\n{{ipath.length}}\n{% for point in ipath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"matdyn_path.in","contextProviders":[{"name":"IPathFormDataManager"}],"applicationName":"espresso","executableName":"matdyn.x","rendered":"&INPUT\n    asr = 'simple'\n    flfrc ='force_constants.fc'\n    flfrq ='frequencies.freq'\n    flvec ='normal_modes.out'\n    q_in_band_form = .true.\n /\n11\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Phonon Density of States + Dispersions","type":"subworkflow","_id":"291d25cd-378a-5be7-9d85-c8013a4b165b","status":"idle","statusTrack":[],"flowchartId":"7897ed9a-6b48-5a79-a50e-28797f3912a5","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","phonon_dispersions","phonon_dos","phonon_dos","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"82043e83-bf1d-5b08-bed6-369c7dfcc1ae","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/phonon_dos.json":{"name":"Phonon Density of States","subworkflows":[{"_id":"2232051b-9f2a-5a48-9b4d-6231eb6e8297","name":"Phonon Density of States","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","phonon_dos"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"13bcafce-56ef-5b47-b079-317495eb6933"},{"type":"execution","name":"ph_grid","head":false,"results":[{"name":"phonon_dos"}],"monitors":[{"name":"standard_output"}],"flowchartId":"13bcafce-56ef-5b47-b079-317495eb6933","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"ph.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"ph_grid.in"}],"results":["phonon_dos"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"ph.x","name":"ph_grid","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUTPH\n    tr2_ph = 1.0d-12\n    asr = .true.\n    search_sym = .false.\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    fildyn = 'dyn'\n    ldisp = .true.\n    {% for d in qgrid.dimensions -%}\n    nq{{loop.index}} = {{d}}\n    {% endfor %}\n/\n","name":"ph_grid.in","contextProviders":[{"name":"QGridFormDataManager"}],"applicationName":"espresso","executableName":"ph.x","rendered":"&INPUTPH\n    tr2_ph = 1.0d-12\n    asr = .true.\n    search_sym = .false.\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    fildyn = 'dyn'\n    ldisp = .true.\n    nq1 = 1\n    nq2 = 1\n    nq3 = 1\n    \n/\n","schemaVersion":"2022.8.16"}],"next":"3b4507a7-9244-540b-abe0-66bceab700f5"},{"type":"execution","name":"q2r","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"3b4507a7-9244-540b-abe0-66bceab700f5","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"q2r.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"q2r.in"}],"results":[],"monitors":["standard_output"],"applicationName":"espresso","executableName":"q2r.x","name":"q2r","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUT\n    fildyn = 'dyn'\n    zasr = 'simple'\n    flfrc = 'force_constants.fc'\n/\n","name":"q2r.in","contextProviders":[],"applicationName":"espresso","executableName":"q2r.x","rendered":"&INPUT\n    fildyn = 'dyn'\n    zasr = 'simple'\n    flfrc = 'force_constants.fc'\n/\n","schemaVersion":"2022.8.16"}],"next":"8fe6a24b-c994-55a2-a448-88657292e8c2"},{"type":"execution","name":"matdyn_grid","head":false,"results":[{"name":"phonon_dos"}],"monitors":[{"name":"standard_output"}],"flowchartId":"8fe6a24b-c994-55a2-a448-88657292e8c2","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"matdyn.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"matdyn_grid.in"}],"monitors":["standard_output"],"results":["phonon_dos"],"applicationName":"espresso","executableName":"matdyn.x","name":"matdyn_grid","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUT\n    asr = 'simple'\n    flfrc = 'force_constants.fc'\n    flfrq = 'frequencies.freq'\n    dos = .true.\n    fldos = 'phonon_dos.out'\n    deltaE = 1.d0\n    {% for d in igrid.dimensions -%}\n    nk{{loop.index}} = {{d}}\n    {% endfor %}\n /\n","name":"matdyn_grid.in","contextProviders":[{"name":"IGridFormDataManager"}],"applicationName":"espresso","executableName":"matdyn.x","rendered":"&INPUT\n    asr = 'simple'\n    flfrc = 'force_constants.fc'\n    flfrq = 'frequencies.freq'\n    dos = .true.\n    fldos = 'phonon_dos.out'\n    deltaE = 1.d0\n    nk1 = 3\n    nk2 = 3\n    nk3 = 3\n    \n /\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Phonon Density of States","type":"subworkflow","_id":"2232051b-9f2a-5a48-9b4d-6231eb6e8297","status":"idle","statusTrack":[],"flowchartId":"1954e749-1d37-50e6-8ae7-7292f5ef59c0","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","phonon_dos","phonon_dos","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"3f7ff505-615d-5544-ab5f-407e67e1add6","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/phonon_map.json":{"name":"Phonon Map","subworkflows":[{"_id":"79f2cb6a-7994-5369-8c85-af07c55ad26f","name":"Preliminary SCF Calculation","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}]}]},{"_id":"2f017bcb-f4ba-55b8-b939-1f780679a88e","name":"ph-init-qpoints","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"ph_init_qpoints","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"b8ea6a33-38f3-5434-b17e-b5eae8fff9fc","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"ph.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"ph_init_qpoints.in"}],"results":[],"monitors":["standard_output"],"applicationName":"espresso","executableName":"ph.x","name":"ph_init_qpoints","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUTPH\n    tr2_ph = 1.0d-18,\n    recover = .false.\n    start_irr = 0\n    last_irr = 0\n    ldisp = .true.\n    fildyn = 'dyn0'\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    {% for d in qgrid.dimensions -%}\n    nq{{loop.index}} = {{d}}\n    {% endfor %}\n/\n","name":"ph_init_qpoints.in","contextProviders":[{"name":"QGridFormDataManager"}],"applicationName":"espresso","executableName":"ph.x","rendered":"&INPUTPH\n    tr2_ph = 1.0d-18,\n    recover = .false.\n    start_irr = 0\n    last_irr = 0\n    ldisp = .true.\n    fildyn = 'dyn0'\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    nq1 = 1\n    nq2 = 1\n    nq3 = 1\n    \n/\n","schemaVersion":"2022.8.16"}]}]},{"_id":"e4b6b2e7-7d8f-5ae1-b6bd-ee81ecbca11a","name":"espresso-xml-get-qpt-irr","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"python","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"9b8a495e-1ac1-56a7-b2e0-af1b405a1219","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"espresso_xml_get_qpt_irr.py"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"espresso_xml_get_qpt_irr","schemaVersion":"2022.8.16","isDefault":false},"next":"d0fd8654-2106-546b-8792-7bb46272befc","status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ---------------------------------------------------------- #\n#                                                            #\n#  This script extracts q-points and irreducible             #\n#  representations from Quantum ESPRESSO xml data.           #\n#                                                            #\n#  Expects control_ph.xml and patterns.?.xml files to exist  #\n#                                                            #\n# ---------------------------------------------------------- #\nfrom __future__ import print_function\n\nimport json\nfrom xml.dom import minidom\n\n{#    JOB_WORK_DIR will be initialized at runtime => avoid substituion below    #}\n{% raw %}\nCONTROL_PH_FILENAME = \"{{JOB_WORK_DIR}}/outdir/_ph0/__prefix__.phsave/control_ph.xml\"\nPATTERNS_FILENAME = \"{{JOB_WORK_DIR}}/outdir/_ph0/__prefix__.phsave/patterns.{}.xml\"\n{% endraw %}\n\n# get integer content of an xml tag in a document\ndef get_int_by_tag_name(doc, tag_name):\n    element = doc.getElementsByTagName(tag_name)\n    return int(element[0].firstChild.nodeValue)\n\nvalues = []\n\n# get number of q-points and cycle through them\nxmldoc = minidom.parse(CONTROL_PH_FILENAME)\nnumber_of_qpoints = get_int_by_tag_name(xmldoc, \"NUMBER_OF_Q_POINTS\")\n\nfor i in range(number_of_qpoints):\n    # get number of irreducible representations per qpoint\n    xmldoc = minidom.parse(PATTERNS_FILENAME.format(i+1))\n    number_of_irr_per_qpoint = get_int_by_tag_name(xmldoc, \"NUMBER_IRR_REP\")\n    # add each distinct combination of qpoint and irr as a separate entry\n    for j in range(number_of_irr_per_qpoint):\n      values.append({\n          \"qpoint\": i + 1,\n          \"irr\": j + 1\n      })\n\n# store final values in standard output (STDOUT)\nprint(json.dumps(values, indent=4))\n","name":"espresso_xml_get_qpt_irr.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ---------------------------------------------------------- #\n#                                                            #\n#  This script extracts q-points and irreducible             #\n#  representations from Quantum ESPRESSO xml data.           #\n#                                                            #\n#  Expects control_ph.xml and patterns.?.xml files to exist  #\n#                                                            #\n# ---------------------------------------------------------- #\nfrom __future__ import print_function\n\nimport json\nfrom xml.dom import minidom\n\n\n\nCONTROL_PH_FILENAME = \"{{JOB_WORK_DIR}}/outdir/_ph0/__prefix__.phsave/control_ph.xml\"\nPATTERNS_FILENAME = \"{{JOB_WORK_DIR}}/outdir/_ph0/__prefix__.phsave/patterns.{}.xml\"\n\n\n# get integer content of an xml tag in a document\ndef get_int_by_tag_name(doc, tag_name):\n    element = doc.getElementsByTagName(tag_name)\n    return int(element[0].firstChild.nodeValue)\n\nvalues = []\n\n# get number of q-points and cycle through them\nxmldoc = minidom.parse(CONTROL_PH_FILENAME)\nnumber_of_qpoints = get_int_by_tag_name(xmldoc, \"NUMBER_OF_Q_POINTS\")\n\nfor i in range(number_of_qpoints):\n    # get number of irreducible representations per qpoint\n    xmldoc = minidom.parse(PATTERNS_FILENAME.format(i+1))\n    number_of_irr_per_qpoint = get_int_by_tag_name(xmldoc, \"NUMBER_IRR_REP\")\n    # add each distinct combination of qpoint and irr as a separate entry\n    for j in range(number_of_irr_per_qpoint):\n      values.append({\n          \"qpoint\": i + 1,\n          \"irr\": j + 1\n      })\n\n# store final values in standard output (STDOUT)\nprint(json.dumps(values, indent=4))\n","schemaVersion":"2022.8.16"}]},{"name":"assignment","type":"assignment","operand":"Q_POINTS","value":"json.loads(STDOUT)","input":[{"scope":"9b8a495e-1ac1-56a7-b2e0-af1b405a1219","name":"STDOUT"}],"status":"idle","statusTrack":[],"flowchartId":"d0fd8654-2106-546b-8792-7bb46272befc","tags":[],"head":false,"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}}]},{"_id":"545a66e2-dfbe-513e-acaf-d79d0d139b9c","name":"reduce","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["phonon_dos","phonon_dispersions"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"ph_grid_restart","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"cb206177-a4af-599a-81ba-6c88d24253b6","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"ph.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"ph_grid_restart.in"}],"results":[],"monitors":["standard_output"],"applicationName":"espresso","executableName":"ph.x","name":"ph_grid_restart","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUTPH\n    tr2_ph = 1.0d-18,\n    recover = .true.\n    ldisp = .true.\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    fildyn = 'dyn'\n    {% for d in qgrid.dimensions -%}\n    nq{{loop.index}} = {{d}}\n    {% endfor %}\n/\n","name":"ph_grid_restart.in","contextProviders":[{"name":"QGridFormDataManager"}],"applicationName":"espresso","executableName":"ph.x","rendered":"&INPUTPH\n    tr2_ph = 1.0d-18,\n    recover = .true.\n    ldisp = .true.\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    fildyn = 'dyn'\n    nq1 = 1\n    nq2 = 1\n    nq3 = 1\n    \n/\n","schemaVersion":"2022.8.16"}],"next":"3b4507a7-9244-540b-abe0-66bceab700f5"},{"type":"execution","name":"q2r","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"3b4507a7-9244-540b-abe0-66bceab700f5","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"q2r.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"q2r.in"}],"results":[],"monitors":["standard_output"],"applicationName":"espresso","executableName":"q2r.x","name":"q2r","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUT\n    fildyn = 'dyn'\n    zasr = 'simple'\n    flfrc = 'force_constants.fc'\n/\n","name":"q2r.in","contextProviders":[],"applicationName":"espresso","executableName":"q2r.x","rendered":"&INPUT\n    fildyn = 'dyn'\n    zasr = 'simple'\n    flfrc = 'force_constants.fc'\n/\n","schemaVersion":"2022.8.16"}],"next":"8fe6a24b-c994-55a2-a448-88657292e8c2"},{"type":"execution","name":"matdyn_grid","head":false,"results":[{"name":"phonon_dos"}],"monitors":[{"name":"standard_output"}],"flowchartId":"8fe6a24b-c994-55a2-a448-88657292e8c2","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"matdyn.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"matdyn_grid.in"}],"monitors":["standard_output"],"results":["phonon_dos"],"applicationName":"espresso","executableName":"matdyn.x","name":"matdyn_grid","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUT\n    asr = 'simple'\n    flfrc = 'force_constants.fc'\n    flfrq = 'frequencies.freq'\n    dos = .true.\n    fldos = 'phonon_dos.out'\n    deltaE = 1.d0\n    {% for d in igrid.dimensions -%}\n    nk{{loop.index}} = {{d}}\n    {% endfor %}\n /\n","name":"matdyn_grid.in","contextProviders":[{"name":"IGridFormDataManager"}],"applicationName":"espresso","executableName":"matdyn.x","rendered":"&INPUT\n    asr = 'simple'\n    flfrc = 'force_constants.fc'\n    flfrq = 'frequencies.freq'\n    dos = .true.\n    fldos = 'phonon_dos.out'\n    deltaE = 1.d0\n    nk1 = 3\n    nk2 = 3\n    nk3 = 3\n    \n /\n","schemaVersion":"2022.8.16"}],"next":"a7fded20-889b-54fc-bbb0-456e82689ab1"},{"type":"execution","name":"matdyn_path","head":false,"results":[{"name":"phonon_dispersions"}],"monitors":[{"name":"standard_output"}],"flowchartId":"a7fded20-889b-54fc-bbb0-456e82689ab1","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"matdyn.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"matdyn_path.in"}],"monitors":["standard_output"],"results":["phonon_dispersions"],"applicationName":"espresso","executableName":"matdyn.x","name":"matdyn_path","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUT\n    asr = 'simple'\n    flfrc ='force_constants.fc'\n    flfrq ='frequencies.freq'\n    flvec ='normal_modes.out'\n    q_in_band_form = .true.\n /\n{{ipath.length}}\n{% for point in ipath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"matdyn_path.in","contextProviders":[{"name":"IPathFormDataManager"}],"applicationName":"espresso","executableName":"matdyn.x","rendered":"&INPUT\n    asr = 'simple'\n    flfrc ='force_constants.fc'\n    flfrq ='frequencies.freq'\n    flvec ='normal_modes.out'\n    q_in_band_form = .true.\n /\n11\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Preliminary SCF Calculation","type":"subworkflow","_id":"79f2cb6a-7994-5369-8c85-af07c55ad26f","status":"idle","statusTrack":[],"flowchartId":"b6a2b27a-0fec-5e0e-8974-073ee9d2ad83","tags":[],"head":true,"next":"4bb74dfb-46a6-5bf4-a477-5d374dc2e271"},{"name":"ph-init-qpoints","type":"subworkflow","_id":"2f017bcb-f4ba-55b8-b939-1f780679a88e","status":"idle","statusTrack":[],"flowchartId":"4bb74dfb-46a6-5bf4-a477-5d374dc2e271","tags":[],"head":false,"next":"9894b91f-6e97-5ee6-af02-0bef26bd62c0"},{"name":"espresso-xml-get-qpt-irr","type":"subworkflow","_id":"e4b6b2e7-7d8f-5ae1-b6bd-ee81ecbca11a","status":"idle","statusTrack":[],"flowchartId":"9894b91f-6e97-5ee6-af02-0bef26bd62c0","tags":[],"head":false,"next":"24e3c1f0-8090-512e-9727-8770071d17c8"},{"name":"map","type":"map","workflowId":"731d3397-3278-516a-b28e-53626ef50f0a","input":{"target":"MAP_DATA","scope":"global","name":"Q_POINTS","values":[],"useValues":false},"status":"idle","statusTrack":[],"flowchartId":"24e3c1f0-8090-512e-9727-8770071d17c8","tags":[],"head":false,"next":"55a9e9fb-3545-5c4b-a1bb-b64a899b78c6"},{"name":"reduce","type":"subworkflow","_id":"545a66e2-dfbe-513e-acaf-d79d0d139b9c","status":"idle","statusTrack":[],"flowchartId":"55a9e9fb-3545-5c4b-a1bb-b64a899b78c6","tags":[],"head":false}],"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"23b9058b-884c-52d4-82a8-ee162b9761e0","workflows":[{"name":"pre-processor","subworkflows":[{"_id":"03f3a8a3-1fd0-5007-925f-fba78be63a51","name":"pre-processor","application":{"name":"shell","shortName":"sh","summary":"Shell Script","build":"GNU","version":"5.1.8","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"shell","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"99304304-e873-5c89-ae83-91e61a7f629c","preProcessors":[],"postProcessors":[],"application":{"name":"shell","shortName":"sh","summary":"Shell Script","build":"GNU","version":"5.1.8","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"sh","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"espresso_link_outdir_save.sh"}],"monitors":["standard_output"],"applicationName":"shell","executableName":"sh","name":"espresso_link_outdir_save","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% raw %}\n#!/bin/bash\n\nmkdir -p {{ JOB_SCRATCH_DIR }}/outdir/_ph0\ncd {{ JOB_SCRATCH_DIR }}/outdir\ncp -r {{ JOB_WORK_DIR }}/../outdir/__prefix__.* .\n{% endraw %}\n","name":"espresso_link_outdir_save.sh","contextProviders":[],"applicationName":"shell","executableName":"sh","rendered":"\n#!/bin/bash\n\nmkdir -p {{ JOB_SCRATCH_DIR }}/outdir/_ph0\ncd {{ JOB_SCRATCH_DIR }}/outdir\ncp -r {{ JOB_WORK_DIR }}/../outdir/__prefix__.* .\n\n","schemaVersion":"2022.8.16"}]}]},{"_id":"e68db280-8636-53e3-81a0-88396ba6147d","name":"ph-single-irr-qpt","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"ph_single_irr_qpt","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"8db9af08-d935-57a0-a824-e7db6d936de8","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"ph.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"ph_single_irr_qpt.in"}],"results":[],"monitors":["standard_output"],"applicationName":"espresso","executableName":"ph.x","name":"ph_single_irr_qpt","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUTPH\n    tr2_ph = 1.0d-18\n    ldisp = .true.\n    {% raw %}\n    start_q = {{MAP_DATA.qpoint}}\n    last_q = {{MAP_DATA.qpoint}}\n    start_irr = {{MAP_DATA.irr}}\n    last_irr= {{MAP_DATA.irr}}\n    {% endraw %}\n    recover = .true.\n    fildyn = 'dyn'\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_SCRATCH_DIR }}/outdir'{% endraw %}\n    {% for d in qgrid.dimensions -%}\n    nq{{loop.index}} = {{d}}\n    {% endfor %}\n/\n","name":"ph_single_irr_qpt.in","contextProviders":[{"name":"QGridFormDataManager"}],"applicationName":"espresso","executableName":"ph.x","rendered":"&INPUTPH\n    tr2_ph = 1.0d-18\n    ldisp = .true.\n    \n    start_q = {{MAP_DATA.qpoint}}\n    last_q = {{MAP_DATA.qpoint}}\n    start_irr = {{MAP_DATA.irr}}\n    last_irr= {{MAP_DATA.irr}}\n    \n    recover = .true.\n    fildyn = 'dyn'\n    prefix = '__prefix__'\n    outdir = '{{ JOB_SCRATCH_DIR }}/outdir'\n    nq1 = 1\n    nq2 = 1\n    nq3 = 1\n    \n/\n","schemaVersion":"2022.8.16"}]}]},{"_id":"7239fc3a-b343-513f-af35-e8687e1829da","name":"post-processor","application":{"name":"shell","shortName":"sh","summary":"Shell Script","build":"GNU","version":"5.1.8","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"shell","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"99304304-e873-5c89-ae83-91e61a7f629c","preProcessors":[],"postProcessors":[],"application":{"name":"shell","shortName":"sh","summary":"Shell Script","build":"GNU","version":"5.1.8","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"sh","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"espresso_collect_dynmat.sh"}],"monitors":["standard_output"],"applicationName":"shell","executableName":"sh","name":"espresso_collect_dynmat","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% raw %}\n#!/bin/bash\n\ncp {{ JOB_SCRATCH_DIR }}/outdir/_ph0/__prefix__.phsave/dynmat* {{ JOB_WORK_DIR }}/../outdir/_ph0/__prefix__.phsave\n{% endraw %}\n","name":"espresso_collect_dynmat.sh","contextProviders":[],"applicationName":"shell","executableName":"sh","rendered":"\n#!/bin/bash\n\ncp {{ JOB_SCRATCH_DIR }}/outdir/_ph0/__prefix__.phsave/dynmat* {{ JOB_WORK_DIR }}/../outdir/_ph0/__prefix__.phsave\n\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"pre-processor","type":"subworkflow","_id":"03f3a8a3-1fd0-5007-925f-fba78be63a51","status":"idle","statusTrack":[],"flowchartId":"e9a790f4-dec6-52c1-b951-014f0ff01cb4","tags":[],"head":true,"next":"c2195045-7a5c-54d3-ab88-211c82de09f1"},{"name":"ph-single-irr-qpt","type":"subworkflow","_id":"e68db280-8636-53e3-81a0-88396ba6147d","status":"idle","statusTrack":[],"flowchartId":"c2195045-7a5c-54d3-ab88-211c82de09f1","tags":[],"head":false,"next":"e483c7fb-2a29-5e91-819a-7465ead70134"},{"name":"post-processor","type":"subworkflow","_id":"7239fc3a-b343-513f-af35-e8687e1829da","status":"idle","statusTrack":[],"flowchartId":"e483c7fb-2a29-5e91-819a-7465ead70134","tags":[],"head":false}],"properties":[],"_id":"731d3397-3278-516a-b28e-53626ef50f0a","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"compute":{"ppn":1,"nodes":1,"queue":"D","timeLimit":"01:00:00","notify":"n","cluster":{"fqdn":""}}}],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/recalculate_bands.json":{"name":"Recalculate Bands","subworkflows":[{"_id":"64551dfb-e529-5d8d-9092-ff268f4da134","name":"Recalculate Bands","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["band_structure"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_bands","head":true,"results":[{"name":"band_structure"}],"monitors":[{"name":"standard_output"}],"flowchartId":"d618df45-5af3-5da5-8882-d74a27e00b04","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_bands.in"}],"results":["band_structure"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pw.x","name":"pw_bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{input.RESTART_MODE}}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS crystal_b\n{{kpath.length}}\n{% for point in kpath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"pw_bands.in","contextProviders":[{"name":"KPathFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS crystal_b\n11\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"}],"next":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2"},{"type":"execution","name":"bands","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"bands.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"bands.in"}],"monitors":["standard_output"],"applicationName":"espresso","executableName":"bands.x","name":"bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&BANDS\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    filband = {% raw %}'{{ JOB_WORK_DIR }}/bands.dat'{% endraw %}\n    no_overlap = .true.\n/\n","name":"bands.in","contextProviders":[],"applicationName":"espresso","executableName":"bands.x","rendered":"&BANDS\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    filband = '{{ JOB_WORK_DIR }}/bands.dat'\n    no_overlap = .true.\n/\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Recalculate Bands","type":"subworkflow","_id":"64551dfb-e529-5d8d-9092-ff268f4da134","status":"idle","statusTrack":[],"flowchartId":"e8b72a45-765e-565f-ab17-c91a21aec09d","tags":[],"head":true}],"properties":["band_structure"],"_id":"42b2b964-8ccc-5b36-9e33-41a954abc2ba","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/surface_energy.json":{"name":"Surface Energy","subworkflows":[{"_id":"3e05a2b5-4171-54a2-9d2d-9e46118a56bf","name":"Surface Energy","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"name":"io-slab","type":"io","subtype":"input","head":true,"results":[],"monitors":[],"flowchartId":"e463ef46-a36e-5168-87dd-e21eb980dfb8","preProcessors":[],"postProcessors":[],"source":"api","input":[{"endpoint":"materials","endpoint_options":{"params":{"query":"{'_id': MATERIAL_ID}","projection":"{}"}},"name":"DATA"}],"next":"ee7abb4e-7848-5aeb-960d-0d441909e2d1","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"slab","type":"assignment","operand":"SLAB","value":"DATA[0]","input":[{"name":"DATA","scope":"e463ef46-a36e-5168-87dd-e21eb980dfb8"}],"head":false,"results":[],"monitors":[],"flowchartId":"ee7abb4e-7848-5aeb-960d-0d441909e2d1","preProcessors":[],"postProcessors":[],"next":"44263820-0c80-5bd1-b854-9da8d198eac1","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"io-bulk","type":"io","subtype":"input","head":false,"results":[],"monitors":[],"flowchartId":"44263820-0c80-5bd1-b854-9da8d198eac1","preProcessors":[],"postProcessors":[],"source":"api","input":[{"endpoint":"materials","endpoint_options":{"params":{"query":"{'_id': SLAB.metadata.bulkId}","projection":"{}"}},"name":"DATA"}],"next":"b70656f1-a394-57f4-b4de-00096969df4b","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"bulk","type":"assignment","operand":"BULK","value":"DATA[0] if DATA else None","input":[{"name":"DATA","scope":"44263820-0c80-5bd1-b854-9da8d198eac1"}],"head":false,"results":[],"monitors":[],"flowchartId":"b70656f1-a394-57f4-b4de-00096969df4b","preProcessors":[],"postProcessors":[],"next":"6ca4006a-e3ae-56ea-91a1-06b9790b5f7e","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"assert-bulk","type":"assertion","statement":"BULK != None","errorMessage":"Bulk material does not exist!","head":false,"results":[],"monitors":[],"flowchartId":"6ca4006a-e3ae-56ea-91a1-06b9790b5f7e","preProcessors":[],"postProcessors":[],"next":"490635e0-c593-5809-9eb2-c794b96cfed1","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"io-e-bulk","type":"io","subtype":"input","head":false,"results":[],"monitors":[],"flowchartId":"490635e0-c593-5809-9eb2-c794b96cfed1","preProcessors":[],"postProcessors":[],"source":"api","input":[{"endpoint":"refined-properties","endpoint_options":{"params":{"query":"{ 'exabyteId': BULK.exabyteId, 'data.name': 'total_energy', 'group': {'$regex': ''.join((SUBWORKFLOW.application.shortName, ':'))} }","projection":"{'sort': {'precision.value': -1}, 'limit': 1}"}},"name":"DATA"}],"next":"bbe13b97-4243-5a85-8f61-a279d0b797aa","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"e-bulk","type":"assignment","operand":"E_BULK","value":"DATA[0].data.value if DATA else None","input":[{"name":"DATA","scope":"490635e0-c593-5809-9eb2-c794b96cfed1"}],"head":false,"results":[],"monitors":[],"flowchartId":"bbe13b97-4243-5a85-8f61-a279d0b797aa","preProcessors":[],"postProcessors":[],"next":"a06c9f43-7670-5fd0-ac42-7028a472235a","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"assert-e-bulk","type":"assertion","statement":"E_BULK != None","errorMessage":"E_BULK does not exist!","head":false,"results":[],"monitors":[],"flowchartId":"a06c9f43-7670-5fd0-ac42-7028a472235a","preProcessors":[],"postProcessors":[],"next":"cdf210be-26ed-585a-b4ac-d55795ba2975","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"surface","type":"assignment","operand":"A","value":"np.linalg.norm(np.cross(SLAB.lattice.vectors.a, SLAB.lattice.vectors.b))","input":[],"head":false,"results":[],"monitors":[],"flowchartId":"cdf210be-26ed-585a-b4ac-d55795ba2975","preProcessors":[],"postProcessors":[],"next":"ffa8e43d-096a-555b-b8d0-6d283365ef47","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"n-bulk","type":"assignment","operand":"N_BULK","value":"len(BULK.basis.elements)","input":[],"head":false,"results":[],"monitors":[],"flowchartId":"ffa8e43d-096a-555b-b8d0-6d283365ef47","preProcessors":[],"postProcessors":[],"next":"a0336ec5-a6da-5e4c-bb48-82b70cf5245f","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"n-slab","type":"assignment","operand":"N_SLAB","value":"len(SLAB.basis.elements)","input":[],"head":false,"results":[],"monitors":[],"flowchartId":"a0336ec5-a6da-5e4c-bb48-82b70cf5245f","preProcessors":[],"postProcessors":[],"next":"9fc7a088-5533-5f70-bb33-f676ec65f565","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"type":"execution","name":"pw_scf","head":false,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"fcd88119-817c-5ac1-a430-ba892ac743eb"},{"name":"e-slab","type":"assignment","operand":"E_SLAB","value":"total_energy","input":[{"name":"total_energy","scope":"9fc7a088-5533-5f70-bb33-f676ec65f565"}],"head":false,"results":[],"monitors":[],"flowchartId":"fcd88119-817c-5ac1-a430-ba892ac743eb","preProcessors":[],"postProcessors":[],"next":"542ea9ad-8a07-5a76-b233-f72fb27c4fc6","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"surface-energy","type":"assignment","operand":"SURFACE_ENERGY","value":"1 / (2 * A) * (E_SLAB - E_BULK * (N_SLAB/N_BULK))","input":[],"head":false,"results":[{"name":"surface_energy"}],"monitors":[],"flowchartId":"542ea9ad-8a07-5a76-b233-f72fb27c4fc6","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]}]}],"units":[{"name":"Surface Energy","type":"subworkflow","_id":"3e05a2b5-4171-54a2-9d2d-9e46118a56bf","status":"idle","statusTrack":[],"flowchartId":"d81dc9ce-bb50-5bc6-af1d-e5ede03bb0a6","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","surface_energy","total_energy","total_energy_contributions","total_force"],"_id":"68512987-de73-5614-bab2-0f8b575cffa3","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/total_energy.json":{"name":"Total Energy","subworkflows":[{"_id":"a16677f9-bb5b-54b5-9f97-c2af8c073184","name":"Total Energy","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Total Energy","type":"subworkflow","_id":"a16677f9-bb5b-54b5-9f97-c2af8c073184","status":"idle","statusTrack":[],"flowchartId":"6059d61a-6a92-5657-9130-02208639aff8","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"4e36ca25-fa46-5628-a227-27d22dea8553","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"tags":["default"],"application":{"name":"espresso"}},"espresso/valence_band_offset.json":{"name":"Valence Band Offset (2D)","subworkflows":[{"isMultiMaterial":true,"_id":"9c65d03e-6a30-58f3-947a-f174342be0c3","name":"BS + Avg ESP (Interface)","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","band_gaps","average_potential_profile"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"name":"Set Material Index (Interface)","type":"assignment","operand":"MATERIAL_INDEX","value":"0","input":[],"status":"idle","statusTrack":[],"flowchartId":"0f21d8c4-ab32-53ba-b40d-fc9b6608e1b9","tags":[],"head":true,"next":"9fc7a088-5533-5f70-bb33-f676ec65f565","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"type":"execution","name":"pw_scf","head":false,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"pw-bands-calculate-band-gap"},{"type":"execution","name":"pw_bands","head":false,"results":[{"name":"band_gaps"}],"monitors":[{"name":"standard_output"}],"flowchartId":"pw-bands-calculate-band-gap","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_bands.in"}],"results":["band_structure"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pw.x","name":"pw_bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{input.RESTART_MODE}}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS crystal_b\n{{kpath.length}}\n{% for point in kpath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"pw_bands.in","contextProviders":[{"name":"KPathFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS crystal_b\n11\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"}],"next":"a667d9fd-35d5-5897-be0e-fa0247233649"},{"name":"Select indirect band gap","type":"assignment","operand":"BAND_GAP_INDIRECT","value":"[bandgap for bandgap in band_gaps['values'] if bandgap['type'] == 'indirect'][0]","input":[{"name":"band_gaps","scope":"pw-bands-calculate-band-gap"}],"status":"idle","statusTrack":[],"flowchartId":"a667d9fd-35d5-5897-be0e-fa0247233649","tags":[],"head":false,"next":"08819369-b541-5b51-8a40-0ee135039482","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"name":"Set Valence Band Maximum","type":"assignment","operand":"VBM","value":"BAND_GAP_INDIRECT['eigenvalueValence']","input":[],"status":"idle","statusTrack":[],"flowchartId":"08819369-b541-5b51-8a40-0ee135039482","tags":[],"head":false,"next":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"type":"execution","name":"bands","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"bands.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"bands.in"}],"monitors":["standard_output"],"applicationName":"espresso","executableName":"bands.x","name":"bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&BANDS\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    filband = {% raw %}'{{ JOB_WORK_DIR }}/bands.dat'{% endraw %}\n    no_overlap = .true.\n/\n","name":"bands.in","contextProviders":[],"applicationName":"espresso","executableName":"bands.x","rendered":"&BANDS\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    filband = '{{ JOB_WORK_DIR }}/bands.dat'\n    no_overlap = .true.\n/\n","schemaVersion":"2022.8.16"}],"next":"9ed927b1-3d84-5730-a6a8-1b1cfba39bde"},{"type":"execution","name":"Electrostatic Potential (ESP)","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"9ed927b1-3d84-5730-a6a8-1b1cfba39bde","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"pp.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"pp_electrostatic_potential.in"}],"results":[],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pp.x","name":"pp_electrostatic_potential","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUTPP\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    filplot = 'pp.dat'\n    plot_num = 11\n/\n","name":"pp_electrostatic_potential.in","contextProviders":[],"applicationName":"espresso","executableName":"pp.x","rendered":"&INPUTPP\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    filplot = 'pp.dat'\n    plot_num = 11\n/\n","schemaVersion":"2022.8.16"}],"next":"average-electrostatic-potential"},{"type":"execution","name":"average ESP","head":false,"results":[{"name":"average_potential_profile"}],"monitors":[{"name":"standard_output"}],"flowchartId":"average-electrostatic-potential","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"average.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"average.in"}],"results":["average_potential_profile"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"average.x","name":"average_potential","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"1\npp.dat\n1.0\n3000\n3\n3.0000\n","name":"average.in","contextProviders":[],"applicationName":"espresso","executableName":"average.x","rendered":"1\npp.dat\n1.0\n3000\n3\n3.0000\n","schemaVersion":"2022.8.16"}],"next":"c6c11873-91d7-5422-8302-3dcc1ce971e9"},{"name":"Set Macroscopically Averaged ESP Data","type":"assignment","operand":"array_from_context","value":"average_potential_profile['yDataSeries'][1]","input":[{"name":"average_potential_profile","scope":"average-electrostatic-potential"}],"status":"idle","statusTrack":[],"flowchartId":"c6c11873-91d7-5422-8302-3dcc1ce971e9","tags":[],"head":false,"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}}]},{"_id":"ce26adc1-6a26-53ef-9626-5eb6a6b9ccb7","name":"Find ESP Values (Interface)","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"Find Extrema","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"python-find-extrema","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"find_extrema.py","templateName":"find_extrema.py"},{"name":"requirements.txt","templateName":"processing_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"generic:processing:find_extrema:scipy","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------- #\n# This script aims to determine extrema for a given array.    #\n# Please adjust the parameters according to your data.        #\n# Note: This template expects the array to be defined in the  #\n# context as 'array_from_context' (see details below).        #\n# ----------------------------------------------------------- #\nimport json\n\nimport numpy as np\nfrom munch import Munch\nfrom scipy.signal import find_peaks\n\n# Data From Context\n# -----------------\n# The array 'array_from_context' is a 1D list (float or int) that has to be defined in\n# a preceding assignment unit in order to be extracted from the context.\n# Example: [0.0, 1.0, 4.0, 3.0]\n# Upon rendering the following Jinja template the extracted array will be inserted.\n{% raw %}Y = np.array({{array_from_context}}){% endraw %}\n\n# Settings\n# --------\nprominence = 0.3  # required prominence in the unit of the data array\n\n# Find Extrema\n# ------------\nmax_indices, _ = find_peaks(Y, prominence=prominence)\nmin_indices, _ = find_peaks(-1 * Y, prominence=prominence)\n\nresult = {\n    \"maxima\": Y[max_indices].tolist(),\n    \"minima\": Y[min_indices].tolist(),\n}\n\n# print final values to standard output (STDOUT),\n# so that they can be read by a subsequent assignment unit (using value=STDOUT)\nprint(json.dumps(result, indent=4))\n","name":"find_extrema.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------- #\n# This script aims to determine extrema for a given array.    #\n# Please adjust the parameters according to your data.        #\n# Note: This template expects the array to be defined in the  #\n# context as 'array_from_context' (see details below).        #\n# ----------------------------------------------------------- #\nimport json\n\nimport numpy as np\nfrom munch import Munch\nfrom scipy.signal import find_peaks\n\n# Data From Context\n# -----------------\n# The array 'array_from_context' is a 1D list (float or int) that has to be defined in\n# a preceding assignment unit in order to be extracted from the context.\n# Example: [0.0, 1.0, 4.0, 3.0]\n# Upon rendering the following Jinja template the extracted array will be inserted.\nY = np.array({{array_from_context}})\n\n# Settings\n# --------\nprominence = 0.3  # required prominence in the unit of the data array\n\n# Find Extrema\n# ------------\nmax_indices, _ = find_peaks(Y, prominence=prominence)\nmin_indices, _ = find_peaks(-1 * Y, prominence=prominence)\n\nresult = {\n    \"maxima\": Y[max_indices].tolist(),\n    \"minima\": Y[min_indices].tolist(),\n}\n\n# print final values to standard output (STDOUT),\n# so that they can be read by a subsequent assignment unit (using value=STDOUT)\nprint(json.dumps(result, indent=4))\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\n\nmunch==2.5.0\nnumpy>=1.19.5\nscipy>=1.5.4\nmatplotlib>=3.0.0\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\n\nmunch==2.5.0\nnumpy>=1.19.5\nscipy>=1.5.4\nmatplotlib>=3.0.0\n","schemaVersion":"2022.8.16"}],"next":"8fce780b-5555-5b73-b3d1-1bb24a4c759d"},{"name":"Set Average ESP Value","type":"assignment","operand":"AVG_ESP_INTERFACE","value":"json.loads(STDOUT)['minima']","input":[{"name":"STDOUT","scope":"python-find-extrema"}],"status":"idle","statusTrack":[],"flowchartId":"8fce780b-5555-5b73-b3d1-1bb24a4c759d","tags":[],"head":false,"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}}]},{"isMultiMaterial":true,"_id":"ba46d9b4-610f-537e-ae39-e39ce5240cda","name":"BS + Avg ESP (interface left)","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","band_gaps","average_potential_profile"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"name":"Set Material Index (Interface left)","type":"assignment","operand":"MATERIAL_INDEX","value":"1","input":[],"status":"idle","statusTrack":[],"flowchartId":"0bd31760-f6e4-5826-b282-882c06c97f94","tags":[],"head":true,"next":"9fc7a088-5533-5f70-bb33-f676ec65f565","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"type":"execution","name":"pw_scf","head":false,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"pw-bands-calculate-band-gap-left"},{"type":"execution","name":"pw_bands","head":false,"results":[{"name":"band_gaps"}],"monitors":[{"name":"standard_output"}],"flowchartId":"pw-bands-calculate-band-gap-left","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_bands.in"}],"results":["band_structure"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pw.x","name":"pw_bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{input.RESTART_MODE}}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS crystal_b\n{{kpath.length}}\n{% for point in kpath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"pw_bands.in","contextProviders":[{"name":"KPathFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS crystal_b\n11\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"}],"next":"a667d9fd-35d5-5897-be0e-fa0247233649"},{"name":"Select indirect band gap","type":"assignment","operand":"BAND_GAP_INDIRECT","value":"[bandgap for bandgap in band_gaps['values'] if bandgap['type'] == 'indirect'][0]","input":[{"name":"band_gaps","scope":"pw-bands-calculate-band-gap-left"}],"status":"idle","statusTrack":[],"flowchartId":"a667d9fd-35d5-5897-be0e-fa0247233649","tags":[],"head":false,"next":"08819369-b541-5b51-8a40-0ee135039482","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"name":"Set Valence Band Maximum","type":"assignment","operand":"VBM_LEFT","value":"BAND_GAP_INDIRECT['eigenvalueValence']","input":[],"status":"idle","statusTrack":[],"flowchartId":"08819369-b541-5b51-8a40-0ee135039482","tags":[],"head":false,"next":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"type":"execution","name":"bands","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"bands.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"bands.in"}],"monitors":["standard_output"],"applicationName":"espresso","executableName":"bands.x","name":"bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&BANDS\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    filband = {% raw %}'{{ JOB_WORK_DIR }}/bands.dat'{% endraw %}\n    no_overlap = .true.\n/\n","name":"bands.in","contextProviders":[],"applicationName":"espresso","executableName":"bands.x","rendered":"&BANDS\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    filband = '{{ JOB_WORK_DIR }}/bands.dat'\n    no_overlap = .true.\n/\n","schemaVersion":"2022.8.16"}],"next":"9ed927b1-3d84-5730-a6a8-1b1cfba39bde"},{"type":"execution","name":"Electrostatic Potential (ESP)","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"9ed927b1-3d84-5730-a6a8-1b1cfba39bde","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"pp.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"pp_electrostatic_potential.in"}],"results":[],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pp.x","name":"pp_electrostatic_potential","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUTPP\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    filplot = 'pp.dat'\n    plot_num = 11\n/\n","name":"pp_electrostatic_potential.in","contextProviders":[],"applicationName":"espresso","executableName":"pp.x","rendered":"&INPUTPP\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    filplot = 'pp.dat'\n    plot_num = 11\n/\n","schemaVersion":"2022.8.16"}],"next":"average-electrostatic-potential-left"},{"type":"execution","name":"average ESP","head":false,"results":[{"name":"average_potential_profile"}],"monitors":[{"name":"standard_output"}],"flowchartId":"average-electrostatic-potential-left","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"average.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"average.in"}],"results":["average_potential_profile"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"average.x","name":"average_potential","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"1\npp.dat\n1.0\n3000\n3\n3.0000\n","name":"average.in","contextProviders":[],"applicationName":"espresso","executableName":"average.x","rendered":"1\npp.dat\n1.0\n3000\n3\n3.0000\n","schemaVersion":"2022.8.16"}],"next":"c6c11873-91d7-5422-8302-3dcc1ce971e9"},{"name":"Set Macroscopically Averaged ESP Data","type":"assignment","operand":"array_from_context","value":"average_potential_profile['yDataSeries'][1]","input":[{"name":"average_potential_profile","scope":"average-electrostatic-potential-left"}],"status":"idle","statusTrack":[],"flowchartId":"c6c11873-91d7-5422-8302-3dcc1ce971e9","tags":[],"head":false,"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}}]},{"_id":"6c303926-905c-5749-81d5-2d2964fdf09a","name":"Find ESP Value (Interface left)","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"Find Extrema","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"python-find-extrema-left","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"find_extrema.py","templateName":"find_extrema.py"},{"name":"requirements.txt","templateName":"processing_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"generic:processing:find_extrema:scipy","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------- #\n# This script aims to determine extrema for a given array.    #\n# Please adjust the parameters according to your data.        #\n# Note: This template expects the array to be defined in the  #\n# context as 'array_from_context' (see details below).        #\n# ----------------------------------------------------------- #\nimport json\n\nimport numpy as np\nfrom munch import Munch\nfrom scipy.signal import find_peaks\n\n# Data From Context\n# -----------------\n# The array 'array_from_context' is a 1D list (float or int) that has to be defined in\n# a preceding assignment unit in order to be extracted from the context.\n# Example: [0.0, 1.0, 4.0, 3.0]\n# Upon rendering the following Jinja template the extracted array will be inserted.\n{% raw %}Y = np.array({{array_from_context}}){% endraw %}\n\n# Settings\n# --------\nprominence = 0.3  # required prominence in the unit of the data array\n\n# Find Extrema\n# ------------\nmax_indices, _ = find_peaks(Y, prominence=prominence)\nmin_indices, _ = find_peaks(-1 * Y, prominence=prominence)\n\nresult = {\n    \"maxima\": Y[max_indices].tolist(),\n    \"minima\": Y[min_indices].tolist(),\n}\n\n# print final values to standard output (STDOUT),\n# so that they can be read by a subsequent assignment unit (using value=STDOUT)\nprint(json.dumps(result, indent=4))\n","name":"find_extrema.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------- #\n# This script aims to determine extrema for a given array.    #\n# Please adjust the parameters according to your data.        #\n# Note: This template expects the array to be defined in the  #\n# context as 'array_from_context' (see details below).        #\n# ----------------------------------------------------------- #\nimport json\n\nimport numpy as np\nfrom munch import Munch\nfrom scipy.signal import find_peaks\n\n# Data From Context\n# -----------------\n# The array 'array_from_context' is a 1D list (float or int) that has to be defined in\n# a preceding assignment unit in order to be extracted from the context.\n# Example: [0.0, 1.0, 4.0, 3.0]\n# Upon rendering the following Jinja template the extracted array will be inserted.\nY = np.array({{array_from_context}})\n\n# Settings\n# --------\nprominence = 0.3  # required prominence in the unit of the data array\n\n# Find Extrema\n# ------------\nmax_indices, _ = find_peaks(Y, prominence=prominence)\nmin_indices, _ = find_peaks(-1 * Y, prominence=prominence)\n\nresult = {\n    \"maxima\": Y[max_indices].tolist(),\n    \"minima\": Y[min_indices].tolist(),\n}\n\n# print final values to standard output (STDOUT),\n# so that they can be read by a subsequent assignment unit (using value=STDOUT)\nprint(json.dumps(result, indent=4))\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\n\nmunch==2.5.0\nnumpy>=1.19.5\nscipy>=1.5.4\nmatplotlib>=3.0.0\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\n\nmunch==2.5.0\nnumpy>=1.19.5\nscipy>=1.5.4\nmatplotlib>=3.0.0\n","schemaVersion":"2022.8.16"}],"next":"8fce780b-5555-5b73-b3d1-1bb24a4c759d"},{"name":"Set Average ESP Value","type":"assignment","operand":"AVG_ESP_LEFT","value":"json.loads(STDOUT)['minima']","input":[{"name":"STDOUT","scope":"python-find-extrema-left"}],"status":"idle","statusTrack":[],"flowchartId":"8fce780b-5555-5b73-b3d1-1bb24a4c759d","tags":[],"head":false,"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}}]},{"isMultiMaterial":true,"_id":"aa611fe8-1e6a-5e5c-976a-f64bfaaaace9","name":"BS + Avg ESP (interface right)","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","band_gaps","average_potential_profile"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"name":"Set Material Index (Interface right)","type":"assignment","operand":"MATERIAL_INDEX","value":"2","input":[],"status":"idle","statusTrack":[],"flowchartId":"a05809d1-cc0d-5a0b-bf5e-d43b90a6ac4b","tags":[],"head":true,"next":"9fc7a088-5533-5f70-bb33-f676ec65f565","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"type":"execution","name":"pw_scf","head":false,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"pw-bands-calculate-band-gap-right"},{"type":"execution","name":"pw_bands","head":false,"results":[{"name":"band_gaps"}],"monitors":[{"name":"standard_output"}],"flowchartId":"pw-bands-calculate-band-gap-right","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_bands.in"}],"results":["band_structure"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pw.x","name":"pw_bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{input.RESTART_MODE}}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS crystal_b\n{{kpath.length}}\n{% for point in kpath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"pw_bands.in","contextProviders":[{"name":"KPathFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'bands'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS crystal_b\n11\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"}],"next":"a667d9fd-35d5-5897-be0e-fa0247233649"},{"name":"Select indirect band gap","type":"assignment","operand":"BAND_GAP_INDIRECT","value":"[bandgap for bandgap in band_gaps['values'] if bandgap['type'] == 'indirect'][0]","input":[{"name":"band_gaps","scope":"pw-bands-calculate-band-gap-right"}],"status":"idle","statusTrack":[],"flowchartId":"a667d9fd-35d5-5897-be0e-fa0247233649","tags":[],"head":false,"next":"08819369-b541-5b51-8a40-0ee135039482","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"name":"Set Valence Band Maximum","type":"assignment","operand":"VBM_RIGHT","value":"BAND_GAP_INDIRECT['eigenvalueValence']","input":[],"status":"idle","statusTrack":[],"flowchartId":"08819369-b541-5b51-8a40-0ee135039482","tags":[],"head":false,"next":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}},{"type":"execution","name":"bands","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"771fbb40-ea80-5ba4-ae3f-6cd9a56c26e2","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"bands.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"bands.in"}],"monitors":["standard_output"],"applicationName":"espresso","executableName":"bands.x","name":"bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&BANDS\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    filband = {% raw %}'{{ JOB_WORK_DIR }}/bands.dat'{% endraw %}\n    no_overlap = .true.\n/\n","name":"bands.in","contextProviders":[],"applicationName":"espresso","executableName":"bands.x","rendered":"&BANDS\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    filband = '{{ JOB_WORK_DIR }}/bands.dat'\n    no_overlap = .true.\n/\n","schemaVersion":"2022.8.16"}],"next":"9ed927b1-3d84-5730-a6a8-1b1cfba39bde"},{"type":"execution","name":"Electrostatic Potential (ESP)","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"9ed927b1-3d84-5730-a6a8-1b1cfba39bde","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"pp.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"pp_electrostatic_potential.in"}],"results":[],"monitors":["standard_output"],"applicationName":"espresso","executableName":"pp.x","name":"pp_electrostatic_potential","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUTPP\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    filplot = 'pp.dat'\n    plot_num = 11\n/\n","name":"pp_electrostatic_potential.in","contextProviders":[],"applicationName":"espresso","executableName":"pp.x","rendered":"&INPUTPP\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    filplot = 'pp.dat'\n    plot_num = 11\n/\n","schemaVersion":"2022.8.16"}],"next":"average-electrostatic-potential-right"},{"type":"execution","name":"average ESP","head":false,"results":[{"name":"average_potential_profile"}],"monitors":[{"name":"standard_output"}],"flowchartId":"average-electrostatic-potential-right","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"average.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"average.in"}],"results":["average_potential_profile"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"average.x","name":"average_potential","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"1\npp.dat\n1.0\n3000\n3\n3.0000\n","name":"average.in","contextProviders":[],"applicationName":"espresso","executableName":"average.x","rendered":"1\npp.dat\n1.0\n3000\n3\n3.0000\n","schemaVersion":"2022.8.16"}],"next":"c6c11873-91d7-5422-8302-3dcc1ce971e9"},{"name":"Set Macroscopically Averaged ESP Data","type":"assignment","operand":"array_from_context","value":"average_potential_profile['yDataSeries'][1]","input":[{"name":"average_potential_profile","scope":"average-electrostatic-potential-right"}],"status":"idle","statusTrack":[],"flowchartId":"c6c11873-91d7-5422-8302-3dcc1ce971e9","tags":[],"head":false,"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"}}]},{"_id":"736295e8-2ee0-5974-83bc-362061ac0688","name":"Find ESP Value (Interface right)","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"Find Extrema","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"python-find-extrema-right","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"find_extrema.py","templateName":"find_extrema.py"},{"name":"requirements.txt","templateName":"processing_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"generic:processing:find_extrema:scipy","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------- #\n# This script aims to determine extrema for a given array.    #\n# Please adjust the parameters according to your data.        #\n# Note: This template expects the array to be defined in the  #\n# context as 'array_from_context' (see details below).        #\n# ----------------------------------------------------------- #\nimport json\n\nimport numpy as np\nfrom munch import Munch\nfrom scipy.signal import find_peaks\n\n# Data From Context\n# -----------------\n# The array 'array_from_context' is a 1D list (float or int) that has to be defined in\n# a preceding assignment unit in order to be extracted from the context.\n# Example: [0.0, 1.0, 4.0, 3.0]\n# Upon rendering the following Jinja template the extracted array will be inserted.\n{% raw %}Y = np.array({{array_from_context}}){% endraw %}\n\n# Settings\n# --------\nprominence = 0.3  # required prominence in the unit of the data array\n\n# Find Extrema\n# ------------\nmax_indices, _ = find_peaks(Y, prominence=prominence)\nmin_indices, _ = find_peaks(-1 * Y, prominence=prominence)\n\nresult = {\n    \"maxima\": Y[max_indices].tolist(),\n    \"minima\": Y[min_indices].tolist(),\n}\n\n# print final values to standard output (STDOUT),\n# so that they can be read by a subsequent assignment unit (using value=STDOUT)\nprint(json.dumps(result, indent=4))\n","name":"find_extrema.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------- #\n# This script aims to determine extrema for a given array.    #\n# Please adjust the parameters according to your data.        #\n# Note: This template expects the array to be defined in the  #\n# context as 'array_from_context' (see details below).        #\n# ----------------------------------------------------------- #\nimport json\n\nimport numpy as np\nfrom munch import Munch\nfrom scipy.signal import find_peaks\n\n# Data From Context\n# -----------------\n# The array 'array_from_context' is a 1D list (float or int) that has to be defined in\n# a preceding assignment unit in order to be extracted from the context.\n# Example: [0.0, 1.0, 4.0, 3.0]\n# Upon rendering the following Jinja template the extracted array will be inserted.\nY = np.array({{array_from_context}})\n\n# Settings\n# --------\nprominence = 0.3  # required prominence in the unit of the data array\n\n# Find Extrema\n# ------------\nmax_indices, _ = find_peaks(Y, prominence=prominence)\nmin_indices, _ = find_peaks(-1 * Y, prominence=prominence)\n\nresult = {\n    \"maxima\": Y[max_indices].tolist(),\n    \"minima\": Y[min_indices].tolist(),\n}\n\n# print final values to standard output (STDOUT),\n# so that they can be read by a subsequent assignment unit (using value=STDOUT)\nprint(json.dumps(result, indent=4))\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\n\nmunch==2.5.0\nnumpy>=1.19.5\nscipy>=1.5.4\nmatplotlib>=3.0.0\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\n\nmunch==2.5.0\nnumpy>=1.19.5\nscipy>=1.5.4\nmatplotlib>=3.0.0\n","schemaVersion":"2022.8.16"}],"next":"8fce780b-5555-5b73-b3d1-1bb24a4c759d"},{"name":"Set Average ESP Value","type":"assignment","operand":"AVG_ESP_RIGHT","value":"json.loads(STDOUT)['minima']","input":[{"name":"STDOUT","scope":"python-find-extrema-right"}],"status":"idle","statusTrack":[],"flowchartId":"8fce780b-5555-5b73-b3d1-1bb24a4c759d","tags":[],"head":false,"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}}]},{"_id":"1b70e606-a7ee-599e-89e0-91a7dc5faa4a","name":"Calculate VBO","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["valence_band_offset"],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"name":"Difference of valence band maxima","type":"assignment","operand":"VBM_DIFF","value":"VBM_LEFT - VBM_RIGHT","input":[],"status":"idle","statusTrack":[],"flowchartId":"bd4eaa98-b001-5694-87ef-ec77540502ab","tags":[],"head":true,"next":"2626f7bb-d392-5fd4-ab71-329b508de347","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Difference of macroscopically averaged ESP in bulk","type":"assignment","operand":"AVG_ESP_DIFF","value":"AVG_ESP_LEFT[0] - AVG_ESP_RIGHT[0]","input":[],"status":"idle","statusTrack":[],"flowchartId":"2626f7bb-d392-5fd4-ab71-329b508de347","tags":[],"head":false,"next":"b7307787-53e2-599b-ad12-d627b04074b4","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Lineup of macroscopically averaged ESP in interface","type":"assignment","operand":"ESP_LINEUP","value":"np.abs(AVG_ESP_INTERFACE[0] - AVG_ESP_INTERFACE[1])","input":[],"status":"idle","statusTrack":[],"flowchartId":"b7307787-53e2-599b-ad12-d627b04074b4","tags":[],"head":false,"next":"197f4b4d-cb7b-57be-a885-d44cb1f61905","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Valence Band Offset","type":"assignment","operand":"VALENCE_BAND_OFFSET","value":"abs(VBM_DIFF - AVG_ESP_DIFF + (np.sign(AVG_ESP_DIFF) * ESP_LINEUP))","input":[],"results":[{"name":"valence_band_offset"}],"status":"idle","statusTrack":[],"flowchartId":"197f4b4d-cb7b-57be-a885-d44cb1f61905","tags":[],"head":false,"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}}]}],"units":[{"name":"BS + Avg ESP (Interface)","type":"subworkflow","_id":"9c65d03e-6a30-58f3-947a-f174342be0c3","status":"idle","statusTrack":[],"flowchartId":"fd622b5c-5c02-594e-b582-b245c17ca9a4","tags":[],"head":true,"next":"ad3b1e4c-5965-5605-a067-dd0c59907c4b"},{"name":"Find ESP Values (Interface)","type":"subworkflow","_id":"ce26adc1-6a26-53ef-9626-5eb6a6b9ccb7","status":"idle","statusTrack":[],"flowchartId":"ad3b1e4c-5965-5605-a067-dd0c59907c4b","tags":[],"head":false,"next":"8d5b4734-edfd-55cc-ad80-aaa72487398d"},{"name":"BS + Avg ESP (interface left)","type":"subworkflow","_id":"ba46d9b4-610f-537e-ae39-e39ce5240cda","status":"idle","statusTrack":[],"flowchartId":"8d5b4734-edfd-55cc-ad80-aaa72487398d","tags":[],"head":false,"next":"102ec582-5b75-52f5-8b39-19ca725ed47a"},{"name":"Find ESP Value (Interface left)","type":"subworkflow","_id":"6c303926-905c-5749-81d5-2d2964fdf09a","status":"idle","statusTrack":[],"flowchartId":"102ec582-5b75-52f5-8b39-19ca725ed47a","tags":[],"head":false,"next":"603c45db-93aa-54ce-a7fe-6e9b65b0037d"},{"name":"BS + Avg ESP (interface right)","type":"subworkflow","_id":"aa611fe8-1e6a-5e5c-976a-f64bfaaaace9","status":"idle","statusTrack":[],"flowchartId":"603c45db-93aa-54ce-a7fe-6e9b65b0037d","tags":[],"head":false,"next":"e3444d35-cc41-59f5-8481-78d0c383b84e"},{"name":"Find ESP Value (Interface right)","type":"subworkflow","_id":"736295e8-2ee0-5974-83bc-362061ac0688","status":"idle","statusTrack":[],"flowchartId":"e3444d35-cc41-59f5-8481-78d0c383b84e","tags":[],"head":false,"next":"0e0b141a-39ca-52bc-9094-e5f96dc72f39"},{"name":"Calculate VBO","type":"subworkflow","_id":"1b70e606-a7ee-599e-89e0-91a7dc5faa4a","status":"idle","statusTrack":[],"flowchartId":"0e0b141a-39ca-52bc-9094-e5f96dc72f39","tags":[],"head":false}],"properties":["atomic_forces","average_potential_profile","band_gaps","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"d8e08cac-7747-50aa-b925-41f214d722c6","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"espresso/variable_cell_relaxation.json":{"name":"Variable-cell Relaxation","subworkflows":[{"systemName":"espresso-variable-cell-relaxation","_id":"58709c44-47f6-5fbf-bf2e-358b9d98f75d","name":"Variable-cell Relaxation","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","fermi_energy","pressure","atomic_forces","total_force","stress_tensor","final_structure"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_vc-relax","head":true,"results":[{"name":"total_energy"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"},{"name":"final_structure"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"},{"name":"convergence_ionic"}],"flowchartId":"e1bd0870-6245-5fc2-a50d-48cabc356ac8","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pw_vc_relax.in"}],"monitors":["standard_output","convergence_electronic","convergence_ionic"],"results":["total_energy","fermi_energy","pressure","atomic_forces","total_force","stress_tensor","final_structure"],"applicationName":"espresso","executableName":"pw.x","name":"pw_vc-relax","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&CONTROL\n    calculation = 'vc-relax'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_vc_relax.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'vc-relax'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Variable-cell Relaxation","type":"subworkflow","_id":"58709c44-47f6-5fbf-bf2e-358b9d98f75d","status":"idle","statusTrack":[],"flowchartId":"8f6e9590-6a87-584b-abd7-1fb98253054c","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","final_structure","pressure","stress_tensor","total_energy","total_force"],"_id":"c45dcef1-d16b-59d1-9318-cedd0b1acf08","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"tags":["variable-cell_relaxation"],"application":{"name":"espresso"}},"espresso/zero_point_energy.json":{"name":"Zero Point Energy","subworkflows":[{"_id":"151538cc-9e71-5269-8b9e-cb5977151227","name":"Zero Point Energy","application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","zero_point_energy"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"us","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"pw_scf","head":true,"results":[{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"total_force"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9fc7a088-5533-5f70-bb33-f676ec65f565","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":true,"postProcessors":["remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"pw.x","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"pw_scf.in"}],"results":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"monitors":["standard_output","convergence_electronic"],"applicationName":"espresso","executableName":"pw.x","name":"pw_scf","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"{% if subworkflowContext.MATERIAL_INDEX %}\n{%- set input = input.perMaterial[subworkflowContext.MATERIAL_INDEX] -%}\n{% endif -%}\n&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = '{{ input.RESTART_MODE }}'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    wfcdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n    prefix = '__prefix__'\n    pseudo_dir = {% raw %}'{{ JOB_WORK_DIR }}/pseudo'{% endraw %}\n/\n&SYSTEM\n    ibrav = {{ input.IBRAV }}\n    nat = {{ input.NAT }}\n    ntyp = {{ input.NTYP }}\n    ecutwfc = {{ cutoffs.wavefunction }}\n    ecutrho = {{ cutoffs.density }}\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\n{{ input.ATOMIC_SPECIES }}\nATOMIC_POSITIONS crystal\n{{ input.ATOMIC_POSITIONS }}\nCELL_PARAMETERS angstrom\n{{ input.CELL_PARAMETERS }}\nK_POINTS automatic\n{% for d in kgrid.dimensions %}{{d}} {% endfor %}{% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"pw_scf.in","contextProviders":[{"name":"KGridFormDataManager"},{"name":"QEPWXInputDataManager"},{"name":"PlanewaveCutoffDataManager"}],"applicationName":"espresso","executableName":"pw.x","rendered":"&CONTROL\n    calculation = 'scf'\n    title = ''\n    verbosity = 'low'\n    restart_mode = 'from_scratch'\n    wf_collect = .true.\n    tstress = .true.\n    tprnfor = .true.\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n    wfcdir = '{{ JOB_WORK_DIR }}/outdir'\n    prefix = '__prefix__'\n    pseudo_dir = '{{ JOB_WORK_DIR }}/pseudo'\n/\n&SYSTEM\n    ibrav = 0\n    nat = 2\n    ntyp = 1\n    ecutwfc = 40\n    ecutrho = 200\n    occupations = 'smearing'\n    degauss = 0.005\n/\n&ELECTRONS\n    diagonalization = 'david'\n    diago_david_ndim = 4\n    diago_full_acc = .true.\n    mixing_beta = 0.3\n    startingwfc = 'atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 \nATOMIC_POSITIONS crystal\nSi     0.000000000    0.000000000    0.000000000 \nSi     0.250000000    0.250000000    0.250000000 \nCELL_PARAMETERS angstrom\n3.348920236 0.000000000 1.933500000\n1.116306745 3.157392278 1.933500000\n0.000000000 0.000000000 3.867000000\nK_POINTS automatic\n2 2 2 0 0 0 \n","schemaVersion":"2022.8.16"}],"next":"107595d1-490f-53a2-8432-7f8a12f14d96"},{"type":"execution","name":"ph_zpe","head":false,"results":[{"name":"zero_point_energy"}],"monitors":[{"name":"standard_output"}],"flowchartId":"107595d1-490f-53a2-8432-7f8a12f14d96","preProcessors":[],"postProcessors":[],"application":{"name":"espresso","shortName":"qe","summary":"Quantum ESPRESSO","build":"GNU","version":"6.3","isDefault":true,"hasAdvancedComputeOptions":true,"schemaVersion":"2022.8.16"},"executable":{"monitors":["standard_output"],"name":"ph.x","schemaVersion":"2022.8.16","isDefault":false},"flavor":{"input":[{"name":"ph_gamma.in"}],"results":["zero_point_energy"],"monitors":["standard_output"],"applicationName":"espresso","executableName":"ph.x","name":"ph_gamma","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"&INPUTPH\n    tr2_ph = 1.0d-12\n    asr = .true.\n    search_sym = .false.\n    prefix = '__prefix__'\n    outdir = {% raw %}'{{ JOB_WORK_DIR }}/outdir'{% endraw %}\n/\n0 0 0\n","name":"ph_gamma.in","contextProviders":[],"applicationName":"espresso","executableName":"ph.x","rendered":"&INPUTPH\n    tr2_ph = 1.0d-12\n    asr = .true.\n    search_sym = .false.\n    prefix = '__prefix__'\n    outdir = '{{ JOB_WORK_DIR }}/outdir'\n/\n0 0 0\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Zero Point Energy","type":"subworkflow","_id":"151538cc-9e71-5269-8b9e-cb5977151227","status":"idle","statusTrack":[],"flowchartId":"d906bd20-eb92-5a01-a0e2-c81a2d9b2a41","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force","zero_point_energy"],"_id":"3158c78d-58bb-5675-8c7f-6f2337061015","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"espresso"}},"nwchem/total_energy.json":{"name":"Total Energy","subworkflows":[{"_id":"9e7a15b7-0b7d-5a8e-be7f-b8fcacd5cc13","name":"Total Energy","application":{"name":"nwchem","shortName":"nwchem","summary":"NWChem","build":"GNU","version":"7.0.2","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","total_energy_contributions"],"model":{"type":"dft","subtype":"gga","method":{"type":"localorbital","subtype":"pople","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"nwchem_total_energy","head":true,"results":[{"name":"total_energy"},{"name":"total_energy_contributions"}],"monitors":[{"name":"standard_output"}],"flowchartId":"6f1eda0b-ebe1-5ccd-92dc-c2e55de5e0c7","preProcessors":[],"postProcessors":[],"application":{"name":"nwchem","shortName":"nwchem","summary":"NWChem","build":"GNU","version":"7.0.2","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"hasAdvancedComputeOptions":false,"postProcessors":["error_handler"],"monitors":["standard_output"],"name":"nwchem","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"nwchem_total_energy.inp"}],"results":["total_energy","total_energy_contributions"],"monitors":["standard_output"],"applicationName":"nwchem","executableName":"nwchem","name":"nwchem_total_energy","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":" start nwchem\n title \"Test\"\n charge {{ input.CHARGE }}\n geometry units au noautosym\n {{ input.ATOMIC_POSITIONS }}\n end\n basis\n   * library {{ input.BASIS }}\n end\n dft\n xc {{ input.FUNCTIONAL }}\n mult {{ input.MULT }}\n end\n task dft energy\n","name":"nwchem_total_energy.inp","contextProviders":[{"name":"NWChemInputDataManager"}],"applicationName":"nwchem","executableName":"nwchem","rendered":" start nwchem\n title \"Test\"\n charge 0\n geometry units au noautosym\n Si     0.000000000    0.000000000    0.000000000 \nSi     1.116306745    0.789348070    1.933500000 \n end\n basis\n   * library 6-31G\n end\n dft\n xc B3LYP\n mult 1\n end\n task dft energy\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Total Energy","type":"subworkflow","_id":"9e7a15b7-0b7d-5a8e-be7f-b8fcacd5cc13","status":"idle","statusTrack":[],"flowchartId":"6059d61a-6a92-5657-9130-02208639aff8","tags":[],"head":true}],"properties":["total_energy","total_energy_contributions"],"_id":"937fbac8-2dec-5fb1-a46f-b8a0cc3d3d05","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"nwchem"}},"python/ml/classification_workflow.json":{"name":"Python ML Train Classification","subworkflows":[{"_id":"03e3f15b-2b22-5bb4-8bfd-6839d28a1ba9","name":"Set Up the Job","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"name":"Set Workflow Mode","type":"assignment","operand":"IS_WORKFLOW_RUNNING_TO_PREDICT","value":"False","input":[],"flowchartId":"head-set-predict-status","tags":["pyml:workflow-type-setter"],"status":"idle","statusTrack":[],"head":true,"next":"head-fetch-training-data","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Fetch Dataset","type":"io","subtype":"input","enableRender":true,"flowchartId":"head-fetch-training-data","input":[{"basename":"{{DATASET_BASENAME}}","objectData":{"CONTAINER":"","NAME":"{{DATASET_FILEPATH}}","PROVIDER":"","REGION":""}}],"source":"object_storage","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"head-branch-on-predict-status","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Train or Predict?","type":"condition","input":[{"name":"IS_WORKFLOW_RUNNING_TO_PREDICT","scope":"global"}],"results":[],"preProcessors":[],"postProcessors":[],"then":"head-fetch-trained-model","else":"end-of-ml-train-head","statement":"IS_WORKFLOW_RUNNING_TO_PREDICT","maxOccurrences":100,"flowchartId":"head-branch-on-predict-status","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"head-fetch-trained-model","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Fetch Trained Model as file","type":"io","subtype":"input","enableRender":true,"flowchartId":"head-fetch-trained-model","input":[{"basename":"","objectData":{"CONTAINER":"","NAME":"","PROVIDER":"","REGION":""}}],"source":"object_storage","tags":["set-io-unit-filenames"],"status":"idle","statusTrack":[],"head":false,"next":"end-of-ml-train-head","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"End Setup","type":"assignment","operand":"IS_SETUP_COMPLETE","value":"True","input":[],"flowchartId":"end-of-ml-train-head","status":"idle","statusTrack":[],"tags":[],"head":false,"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}}]},{"_id":"30acc5cd-54e6-5f05-aafd-413ee8a69aa1","name":"Machine Learning","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["workflow:pyml_predict","file_content"],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"Setup Variables and Packages","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"c3608488-0259-5ff4-8b90-11c6e60d6c85","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"settings.py","templateName":"pyml_settings.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:setup_variables_packages","schemaVersion":"2022.8.16","isDefault":false},"enableRender":true,"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   General settings for PythonML jobs on the Exabyte.io Platform   #\n#                                                                   #\n#   This file generally shouldn't be modified directly by users.    #\n#   The \"datafile\" and \"is_workflow_running_to_predict\" variables   #\n#   are defined in the head subworkflow, and are templated into     #\n#   this file. This helps facilitate the workflow's behavior        #\n#   differing whether it is in a \"train\" or \"predict\" mode.         #\n#                                                                   #\n#   Also in this file is the \"Context\" object, which helps maintain #\n#   certain Python objects between workflow units, and between      #\n#   predict runs.                                                   #\n#                                                                   #\n#   Whenever a python object needs to be stored for subsequent runs #\n#   (such as in the case of a trained model), context.save() can be #\n#   called to save it. The object can then be loaded again by using #\n#   context.load().                                                 #\n# ----------------------------------------------------------------- #\n\n\nimport os\nimport pickle\n\n# ==================================================\n# Variables modified in the Important Settings menu\n# ==================================================\n# Variables in this section can (and oftentimes need to) be modified by the user in the \"Important Settings\" tab\n# of a workflow.\n\n# Target_column_name is used during training to identify the variable the model is traing to predict.\n# For example, consider a CSV containing three columns, \"Y\", \"X1\", and \"X2\". If the goal is to train a model\n# that will predict the value of \"Y,\" then target_column_name would be set to \"Y\"\ntarget_column_name = \"{{ mlSettings.target_column_name }}\"\n\n# The type of ML problem being performed. Can be either \"regression\", \"classification,\" or \"clustering.\"\nproblem_category = \"{{ mlSettings.problem_category }}\"\n\n# =============================\n# Non user-modifiable variables\n# =============================\n# Variables in this section generally do not need to be modified.\n\n# The problem category, regression or classification or clustering. In regression, the target (predicted) variable\n# is continues. In classification, it is categorical. In clustering, there is no target - a set of labels is\n# automatically generated.\nis_regression = is_classification = is_clustering = False\nif problem_category.lower() == \"regression\":\n    is_regression = True\nelif problem_category.lower() == \"classification\":\n    is_classification = True\nelif problem_category.lower() == \"clustering\":\n    is_clustering = True\nelse:\n    raise ValueError(\n        \"Variable 'problem_category' must be either 'regression', 'classification', or 'clustering'. Check settings.py\")\n\n# The variables \"is_workflow_running_to_predict\" and \"is_workflow_running_to_train\" are used to control whether\n# the workflow is in a \"training\" mode or a \"prediction\" mode. The \"IS_WORKFLOW_RUNNING_TO_PREDICT\" variable is set by\n# an assignment unit in the \"Set Up the Job\" subworkflow that executes at the start of the job. It is automatically\n# changed when the predict workflow is generated, so users should not need to modify this variable.\nis_workflow_running_to_predict = {% raw %}{{IS_WORKFLOW_RUNNING_TO_PREDICT}}{% endraw %}\nis_workflow_running_to_train = not is_workflow_running_to_predict\n\n# Sets the datafile variable. The \"datafile\" is the data that will be read in, and will be used by subsequent\n# workflow units for either training or prediction, depending on the workflow mode.\nif is_workflow_running_to_predict:\n    datafile = \"{% raw %}{{DATASET_BASENAME}}{% endraw %}\"\nelse:\n    datafile = \"{% raw %}{{DATASET_BASENAME}}{% endraw %}\"\n\n# The \"Context\" class allows for data to be saved and loaded between units, and between train and predict runs.\n# Variables which have been saved using the \"Save\" method are written to disk, and the predict workflow is automatically\n# configured to obtain these files when it starts.\n#\n# IMPORTANT NOTE: Do *not* adjust the value of \"context_dir_pathname\" in the Context object. If the value is changed, then\n# files will not be correctly copied into the generated predict workflow. This will cause the predict workflow to be\n# generated in a broken state, and it will not be able to make any predictions.\nclass Context(object):\n    \"\"\"\n    Saves and loads objects from the disk, useful for preserving data between workflow units\n\n    Attributes:\n        context_paths (dict): Dictionary of the format {variable_name: path}, that governs where\n                              pickle saves files.\n\n    Methods:\n        save: Used to save objects to the context directory\n        load: Used to load objects from the context directory\n    \"\"\"\n\n    def __init__(self, context_file_basename=\"workflow_context_file_mapping\"):\n        \"\"\"\n        Constructor for Context objects\n\n        Args:\n            context_file_basename (str): Name of the file to store context paths in\n        \"\"\"\n\n        # Warning: DO NOT modify the context_dir_pathname variable below\n        # vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv\n        context_dir_pathname = \"{% raw %}{{ CONTEXT_DIR_RELATIVE_PATH }}{% endraw %}\"\n        # ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n        self._context_dir_pathname = context_dir_pathname\n        self._context_file = os.path.join(context_dir_pathname, context_file_basename)\n\n        # Make context dir if it does not exist\n        if not os.path.exists(context_dir_pathname):\n            os.makedirs(context_dir_pathname)\n\n        # Read in the context sources dictionary, if it exists\n        if os.path.exists(self._context_file):\n            with open(self._context_file, \"rb\") as file_handle:\n                self.context_paths: dict = pickle.load(file_handle)\n        else:\n            # Items is a dictionary of {varname: path}\n            self.context_paths = {}\n\n    def __enter__(self):\n        return self\n\n    def __exit__(self, exc_type, exc_value, traceback):\n        self._update_context()\n\n    def __contains__(self, item):\n        return item in self.context_paths\n\n    def _update_context(self):\n        with open(self._context_file, \"wb\") as file_handle:\n            pickle.dump(self.context_paths, file_handle)\n\n    def load(self, name: str):\n        \"\"\"\n        Returns a contextd object\n\n        Args:\n            name (str): The name in self.context_paths of the object\n        \"\"\"\n        path = self.context_paths[name]\n        with open(path, \"rb\") as file_handle:\n            obj = pickle.load(file_handle)\n        return obj\n\n    def save(self, obj: object, name: str):\n        \"\"\"\n        Saves an object to disk using pickle\n\n        Args:\n            name (str): Friendly name for the object, used for lookup in load() method\n            obj (object): Object to store on disk\n        \"\"\"\n        path = os.path.join(self._context_dir_pathname, f\"{name}.pkl\")\n        self.context_paths[name] = path\n        with open(path, \"wb\") as file_handle:\n            pickle.dump(obj, file_handle)\n        self._update_context()\n\n# Generate a context object, so that the \"with settings.context\" can be used by other units in this workflow.\ncontext = Context()\n\nis_using_train_test_split = \"is_using_train_test_split\" in context and (context.load(\"is_using_train_test_split\"))\n\n# Create a Class for a DummyScaler()\nclass DummyScaler:\n    \"\"\"\n    This class is a 'DummyScaler' which trivially acts on data by returning it unchanged.\n    \"\"\"\n\n    def fit(self, X):\n        return self\n\n    def transform(self, X):\n        return X\n\n    def fit_transform(self, X):\n        return X\n\n    def inverse_transform(self, X):\n        return X\n\nif 'target_scaler' not in context:\n    context.save(DummyScaler(), 'target_scaler')\n","name":"settings.py","contextProviders":[{"name":"MLSettingsDataManager"}],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   General settings for PythonML jobs on the Exabyte.io Platform   #\n#                                                                   #\n#   This file generally shouldn't be modified directly by users.    #\n#   The \"datafile\" and \"is_workflow_running_to_predict\" variables   #\n#   are defined in the head subworkflow, and are templated into     #\n#   this file. This helps facilitate the workflow's behavior        #\n#   differing whether it is in a \"train\" or \"predict\" mode.         #\n#                                                                   #\n#   Also in this file is the \"Context\" object, which helps maintain #\n#   certain Python objects between workflow units, and between      #\n#   predict runs.                                                   #\n#                                                                   #\n#   Whenever a python object needs to be stored for subsequent runs #\n#   (such as in the case of a trained model), context.save() can be #\n#   called to save it. The object can then be loaded again by using #\n#   context.load().                                                 #\n# ----------------------------------------------------------------- #\n\n\nimport os\nimport pickle\n\n# ==================================================\n# Variables modified in the Important Settings menu\n# ==================================================\n# Variables in this section can (and oftentimes need to) be modified by the user in the \"Important Settings\" tab\n# of a workflow.\n\n# Target_column_name is used during training to identify the variable the model is traing to predict.\n# For example, consider a CSV containing three columns, \"Y\", \"X1\", and \"X2\". If the goal is to train a model\n# that will predict the value of \"Y,\" then target_column_name would be set to \"Y\"\ntarget_column_name = \"target\"\n\n# The type of ML problem being performed. Can be either \"regression\", \"classification,\" or \"clustering.\"\nproblem_category = \"regression\"\n\n# =============================\n# Non user-modifiable variables\n# =============================\n# Variables in this section generally do not need to be modified.\n\n# The problem category, regression or classification or clustering. In regression, the target (predicted) variable\n# is continues. In classification, it is categorical. In clustering, there is no target - a set of labels is\n# automatically generated.\nis_regression = is_classification = is_clustering = False\nif problem_category.lower() == \"regression\":\n    is_regression = True\nelif problem_category.lower() == \"classification\":\n    is_classification = True\nelif problem_category.lower() == \"clustering\":\n    is_clustering = True\nelse:\n    raise ValueError(\n        \"Variable 'problem_category' must be either 'regression', 'classification', or 'clustering'. Check settings.py\")\n\n# The variables \"is_workflow_running_to_predict\" and \"is_workflow_running_to_train\" are used to control whether\n# the workflow is in a \"training\" mode or a \"prediction\" mode. The \"IS_WORKFLOW_RUNNING_TO_PREDICT\" variable is set by\n# an assignment unit in the \"Set Up the Job\" subworkflow that executes at the start of the job. It is automatically\n# changed when the predict workflow is generated, so users should not need to modify this variable.\nis_workflow_running_to_predict = {{IS_WORKFLOW_RUNNING_TO_PREDICT}}\nis_workflow_running_to_train = not is_workflow_running_to_predict\n\n# Sets the datafile variable. The \"datafile\" is the data that will be read in, and will be used by subsequent\n# workflow units for either training or prediction, depending on the workflow mode.\nif is_workflow_running_to_predict:\n    datafile = \"{{DATASET_BASENAME}}\"\nelse:\n    datafile = \"{{DATASET_BASENAME}}\"\n\n# The \"Context\" class allows for data to be saved and loaded between units, and between train and predict runs.\n# Variables which have been saved using the \"Save\" method are written to disk, and the predict workflow is automatically\n# configured to obtain these files when it starts.\n#\n# IMPORTANT NOTE: Do *not* adjust the value of \"context_dir_pathname\" in the Context object. If the value is changed, then\n# files will not be correctly copied into the generated predict workflow. This will cause the predict workflow to be\n# generated in a broken state, and it will not be able to make any predictions.\nclass Context(object):\n    \"\"\"\n    Saves and loads objects from the disk, useful for preserving data between workflow units\n\n    Attributes:\n        context_paths (dict): Dictionary of the format {variable_name: path}, that governs where\n                              pickle saves files.\n\n    Methods:\n        save: Used to save objects to the context directory\n        load: Used to load objects from the context directory\n    \"\"\"\n\n    def __init__(self, context_file_basename=\"workflow_context_file_mapping\"):\n        \"\"\"\n        Constructor for Context objects\n\n        Args:\n            context_file_basename (str): Name of the file to store context paths in\n        \"\"\"\n\n        # Warning: DO NOT modify the context_dir_pathname variable below\n        # vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv\n        context_dir_pathname = \"{{ CONTEXT_DIR_RELATIVE_PATH }}\"\n        # ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n        self._context_dir_pathname = context_dir_pathname\n        self._context_file = os.path.join(context_dir_pathname, context_file_basename)\n\n        # Make context dir if it does not exist\n        if not os.path.exists(context_dir_pathname):\n            os.makedirs(context_dir_pathname)\n\n        # Read in the context sources dictionary, if it exists\n        if os.path.exists(self._context_file):\n            with open(self._context_file, \"rb\") as file_handle:\n                self.context_paths: dict = pickle.load(file_handle)\n        else:\n            # Items is a dictionary of {varname: path}\n            self.context_paths = {}\n\n    def __enter__(self):\n        return self\n\n    def __exit__(self, exc_type, exc_value, traceback):\n        self._update_context()\n\n    def __contains__(self, item):\n        return item in self.context_paths\n\n    def _update_context(self):\n        with open(self._context_file, \"wb\") as file_handle:\n            pickle.dump(self.context_paths, file_handle)\n\n    def load(self, name: str):\n        \"\"\"\n        Returns a contextd object\n\n        Args:\n            name (str): The name in self.context_paths of the object\n        \"\"\"\n        path = self.context_paths[name]\n        with open(path, \"rb\") as file_handle:\n            obj = pickle.load(file_handle)\n        return obj\n\n    def save(self, obj: object, name: str):\n        \"\"\"\n        Saves an object to disk using pickle\n\n        Args:\n            name (str): Friendly name for the object, used for lookup in load() method\n            obj (object): Object to store on disk\n        \"\"\"\n        path = os.path.join(self._context_dir_pathname, f\"{name}.pkl\")\n        self.context_paths[name] = path\n        with open(path, \"wb\") as file_handle:\n            pickle.dump(obj, file_handle)\n        self._update_context()\n\n# Generate a context object, so that the \"with settings.context\" can be used by other units in this workflow.\ncontext = Context()\n\nis_using_train_test_split = \"is_using_train_test_split\" in context and (context.load(\"is_using_train_test_split\"))\n\n# Create a Class for a DummyScaler()\nclass DummyScaler:\n    \"\"\"\n    This class is a 'DummyScaler' which trivially acts on data by returning it unchanged.\n    \"\"\"\n\n    def fit(self, X):\n        return self\n\n    def transform(self, X):\n        return X\n\n    def fit_transform(self, X):\n        return X\n\n    def inverse_transform(self, X):\n        return X\n\nif 'target_scaler' not in context:\n    context.save(DummyScaler(), 'target_scaler')\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"cb69ea2a-7efc-56b4-8bbe-0de1e70c49e3"},{"type":"execution","name":"Data Input","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"cb69ea2a-7efc-56b4-8bbe-0de1e70c49e3","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"data_input_read_csv_pandas.py","templateName":"data_input_read_csv_pandas.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:data_input:read_csv:pandas","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Workflow Unit to read in data for the ML workflow.              #\n#                                                                   #\n#   Also showcased here is the concept of branching based on        #\n#   whether the workflow is in \"train\" or \"predict\" mode.           #\n#                                                                   #\n#   If the workflow is in \"training\" mode, it will read in the data #\n#   before converting it to a Numpy array and save it for use       #\n#   later. During training, we already have values for the output,  #\n#   and this gets saved to \"target.\"                                #\n#                                                                   #\n#   Finally, whether the workflow is in training or predict mode,   #\n#   it will always read in a set of descriptors from a datafile     #\n#   defined in settings.py                                          #\n# ----------------------------------------------------------------- #\n\n\nimport pandas\nimport settings\nimport sklearn.preprocessing\n\nwith settings.context as context:\n    data = pandas.read_csv(settings.datafile)\n\n    # Train\n    # By default, we don't do train/test splitting: the train and test represent the same dataset at first.\n    # Other units (such as a train/test splitter) down the line can adjust this as-needed.\n    if settings.is_workflow_running_to_train:\n\n        # Handle the case where we are clustering\n        if settings.is_clustering:\n            target = data.to_numpy()[:, 0]  # Just get the first column, it's not going to get used anyway\n        else:\n            target = data.pop(settings.target_column_name).to_numpy()\n\n        # Handle the case where we are classifying. In this case, we must convert any labels provided to be categorical.\n        # Specifically, labels are encoded with values between 0 and (N_Classes - 1)\n        if settings.is_classification:\n            label_encoder = sklearn.preprocessing.LabelEncoder()\n            target = label_encoder.fit_transform(target)\n            context.save(label_encoder, \"label_encoder\")\n\n        target = target.reshape(-1, 1)  # Reshape array from a row vector into a column vector\n\n        context.save(target, \"train_target\")\n        context.save(target, \"test_target\")\n\n        descriptors = data.to_numpy()\n\n        context.save(descriptors, \"train_descriptors\")\n        context.save(descriptors, \"test_descriptors\")\n\n    else:\n        descriptors = data.to_numpy()\n        context.save(descriptors, \"descriptors\")\n","name":"data_input_read_csv_pandas.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Workflow Unit to read in data for the ML workflow.              #\n#                                                                   #\n#   Also showcased here is the concept of branching based on        #\n#   whether the workflow is in \"train\" or \"predict\" mode.           #\n#                                                                   #\n#   If the workflow is in \"training\" mode, it will read in the data #\n#   before converting it to a Numpy array and save it for use       #\n#   later. During training, we already have values for the output,  #\n#   and this gets saved to \"target.\"                                #\n#                                                                   #\n#   Finally, whether the workflow is in training or predict mode,   #\n#   it will always read in a set of descriptors from a datafile     #\n#   defined in settings.py                                          #\n# ----------------------------------------------------------------- #\n\n\nimport pandas\nimport settings\nimport sklearn.preprocessing\n\nwith settings.context as context:\n    data = pandas.read_csv(settings.datafile)\n\n    # Train\n    # By default, we don't do train/test splitting: the train and test represent the same dataset at first.\n    # Other units (such as a train/test splitter) down the line can adjust this as-needed.\n    if settings.is_workflow_running_to_train:\n\n        # Handle the case where we are clustering\n        if settings.is_clustering:\n            target = data.to_numpy()[:, 0]  # Just get the first column, it's not going to get used anyway\n        else:\n            target = data.pop(settings.target_column_name).to_numpy()\n\n        # Handle the case where we are classifying. In this case, we must convert any labels provided to be categorical.\n        # Specifically, labels are encoded with values between 0 and (N_Classes - 1)\n        if settings.is_classification:\n            label_encoder = sklearn.preprocessing.LabelEncoder()\n            target = label_encoder.fit_transform(target)\n            context.save(label_encoder, \"label_encoder\")\n\n        target = target.reshape(-1, 1)  # Reshape array from a row vector into a column vector\n\n        context.save(target, \"train_target\")\n        context.save(target, \"test_target\")\n\n        descriptors = data.to_numpy()\n\n        context.save(descriptors, \"train_descriptors\")\n        context.save(descriptors, \"test_descriptors\")\n\n    else:\n        descriptors = data.to_numpy()\n        context.save(descriptors, \"descriptors\")\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"7fff5212-6c6d-586b-9997-4d4485e09383"},{"type":"execution","name":"Train Test Split","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"7fff5212-6c6d-586b-9997-4d4485e09383","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"data_input_train_test_split_sklearn.py","templateName":"data_input_train_test_split_sklearn.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:data_input:train_test_split:sklearn","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Workflow Unit to perform a train/test split                     #\n#                                                                   #\n#   Splits the dataset into a training and testing set. The         #\n#   variable `percent_held_as_test` controls how much of the        #\n#   input dataset is removed for use as a testing set. By default,  #\n#   this unit puts 20% of the dataset into the testing set, and     #\n#   places the remaining 80% into the training set.                 #\n#                                                                   #\n#   Does nothing in the case of predictions.                        #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nimport numpy as np\nimport settings\nimport sklearn.model_selection\n\n# `percent_held_as_test` is the amount of the dataset held out as the testing set. If it is set to 0.2,\n# then 20% of the dataset is held out as a testing set. The remaining 80% is the training set.\npercent_held_as_test = {{ mlTrainTestSplit.fraction_held_as_test_set }}\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Load training data\n        train_target = context.load(\"train_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n\n        # Combine datasets to facilitate train/test split\n\n        # Do train/test split\n        train_descriptors, test_descriptors, train_target, test_target = sklearn.model_selection.train_test_split(\n            train_descriptors, train_target, test_size=percent_held_as_test)\n\n        # Set the flag for using a train/test split\n        context.save(True, \"is_using_train_test_split\")\n\n        # Save training data\n        context.save(train_target, \"train_target\")\n        context.save(train_descriptors, \"train_descriptors\")\n        context.save(test_target, \"test_target\")\n        context.save(test_descriptors, \"test_descriptors\")\n\n    # Predict\n    else:\n        pass\n","name":"data_input_train_test_split_sklearn.py","contextProviders":[{"name":"MLTrainTestSplitDataManager"}],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Workflow Unit to perform a train/test split                     #\n#                                                                   #\n#   Splits the dataset into a training and testing set. The         #\n#   variable `percent_held_as_test` controls how much of the        #\n#   input dataset is removed for use as a testing set. By default,  #\n#   this unit puts 20% of the dataset into the testing set, and     #\n#   places the remaining 80% into the training set.                 #\n#                                                                   #\n#   Does nothing in the case of predictions.                        #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nimport numpy as np\nimport settings\nimport sklearn.model_selection\n\n# `percent_held_as_test` is the amount of the dataset held out as the testing set. If it is set to 0.2,\n# then 20% of the dataset is held out as a testing set. The remaining 80% is the training set.\npercent_held_as_test = 0.2\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Load training data\n        train_target = context.load(\"train_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n\n        # Combine datasets to facilitate train/test split\n\n        # Do train/test split\n        train_descriptors, test_descriptors, train_target, test_target = sklearn.model_selection.train_test_split(\n            train_descriptors, train_target, test_size=percent_held_as_test)\n\n        # Set the flag for using a train/test split\n        context.save(True, \"is_using_train_test_split\")\n\n        # Save training data\n        context.save(train_target, \"train_target\")\n        context.save(train_descriptors, \"train_descriptors\")\n        context.save(test_target, \"test_target\")\n        context.save(test_descriptors, \"test_descriptors\")\n\n    # Predict\n    else:\n        pass\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"799de7dc-9394-571b-8e0d-3ff876a3df02"},{"type":"execution","name":"Data Standardize","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"799de7dc-9394-571b-8e0d-3ff876a3df02","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pre_processing_standardization_sklearn.py","templateName":"pre_processing_standardization_sklearn.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:pre_processing:standardization:sklearn","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Sklearn Standard Scaler workflow unit                           #\n#                                                                   #\n#   This workflow unit scales the data such that it a mean of 0 and #\n#   a standard deviation of 1. It then saves the data for use       #\n#   further down the road in the workflow, for use in               #\n#   un-transforming the data.                                       #\n#                                                                   #\n#   It is important that new predictions are made by scaling the    #\n#   new inputs using the mean and variance of the original training #\n#   set. As a result, the scaler gets saved in the Training phase.  #\n#                                                                   #\n#   During a predict workflow, the scaler is loaded, and the        #\n#   new examples are scaled using the stored scaler.                #\n# ----------------------------------------------------------------- #\n\n\nimport settings\nimport sklearn.preprocessing\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n        test_target = context.load(\"test_target\")\n        test_descriptors = context.load(\"test_descriptors\")\n\n        # Descriptor Scaler\n        scaler = sklearn.preprocessing.StandardScaler\n        descriptor_scaler = scaler()\n        train_descriptors = descriptor_scaler.fit_transform(train_descriptors)\n        test_descriptors = descriptor_scaler.transform(test_descriptors)\n        context.save(descriptor_scaler, \"descriptor_scaler\")\n        context.save(train_descriptors, \"train_descriptors\")\n        context.save(test_descriptors, \"test_descriptors\")\n\n        # Our target is only continuous if it's a regression problem\n        if settings.is_regression:\n            target_scaler = scaler()\n            train_target = target_scaler.fit_transform(train_target)\n            test_target = target_scaler.transform(test_target)\n            context.save(target_scaler, \"target_scaler\")\n            context.save(train_target, \"train_target\")\n            context.save(test_target, \"test_target\")\n\n    # Predict\n    else:\n        # Restore data\n        descriptors = context.load(\"descriptors\")\n\n        # Get the scaler\n        descriptor_scaler = context.load(\"descriptor_scaler\")\n\n        # Scale the data\n        descriptors = descriptor_scaler.transform(descriptors)\n\n        # Store the data\n        context.save(descriptors, \"descriptors\")\n","name":"pre_processing_standardization_sklearn.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Sklearn Standard Scaler workflow unit                           #\n#                                                                   #\n#   This workflow unit scales the data such that it a mean of 0 and #\n#   a standard deviation of 1. It then saves the data for use       #\n#   further down the road in the workflow, for use in               #\n#   un-transforming the data.                                       #\n#                                                                   #\n#   It is important that new predictions are made by scaling the    #\n#   new inputs using the mean and variance of the original training #\n#   set. As a result, the scaler gets saved in the Training phase.  #\n#                                                                   #\n#   During a predict workflow, the scaler is loaded, and the        #\n#   new examples are scaled using the stored scaler.                #\n# ----------------------------------------------------------------- #\n\n\nimport settings\nimport sklearn.preprocessing\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n        test_target = context.load(\"test_target\")\n        test_descriptors = context.load(\"test_descriptors\")\n\n        # Descriptor Scaler\n        scaler = sklearn.preprocessing.StandardScaler\n        descriptor_scaler = scaler()\n        train_descriptors = descriptor_scaler.fit_transform(train_descriptors)\n        test_descriptors = descriptor_scaler.transform(test_descriptors)\n        context.save(descriptor_scaler, \"descriptor_scaler\")\n        context.save(train_descriptors, \"train_descriptors\")\n        context.save(test_descriptors, \"test_descriptors\")\n\n        # Our target is only continuous if it's a regression problem\n        if settings.is_regression:\n            target_scaler = scaler()\n            train_target = target_scaler.fit_transform(train_target)\n            test_target = target_scaler.transform(test_target)\n            context.save(target_scaler, \"target_scaler\")\n            context.save(train_target, \"train_target\")\n            context.save(test_target, \"test_target\")\n\n    # Predict\n    else:\n        # Restore data\n        descriptors = context.load(\"descriptors\")\n\n        # Get the scaler\n        descriptor_scaler = context.load(\"descriptor_scaler\")\n\n        # Scale the data\n        descriptors = descriptor_scaler.transform(descriptors)\n\n        # Store the data\n        context.save(descriptors, \"descriptors\")\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"8dfc61c3-067d-5ea8-bd26-7296628d707a"},{"type":"execution","name":"Model Train and Predict","head":false,"results":[{"name":"workflow:pyml_predict"}],"monitors":[{"name":"standard_output"}],"flowchartId":"8dfc61c3-067d-5ea8-bd26-7296628d707a","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"model_random_forest_classification_sklearn.py","templateName":"model_random_forest_classification_sklearn.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"results":["workflow:pyml_predict"],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:model:random_forest_classification:sklearn","schemaVersion":"2022.8.16","isDefault":false},"tags":["remove-all-results","creates-predictions-csv-during-predict-phase"],"status":"idle","statusTrack":[],"input":[{"content":"# ------------------------------------------------------------ #\n# Workflow unit for a random forest classification model with  #\n# Scikit-Learn. Parameters derived from Scikit-Learn's         #\n# defaults.                                                    #\n#                                                              #\n# When then workflow is in Training mode, the model is trained #\n# and then it is saved, along with the confusion matrix. When  #\n# the workflow is run in Predict mode, the model is loaded,    #\n# predictions are made, they are un-transformed using the      #\n# trained scaler from the training run, and they are written   #\n# to a filee named \"predictions.csv\"                           #\n# ------------------------------------------------------------ #\n\n\nimport numpy as np\nimport settings\nimport sklearn.ensemble\nimport sklearn.metrics\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        test_target = context.load(\"test_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n        test_descriptors = context.load(\"test_descriptors\")\n\n        # Flatten the targets\n        train_target = train_target.flatten()\n        test_target = test_target.flatten()\n\n        # Initialize the Model\n        model = sklearn.ensemble.RandomForestClassifier(\n            n_estimators=100,\n            criterion=\"gini\",\n            max_depth=None,\n            min_samples_split=2,\n            min_samples_leaf=1,\n            min_weight_fraction_leaf=0.0,\n            max_features=\"auto\",\n            max_leaf_nodes=None,\n            min_impurity_decrease=0.0,\n            bootstrap=True,\n            oob_score=False,\n            verbose=0,\n            class_weight=None,\n            ccp_alpha=0.0,\n            max_samples=None,\n        )\n\n        # Train the model and save\n        model.fit(train_descriptors, train_target)\n        context.save(model, \"random_forest\")\n        train_predictions = model.predict(train_descriptors)\n        test_predictions = model.predict(test_descriptors)\n\n        # Save the probabilities of the model\n        test_probabilities = model.predict_proba(test_descriptors)\n        context.save(test_probabilities, \"test_probabilities\")\n\n        # Print some information to the screen for the regression problem\n        confusion_matrix = sklearn.metrics.confusion_matrix(test_target, test_predictions)\n        print(\"Confusion Matrix:\")\n        print(confusion_matrix)\n        context.save(confusion_matrix, \"confusion_matrix\")\n\n        context.save(train_predictions, \"train_predictions\")\n        context.save(test_predictions, \"test_predictions\")\n\n    # Predict\n    else:\n        # Restore data\n        descriptors = context.load(\"descriptors\")\n\n        # Restore model\n        model = context.load(\"random_forest\")\n\n        # Make some predictions\n        predictions = model.predict(descriptors)\n\n        # Transform predictions back to their original labels\n        label_encoder: sklearn.preprocessing.LabelEncoder = context.load(\"label_encoder\")\n        predictions = label_encoder.inverse_transform(predictions)\n\n        # Save the predictions to file\n        np.savetxt(\"predictions.csv\", predictions, header=\"prediction\", comments=\"\", fmt=\"%s\")\n","name":"model_random_forest_classification_sklearn.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ------------------------------------------------------------ #\n# Workflow unit for a random forest classification model with  #\n# Scikit-Learn. Parameters derived from Scikit-Learn's         #\n# defaults.                                                    #\n#                                                              #\n# When then workflow is in Training mode, the model is trained #\n# and then it is saved, along with the confusion matrix. When  #\n# the workflow is run in Predict mode, the model is loaded,    #\n# predictions are made, they are un-transformed using the      #\n# trained scaler from the training run, and they are written   #\n# to a filee named \"predictions.csv\"                           #\n# ------------------------------------------------------------ #\n\n\nimport numpy as np\nimport settings\nimport sklearn.ensemble\nimport sklearn.metrics\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        test_target = context.load(\"test_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n        test_descriptors = context.load(\"test_descriptors\")\n\n        # Flatten the targets\n        train_target = train_target.flatten()\n        test_target = test_target.flatten()\n\n        # Initialize the Model\n        model = sklearn.ensemble.RandomForestClassifier(\n            n_estimators=100,\n            criterion=\"gini\",\n            max_depth=None,\n            min_samples_split=2,\n            min_samples_leaf=1,\n            min_weight_fraction_leaf=0.0,\n            max_features=\"auto\",\n            max_leaf_nodes=None,\n            min_impurity_decrease=0.0,\n            bootstrap=True,\n            oob_score=False,\n            verbose=0,\n            class_weight=None,\n            ccp_alpha=0.0,\n            max_samples=None,\n        )\n\n        # Train the model and save\n        model.fit(train_descriptors, train_target)\n        context.save(model, \"random_forest\")\n        train_predictions = model.predict(train_descriptors)\n        test_predictions = model.predict(test_descriptors)\n\n        # Save the probabilities of the model\n        test_probabilities = model.predict_proba(test_descriptors)\n        context.save(test_probabilities, \"test_probabilities\")\n\n        # Print some information to the screen for the regression problem\n        confusion_matrix = sklearn.metrics.confusion_matrix(test_target, test_predictions)\n        print(\"Confusion Matrix:\")\n        print(confusion_matrix)\n        context.save(confusion_matrix, \"confusion_matrix\")\n\n        context.save(train_predictions, \"train_predictions\")\n        context.save(test_predictions, \"test_predictions\")\n\n    # Predict\n    else:\n        # Restore data\n        descriptors = context.load(\"descriptors\")\n\n        # Restore model\n        model = context.load(\"random_forest\")\n\n        # Make some predictions\n        predictions = model.predict(descriptors)\n\n        # Transform predictions back to their original labels\n        label_encoder: sklearn.preprocessing.LabelEncoder = context.load(\"label_encoder\")\n        predictions = label_encoder.inverse_transform(predictions)\n\n        # Save the predictions to file\n        np.savetxt(\"predictions.csv\", predictions, header=\"prediction\", comments=\"\", fmt=\"%s\")\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"35436b4a-cd9c-5089-ab42-665c4f9ba049"},{"type":"execution","name":"ROC Curve Plot","head":false,"results":[{"basename":"my_roc_plot.png","filetype":"image","name":"file_content"}],"monitors":[{"name":"standard_output"}],"flowchartId":"35436b4a-cd9c-5089-ab42-665c4f9ba049","preProcessors":[],"postProcessors":[{"name":"remove_virtual_environment"}],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"post_processing_roc_curve_sklearn.py","templateName":"post_processing_roc_curve_sklearn.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"results":["file_content"],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:post_processing:roc_curve:sklearn","schemaVersion":"2022.8.16","isDefault":false},"tags":["remove-all-results"],"status":"idle","statusTrack":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   ROC Curve Generator                                             #\n#                                                                   #\n#   Computes and displays the Receiver Operating Characteristic     #\n#   (ROC) curve. This is restricted to binary classification tasks. #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\n\nimport matplotlib.collections\nimport matplotlib.pyplot as plt\nimport numpy as np\nimport settings\nimport sklearn.metrics\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        test_target = context.load(\"test_target\").flatten()\n        # Slice the first column because Sklearn's ROC curve prefers probabilities for the positive class\n        test_probabilities = context.load(\"test_probabilities\")[:, 1]\n\n        # Exit if there's more than one label in the predictions\n        if len(set(test_target)) > 2:\n            exit()\n\n        # ROC curve function in sklearn prefers the positive class\n        false_positive_rate, true_positive_rate, thresholds = sklearn.metrics.roc_curve(test_target, test_probabilities,\n                                                                                        pos_label=1)\n        thresholds[0] -= 1  # Sklearn arbitrarily adds 1 to the first threshold\n        roc_auc = np.round(sklearn.metrics.auc(false_positive_rate, true_positive_rate), 3)\n\n        # Plot the curve\n        fig, ax = plt.subplots()\n        points = np.array([false_positive_rate, true_positive_rate]).T.reshape(-1, 1, 2)\n        segments = np.concatenate([points[:-1], points[1:]], axis=1)\n        norm = plt.Normalize(thresholds.min(), thresholds.max())\n        lc = matplotlib.collections.LineCollection(segments, cmap='jet', norm=norm, linewidths=2)\n        lc.set_array(thresholds)\n        line = ax.add_collection(lc)\n        fig.colorbar(line, ax=ax).set_label('Threshold')\n\n        # Padding to ensure we see the line\n        ax.margins(0.01)\n\n        plt.title(f\"ROC curve, AUC={roc_auc}\")\n        plt.xlabel(\"False Positive Rate\")\n        plt.ylabel(\"True Positive Rate\")\n        plt.tight_layout()\n        plt.savefig(\"my_roc_curve.png\", dpi=600)\n\n    # Predict\n    else:\n        # It might not make as much sense to draw a plot when predicting...\n        pass\n","name":"post_processing_roc_curve_sklearn.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   ROC Curve Generator                                             #\n#                                                                   #\n#   Computes and displays the Receiver Operating Characteristic     #\n#   (ROC) curve. This is restricted to binary classification tasks. #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\n\nimport matplotlib.collections\nimport matplotlib.pyplot as plt\nimport numpy as np\nimport settings\nimport sklearn.metrics\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        test_target = context.load(\"test_target\").flatten()\n        # Slice the first column because Sklearn's ROC curve prefers probabilities for the positive class\n        test_probabilities = context.load(\"test_probabilities\")[:, 1]\n\n        # Exit if there's more than one label in the predictions\n        if len(set(test_target)) > 2:\n            exit()\n\n        # ROC curve function in sklearn prefers the positive class\n        false_positive_rate, true_positive_rate, thresholds = sklearn.metrics.roc_curve(test_target, test_probabilities,\n                                                                                        pos_label=1)\n        thresholds[0] -= 1  # Sklearn arbitrarily adds 1 to the first threshold\n        roc_auc = np.round(sklearn.metrics.auc(false_positive_rate, true_positive_rate), 3)\n\n        # Plot the curve\n        fig, ax = plt.subplots()\n        points = np.array([false_positive_rate, true_positive_rate]).T.reshape(-1, 1, 2)\n        segments = np.concatenate([points[:-1], points[1:]], axis=1)\n        norm = plt.Normalize(thresholds.min(), thresholds.max())\n        lc = matplotlib.collections.LineCollection(segments, cmap='jet', norm=norm, linewidths=2)\n        lc.set_array(thresholds)\n        line = ax.add_collection(lc)\n        fig.colorbar(line, ax=ax).set_label('Threshold')\n\n        # Padding to ensure we see the line\n        ax.margins(0.01)\n\n        plt.title(f\"ROC curve, AUC={roc_auc}\")\n        plt.xlabel(\"False Positive Rate\")\n        plt.ylabel(\"True Positive Rate\")\n        plt.tight_layout()\n        plt.savefig(\"my_roc_curve.png\", dpi=600)\n\n    # Predict\n    else:\n        # It might not make as much sense to draw a plot when predicting...\n        pass\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Set Up the Job","type":"subworkflow","_id":"03e3f15b-2b22-5bb4-8bfd-6839d28a1ba9","status":"idle","statusTrack":[],"flowchartId":"5b51df93-15dd-5440-90fd-a3ffa264b7d8","tags":[],"head":true,"next":"90738aae-daac-599f-913f-29fb6acdff00"},{"name":"Machine Learning","type":"subworkflow","_id":"30acc5cd-54e6-5f05-aafd-413ee8a69aa1","status":"idle","statusTrack":[],"flowchartId":"90738aae-daac-599f-913f-29fb6acdff00","tags":[],"head":false}],"properties":[],"_id":"f447c6df-3b7b-5b8e-a0cc-1a743847ceed","workflows":[],"isUsingDataset":true,"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"python"}},"python/ml/clustering_workflow.json":{"name":"Python ML Train Clustering","subworkflows":[{"_id":"03e3f15b-2b22-5bb4-8bfd-6839d28a1ba9","name":"Set Up the Job","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"name":"Set Workflow Mode","type":"assignment","operand":"IS_WORKFLOW_RUNNING_TO_PREDICT","value":"False","input":[],"flowchartId":"head-set-predict-status","tags":["pyml:workflow-type-setter"],"status":"idle","statusTrack":[],"head":true,"next":"head-fetch-training-data","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Fetch Dataset","type":"io","subtype":"input","enableRender":true,"flowchartId":"head-fetch-training-data","input":[{"basename":"{{DATASET_BASENAME}}","objectData":{"CONTAINER":"","NAME":"{{DATASET_FILEPATH}}","PROVIDER":"","REGION":""}}],"source":"object_storage","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"head-branch-on-predict-status","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Train or Predict?","type":"condition","input":[{"name":"IS_WORKFLOW_RUNNING_TO_PREDICT","scope":"global"}],"results":[],"preProcessors":[],"postProcessors":[],"then":"head-fetch-trained-model","else":"end-of-ml-train-head","statement":"IS_WORKFLOW_RUNNING_TO_PREDICT","maxOccurrences":100,"flowchartId":"head-branch-on-predict-status","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"head-fetch-trained-model","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Fetch Trained Model as file","type":"io","subtype":"input","enableRender":true,"flowchartId":"head-fetch-trained-model","input":[{"basename":"","objectData":{"CONTAINER":"","NAME":"","PROVIDER":"","REGION":""}}],"source":"object_storage","tags":["set-io-unit-filenames"],"status":"idle","statusTrack":[],"head":false,"next":"end-of-ml-train-head","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"End Setup","type":"assignment","operand":"IS_SETUP_COMPLETE","value":"True","input":[],"flowchartId":"end-of-ml-train-head","status":"idle","statusTrack":[],"tags":[],"head":false,"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}}]},{"_id":"30acc5cd-54e6-5f05-aafd-413ee8a69aa1","name":"Machine Learning","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["workflow:pyml_predict","file_content"],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"Setup Variables and Packages","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"c3608488-0259-5ff4-8b90-11c6e60d6c85","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"settings.py","templateName":"pyml_settings.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:setup_variables_packages","schemaVersion":"2022.8.16","isDefault":false},"enableRender":true,"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   General settings for PythonML jobs on the Exabyte.io Platform   #\n#                                                                   #\n#   This file generally shouldn't be modified directly by users.    #\n#   The \"datafile\" and \"is_workflow_running_to_predict\" variables   #\n#   are defined in the head subworkflow, and are templated into     #\n#   this file. This helps facilitate the workflow's behavior        #\n#   differing whether it is in a \"train\" or \"predict\" mode.         #\n#                                                                   #\n#   Also in this file is the \"Context\" object, which helps maintain #\n#   certain Python objects between workflow units, and between      #\n#   predict runs.                                                   #\n#                                                                   #\n#   Whenever a python object needs to be stored for subsequent runs #\n#   (such as in the case of a trained model), context.save() can be #\n#   called to save it. The object can then be loaded again by using #\n#   context.load().                                                 #\n# ----------------------------------------------------------------- #\n\n\nimport os\nimport pickle\n\n# ==================================================\n# Variables modified in the Important Settings menu\n# ==================================================\n# Variables in this section can (and oftentimes need to) be modified by the user in the \"Important Settings\" tab\n# of a workflow.\n\n# Target_column_name is used during training to identify the variable the model is traing to predict.\n# For example, consider a CSV containing three columns, \"Y\", \"X1\", and \"X2\". If the goal is to train a model\n# that will predict the value of \"Y,\" then target_column_name would be set to \"Y\"\ntarget_column_name = \"{{ mlSettings.target_column_name }}\"\n\n# The type of ML problem being performed. Can be either \"regression\", \"classification,\" or \"clustering.\"\nproblem_category = \"{{ mlSettings.problem_category }}\"\n\n# =============================\n# Non user-modifiable variables\n# =============================\n# Variables in this section generally do not need to be modified.\n\n# The problem category, regression or classification or clustering. In regression, the target (predicted) variable\n# is continues. In classification, it is categorical. In clustering, there is no target - a set of labels is\n# automatically generated.\nis_regression = is_classification = is_clustering = False\nif problem_category.lower() == \"regression\":\n    is_regression = True\nelif problem_category.lower() == \"classification\":\n    is_classification = True\nelif problem_category.lower() == \"clustering\":\n    is_clustering = True\nelse:\n    raise ValueError(\n        \"Variable 'problem_category' must be either 'regression', 'classification', or 'clustering'. Check settings.py\")\n\n# The variables \"is_workflow_running_to_predict\" and \"is_workflow_running_to_train\" are used to control whether\n# the workflow is in a \"training\" mode or a \"prediction\" mode. The \"IS_WORKFLOW_RUNNING_TO_PREDICT\" variable is set by\n# an assignment unit in the \"Set Up the Job\" subworkflow that executes at the start of the job. It is automatically\n# changed when the predict workflow is generated, so users should not need to modify this variable.\nis_workflow_running_to_predict = {% raw %}{{IS_WORKFLOW_RUNNING_TO_PREDICT}}{% endraw %}\nis_workflow_running_to_train = not is_workflow_running_to_predict\n\n# Sets the datafile variable. The \"datafile\" is the data that will be read in, and will be used by subsequent\n# workflow units for either training or prediction, depending on the workflow mode.\nif is_workflow_running_to_predict:\n    datafile = \"{% raw %}{{DATASET_BASENAME}}{% endraw %}\"\nelse:\n    datafile = \"{% raw %}{{DATASET_BASENAME}}{% endraw %}\"\n\n# The \"Context\" class allows for data to be saved and loaded between units, and between train and predict runs.\n# Variables which have been saved using the \"Save\" method are written to disk, and the predict workflow is automatically\n# configured to obtain these files when it starts.\n#\n# IMPORTANT NOTE: Do *not* adjust the value of \"context_dir_pathname\" in the Context object. If the value is changed, then\n# files will not be correctly copied into the generated predict workflow. This will cause the predict workflow to be\n# generated in a broken state, and it will not be able to make any predictions.\nclass Context(object):\n    \"\"\"\n    Saves and loads objects from the disk, useful for preserving data between workflow units\n\n    Attributes:\n        context_paths (dict): Dictionary of the format {variable_name: path}, that governs where\n                              pickle saves files.\n\n    Methods:\n        save: Used to save objects to the context directory\n        load: Used to load objects from the context directory\n    \"\"\"\n\n    def __init__(self, context_file_basename=\"workflow_context_file_mapping\"):\n        \"\"\"\n        Constructor for Context objects\n\n        Args:\n            context_file_basename (str): Name of the file to store context paths in\n        \"\"\"\n\n        # Warning: DO NOT modify the context_dir_pathname variable below\n        # vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv\n        context_dir_pathname = \"{% raw %}{{ CONTEXT_DIR_RELATIVE_PATH }}{% endraw %}\"\n        # ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n        self._context_dir_pathname = context_dir_pathname\n        self._context_file = os.path.join(context_dir_pathname, context_file_basename)\n\n        # Make context dir if it does not exist\n        if not os.path.exists(context_dir_pathname):\n            os.makedirs(context_dir_pathname)\n\n        # Read in the context sources dictionary, if it exists\n        if os.path.exists(self._context_file):\n            with open(self._context_file, \"rb\") as file_handle:\n                self.context_paths: dict = pickle.load(file_handle)\n        else:\n            # Items is a dictionary of {varname: path}\n            self.context_paths = {}\n\n    def __enter__(self):\n        return self\n\n    def __exit__(self, exc_type, exc_value, traceback):\n        self._update_context()\n\n    def __contains__(self, item):\n        return item in self.context_paths\n\n    def _update_context(self):\n        with open(self._context_file, \"wb\") as file_handle:\n            pickle.dump(self.context_paths, file_handle)\n\n    def load(self, name: str):\n        \"\"\"\n        Returns a contextd object\n\n        Args:\n            name (str): The name in self.context_paths of the object\n        \"\"\"\n        path = self.context_paths[name]\n        with open(path, \"rb\") as file_handle:\n            obj = pickle.load(file_handle)\n        return obj\n\n    def save(self, obj: object, name: str):\n        \"\"\"\n        Saves an object to disk using pickle\n\n        Args:\n            name (str): Friendly name for the object, used for lookup in load() method\n            obj (object): Object to store on disk\n        \"\"\"\n        path = os.path.join(self._context_dir_pathname, f\"{name}.pkl\")\n        self.context_paths[name] = path\n        with open(path, \"wb\") as file_handle:\n            pickle.dump(obj, file_handle)\n        self._update_context()\n\n# Generate a context object, so that the \"with settings.context\" can be used by other units in this workflow.\ncontext = Context()\n\nis_using_train_test_split = \"is_using_train_test_split\" in context and (context.load(\"is_using_train_test_split\"))\n\n# Create a Class for a DummyScaler()\nclass DummyScaler:\n    \"\"\"\n    This class is a 'DummyScaler' which trivially acts on data by returning it unchanged.\n    \"\"\"\n\n    def fit(self, X):\n        return self\n\n    def transform(self, X):\n        return X\n\n    def fit_transform(self, X):\n        return X\n\n    def inverse_transform(self, X):\n        return X\n\nif 'target_scaler' not in context:\n    context.save(DummyScaler(), 'target_scaler')\n","name":"settings.py","contextProviders":[{"name":"MLSettingsDataManager"}],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   General settings for PythonML jobs on the Exabyte.io Platform   #\n#                                                                   #\n#   This file generally shouldn't be modified directly by users.    #\n#   The \"datafile\" and \"is_workflow_running_to_predict\" variables   #\n#   are defined in the head subworkflow, and are templated into     #\n#   this file. This helps facilitate the workflow's behavior        #\n#   differing whether it is in a \"train\" or \"predict\" mode.         #\n#                                                                   #\n#   Also in this file is the \"Context\" object, which helps maintain #\n#   certain Python objects between workflow units, and between      #\n#   predict runs.                                                   #\n#                                                                   #\n#   Whenever a python object needs to be stored for subsequent runs #\n#   (such as in the case of a trained model), context.save() can be #\n#   called to save it. The object can then be loaded again by using #\n#   context.load().                                                 #\n# ----------------------------------------------------------------- #\n\n\nimport os\nimport pickle\n\n# ==================================================\n# Variables modified in the Important Settings menu\n# ==================================================\n# Variables in this section can (and oftentimes need to) be modified by the user in the \"Important Settings\" tab\n# of a workflow.\n\n# Target_column_name is used during training to identify the variable the model is traing to predict.\n# For example, consider a CSV containing three columns, \"Y\", \"X1\", and \"X2\". If the goal is to train a model\n# that will predict the value of \"Y,\" then target_column_name would be set to \"Y\"\ntarget_column_name = \"target\"\n\n# The type of ML problem being performed. Can be either \"regression\", \"classification,\" or \"clustering.\"\nproblem_category = \"regression\"\n\n# =============================\n# Non user-modifiable variables\n# =============================\n# Variables in this section generally do not need to be modified.\n\n# The problem category, regression or classification or clustering. In regression, the target (predicted) variable\n# is continues. In classification, it is categorical. In clustering, there is no target - a set of labels is\n# automatically generated.\nis_regression = is_classification = is_clustering = False\nif problem_category.lower() == \"regression\":\n    is_regression = True\nelif problem_category.lower() == \"classification\":\n    is_classification = True\nelif problem_category.lower() == \"clustering\":\n    is_clustering = True\nelse:\n    raise ValueError(\n        \"Variable 'problem_category' must be either 'regression', 'classification', or 'clustering'. Check settings.py\")\n\n# The variables \"is_workflow_running_to_predict\" and \"is_workflow_running_to_train\" are used to control whether\n# the workflow is in a \"training\" mode or a \"prediction\" mode. The \"IS_WORKFLOW_RUNNING_TO_PREDICT\" variable is set by\n# an assignment unit in the \"Set Up the Job\" subworkflow that executes at the start of the job. It is automatically\n# changed when the predict workflow is generated, so users should not need to modify this variable.\nis_workflow_running_to_predict = {{IS_WORKFLOW_RUNNING_TO_PREDICT}}\nis_workflow_running_to_train = not is_workflow_running_to_predict\n\n# Sets the datafile variable. The \"datafile\" is the data that will be read in, and will be used by subsequent\n# workflow units for either training or prediction, depending on the workflow mode.\nif is_workflow_running_to_predict:\n    datafile = \"{{DATASET_BASENAME}}\"\nelse:\n    datafile = \"{{DATASET_BASENAME}}\"\n\n# The \"Context\" class allows for data to be saved and loaded between units, and between train and predict runs.\n# Variables which have been saved using the \"Save\" method are written to disk, and the predict workflow is automatically\n# configured to obtain these files when it starts.\n#\n# IMPORTANT NOTE: Do *not* adjust the value of \"context_dir_pathname\" in the Context object. If the value is changed, then\n# files will not be correctly copied into the generated predict workflow. This will cause the predict workflow to be\n# generated in a broken state, and it will not be able to make any predictions.\nclass Context(object):\n    \"\"\"\n    Saves and loads objects from the disk, useful for preserving data between workflow units\n\n    Attributes:\n        context_paths (dict): Dictionary of the format {variable_name: path}, that governs where\n                              pickle saves files.\n\n    Methods:\n        save: Used to save objects to the context directory\n        load: Used to load objects from the context directory\n    \"\"\"\n\n    def __init__(self, context_file_basename=\"workflow_context_file_mapping\"):\n        \"\"\"\n        Constructor for Context objects\n\n        Args:\n            context_file_basename (str): Name of the file to store context paths in\n        \"\"\"\n\n        # Warning: DO NOT modify the context_dir_pathname variable below\n        # vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv\n        context_dir_pathname = \"{{ CONTEXT_DIR_RELATIVE_PATH }}\"\n        # ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n        self._context_dir_pathname = context_dir_pathname\n        self._context_file = os.path.join(context_dir_pathname, context_file_basename)\n\n        # Make context dir if it does not exist\n        if not os.path.exists(context_dir_pathname):\n            os.makedirs(context_dir_pathname)\n\n        # Read in the context sources dictionary, if it exists\n        if os.path.exists(self._context_file):\n            with open(self._context_file, \"rb\") as file_handle:\n                self.context_paths: dict = pickle.load(file_handle)\n        else:\n            # Items is a dictionary of {varname: path}\n            self.context_paths = {}\n\n    def __enter__(self):\n        return self\n\n    def __exit__(self, exc_type, exc_value, traceback):\n        self._update_context()\n\n    def __contains__(self, item):\n        return item in self.context_paths\n\n    def _update_context(self):\n        with open(self._context_file, \"wb\") as file_handle:\n            pickle.dump(self.context_paths, file_handle)\n\n    def load(self, name: str):\n        \"\"\"\n        Returns a contextd object\n\n        Args:\n            name (str): The name in self.context_paths of the object\n        \"\"\"\n        path = self.context_paths[name]\n        with open(path, \"rb\") as file_handle:\n            obj = pickle.load(file_handle)\n        return obj\n\n    def save(self, obj: object, name: str):\n        \"\"\"\n        Saves an object to disk using pickle\n\n        Args:\n            name (str): Friendly name for the object, used for lookup in load() method\n            obj (object): Object to store on disk\n        \"\"\"\n        path = os.path.join(self._context_dir_pathname, f\"{name}.pkl\")\n        self.context_paths[name] = path\n        with open(path, \"wb\") as file_handle:\n            pickle.dump(obj, file_handle)\n        self._update_context()\n\n# Generate a context object, so that the \"with settings.context\" can be used by other units in this workflow.\ncontext = Context()\n\nis_using_train_test_split = \"is_using_train_test_split\" in context and (context.load(\"is_using_train_test_split\"))\n\n# Create a Class for a DummyScaler()\nclass DummyScaler:\n    \"\"\"\n    This class is a 'DummyScaler' which trivially acts on data by returning it unchanged.\n    \"\"\"\n\n    def fit(self, X):\n        return self\n\n    def transform(self, X):\n        return X\n\n    def fit_transform(self, X):\n        return X\n\n    def inverse_transform(self, X):\n        return X\n\nif 'target_scaler' not in context:\n    context.save(DummyScaler(), 'target_scaler')\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"cb69ea2a-7efc-56b4-8bbe-0de1e70c49e3"},{"type":"execution","name":"Data Input","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"cb69ea2a-7efc-56b4-8bbe-0de1e70c49e3","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"data_input_read_csv_pandas.py","templateName":"data_input_read_csv_pandas.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:data_input:read_csv:pandas","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Workflow Unit to read in data for the ML workflow.              #\n#                                                                   #\n#   Also showcased here is the concept of branching based on        #\n#   whether the workflow is in \"train\" or \"predict\" mode.           #\n#                                                                   #\n#   If the workflow is in \"training\" mode, it will read in the data #\n#   before converting it to a Numpy array and save it for use       #\n#   later. During training, we already have values for the output,  #\n#   and this gets saved to \"target.\"                                #\n#                                                                   #\n#   Finally, whether the workflow is in training or predict mode,   #\n#   it will always read in a set of descriptors from a datafile     #\n#   defined in settings.py                                          #\n# ----------------------------------------------------------------- #\n\n\nimport pandas\nimport settings\nimport sklearn.preprocessing\n\nwith settings.context as context:\n    data = pandas.read_csv(settings.datafile)\n\n    # Train\n    # By default, we don't do train/test splitting: the train and test represent the same dataset at first.\n    # Other units (such as a train/test splitter) down the line can adjust this as-needed.\n    if settings.is_workflow_running_to_train:\n\n        # Handle the case where we are clustering\n        if settings.is_clustering:\n            target = data.to_numpy()[:, 0]  # Just get the first column, it's not going to get used anyway\n        else:\n            target = data.pop(settings.target_column_name).to_numpy()\n\n        # Handle the case where we are classifying. In this case, we must convert any labels provided to be categorical.\n        # Specifically, labels are encoded with values between 0 and (N_Classes - 1)\n        if settings.is_classification:\n            label_encoder = sklearn.preprocessing.LabelEncoder()\n            target = label_encoder.fit_transform(target)\n            context.save(label_encoder, \"label_encoder\")\n\n        target = target.reshape(-1, 1)  # Reshape array from a row vector into a column vector\n\n        context.save(target, \"train_target\")\n        context.save(target, \"test_target\")\n\n        descriptors = data.to_numpy()\n\n        context.save(descriptors, \"train_descriptors\")\n        context.save(descriptors, \"test_descriptors\")\n\n    else:\n        descriptors = data.to_numpy()\n        context.save(descriptors, \"descriptors\")\n","name":"data_input_read_csv_pandas.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Workflow Unit to read in data for the ML workflow.              #\n#                                                                   #\n#   Also showcased here is the concept of branching based on        #\n#   whether the workflow is in \"train\" or \"predict\" mode.           #\n#                                                                   #\n#   If the workflow is in \"training\" mode, it will read in the data #\n#   before converting it to a Numpy array and save it for use       #\n#   later. During training, we already have values for the output,  #\n#   and this gets saved to \"target.\"                                #\n#                                                                   #\n#   Finally, whether the workflow is in training or predict mode,   #\n#   it will always read in a set of descriptors from a datafile     #\n#   defined in settings.py                                          #\n# ----------------------------------------------------------------- #\n\n\nimport pandas\nimport settings\nimport sklearn.preprocessing\n\nwith settings.context as context:\n    data = pandas.read_csv(settings.datafile)\n\n    # Train\n    # By default, we don't do train/test splitting: the train and test represent the same dataset at first.\n    # Other units (such as a train/test splitter) down the line can adjust this as-needed.\n    if settings.is_workflow_running_to_train:\n\n        # Handle the case where we are clustering\n        if settings.is_clustering:\n            target = data.to_numpy()[:, 0]  # Just get the first column, it's not going to get used anyway\n        else:\n            target = data.pop(settings.target_column_name).to_numpy()\n\n        # Handle the case where we are classifying. In this case, we must convert any labels provided to be categorical.\n        # Specifically, labels are encoded with values between 0 and (N_Classes - 1)\n        if settings.is_classification:\n            label_encoder = sklearn.preprocessing.LabelEncoder()\n            target = label_encoder.fit_transform(target)\n            context.save(label_encoder, \"label_encoder\")\n\n        target = target.reshape(-1, 1)  # Reshape array from a row vector into a column vector\n\n        context.save(target, \"train_target\")\n        context.save(target, \"test_target\")\n\n        descriptors = data.to_numpy()\n\n        context.save(descriptors, \"train_descriptors\")\n        context.save(descriptors, \"test_descriptors\")\n\n    else:\n        descriptors = data.to_numpy()\n        context.save(descriptors, \"descriptors\")\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"7fff5212-6c6d-586b-9997-4d4485e09383"},{"type":"execution","name":"Train Test Split","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"7fff5212-6c6d-586b-9997-4d4485e09383","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"data_input_train_test_split_sklearn.py","templateName":"data_input_train_test_split_sklearn.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:data_input:train_test_split:sklearn","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Workflow Unit to perform a train/test split                     #\n#                                                                   #\n#   Splits the dataset into a training and testing set. The         #\n#   variable `percent_held_as_test` controls how much of the        #\n#   input dataset is removed for use as a testing set. By default,  #\n#   this unit puts 20% of the dataset into the testing set, and     #\n#   places the remaining 80% into the training set.                 #\n#                                                                   #\n#   Does nothing in the case of predictions.                        #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nimport numpy as np\nimport settings\nimport sklearn.model_selection\n\n# `percent_held_as_test` is the amount of the dataset held out as the testing set. If it is set to 0.2,\n# then 20% of the dataset is held out as a testing set. The remaining 80% is the training set.\npercent_held_as_test = {{ mlTrainTestSplit.fraction_held_as_test_set }}\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Load training data\n        train_target = context.load(\"train_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n\n        # Combine datasets to facilitate train/test split\n\n        # Do train/test split\n        train_descriptors, test_descriptors, train_target, test_target = sklearn.model_selection.train_test_split(\n            train_descriptors, train_target, test_size=percent_held_as_test)\n\n        # Set the flag for using a train/test split\n        context.save(True, \"is_using_train_test_split\")\n\n        # Save training data\n        context.save(train_target, \"train_target\")\n        context.save(train_descriptors, \"train_descriptors\")\n        context.save(test_target, \"test_target\")\n        context.save(test_descriptors, \"test_descriptors\")\n\n    # Predict\n    else:\n        pass\n","name":"data_input_train_test_split_sklearn.py","contextProviders":[{"name":"MLTrainTestSplitDataManager"}],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Workflow Unit to perform a train/test split                     #\n#                                                                   #\n#   Splits the dataset into a training and testing set. The         #\n#   variable `percent_held_as_test` controls how much of the        #\n#   input dataset is removed for use as a testing set. By default,  #\n#   this unit puts 20% of the dataset into the testing set, and     #\n#   places the remaining 80% into the training set.                 #\n#                                                                   #\n#   Does nothing in the case of predictions.                        #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nimport numpy as np\nimport settings\nimport sklearn.model_selection\n\n# `percent_held_as_test` is the amount of the dataset held out as the testing set. If it is set to 0.2,\n# then 20% of the dataset is held out as a testing set. The remaining 80% is the training set.\npercent_held_as_test = 0.2\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Load training data\n        train_target = context.load(\"train_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n\n        # Combine datasets to facilitate train/test split\n\n        # Do train/test split\n        train_descriptors, test_descriptors, train_target, test_target = sklearn.model_selection.train_test_split(\n            train_descriptors, train_target, test_size=percent_held_as_test)\n\n        # Set the flag for using a train/test split\n        context.save(True, \"is_using_train_test_split\")\n\n        # Save training data\n        context.save(train_target, \"train_target\")\n        context.save(train_descriptors, \"train_descriptors\")\n        context.save(test_target, \"test_target\")\n        context.save(test_descriptors, \"test_descriptors\")\n\n    # Predict\n    else:\n        pass\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"799de7dc-9394-571b-8e0d-3ff876a3df02"},{"type":"execution","name":"Data Standardize","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"799de7dc-9394-571b-8e0d-3ff876a3df02","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pre_processing_standardization_sklearn.py","templateName":"pre_processing_standardization_sklearn.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:pre_processing:standardization:sklearn","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Sklearn Standard Scaler workflow unit                           #\n#                                                                   #\n#   This workflow unit scales the data such that it a mean of 0 and #\n#   a standard deviation of 1. It then saves the data for use       #\n#   further down the road in the workflow, for use in               #\n#   un-transforming the data.                                       #\n#                                                                   #\n#   It is important that new predictions are made by scaling the    #\n#   new inputs using the mean and variance of the original training #\n#   set. As a result, the scaler gets saved in the Training phase.  #\n#                                                                   #\n#   During a predict workflow, the scaler is loaded, and the        #\n#   new examples are scaled using the stored scaler.                #\n# ----------------------------------------------------------------- #\n\n\nimport settings\nimport sklearn.preprocessing\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n        test_target = context.load(\"test_target\")\n        test_descriptors = context.load(\"test_descriptors\")\n\n        # Descriptor Scaler\n        scaler = sklearn.preprocessing.StandardScaler\n        descriptor_scaler = scaler()\n        train_descriptors = descriptor_scaler.fit_transform(train_descriptors)\n        test_descriptors = descriptor_scaler.transform(test_descriptors)\n        context.save(descriptor_scaler, \"descriptor_scaler\")\n        context.save(train_descriptors, \"train_descriptors\")\n        context.save(test_descriptors, \"test_descriptors\")\n\n        # Our target is only continuous if it's a regression problem\n        if settings.is_regression:\n            target_scaler = scaler()\n            train_target = target_scaler.fit_transform(train_target)\n            test_target = target_scaler.transform(test_target)\n            context.save(target_scaler, \"target_scaler\")\n            context.save(train_target, \"train_target\")\n            context.save(test_target, \"test_target\")\n\n    # Predict\n    else:\n        # Restore data\n        descriptors = context.load(\"descriptors\")\n\n        # Get the scaler\n        descriptor_scaler = context.load(\"descriptor_scaler\")\n\n        # Scale the data\n        descriptors = descriptor_scaler.transform(descriptors)\n\n        # Store the data\n        context.save(descriptors, \"descriptors\")\n","name":"pre_processing_standardization_sklearn.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Sklearn Standard Scaler workflow unit                           #\n#                                                                   #\n#   This workflow unit scales the data such that it a mean of 0 and #\n#   a standard deviation of 1. It then saves the data for use       #\n#   further down the road in the workflow, for use in               #\n#   un-transforming the data.                                       #\n#                                                                   #\n#   It is important that new predictions are made by scaling the    #\n#   new inputs using the mean and variance of the original training #\n#   set. As a result, the scaler gets saved in the Training phase.  #\n#                                                                   #\n#   During a predict workflow, the scaler is loaded, and the        #\n#   new examples are scaled using the stored scaler.                #\n# ----------------------------------------------------------------- #\n\n\nimport settings\nimport sklearn.preprocessing\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n        test_target = context.load(\"test_target\")\n        test_descriptors = context.load(\"test_descriptors\")\n\n        # Descriptor Scaler\n        scaler = sklearn.preprocessing.StandardScaler\n        descriptor_scaler = scaler()\n        train_descriptors = descriptor_scaler.fit_transform(train_descriptors)\n        test_descriptors = descriptor_scaler.transform(test_descriptors)\n        context.save(descriptor_scaler, \"descriptor_scaler\")\n        context.save(train_descriptors, \"train_descriptors\")\n        context.save(test_descriptors, \"test_descriptors\")\n\n        # Our target is only continuous if it's a regression problem\n        if settings.is_regression:\n            target_scaler = scaler()\n            train_target = target_scaler.fit_transform(train_target)\n            test_target = target_scaler.transform(test_target)\n            context.save(target_scaler, \"target_scaler\")\n            context.save(train_target, \"train_target\")\n            context.save(test_target, \"test_target\")\n\n    # Predict\n    else:\n        # Restore data\n        descriptors = context.load(\"descriptors\")\n\n        # Get the scaler\n        descriptor_scaler = context.load(\"descriptor_scaler\")\n\n        # Scale the data\n        descriptors = descriptor_scaler.transform(descriptors)\n\n        # Store the data\n        context.save(descriptors, \"descriptors\")\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"8dfc61c3-067d-5ea8-bd26-7296628d707a"},{"type":"execution","name":"Model Train and Predict","head":false,"results":[{"name":"workflow:pyml_predict"}],"monitors":[{"name":"standard_output"}],"flowchartId":"8dfc61c3-067d-5ea8-bd26-7296628d707a","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"model_random_forest_classification_sklearn.py","templateName":"model_random_forest_classification_sklearn.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"results":["workflow:pyml_predict"],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:model:random_forest_classification:sklearn","schemaVersion":"2022.8.16","isDefault":false},"tags":["remove-all-results","creates-predictions-csv-during-predict-phase"],"status":"idle","statusTrack":[],"input":[{"content":"# ------------------------------------------------------------ #\n# Workflow unit for a random forest classification model with  #\n# Scikit-Learn. Parameters derived from Scikit-Learn's         #\n# defaults.                                                    #\n#                                                              #\n# When then workflow is in Training mode, the model is trained #\n# and then it is saved, along with the confusion matrix. When  #\n# the workflow is run in Predict mode, the model is loaded,    #\n# predictions are made, they are un-transformed using the      #\n# trained scaler from the training run, and they are written   #\n# to a filee named \"predictions.csv\"                           #\n# ------------------------------------------------------------ #\n\n\nimport numpy as np\nimport settings\nimport sklearn.ensemble\nimport sklearn.metrics\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        test_target = context.load(\"test_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n        test_descriptors = context.load(\"test_descriptors\")\n\n        # Flatten the targets\n        train_target = train_target.flatten()\n        test_target = test_target.flatten()\n\n        # Initialize the Model\n        model = sklearn.ensemble.RandomForestClassifier(\n            n_estimators=100,\n            criterion=\"gini\",\n            max_depth=None,\n            min_samples_split=2,\n            min_samples_leaf=1,\n            min_weight_fraction_leaf=0.0,\n            max_features=\"auto\",\n            max_leaf_nodes=None,\n            min_impurity_decrease=0.0,\n            bootstrap=True,\n            oob_score=False,\n            verbose=0,\n            class_weight=None,\n            ccp_alpha=0.0,\n            max_samples=None,\n        )\n\n        # Train the model and save\n        model.fit(train_descriptors, train_target)\n        context.save(model, \"random_forest\")\n        train_predictions = model.predict(train_descriptors)\n        test_predictions = model.predict(test_descriptors)\n\n        # Save the probabilities of the model\n        test_probabilities = model.predict_proba(test_descriptors)\n        context.save(test_probabilities, \"test_probabilities\")\n\n        # Print some information to the screen for the regression problem\n        confusion_matrix = sklearn.metrics.confusion_matrix(test_target, test_predictions)\n        print(\"Confusion Matrix:\")\n        print(confusion_matrix)\n        context.save(confusion_matrix, \"confusion_matrix\")\n\n        context.save(train_predictions, \"train_predictions\")\n        context.save(test_predictions, \"test_predictions\")\n\n    # Predict\n    else:\n        # Restore data\n        descriptors = context.load(\"descriptors\")\n\n        # Restore model\n        model = context.load(\"random_forest\")\n\n        # Make some predictions\n        predictions = model.predict(descriptors)\n\n        # Transform predictions back to their original labels\n        label_encoder: sklearn.preprocessing.LabelEncoder = context.load(\"label_encoder\")\n        predictions = label_encoder.inverse_transform(predictions)\n\n        # Save the predictions to file\n        np.savetxt(\"predictions.csv\", predictions, header=\"prediction\", comments=\"\", fmt=\"%s\")\n","name":"model_random_forest_classification_sklearn.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ------------------------------------------------------------ #\n# Workflow unit for a random forest classification model with  #\n# Scikit-Learn. Parameters derived from Scikit-Learn's         #\n# defaults.                                                    #\n#                                                              #\n# When then workflow is in Training mode, the model is trained #\n# and then it is saved, along with the confusion matrix. When  #\n# the workflow is run in Predict mode, the model is loaded,    #\n# predictions are made, they are un-transformed using the      #\n# trained scaler from the training run, and they are written   #\n# to a filee named \"predictions.csv\"                           #\n# ------------------------------------------------------------ #\n\n\nimport numpy as np\nimport settings\nimport sklearn.ensemble\nimport sklearn.metrics\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        test_target = context.load(\"test_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n        test_descriptors = context.load(\"test_descriptors\")\n\n        # Flatten the targets\n        train_target = train_target.flatten()\n        test_target = test_target.flatten()\n\n        # Initialize the Model\n        model = sklearn.ensemble.RandomForestClassifier(\n            n_estimators=100,\n            criterion=\"gini\",\n            max_depth=None,\n            min_samples_split=2,\n            min_samples_leaf=1,\n            min_weight_fraction_leaf=0.0,\n            max_features=\"auto\",\n            max_leaf_nodes=None,\n            min_impurity_decrease=0.0,\n            bootstrap=True,\n            oob_score=False,\n            verbose=0,\n            class_weight=None,\n            ccp_alpha=0.0,\n            max_samples=None,\n        )\n\n        # Train the model and save\n        model.fit(train_descriptors, train_target)\n        context.save(model, \"random_forest\")\n        train_predictions = model.predict(train_descriptors)\n        test_predictions = model.predict(test_descriptors)\n\n        # Save the probabilities of the model\n        test_probabilities = model.predict_proba(test_descriptors)\n        context.save(test_probabilities, \"test_probabilities\")\n\n        # Print some information to the screen for the regression problem\n        confusion_matrix = sklearn.metrics.confusion_matrix(test_target, test_predictions)\n        print(\"Confusion Matrix:\")\n        print(confusion_matrix)\n        context.save(confusion_matrix, \"confusion_matrix\")\n\n        context.save(train_predictions, \"train_predictions\")\n        context.save(test_predictions, \"test_predictions\")\n\n    # Predict\n    else:\n        # Restore data\n        descriptors = context.load(\"descriptors\")\n\n        # Restore model\n        model = context.load(\"random_forest\")\n\n        # Make some predictions\n        predictions = model.predict(descriptors)\n\n        # Transform predictions back to their original labels\n        label_encoder: sklearn.preprocessing.LabelEncoder = context.load(\"label_encoder\")\n        predictions = label_encoder.inverse_transform(predictions)\n\n        # Save the predictions to file\n        np.savetxt(\"predictions.csv\", predictions, header=\"prediction\", comments=\"\", fmt=\"%s\")\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"35436b4a-cd9c-5089-ab42-665c4f9ba049"},{"type":"execution","name":"ROC Curve Plot","head":false,"results":[{"basename":"my_roc_plot.png","filetype":"image","name":"file_content"}],"monitors":[{"name":"standard_output"}],"flowchartId":"35436b4a-cd9c-5089-ab42-665c4f9ba049","preProcessors":[],"postProcessors":[{"name":"remove_virtual_environment"}],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"post_processing_roc_curve_sklearn.py","templateName":"post_processing_roc_curve_sklearn.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"results":["file_content"],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:post_processing:roc_curve:sklearn","schemaVersion":"2022.8.16","isDefault":false},"tags":["remove-all-results"],"status":"idle","statusTrack":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   ROC Curve Generator                                             #\n#                                                                   #\n#   Computes and displays the Receiver Operating Characteristic     #\n#   (ROC) curve. This is restricted to binary classification tasks. #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\n\nimport matplotlib.collections\nimport matplotlib.pyplot as plt\nimport numpy as np\nimport settings\nimport sklearn.metrics\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        test_target = context.load(\"test_target\").flatten()\n        # Slice the first column because Sklearn's ROC curve prefers probabilities for the positive class\n        test_probabilities = context.load(\"test_probabilities\")[:, 1]\n\n        # Exit if there's more than one label in the predictions\n        if len(set(test_target)) > 2:\n            exit()\n\n        # ROC curve function in sklearn prefers the positive class\n        false_positive_rate, true_positive_rate, thresholds = sklearn.metrics.roc_curve(test_target, test_probabilities,\n                                                                                        pos_label=1)\n        thresholds[0] -= 1  # Sklearn arbitrarily adds 1 to the first threshold\n        roc_auc = np.round(sklearn.metrics.auc(false_positive_rate, true_positive_rate), 3)\n\n        # Plot the curve\n        fig, ax = plt.subplots()\n        points = np.array([false_positive_rate, true_positive_rate]).T.reshape(-1, 1, 2)\n        segments = np.concatenate([points[:-1], points[1:]], axis=1)\n        norm = plt.Normalize(thresholds.min(), thresholds.max())\n        lc = matplotlib.collections.LineCollection(segments, cmap='jet', norm=norm, linewidths=2)\n        lc.set_array(thresholds)\n        line = ax.add_collection(lc)\n        fig.colorbar(line, ax=ax).set_label('Threshold')\n\n        # Padding to ensure we see the line\n        ax.margins(0.01)\n\n        plt.title(f\"ROC curve, AUC={roc_auc}\")\n        plt.xlabel(\"False Positive Rate\")\n        plt.ylabel(\"True Positive Rate\")\n        plt.tight_layout()\n        plt.savefig(\"my_roc_curve.png\", dpi=600)\n\n    # Predict\n    else:\n        # It might not make as much sense to draw a plot when predicting...\n        pass\n","name":"post_processing_roc_curve_sklearn.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   ROC Curve Generator                                             #\n#                                                                   #\n#   Computes and displays the Receiver Operating Characteristic     #\n#   (ROC) curve. This is restricted to binary classification tasks. #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\n\nimport matplotlib.collections\nimport matplotlib.pyplot as plt\nimport numpy as np\nimport settings\nimport sklearn.metrics\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        test_target = context.load(\"test_target\").flatten()\n        # Slice the first column because Sklearn's ROC curve prefers probabilities for the positive class\n        test_probabilities = context.load(\"test_probabilities\")[:, 1]\n\n        # Exit if there's more than one label in the predictions\n        if len(set(test_target)) > 2:\n            exit()\n\n        # ROC curve function in sklearn prefers the positive class\n        false_positive_rate, true_positive_rate, thresholds = sklearn.metrics.roc_curve(test_target, test_probabilities,\n                                                                                        pos_label=1)\n        thresholds[0] -= 1  # Sklearn arbitrarily adds 1 to the first threshold\n        roc_auc = np.round(sklearn.metrics.auc(false_positive_rate, true_positive_rate), 3)\n\n        # Plot the curve\n        fig, ax = plt.subplots()\n        points = np.array([false_positive_rate, true_positive_rate]).T.reshape(-1, 1, 2)\n        segments = np.concatenate([points[:-1], points[1:]], axis=1)\n        norm = plt.Normalize(thresholds.min(), thresholds.max())\n        lc = matplotlib.collections.LineCollection(segments, cmap='jet', norm=norm, linewidths=2)\n        lc.set_array(thresholds)\n        line = ax.add_collection(lc)\n        fig.colorbar(line, ax=ax).set_label('Threshold')\n\n        # Padding to ensure we see the line\n        ax.margins(0.01)\n\n        plt.title(f\"ROC curve, AUC={roc_auc}\")\n        plt.xlabel(\"False Positive Rate\")\n        plt.ylabel(\"True Positive Rate\")\n        plt.tight_layout()\n        plt.savefig(\"my_roc_curve.png\", dpi=600)\n\n    # Predict\n    else:\n        # It might not make as much sense to draw a plot when predicting...\n        pass\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Set Up the Job","type":"subworkflow","_id":"03e3f15b-2b22-5bb4-8bfd-6839d28a1ba9","status":"idle","statusTrack":[],"flowchartId":"5b51df93-15dd-5440-90fd-a3ffa264b7d8","tags":[],"head":true,"next":"90738aae-daac-599f-913f-29fb6acdff00"},{"name":"Machine Learning","type":"subworkflow","_id":"30acc5cd-54e6-5f05-aafd-413ee8a69aa1","status":"idle","statusTrack":[],"flowchartId":"90738aae-daac-599f-913f-29fb6acdff00","tags":[],"head":false}],"properties":[],"_id":"f447c6df-3b7b-5b8e-a0cc-1a743847ceed","workflows":[],"isUsingDataset":true,"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"python"}},"python/ml/regression_workflow.json":{"name":"Python ML Train Regression","subworkflows":[{"_id":"03e3f15b-2b22-5bb4-8bfd-6839d28a1ba9","name":"Set Up the Job","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"name":"Set Workflow Mode","type":"assignment","operand":"IS_WORKFLOW_RUNNING_TO_PREDICT","value":"False","input":[],"flowchartId":"head-set-predict-status","tags":["pyml:workflow-type-setter"],"status":"idle","statusTrack":[],"head":true,"next":"head-fetch-training-data","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Fetch Dataset","type":"io","subtype":"input","enableRender":true,"flowchartId":"head-fetch-training-data","input":[{"basename":"{{DATASET_BASENAME}}","objectData":{"CONTAINER":"","NAME":"{{DATASET_FILEPATH}}","PROVIDER":"","REGION":""}}],"source":"object_storage","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"head-branch-on-predict-status","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Train or Predict?","type":"condition","input":[{"name":"IS_WORKFLOW_RUNNING_TO_PREDICT","scope":"global"}],"results":[],"preProcessors":[],"postProcessors":[],"then":"head-fetch-trained-model","else":"end-of-ml-train-head","statement":"IS_WORKFLOW_RUNNING_TO_PREDICT","maxOccurrences":100,"flowchartId":"head-branch-on-predict-status","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"head-fetch-trained-model","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Fetch Trained Model as file","type":"io","subtype":"input","enableRender":true,"flowchartId":"head-fetch-trained-model","input":[{"basename":"","objectData":{"CONTAINER":"","NAME":"","PROVIDER":"","REGION":""}}],"source":"object_storage","tags":["set-io-unit-filenames"],"status":"idle","statusTrack":[],"head":false,"next":"end-of-ml-train-head","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"End Setup","type":"assignment","operand":"IS_SETUP_COMPLETE","value":"True","input":[],"flowchartId":"end-of-ml-train-head","status":"idle","statusTrack":[],"tags":[],"head":false,"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"}}]},{"_id":"30acc5cd-54e6-5f05-aafd-413ee8a69aa1","name":"Machine Learning","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["workflow:pyml_predict","file_content"],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"Setup Variables and Packages","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"c3608488-0259-5ff4-8b90-11c6e60d6c85","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"settings.py","templateName":"pyml_settings.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:setup_variables_packages","schemaVersion":"2022.8.16","isDefault":false},"enableRender":true,"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   General settings for PythonML jobs on the Exabyte.io Platform   #\n#                                                                   #\n#   This file generally shouldn't be modified directly by users.    #\n#   The \"datafile\" and \"is_workflow_running_to_predict\" variables   #\n#   are defined in the head subworkflow, and are templated into     #\n#   this file. This helps facilitate the workflow's behavior        #\n#   differing whether it is in a \"train\" or \"predict\" mode.         #\n#                                                                   #\n#   Also in this file is the \"Context\" object, which helps maintain #\n#   certain Python objects between workflow units, and between      #\n#   predict runs.                                                   #\n#                                                                   #\n#   Whenever a python object needs to be stored for subsequent runs #\n#   (such as in the case of a trained model), context.save() can be #\n#   called to save it. The object can then be loaded again by using #\n#   context.load().                                                 #\n# ----------------------------------------------------------------- #\n\n\nimport os\nimport pickle\n\n# ==================================================\n# Variables modified in the Important Settings menu\n# ==================================================\n# Variables in this section can (and oftentimes need to) be modified by the user in the \"Important Settings\" tab\n# of a workflow.\n\n# Target_column_name is used during training to identify the variable the model is traing to predict.\n# For example, consider a CSV containing three columns, \"Y\", \"X1\", and \"X2\". If the goal is to train a model\n# that will predict the value of \"Y,\" then target_column_name would be set to \"Y\"\ntarget_column_name = \"{{ mlSettings.target_column_name }}\"\n\n# The type of ML problem being performed. Can be either \"regression\", \"classification,\" or \"clustering.\"\nproblem_category = \"{{ mlSettings.problem_category }}\"\n\n# =============================\n# Non user-modifiable variables\n# =============================\n# Variables in this section generally do not need to be modified.\n\n# The problem category, regression or classification or clustering. In regression, the target (predicted) variable\n# is continues. In classification, it is categorical. In clustering, there is no target - a set of labels is\n# automatically generated.\nis_regression = is_classification = is_clustering = False\nif problem_category.lower() == \"regression\":\n    is_regression = True\nelif problem_category.lower() == \"classification\":\n    is_classification = True\nelif problem_category.lower() == \"clustering\":\n    is_clustering = True\nelse:\n    raise ValueError(\n        \"Variable 'problem_category' must be either 'regression', 'classification', or 'clustering'. Check settings.py\")\n\n# The variables \"is_workflow_running_to_predict\" and \"is_workflow_running_to_train\" are used to control whether\n# the workflow is in a \"training\" mode or a \"prediction\" mode. The \"IS_WORKFLOW_RUNNING_TO_PREDICT\" variable is set by\n# an assignment unit in the \"Set Up the Job\" subworkflow that executes at the start of the job. It is automatically\n# changed when the predict workflow is generated, so users should not need to modify this variable.\nis_workflow_running_to_predict = {% raw %}{{IS_WORKFLOW_RUNNING_TO_PREDICT}}{% endraw %}\nis_workflow_running_to_train = not is_workflow_running_to_predict\n\n# Sets the datafile variable. The \"datafile\" is the data that will be read in, and will be used by subsequent\n# workflow units for either training or prediction, depending on the workflow mode.\nif is_workflow_running_to_predict:\n    datafile = \"{% raw %}{{DATASET_BASENAME}}{% endraw %}\"\nelse:\n    datafile = \"{% raw %}{{DATASET_BASENAME}}{% endraw %}\"\n\n# The \"Context\" class allows for data to be saved and loaded between units, and between train and predict runs.\n# Variables which have been saved using the \"Save\" method are written to disk, and the predict workflow is automatically\n# configured to obtain these files when it starts.\n#\n# IMPORTANT NOTE: Do *not* adjust the value of \"context_dir_pathname\" in the Context object. If the value is changed, then\n# files will not be correctly copied into the generated predict workflow. This will cause the predict workflow to be\n# generated in a broken state, and it will not be able to make any predictions.\nclass Context(object):\n    \"\"\"\n    Saves and loads objects from the disk, useful for preserving data between workflow units\n\n    Attributes:\n        context_paths (dict): Dictionary of the format {variable_name: path}, that governs where\n                              pickle saves files.\n\n    Methods:\n        save: Used to save objects to the context directory\n        load: Used to load objects from the context directory\n    \"\"\"\n\n    def __init__(self, context_file_basename=\"workflow_context_file_mapping\"):\n        \"\"\"\n        Constructor for Context objects\n\n        Args:\n            context_file_basename (str): Name of the file to store context paths in\n        \"\"\"\n\n        # Warning: DO NOT modify the context_dir_pathname variable below\n        # vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv\n        context_dir_pathname = \"{% raw %}{{ CONTEXT_DIR_RELATIVE_PATH }}{% endraw %}\"\n        # ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n        self._context_dir_pathname = context_dir_pathname\n        self._context_file = os.path.join(context_dir_pathname, context_file_basename)\n\n        # Make context dir if it does not exist\n        if not os.path.exists(context_dir_pathname):\n            os.makedirs(context_dir_pathname)\n\n        # Read in the context sources dictionary, if it exists\n        if os.path.exists(self._context_file):\n            with open(self._context_file, \"rb\") as file_handle:\n                self.context_paths: dict = pickle.load(file_handle)\n        else:\n            # Items is a dictionary of {varname: path}\n            self.context_paths = {}\n\n    def __enter__(self):\n        return self\n\n    def __exit__(self, exc_type, exc_value, traceback):\n        self._update_context()\n\n    def __contains__(self, item):\n        return item in self.context_paths\n\n    def _update_context(self):\n        with open(self._context_file, \"wb\") as file_handle:\n            pickle.dump(self.context_paths, file_handle)\n\n    def load(self, name: str):\n        \"\"\"\n        Returns a contextd object\n\n        Args:\n            name (str): The name in self.context_paths of the object\n        \"\"\"\n        path = self.context_paths[name]\n        with open(path, \"rb\") as file_handle:\n            obj = pickle.load(file_handle)\n        return obj\n\n    def save(self, obj: object, name: str):\n        \"\"\"\n        Saves an object to disk using pickle\n\n        Args:\n            name (str): Friendly name for the object, used for lookup in load() method\n            obj (object): Object to store on disk\n        \"\"\"\n        path = os.path.join(self._context_dir_pathname, f\"{name}.pkl\")\n        self.context_paths[name] = path\n        with open(path, \"wb\") as file_handle:\n            pickle.dump(obj, file_handle)\n        self._update_context()\n\n# Generate a context object, so that the \"with settings.context\" can be used by other units in this workflow.\ncontext = Context()\n\nis_using_train_test_split = \"is_using_train_test_split\" in context and (context.load(\"is_using_train_test_split\"))\n\n# Create a Class for a DummyScaler()\nclass DummyScaler:\n    \"\"\"\n    This class is a 'DummyScaler' which trivially acts on data by returning it unchanged.\n    \"\"\"\n\n    def fit(self, X):\n        return self\n\n    def transform(self, X):\n        return X\n\n    def fit_transform(self, X):\n        return X\n\n    def inverse_transform(self, X):\n        return X\n\nif 'target_scaler' not in context:\n    context.save(DummyScaler(), 'target_scaler')\n","name":"settings.py","contextProviders":[{"name":"MLSettingsDataManager"}],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   General settings for PythonML jobs on the Exabyte.io Platform   #\n#                                                                   #\n#   This file generally shouldn't be modified directly by users.    #\n#   The \"datafile\" and \"is_workflow_running_to_predict\" variables   #\n#   are defined in the head subworkflow, and are templated into     #\n#   this file. This helps facilitate the workflow's behavior        #\n#   differing whether it is in a \"train\" or \"predict\" mode.         #\n#                                                                   #\n#   Also in this file is the \"Context\" object, which helps maintain #\n#   certain Python objects between workflow units, and between      #\n#   predict runs.                                                   #\n#                                                                   #\n#   Whenever a python object needs to be stored for subsequent runs #\n#   (such as in the case of a trained model), context.save() can be #\n#   called to save it. The object can then be loaded again by using #\n#   context.load().                                                 #\n# ----------------------------------------------------------------- #\n\n\nimport os\nimport pickle\n\n# ==================================================\n# Variables modified in the Important Settings menu\n# ==================================================\n# Variables in this section can (and oftentimes need to) be modified by the user in the \"Important Settings\" tab\n# of a workflow.\n\n# Target_column_name is used during training to identify the variable the model is traing to predict.\n# For example, consider a CSV containing three columns, \"Y\", \"X1\", and \"X2\". If the goal is to train a model\n# that will predict the value of \"Y,\" then target_column_name would be set to \"Y\"\ntarget_column_name = \"target\"\n\n# The type of ML problem being performed. Can be either \"regression\", \"classification,\" or \"clustering.\"\nproblem_category = \"regression\"\n\n# =============================\n# Non user-modifiable variables\n# =============================\n# Variables in this section generally do not need to be modified.\n\n# The problem category, regression or classification or clustering. In regression, the target (predicted) variable\n# is continues. In classification, it is categorical. In clustering, there is no target - a set of labels is\n# automatically generated.\nis_regression = is_classification = is_clustering = False\nif problem_category.lower() == \"regression\":\n    is_regression = True\nelif problem_category.lower() == \"classification\":\n    is_classification = True\nelif problem_category.lower() == \"clustering\":\n    is_clustering = True\nelse:\n    raise ValueError(\n        \"Variable 'problem_category' must be either 'regression', 'classification', or 'clustering'. Check settings.py\")\n\n# The variables \"is_workflow_running_to_predict\" and \"is_workflow_running_to_train\" are used to control whether\n# the workflow is in a \"training\" mode or a \"prediction\" mode. The \"IS_WORKFLOW_RUNNING_TO_PREDICT\" variable is set by\n# an assignment unit in the \"Set Up the Job\" subworkflow that executes at the start of the job. It is automatically\n# changed when the predict workflow is generated, so users should not need to modify this variable.\nis_workflow_running_to_predict = {{IS_WORKFLOW_RUNNING_TO_PREDICT}}\nis_workflow_running_to_train = not is_workflow_running_to_predict\n\n# Sets the datafile variable. The \"datafile\" is the data that will be read in, and will be used by subsequent\n# workflow units for either training or prediction, depending on the workflow mode.\nif is_workflow_running_to_predict:\n    datafile = \"{{DATASET_BASENAME}}\"\nelse:\n    datafile = \"{{DATASET_BASENAME}}\"\n\n# The \"Context\" class allows for data to be saved and loaded between units, and between train and predict runs.\n# Variables which have been saved using the \"Save\" method are written to disk, and the predict workflow is automatically\n# configured to obtain these files when it starts.\n#\n# IMPORTANT NOTE: Do *not* adjust the value of \"context_dir_pathname\" in the Context object. If the value is changed, then\n# files will not be correctly copied into the generated predict workflow. This will cause the predict workflow to be\n# generated in a broken state, and it will not be able to make any predictions.\nclass Context(object):\n    \"\"\"\n    Saves and loads objects from the disk, useful for preserving data between workflow units\n\n    Attributes:\n        context_paths (dict): Dictionary of the format {variable_name: path}, that governs where\n                              pickle saves files.\n\n    Methods:\n        save: Used to save objects to the context directory\n        load: Used to load objects from the context directory\n    \"\"\"\n\n    def __init__(self, context_file_basename=\"workflow_context_file_mapping\"):\n        \"\"\"\n        Constructor for Context objects\n\n        Args:\n            context_file_basename (str): Name of the file to store context paths in\n        \"\"\"\n\n        # Warning: DO NOT modify the context_dir_pathname variable below\n        # vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv\n        context_dir_pathname = \"{{ CONTEXT_DIR_RELATIVE_PATH }}\"\n        # ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n        self._context_dir_pathname = context_dir_pathname\n        self._context_file = os.path.join(context_dir_pathname, context_file_basename)\n\n        # Make context dir if it does not exist\n        if not os.path.exists(context_dir_pathname):\n            os.makedirs(context_dir_pathname)\n\n        # Read in the context sources dictionary, if it exists\n        if os.path.exists(self._context_file):\n            with open(self._context_file, \"rb\") as file_handle:\n                self.context_paths: dict = pickle.load(file_handle)\n        else:\n            # Items is a dictionary of {varname: path}\n            self.context_paths = {}\n\n    def __enter__(self):\n        return self\n\n    def __exit__(self, exc_type, exc_value, traceback):\n        self._update_context()\n\n    def __contains__(self, item):\n        return item in self.context_paths\n\n    def _update_context(self):\n        with open(self._context_file, \"wb\") as file_handle:\n            pickle.dump(self.context_paths, file_handle)\n\n    def load(self, name: str):\n        \"\"\"\n        Returns a contextd object\n\n        Args:\n            name (str): The name in self.context_paths of the object\n        \"\"\"\n        path = self.context_paths[name]\n        with open(path, \"rb\") as file_handle:\n            obj = pickle.load(file_handle)\n        return obj\n\n    def save(self, obj: object, name: str):\n        \"\"\"\n        Saves an object to disk using pickle\n\n        Args:\n            name (str): Friendly name for the object, used for lookup in load() method\n            obj (object): Object to store on disk\n        \"\"\"\n        path = os.path.join(self._context_dir_pathname, f\"{name}.pkl\")\n        self.context_paths[name] = path\n        with open(path, \"wb\") as file_handle:\n            pickle.dump(obj, file_handle)\n        self._update_context()\n\n# Generate a context object, so that the \"with settings.context\" can be used by other units in this workflow.\ncontext = Context()\n\nis_using_train_test_split = \"is_using_train_test_split\" in context and (context.load(\"is_using_train_test_split\"))\n\n# Create a Class for a DummyScaler()\nclass DummyScaler:\n    \"\"\"\n    This class is a 'DummyScaler' which trivially acts on data by returning it unchanged.\n    \"\"\"\n\n    def fit(self, X):\n        return self\n\n    def transform(self, X):\n        return X\n\n    def fit_transform(self, X):\n        return X\n\n    def inverse_transform(self, X):\n        return X\n\nif 'target_scaler' not in context:\n    context.save(DummyScaler(), 'target_scaler')\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"cb69ea2a-7efc-56b4-8bbe-0de1e70c49e3"},{"type":"execution","name":"Data Input","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"cb69ea2a-7efc-56b4-8bbe-0de1e70c49e3","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"data_input_read_csv_pandas.py","templateName":"data_input_read_csv_pandas.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:data_input:read_csv:pandas","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Workflow Unit to read in data for the ML workflow.              #\n#                                                                   #\n#   Also showcased here is the concept of branching based on        #\n#   whether the workflow is in \"train\" or \"predict\" mode.           #\n#                                                                   #\n#   If the workflow is in \"training\" mode, it will read in the data #\n#   before converting it to a Numpy array and save it for use       #\n#   later. During training, we already have values for the output,  #\n#   and this gets saved to \"target.\"                                #\n#                                                                   #\n#   Finally, whether the workflow is in training or predict mode,   #\n#   it will always read in a set of descriptors from a datafile     #\n#   defined in settings.py                                          #\n# ----------------------------------------------------------------- #\n\n\nimport pandas\nimport settings\nimport sklearn.preprocessing\n\nwith settings.context as context:\n    data = pandas.read_csv(settings.datafile)\n\n    # Train\n    # By default, we don't do train/test splitting: the train and test represent the same dataset at first.\n    # Other units (such as a train/test splitter) down the line can adjust this as-needed.\n    if settings.is_workflow_running_to_train:\n\n        # Handle the case where we are clustering\n        if settings.is_clustering:\n            target = data.to_numpy()[:, 0]  # Just get the first column, it's not going to get used anyway\n        else:\n            target = data.pop(settings.target_column_name).to_numpy()\n\n        # Handle the case where we are classifying. In this case, we must convert any labels provided to be categorical.\n        # Specifically, labels are encoded with values between 0 and (N_Classes - 1)\n        if settings.is_classification:\n            label_encoder = sklearn.preprocessing.LabelEncoder()\n            target = label_encoder.fit_transform(target)\n            context.save(label_encoder, \"label_encoder\")\n\n        target = target.reshape(-1, 1)  # Reshape array from a row vector into a column vector\n\n        context.save(target, \"train_target\")\n        context.save(target, \"test_target\")\n\n        descriptors = data.to_numpy()\n\n        context.save(descriptors, \"train_descriptors\")\n        context.save(descriptors, \"test_descriptors\")\n\n    else:\n        descriptors = data.to_numpy()\n        context.save(descriptors, \"descriptors\")\n","name":"data_input_read_csv_pandas.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Workflow Unit to read in data for the ML workflow.              #\n#                                                                   #\n#   Also showcased here is the concept of branching based on        #\n#   whether the workflow is in \"train\" or \"predict\" mode.           #\n#                                                                   #\n#   If the workflow is in \"training\" mode, it will read in the data #\n#   before converting it to a Numpy array and save it for use       #\n#   later. During training, we already have values for the output,  #\n#   and this gets saved to \"target.\"                                #\n#                                                                   #\n#   Finally, whether the workflow is in training or predict mode,   #\n#   it will always read in a set of descriptors from a datafile     #\n#   defined in settings.py                                          #\n# ----------------------------------------------------------------- #\n\n\nimport pandas\nimport settings\nimport sklearn.preprocessing\n\nwith settings.context as context:\n    data = pandas.read_csv(settings.datafile)\n\n    # Train\n    # By default, we don't do train/test splitting: the train and test represent the same dataset at first.\n    # Other units (such as a train/test splitter) down the line can adjust this as-needed.\n    if settings.is_workflow_running_to_train:\n\n        # Handle the case where we are clustering\n        if settings.is_clustering:\n            target = data.to_numpy()[:, 0]  # Just get the first column, it's not going to get used anyway\n        else:\n            target = data.pop(settings.target_column_name).to_numpy()\n\n        # Handle the case where we are classifying. In this case, we must convert any labels provided to be categorical.\n        # Specifically, labels are encoded with values between 0 and (N_Classes - 1)\n        if settings.is_classification:\n            label_encoder = sklearn.preprocessing.LabelEncoder()\n            target = label_encoder.fit_transform(target)\n            context.save(label_encoder, \"label_encoder\")\n\n        target = target.reshape(-1, 1)  # Reshape array from a row vector into a column vector\n\n        context.save(target, \"train_target\")\n        context.save(target, \"test_target\")\n\n        descriptors = data.to_numpy()\n\n        context.save(descriptors, \"train_descriptors\")\n        context.save(descriptors, \"test_descriptors\")\n\n    else:\n        descriptors = data.to_numpy()\n        context.save(descriptors, \"descriptors\")\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"7fff5212-6c6d-586b-9997-4d4485e09383"},{"type":"execution","name":"Train Test Split","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"7fff5212-6c6d-586b-9997-4d4485e09383","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"data_input_train_test_split_sklearn.py","templateName":"data_input_train_test_split_sklearn.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:data_input:train_test_split:sklearn","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Workflow Unit to perform a train/test split                     #\n#                                                                   #\n#   Splits the dataset into a training and testing set. The         #\n#   variable `percent_held_as_test` controls how much of the        #\n#   input dataset is removed for use as a testing set. By default,  #\n#   this unit puts 20% of the dataset into the testing set, and     #\n#   places the remaining 80% into the training set.                 #\n#                                                                   #\n#   Does nothing in the case of predictions.                        #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nimport numpy as np\nimport settings\nimport sklearn.model_selection\n\n# `percent_held_as_test` is the amount of the dataset held out as the testing set. If it is set to 0.2,\n# then 20% of the dataset is held out as a testing set. The remaining 80% is the training set.\npercent_held_as_test = {{ mlTrainTestSplit.fraction_held_as_test_set }}\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Load training data\n        train_target = context.load(\"train_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n\n        # Combine datasets to facilitate train/test split\n\n        # Do train/test split\n        train_descriptors, test_descriptors, train_target, test_target = sklearn.model_selection.train_test_split(\n            train_descriptors, train_target, test_size=percent_held_as_test)\n\n        # Set the flag for using a train/test split\n        context.save(True, \"is_using_train_test_split\")\n\n        # Save training data\n        context.save(train_target, \"train_target\")\n        context.save(train_descriptors, \"train_descriptors\")\n        context.save(test_target, \"test_target\")\n        context.save(test_descriptors, \"test_descriptors\")\n\n    # Predict\n    else:\n        pass\n","name":"data_input_train_test_split_sklearn.py","contextProviders":[{"name":"MLTrainTestSplitDataManager"}],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Workflow Unit to perform a train/test split                     #\n#                                                                   #\n#   Splits the dataset into a training and testing set. The         #\n#   variable `percent_held_as_test` controls how much of the        #\n#   input dataset is removed for use as a testing set. By default,  #\n#   this unit puts 20% of the dataset into the testing set, and     #\n#   places the remaining 80% into the training set.                 #\n#                                                                   #\n#   Does nothing in the case of predictions.                        #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nimport numpy as np\nimport settings\nimport sklearn.model_selection\n\n# `percent_held_as_test` is the amount of the dataset held out as the testing set. If it is set to 0.2,\n# then 20% of the dataset is held out as a testing set. The remaining 80% is the training set.\npercent_held_as_test = 0.2\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Load training data\n        train_target = context.load(\"train_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n\n        # Combine datasets to facilitate train/test split\n\n        # Do train/test split\n        train_descriptors, test_descriptors, train_target, test_target = sklearn.model_selection.train_test_split(\n            train_descriptors, train_target, test_size=percent_held_as_test)\n\n        # Set the flag for using a train/test split\n        context.save(True, \"is_using_train_test_split\")\n\n        # Save training data\n        context.save(train_target, \"train_target\")\n        context.save(train_descriptors, \"train_descriptors\")\n        context.save(test_target, \"test_target\")\n        context.save(test_descriptors, \"test_descriptors\")\n\n    # Predict\n    else:\n        pass\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"799de7dc-9394-571b-8e0d-3ff876a3df02"},{"type":"execution","name":"Data Standardize","head":false,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"799de7dc-9394-571b-8e0d-3ff876a3df02","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"pre_processing_standardization_sklearn.py","templateName":"pre_processing_standardization_sklearn.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:pre_processing:standardization:sklearn","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Sklearn Standard Scaler workflow unit                           #\n#                                                                   #\n#   This workflow unit scales the data such that it a mean of 0 and #\n#   a standard deviation of 1. It then saves the data for use       #\n#   further down the road in the workflow, for use in               #\n#   un-transforming the data.                                       #\n#                                                                   #\n#   It is important that new predictions are made by scaling the    #\n#   new inputs using the mean and variance of the original training #\n#   set. As a result, the scaler gets saved in the Training phase.  #\n#                                                                   #\n#   During a predict workflow, the scaler is loaded, and the        #\n#   new examples are scaled using the stored scaler.                #\n# ----------------------------------------------------------------- #\n\n\nimport settings\nimport sklearn.preprocessing\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n        test_target = context.load(\"test_target\")\n        test_descriptors = context.load(\"test_descriptors\")\n\n        # Descriptor Scaler\n        scaler = sklearn.preprocessing.StandardScaler\n        descriptor_scaler = scaler()\n        train_descriptors = descriptor_scaler.fit_transform(train_descriptors)\n        test_descriptors = descriptor_scaler.transform(test_descriptors)\n        context.save(descriptor_scaler, \"descriptor_scaler\")\n        context.save(train_descriptors, \"train_descriptors\")\n        context.save(test_descriptors, \"test_descriptors\")\n\n        # Our target is only continuous if it's a regression problem\n        if settings.is_regression:\n            target_scaler = scaler()\n            train_target = target_scaler.fit_transform(train_target)\n            test_target = target_scaler.transform(test_target)\n            context.save(target_scaler, \"target_scaler\")\n            context.save(train_target, \"train_target\")\n            context.save(test_target, \"test_target\")\n\n    # Predict\n    else:\n        # Restore data\n        descriptors = context.load(\"descriptors\")\n\n        # Get the scaler\n        descriptor_scaler = context.load(\"descriptor_scaler\")\n\n        # Scale the data\n        descriptors = descriptor_scaler.transform(descriptors)\n\n        # Store the data\n        context.save(descriptors, \"descriptors\")\n","name":"pre_processing_standardization_sklearn.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Sklearn Standard Scaler workflow unit                           #\n#                                                                   #\n#   This workflow unit scales the data such that it a mean of 0 and #\n#   a standard deviation of 1. It then saves the data for use       #\n#   further down the road in the workflow, for use in               #\n#   un-transforming the data.                                       #\n#                                                                   #\n#   It is important that new predictions are made by scaling the    #\n#   new inputs using the mean and variance of the original training #\n#   set. As a result, the scaler gets saved in the Training phase.  #\n#                                                                   #\n#   During a predict workflow, the scaler is loaded, and the        #\n#   new examples are scaled using the stored scaler.                #\n# ----------------------------------------------------------------- #\n\n\nimport settings\nimport sklearn.preprocessing\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n        test_target = context.load(\"test_target\")\n        test_descriptors = context.load(\"test_descriptors\")\n\n        # Descriptor Scaler\n        scaler = sklearn.preprocessing.StandardScaler\n        descriptor_scaler = scaler()\n        train_descriptors = descriptor_scaler.fit_transform(train_descriptors)\n        test_descriptors = descriptor_scaler.transform(test_descriptors)\n        context.save(descriptor_scaler, \"descriptor_scaler\")\n        context.save(train_descriptors, \"train_descriptors\")\n        context.save(test_descriptors, \"test_descriptors\")\n\n        # Our target is only continuous if it's a regression problem\n        if settings.is_regression:\n            target_scaler = scaler()\n            train_target = target_scaler.fit_transform(train_target)\n            test_target = target_scaler.transform(test_target)\n            context.save(target_scaler, \"target_scaler\")\n            context.save(train_target, \"train_target\")\n            context.save(test_target, \"test_target\")\n\n    # Predict\n    else:\n        # Restore data\n        descriptors = context.load(\"descriptors\")\n\n        # Get the scaler\n        descriptor_scaler = context.load(\"descriptor_scaler\")\n\n        # Scale the data\n        descriptors = descriptor_scaler.transform(descriptors)\n\n        # Store the data\n        context.save(descriptors, \"descriptors\")\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"8dfc61c3-067d-5ea8-bd26-7296628d707a"},{"type":"execution","name":"Model Train and Predict","head":false,"results":[{"name":"workflow:pyml_predict"}],"monitors":[{"name":"standard_output"}],"flowchartId":"8dfc61c3-067d-5ea8-bd26-7296628d707a","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"model_mlp_sklearn.py","templateName":"model_mlp_sklearn.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"results":["workflow:pyml_predict"],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:model:multilayer_perceptron:sklearn","schemaVersion":"2022.8.16","isDefault":false},"tags":["remove-all-results","creates-predictions-csv-during-predict-phase"],"status":"idle","statusTrack":[],"input":[{"content":"# ------------------------------------------------------------ #\n# Workflow unit to train a simple feedforward neural network   #\n# model on a regression problem using scikit-learn. In this    #\n# template, we use the default values for hidden_layer_sizes,  #\n# activation, solver, and learning rate. Other parameters are  #\n# available (consult the sklearn docs), but in this case, we   #\n# only include those relevant to the Adam optimizer. Sklearn   #\n# Docs: Sklearn docs:http://scikit-learn.org/stable/modules/ge #\n# nerated/sklearn.neural_network.MLPRegressor.html             #\n#                                                              #\n# When then workflow is in Training mode, the model is trained #\n# and then it is saved, along with the RMSE and some           #\n# predictions made using the training data (e.g. for use in a  #\n# parity plot or calculation of other error metrics). When the #\n# workflow is run in Predict mode, the model is loaded,        #\n# predictions are made, they are un-transformed using the      #\n# trained scaler from the training run, and they are written   #\n# to a file named \"predictions.csv\"                            #\n# ------------------------------------------------------------ #\n\n\nimport numpy as np\nimport settings\nimport sklearn.metrics\nimport sklearn.neural_network\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        test_target = context.load(\"test_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n        test_descriptors = context.load(\"test_descriptors\")\n\n        # Flatten the targets\n        train_target = train_target.flatten()\n        test_target = test_target.flatten()\n\n        # Initialize the Model\n        model = sklearn.neural_network.MLPRegressor(\n            hidden_layer_sizes=(100,),\n            activation=\"relu\",\n            solver=\"adam\",\n            max_iter=300,\n            early_stopping=False,\n            validation_fraction=0.1,\n        )\n\n        # Train the model and save\n        model.fit(train_descriptors, train_target)\n        context.save(model, \"multilayer_perceptron\")\n        train_predictions = model.predict(train_descriptors)\n        test_predictions = model.predict(test_descriptors)\n\n        # Scale predictions so they have the same shape as the saved target\n        train_predictions = train_predictions.reshape(-1, 1)\n        test_predictions = test_predictions.reshape(-1, 1)\n\n        # Scale for RMSE calc on the test set\n        target_scaler = context.load(\"target_scaler\")\n\n        # Unflatten the target\n        test_target = test_target.reshape(-1, 1)\n        y_true = target_scaler.inverse_transform(test_target)\n        y_pred = target_scaler.inverse_transform(test_predictions)\n\n        # RMSE\n        mse = sklearn.metrics.mean_squared_error(y_true, y_pred)\n        rmse = np.sqrt(mse)\n        print(f\"RMSE = {rmse}\")\n        context.save(rmse, \"RMSE\")\n\n        context.save(train_predictions, \"train_predictions\")\n        context.save(test_predictions, \"test_predictions\")\n\n    # Predict\n    else:\n        # Restore data\n        descriptors = context.load(\"descriptors\")\n\n        # Restore model\n        model = context.load(\"multilayer_perceptron\")\n\n        # Make some predictions\n        predictions = model.predict(descriptors)\n\n        # Save the predictions to file\n        np.savetxt(\"predictions.csv\", predictions, header=\"prediction\", comments=\"\", fmt=\"%s\")\n","name":"model_mlp_sklearn.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ------------------------------------------------------------ #\n# Workflow unit to train a simple feedforward neural network   #\n# model on a regression problem using scikit-learn. In this    #\n# template, we use the default values for hidden_layer_sizes,  #\n# activation, solver, and learning rate. Other parameters are  #\n# available (consult the sklearn docs), but in this case, we   #\n# only include those relevant to the Adam optimizer. Sklearn   #\n# Docs: Sklearn docs:http://scikit-learn.org/stable/modules/ge #\n# nerated/sklearn.neural_network.MLPRegressor.html             #\n#                                                              #\n# When then workflow is in Training mode, the model is trained #\n# and then it is saved, along with the RMSE and some           #\n# predictions made using the training data (e.g. for use in a  #\n# parity plot or calculation of other error metrics). When the #\n# workflow is run in Predict mode, the model is loaded,        #\n# predictions are made, they are un-transformed using the      #\n# trained scaler from the training run, and they are written   #\n# to a file named \"predictions.csv\"                            #\n# ------------------------------------------------------------ #\n\n\nimport numpy as np\nimport settings\nimport sklearn.metrics\nimport sklearn.neural_network\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        test_target = context.load(\"test_target\")\n        train_descriptors = context.load(\"train_descriptors\")\n        test_descriptors = context.load(\"test_descriptors\")\n\n        # Flatten the targets\n        train_target = train_target.flatten()\n        test_target = test_target.flatten()\n\n        # Initialize the Model\n        model = sklearn.neural_network.MLPRegressor(\n            hidden_layer_sizes=(100,),\n            activation=\"relu\",\n            solver=\"adam\",\n            max_iter=300,\n            early_stopping=False,\n            validation_fraction=0.1,\n        )\n\n        # Train the model and save\n        model.fit(train_descriptors, train_target)\n        context.save(model, \"multilayer_perceptron\")\n        train_predictions = model.predict(train_descriptors)\n        test_predictions = model.predict(test_descriptors)\n\n        # Scale predictions so they have the same shape as the saved target\n        train_predictions = train_predictions.reshape(-1, 1)\n        test_predictions = test_predictions.reshape(-1, 1)\n\n        # Scale for RMSE calc on the test set\n        target_scaler = context.load(\"target_scaler\")\n\n        # Unflatten the target\n        test_target = test_target.reshape(-1, 1)\n        y_true = target_scaler.inverse_transform(test_target)\n        y_pred = target_scaler.inverse_transform(test_predictions)\n\n        # RMSE\n        mse = sklearn.metrics.mean_squared_error(y_true, y_pred)\n        rmse = np.sqrt(mse)\n        print(f\"RMSE = {rmse}\")\n        context.save(rmse, \"RMSE\")\n\n        context.save(train_predictions, \"train_predictions\")\n        context.save(test_predictions, \"test_predictions\")\n\n    # Predict\n    else:\n        # Restore data\n        descriptors = context.load(\"descriptors\")\n\n        # Restore model\n        model = context.load(\"multilayer_perceptron\")\n\n        # Make some predictions\n        predictions = model.predict(descriptors)\n\n        # Save the predictions to file\n        np.savetxt(\"predictions.csv\", predictions, header=\"prediction\", comments=\"\", fmt=\"%s\")\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}],"next":"1ca76a49-a3c7-5fa2-b693-538b599ecd7c"},{"type":"execution","name":"Parity Plot","head":false,"results":[{"basename":"my_parity_plot.png","filetype":"image","name":"file_content"}],"monitors":[{"name":"standard_output"}],"flowchartId":"1ca76a49-a3c7-5fa2-b693-538b599ecd7c","preProcessors":[],"postProcessors":[{"name":"remove_virtual_environment"}],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"post_processing_parity_plot_matplotlib.py","templateName":"post_processing_parity_plot_matplotlib.py"},{"name":"requirements.txt","templateName":"pyml_requirements.txt"}],"results":["file_content"],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"pyml:post_processing:parity_plot:matplotlib","schemaVersion":"2022.8.16","isDefault":false},"tags":["remove-all-results"],"status":"idle","statusTrack":[],"input":[{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Parity plot generation unit                                     #\n#                                                                   #\n#   This unit generates a parity plot based on the known values     #\n#   in the training data, and the predicted values generated        #\n#   using the training data.                                        #\n#                                                                   #\n#   Because this metric compares predictions versus a ground truth, #\n#   it doesn't make sense to generate the plot when a predict       #\n#   workflow is being run (because in that case, we generally don't #\n#   know the ground truth for the values being predicted). Hence,   #\n#   this unit does nothing if the workflow is in \"predict\" mode.    #\n# ----------------------------------------------------------------- #\n\n\nimport matplotlib.pyplot as plt\nimport settings\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        train_predictions = context.load(\"train_predictions\")\n        test_target = context.load(\"test_target\")\n        test_predictions = context.load(\"test_predictions\")\n\n        # Un-transform the data\n        target_scaler = context.load(\"target_scaler\")\n        train_target = target_scaler.inverse_transform(train_target)\n        train_predictions = target_scaler.inverse_transform(train_predictions)\n        test_target = target_scaler.inverse_transform(test_target)\n        test_predictions = target_scaler.inverse_transform(test_predictions)\n\n        # Plot the data\n        plt.scatter(train_target, train_predictions, c=\"#203d78\", label=\"Training Set\")\n        if settings.is_using_train_test_split:\n            plt.scatter(test_target, test_predictions, c=\"#67ac5b\", label=\"Testing Set\")\n        plt.xlabel(\"Actual Value\")\n        plt.ylabel(\"Predicted Value\")\n\n        # Scale the plot\n        target_range = (min(min(train_target), min(test_target)),\n                        max(max(train_target), max(test_target)))\n        predictions_range = (min(min(train_predictions), min(test_predictions)),\n                             max(max(train_predictions), max(test_predictions)))\n\n        limits = (min(min(target_range), min(target_range)),\n                  max(max(predictions_range), max(predictions_range)))\n        plt.xlim = (limits[0], limits[1])\n        plt.ylim = (limits[0], limits[1])\n\n        # Draw a parity line, as a guide to the eye\n        plt.plot((limits[0], limits[1]), (limits[0], limits[1]), c=\"black\", linestyle=\"dotted\", label=\"Parity\")\n        plt.legend()\n\n        # Save the figure\n        plt.tight_layout()\n        plt.savefig(\"my_parity_plot.png\", dpi=600)\n\n    # Predict\n    else:\n        # It might not make as much sense to draw a plot when predicting...\n        pass\n","name":"post_processing_parity_plot_matplotlib.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#   Parity plot generation unit                                     #\n#                                                                   #\n#   This unit generates a parity plot based on the known values     #\n#   in the training data, and the predicted values generated        #\n#   using the training data.                                        #\n#                                                                   #\n#   Because this metric compares predictions versus a ground truth, #\n#   it doesn't make sense to generate the plot when a predict       #\n#   workflow is being run (because in that case, we generally don't #\n#   know the ground truth for the values being predicted). Hence,   #\n#   this unit does nothing if the workflow is in \"predict\" mode.    #\n# ----------------------------------------------------------------- #\n\n\nimport matplotlib.pyplot as plt\nimport settings\n\nwith settings.context as context:\n    # Train\n    if settings.is_workflow_running_to_train:\n        # Restore the data\n        train_target = context.load(\"train_target\")\n        train_predictions = context.load(\"train_predictions\")\n        test_target = context.load(\"test_target\")\n        test_predictions = context.load(\"test_predictions\")\n\n        # Un-transform the data\n        target_scaler = context.load(\"target_scaler\")\n        train_target = target_scaler.inverse_transform(train_target)\n        train_predictions = target_scaler.inverse_transform(train_predictions)\n        test_target = target_scaler.inverse_transform(test_target)\n        test_predictions = target_scaler.inverse_transform(test_predictions)\n\n        # Plot the data\n        plt.scatter(train_target, train_predictions, c=\"#203d78\", label=\"Training Set\")\n        if settings.is_using_train_test_split:\n            plt.scatter(test_target, test_predictions, c=\"#67ac5b\", label=\"Testing Set\")\n        plt.xlabel(\"Actual Value\")\n        plt.ylabel(\"Predicted Value\")\n\n        # Scale the plot\n        target_range = (min(min(train_target), min(test_target)),\n                        max(max(train_target), max(test_target)))\n        predictions_range = (min(min(train_predictions), min(test_predictions)),\n                             max(max(train_predictions), max(test_predictions)))\n\n        limits = (min(min(target_range), min(target_range)),\n                  max(max(predictions_range), max(predictions_range)))\n        plt.xlim = (limits[0], limits[1])\n        plt.ylim = (limits[0], limits[1])\n\n        # Draw a parity line, as a guide to the eye\n        plt.plot((limits[0], limits[1]), (limits[0], limits[1]), c=\"black\", linestyle=\"dotted\", label=\"Parity\")\n        plt.legend()\n\n        # Save the figure\n        plt.tight_layout()\n        plt.savefig(\"my_parity_plot.png\", dpi=600)\n\n    # Predict\n    else:\n        # It might not make as much sense to draw a plot when predicting...\n        pass\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nmatplotlib\nnumpy\nscikit-learn\nxgboost\npandas\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Set Up the Job","type":"subworkflow","_id":"03e3f15b-2b22-5bb4-8bfd-6839d28a1ba9","status":"idle","statusTrack":[],"flowchartId":"5b51df93-15dd-5440-90fd-a3ffa264b7d8","tags":[],"head":true,"next":"90738aae-daac-599f-913f-29fb6acdff00"},{"name":"Machine Learning","type":"subworkflow","_id":"30acc5cd-54e6-5f05-aafd-413ee8a69aa1","status":"idle","statusTrack":[],"flowchartId":"90738aae-daac-599f-913f-29fb6acdff00","tags":[],"head":false}],"properties":[],"_id":"f447c6df-3b7b-5b8e-a0cc-1a743847ceed","workflows":[],"isUsingDataset":true,"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"python"}},"python/python_script.json":{"name":"Python Script","subworkflows":[{"_id":"64a079ba-7a12-57b7-ac06-310b2bf8d354","name":"Python Script","application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"python","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"9b8a495e-1ac1-56a7-b2e0-af1b405a1219","preProcessors":[],"postProcessors":[],"application":{"name":"python","shortName":"py","summary":"Python Script","build":"GNU","version":"3.10.13","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"python","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"script.py","templateName":"hello_world.py"},{"name":"requirements.txt"}],"monitors":["standard_output"],"applicationName":"python","executableName":"python","name":"hello_world","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"# ---------------------------------------------------------------- #\n#                                                                  #\n#  Example python script for Exabyte.io platform.                  #\n#                                                                  #\n#  Will be used as follows:                                        #\n#                                                                  #\n#    1. runtime directory for this calculation is created          #\n#    2. requirements.txt is used to create a virtual environment   #\n#    3. virtual environment is activated                           #\n#    4. python process running this script is started              #\n#                                                                  #\n#  Adjust the content below to include your code.                  #\n#                                                                  #\n# ---------------------------------------------------------------- #\n\nimport numpy as np\n\npi_value = np.pi\nprint(pi_value)\n","name":"script.py","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ---------------------------------------------------------------- #\n#                                                                  #\n#  Example python script for Exabyte.io platform.                  #\n#                                                                  #\n#  Will be used as follows:                                        #\n#                                                                  #\n#    1. runtime directory for this calculation is created          #\n#    2. requirements.txt is used to create a virtual environment   #\n#    3. virtual environment is activated                           #\n#    4. python process running this script is started              #\n#                                                                  #\n#  Adjust the content below to include your code.                  #\n#                                                                  #\n# ---------------------------------------------------------------- #\n\nimport numpy as np\n\npi_value = np.pi\nprint(pi_value)\n","schemaVersion":"2022.8.16"},{"content":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n#  Adjust the list to include your preferred packages.              #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nnumpy<2\n","name":"requirements.txt","contextProviders":[],"applicationName":"python","executableName":"python","rendered":"# ----------------------------------------------------------------- #\n#                                                                   #\n#  Example Python package requirements for the Mat3ra platform      #\n#                                                                   #\n#  Will be used as follows:                                         #\n#                                                                   #\n#    1. A runtime directory for this calculation is created         #\n#    2. This list is used to populate a Python virtual environment  #\n#    3. The virtual environment is activated                        #\n#    4. The Python process running the script included within this  #\n#       job is started                                              #\n#                                                                   #\n#  For more information visit:                                      #\n#   - https://pip.pypa.io/en/stable/reference/pip_install           #\n#   - https://virtualenv.pypa.io/en/stable/                         #\n#                                                                   #\n#  Adjust the list to include your preferred packages.              #\n#                                                                   #\n# ----------------------------------------------------------------- #\n\nnumpy<2\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Python Script","type":"subworkflow","_id":"64a079ba-7a12-57b7-ac06-310b2bf8d354","status":"idle","statusTrack":[],"flowchartId":"c50e28b2-a0c5-5324-8b6f-e99b5a546bd8","tags":[],"head":true}],"properties":[],"_id":"de816646-766b-5f97-b468-0937d4381440","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"python"}},"shell/batch_espresso_pwscf.json":{"name":"Shell Batch Job (Espresso PWSCF)","subworkflows":[{"_id":"f0775c7b-214a-5245-b921-5b4eb53d15a9","name":"Shell Batch Job (Espresso PWSCF)","application":{"name":"shell","shortName":"sh","summary":"Shell Script","build":"GNU","version":"5.1.8","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"shell","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"99304304-e873-5c89-ae83-91e61a7f629c","preProcessors":[],"postProcessors":[],"application":{"name":"shell","shortName":"sh","summary":"Shell Script","build":"GNU","version":"5.1.8","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"sh","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"job_espresso_pw_scf.sh"}],"monitors":["standard_output"],"applicationName":"shell","executableName":"sh","name":"job_espresso_pw_scf","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"#!/bin/bash\n\n# ---------------------------------------------------------------- #\n#                                                                  #\n#  Example job submission script for Exabyte.io platform           #\n#                                                                  #\n#  Shows resource manager directives for:                          #\n#                                                                  #\n#    1. the name of the job                (-N)                    #\n#    2. the number of nodes to be used     (-l nodes=)             #\n#    3. the number of processors per node  (-l ppn=)               #\n#    4. the walltime in dd:hh:mm:ss format (-l walltime=)          #\n#    5. queue                              (-q) D, OR, OF, SR, SF  #\n#    6. merging standard output and error  (-j oe)                 #\n#    7. email about job abort, begin, end  (-m abe)                #\n#    8. email address to use               (-M)                    #\n#                                                                  #\n#  For more information visit https://docs.mat3ra.com/cli/jobs     #\n# ---------------------------------------------------------------- #\n\n#PBS -N ESPRESSO-TEST\n#PBS -j oe\n#PBS -l nodes=1\n#PBS -l ppn=1\n#PBS -l walltime=00:00:10:00\n#PBS -q D\n#PBS -m abe\n#PBS -M info@mat3ra.com\n\n# load module\nmodule add espresso\n\n# go to the job working directory\ncd $PBS_O_WORKDIR\n\n# create input file\ncat > pw.in <<EOF\n&CONTROL\n    calculation= 'scf'\n    title= ''\n    verbosity= 'low'\n    restart_mode= 'from_scratch'\n    wf_collect= .true.\n    tstress= .true.\n    tprnfor= .true.\n    outdir= './'\n    wfcdir= './'\n    prefix= '__prefix__'\n    pseudo_dir= '/export/share/pseudo/si/gga/pbe/gbrv/1.0/us/'\n/\n&SYSTEM\n    ibrav=0\n    nat=2\n    ntyp=1\n    ecutwfc= 40\n    ecutrho= 200\n    occupations= 'smearing'\n    degauss= 0.005\n/\n&ELECTRONS\n    diagonalization= 'david'\n    diago_david_ndim= 4\n    diago_full_acc= .true.\n    mixing_beta= 0.3\n    startingwfc='atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 si_pbe_gbrv_1.0.upf\nCELL_PARAMETERS angstrom\n3.867000000 0.000000000 0.000000000\n1.933500000 3.348920236 0.000000000\n1.933500000 1.116306745 3.157392278\nATOMIC_POSITIONS crystal\nSi 0.000000000 0.000000000 0.000000000\nSi 0.250000000 0.250000000 0.250000000\nK_POINTS automatic\n10 10 10 0 0 0\nEOF\n\n# run the calculation\n# EXEC_CMD envvar is (conditionally) set by the module\nmpirun -np $PBS_NP $EXEC_CMD pw.x -in pw.in > pw.out\n","name":"job_espresso_pw_scf.sh","contextProviders":[],"applicationName":"shell","executableName":"sh","rendered":"#!/bin/bash\n\n# ---------------------------------------------------------------- #\n#                                                                  #\n#  Example job submission script for Exabyte.io platform           #\n#                                                                  #\n#  Shows resource manager directives for:                          #\n#                                                                  #\n#    1. the name of the job                (-N)                    #\n#    2. the number of nodes to be used     (-l nodes=)             #\n#    3. the number of processors per node  (-l ppn=)               #\n#    4. the walltime in dd:hh:mm:ss format (-l walltime=)          #\n#    5. queue                              (-q) D, OR, OF, SR, SF  #\n#    6. merging standard output and error  (-j oe)                 #\n#    7. email about job abort, begin, end  (-m abe)                #\n#    8. email address to use               (-M)                    #\n#                                                                  #\n#  For more information visit https://docs.mat3ra.com/cli/jobs     #\n# ---------------------------------------------------------------- #\n\n#PBS -N ESPRESSO-TEST\n#PBS -j oe\n#PBS -l nodes=1\n#PBS -l ppn=1\n#PBS -l walltime=00:00:10:00\n#PBS -q D\n#PBS -m abe\n#PBS -M info@mat3ra.com\n\n# load module\nmodule add espresso\n\n# go to the job working directory\ncd $PBS_O_WORKDIR\n\n# create input file\ncat > pw.in <<EOF\n&CONTROL\n    calculation= 'scf'\n    title= ''\n    verbosity= 'low'\n    restart_mode= 'from_scratch'\n    wf_collect= .true.\n    tstress= .true.\n    tprnfor= .true.\n    outdir= './'\n    wfcdir= './'\n    prefix= '__prefix__'\n    pseudo_dir= '/export/share/pseudo/si/gga/pbe/gbrv/1.0/us/'\n/\n&SYSTEM\n    ibrav=0\n    nat=2\n    ntyp=1\n    ecutwfc= 40\n    ecutrho= 200\n    occupations= 'smearing'\n    degauss= 0.005\n/\n&ELECTRONS\n    diagonalization= 'david'\n    diago_david_ndim= 4\n    diago_full_acc= .true.\n    mixing_beta= 0.3\n    startingwfc='atomic+random'\n/\n&IONS\n/\n&CELL\n/\nATOMIC_SPECIES\nSi 28.0855 si_pbe_gbrv_1.0.upf\nCELL_PARAMETERS angstrom\n3.867000000 0.000000000 0.000000000\n1.933500000 3.348920236 0.000000000\n1.933500000 1.116306745 3.157392278\nATOMIC_POSITIONS crystal\nSi 0.000000000 0.000000000 0.000000000\nSi 0.250000000 0.250000000 0.250000000\nK_POINTS automatic\n10 10 10 0 0 0\nEOF\n\n# run the calculation\n# EXEC_CMD envvar is (conditionally) set by the module\nmpirun -np $PBS_NP $EXEC_CMD pw.x -in pw.in > pw.out\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Shell Batch Job (Espresso PWSCF)","type":"subworkflow","_id":"f0775c7b-214a-5245-b921-5b4eb53d15a9","status":"idle","statusTrack":[],"flowchartId":"d884e8f7-7acf-5a03-bc9a-186903bdaa0e","tags":[],"head":true}],"properties":[],"_id":"e0046fb4-37db-5732-bf81-c48e13081a4c","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"shell"}},"shell/hello_world.json":{"name":"Shell Script","subworkflows":[{"_id":"ce33d4cf-e0d2-5020-854d-9ea1fe5c8512","name":"Shell Hello World","application":{"name":"shell","shortName":"sh","summary":"Shell Script","build":"GNU","version":"5.1.8","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"shell","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"99304304-e873-5c89-ae83-91e61a7f629c","preProcessors":[],"postProcessors":[],"application":{"name":"shell","shortName":"sh","summary":"Shell Script","build":"GNU","version":"5.1.8","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"sh","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"hello_world.sh"}],"monitors":["standard_output"],"applicationName":"shell","executableName":"sh","name":"hello_world","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"#!/bin/bash\n# ---------------------------------------------------------------- #\n#                                                                  #\n#  Example shell script for Exabyte.io platform.                   #\n#                                                                  #\n#  Will be used as follows:                                        #\n#                                                                  #\n#    1. shebang line is read from the first line above             #\n#    2. based on shebang one of the shell types is selected:       #\n#       - /bin/bash                                                #\n#       - /bin/csh                                                 #\n#       - /bin/tclsh                                               #\n#       - /bin/tcsh                                                #\n#       - /bin/zsh                                                 #\n#    3. runtime directory for this calculation is created          #\n#    4. the content of the script is executed                      #\n#                                                                  #\n#  Adjust the content below to include your code.                  #\n#                                                                  #\n# ---------------------------------------------------------------- #\n\necho \"Hello world!\"\n","name":"hello_world.sh","contextProviders":[],"applicationName":"shell","executableName":"sh","rendered":"#!/bin/bash\n# ---------------------------------------------------------------- #\n#                                                                  #\n#  Example shell script for Exabyte.io platform.                   #\n#                                                                  #\n#  Will be used as follows:                                        #\n#                                                                  #\n#    1. shebang line is read from the first line above             #\n#    2. based on shebang one of the shell types is selected:       #\n#       - /bin/bash                                                #\n#       - /bin/csh                                                 #\n#       - /bin/tclsh                                               #\n#       - /bin/tcsh                                                #\n#       - /bin/zsh                                                 #\n#    3. runtime directory for this calculation is created          #\n#    4. the content of the script is executed                      #\n#                                                                  #\n#  Adjust the content below to include your code.                  #\n#                                                                  #\n# ---------------------------------------------------------------- #\n\necho \"Hello world!\"\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Shell Hello World","type":"subworkflow","_id":"ce33d4cf-e0d2-5020-854d-9ea1fe5c8512","status":"idle","statusTrack":[],"flowchartId":"319307c2-bf22-5bf2-b4e9-a4cdf671b786","tags":[],"head":true}],"properties":[],"_id":"d2fd444c-06b4-5d66-baeb-449c680ae1bf","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"shell"}},"vasp/band_gap.json":{"name":"Band Gap","subworkflows":[{"_id":"e65f2461-5f5c-5a51-8c48-88ad37bff100","name":"Band Gap","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor","band_gaps","fermi_energy"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"vasp","head":true,"results":[{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"pressure"},{"name":"fermi_energy"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9cb87769-bf20-56bf-a8b3-5a164e3bf541","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"INCAR"},{"name":"KPOINTS"},{"name":"POSCAR"}],"results":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}],"next":"f0d65517-9592-5bc8-948e-a0851a766cbb"},{"type":"execution","name":"vasp_nscf","head":false,"results":[{"name":"band_gaps"},{"name":"fermi_energy"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"f0d65517-9592-5bc8-948e-a0851a766cbb","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"INCAR","templateName":"INCAR_BANDS"},{"name":"KPOINTS","templateName":"KPOINTS"},{"name":"POSCAR","templateName":"POSCAR"}],"results":["band_gaps","fermi_energy"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp_nscf","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA = 0.05\nISTART = 1\nICHARG = 11\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA = 0.05\nISTART = 1\nICHARG = 11\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Band Gap","type":"subworkflow","_id":"e65f2461-5f5c-5a51-8c48-88ad37bff100","status":"idle","statusTrack":[],"flowchartId":"db3b83ea-0ef5-594c-89a8-bde38dbc6105","tags":[],"head":true}],"properties":["atomic_forces","band_gaps","fermi_energy","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"16ca0232-a570-53d1-a4d3-32bbd6f3f0a2","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"vasp"}},"vasp/band_structure_dos.json":{"name":"Band Structure + Density of States","subworkflows":[{"_id":"d38fea11-9781-5151-8dae-d705381498be","name":"Band Structure + Density of States","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["density_of_states","total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor","band_structure"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"vasp","head":true,"results":[{"name":"density_of_states"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"pressure"},{"name":"fermi_energy"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9cb87769-bf20-56bf-a8b3-5a164e3bf541","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"INCAR"},{"name":"KPOINTS"},{"name":"POSCAR"}],"results":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}],"next":"1e1de3be-f6e4-513e-afe2-c84e567a8108"},{"type":"execution","name":"vasp_bands","head":false,"results":[{"name":"band_structure"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"1e1de3be-f6e4-513e-afe2-c84e567a8108","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"INCAR","templateName":"INCAR_BANDS"},{"name":"KPOINTS","templateName":"KPOINTS_BANDS"},{"name":"POSCAR","templateName":""}],"results":["band_structure"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp_bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA = 0.05\nISTART = 1\nICHARG = 11\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA = 0.05\nISTART = 1\nICHARG = 11\n","schemaVersion":"2022.8.16"},{"content":"kpoints path\n{{kpath.length}}\nreciprocal\n{% for point in kpath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KPathFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"kpoints path\n11\nreciprocal\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Band Structure + Density of States","type":"subworkflow","_id":"d38fea11-9781-5151-8dae-d705381498be","status":"idle","statusTrack":[],"flowchartId":"8a098bb9-73b1-5e84-bfc7-b783e02d0f53","tags":[],"head":true}],"properties":["atomic_forces","band_structure","density_of_states","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"c8338d40-3c6e-5581-b03c-d7fb5cbb8df5","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"vasp"}},"vasp/band_structure.json":{"name":"Band Structure","subworkflows":[{"_id":"cd6e3d59-5544-56ac-878b-fd8716a09768","name":"Band Structure","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor","band_structure"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"vasp","head":true,"results":[{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"pressure"},{"name":"fermi_energy"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9cb87769-bf20-56bf-a8b3-5a164e3bf541","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"INCAR"},{"name":"KPOINTS"},{"name":"POSCAR"}],"results":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}],"next":"1e1de3be-f6e4-513e-afe2-c84e567a8108"},{"type":"execution","name":"vasp_bands","head":false,"results":[{"name":"band_structure"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"1e1de3be-f6e4-513e-afe2-c84e567a8108","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"INCAR","templateName":"INCAR_BANDS"},{"name":"KPOINTS","templateName":"KPOINTS_BANDS"},{"name":"POSCAR","templateName":""}],"results":["band_structure"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp_bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA = 0.05\nISTART = 1\nICHARG = 11\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA = 0.05\nISTART = 1\nICHARG = 11\n","schemaVersion":"2022.8.16"},{"content":"kpoints path\n{{kpath.length}}\nreciprocal\n{% for point in kpath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KPathFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"kpoints path\n11\nreciprocal\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Band Structure","type":"subworkflow","_id":"cd6e3d59-5544-56ac-878b-fd8716a09768","status":"idle","statusTrack":[],"flowchartId":"c573187f-a8bb-5084-9fcf-1560bf4a7786","tags":[],"head":true}],"properties":["atomic_forces","band_structure","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"25b0ad08-87bb-5400-bea4-acd5fe2163c0","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"vasp"}},"vasp/dos.json":{"name":"Density of States","subworkflows":[{"_id":"4897ca33-b023-5a8d-9a5d-9e74df0f00ad","name":"Density of States","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["density_of_states","total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"vasp","head":true,"results":[{"name":"density_of_states"},{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"pressure"},{"name":"fermi_energy"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9cb87769-bf20-56bf-a8b3-5a164e3bf541","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"INCAR"},{"name":"KPOINTS"},{"name":"POSCAR"}],"results":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Density of States","type":"subworkflow","_id":"4897ca33-b023-5a8d-9a5d-9e74df0f00ad","status":"idle","statusTrack":[],"flowchartId":"3e64fdb4-ab5b-52a0-a1d5-51343c49481c","tags":[],"head":true}],"properties":["atomic_forces","density_of_states","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"629a79fb-a03f-5e34-b2ce-9c735e8ef6c0","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"vasp"}},"vasp/fixed_cell_relaxation.json":{"name":"Fixed-cell Relaxation","subworkflows":[{"_id":"db6cc94b-2f26-5688-ba97-80b11567b549","name":"Fixed-cell Relaxation","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","atomic_forces","fermi_energy","pressure","stress_tensor","total_force","final_structure"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"vasp_relax","head":true,"results":[{"name":"total_energy"},{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_force"},{"name":"final_structure"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"},{"name":"convergence_ionic"}],"flowchartId":"2f718a3d-5800-57e2-b707-075c1f1755c6","preProcessors":[],"postProcessors":[{"name":"prepare_restart"}],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"INCAR","templateName":"INCAR_RELAX"},{"name":"KPOINTS","templateName":"KPOINTS"},{"name":"POSCAR","templateName":"POSCAR"}],"results":["total_energy","atomic_forces","fermi_energy","pressure","stress_tensor","total_force","final_structure"],"monitors":["standard_output","convergence_electronic","convergence_ionic"],"postProcessors":["prepare_restart"],"applicationName":"vasp","executableName":"vasp","name":"vasp_relax","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA = 0.05\nISIF = 2\nIBRION = 2\nNSW = 300\nLWAVE = .FALSE.\nLCHARG = .FALSE.\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA = 0.05\nISIF = 2\nIBRION = 2\nNSW = 300\nLWAVE = .FALSE.\nLCHARG = .FALSE.\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Fixed-cell Relaxation","type":"subworkflow","_id":"db6cc94b-2f26-5688-ba97-80b11567b549","status":"idle","statusTrack":[],"flowchartId":"0de8c4c8-b722-5cd2-ae68-b484262e0a01","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","final_structure","pressure","stress_tensor","total_energy","total_force"],"_id":"cb69418c-2f6c-551d-af81-0cf20ec1113d","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"vasp"}},"vasp/kpoint_convergence.json":{"name":"K-point Convergence","subworkflows":[{"_id":"5d736d84-d616-538f-a09b-81a32ac0777c","name":"K-point Convergence","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"name":"Init tolerance","type":"assignment","operand":"TOL","value":0.00001,"input":[],"flowchartId":"init-tolerance","status":"idle","statusTrack":[],"tags":[],"head":true,"next":"init-increment","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Init increment","type":"assignment","operand":"INC","value":1,"input":[],"flowchartId":"init-increment","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"init-result","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Init result","type":"assignment","operand":"PREV_RESULT","value":0,"input":[],"flowchartId":"init-result","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"init-parameter","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"Init parameter","type":"assignment","operand":"PARAMETER","value":1,"input":[],"flowchartId":"init-parameter","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"vasp-kpoint-convergence","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"}},{"type":"execution","name":"vasp_kpt_conv","head":false,"results":[{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"pressure"},{"name":"fermi_energy"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"vasp-kpoint-convergence","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"INCAR","templateName":"INCAR"},{"name":"KPOINTS","templateName":"KPOINTS_CONV"},{"name":"POSCAR","templateName":"POSCAR"}],"results":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp_kpt_conv","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n","schemaVersion":"2022.8.16"},{"content":"Automatic Mesh\n0\nGamma\n{% raw %}{{PARAMETER | default('1')}} {{PARAMETER | default('1')}} {{PARAMETER | default('1')}}{% endraw %}\n0 0 0\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic Mesh\n0\nGamma\n{{PARAMETER | default('1')}} {{PARAMETER | default('1')}} {{PARAMETER | default('1')}}\n0 0 0\n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}],"next":"store-result"},{"name":"store result","type":"assignment","operand":"RESULT","value":"total_energy","input":[{"name":"total_energy","scope":"vasp-kpoint-convergence"}],"flowchartId":"store-result","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"check-convergence","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"check convergence","type":"condition","input":[],"results":[],"preProcessors":[],"postProcessors":[],"then":"convergence-is-reached","else":"update-result","statement":"abs((PREV_RESULT-RESULT)/RESULT) < TOL","maxOccurrences":50,"flowchartId":"check-convergence","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"update-result","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"update result","type":"assignment","operand":"PREV_RESULT","value":"RESULT","input":[{"name":"RESULT","scope":"global"}],"flowchartId":"update-result","status":"idle","statusTrack":[],"tags":[],"head":false,"next":"increment-parameter","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"increment parameter","type":"assignment","operand":"PREV_RESULT","value":"PARAMETER+INC","input":[{"name":"INC","scope":"global"},{"name":"PARAMETER","scope":"global"}],"flowchartId":"increment-parameter","next":"vasp-kpoint-convergence","status":"idle","statusTrack":[],"tags":[],"head":false,"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"}},{"name":"exit","type":"assignment","operand":"PARAMETER","value":"PARAMETER","input":[{"name":"PARAMETER","scope":"global"}],"flowchartId":"convergence-is-reached","status":"idle","statusTrack":[],"tags":[],"head":false,"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"}}]}],"units":[{"name":"K-point Convergence","type":"subworkflow","_id":"5d736d84-d616-538f-a09b-81a32ac0777c","status":"idle","statusTrack":[],"flowchartId":"a34eec2c-cdb2-537d-88c0-ed1d7b205879","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"fcf105f9-5ae7-5c32-a6b3-e3579cbdf39a","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"vasp"}},"vasp/neb.json":{"name":"Nudged Elastic Band (NEB)","subworkflows":[{"isMultiMaterial":true,"_id":"792e8c42-86ce-5f01-812a-66378ec4f379","name":"Initial/Final Total Energies","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor","total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"vasp_neb_initial","head":true,"results":[{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"pressure"},{"name":"fermi_energy"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"f969f010-9dae-5085-9ac5-86150ef78897","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"INCAR","templateName":"INCAR_NEB_INITIAL_FINAL"},{"name":"KPOINTS"},{"name":"POSCAR","templateName":"POSCAR_NEB_INITIAL"}],"results":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp_neb_initial","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISTART = 0\nENCUT = 500\nISPIN = 2\n","name":"INCAR","contextProviders":[{"name":"NEBFormDataManager"},{"name":"VASPNEBInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISTART = 0\nENCUT = 500\nISPIN = 2\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"},{"content":"{{ input.FIRST_IMAGE }}\n","name":"POSCAR","contextProviders":[{"name":"NEBFormDataManager"},{"name":"VASPNEBInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}],"next":"e65a17ce-10c8-5710-ad4d-fb3d42434091"},{"type":"execution","name":"vasp_neb_final","head":false,"results":[{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"pressure"},{"name":"fermi_energy"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"e65a17ce-10c8-5710-ad4d-fb3d42434091","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"INCAR","templateName":"INCAR_NEB_INITIAL_FINAL"},{"name":"KPOINTS"},{"name":"POSCAR","templateName":"POSCAR_NEB_FINAL"}],"results":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp_neb_final","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISTART = 0\nENCUT = 500\nISPIN = 2\n","name":"INCAR","contextProviders":[{"name":"NEBFormDataManager"},{"name":"VASPNEBInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISTART = 0\nENCUT = 500\nISPIN = 2\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"},{"content":"{{ input.LAST_IMAGE }}\n","name":"POSCAR","contextProviders":[{"name":"NEBFormDataManager"},{"name":"VASPNEBInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}]}]},{"isMultiMaterial":true,"_id":"c9b7ad2a-5207-5e41-9b66-28474a8921f8","name":"Prepare Directories","application":{"name":"shell","shortName":"sh","summary":"Shell Script","build":"GNU","version":"5.1.8","isDefault":true,"schemaVersion":"2022.8.16"},"properties":[],"model":{"type":"unknown","subtype":"unknown","method":{"type":"unknown","subtype":"unknown","data":{}}},"units":[{"type":"execution","name":"prepare-neb-images","head":true,"results":[],"monitors":[{"name":"standard_output"}],"flowchartId":"dc397ead-54ad-513b-992e-aedd54576409","preProcessors":[],"postProcessors":[],"application":{"name":"shell","shortName":"sh","summary":"Shell Script","build":"GNU","version":"5.1.8","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"monitors":["standard_output"],"name":"sh","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"bash_vasp_prepare_neb_images.sh"}],"monitors":["standard_output"],"applicationName":"shell","executableName":"sh","name":"bash_vasp_prepare_neb_images","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"#!/bin/bash\n\n# ------------------------------------------------------------------ #\n#  This script prepares necessary directories to run VASP NEB\n#  calculation. It puts initial POSCAR into directory 00, final into 0N\n#  and intermediate images in 01 to 0(N-1). It is assumed that SCF\n#  calculations for initial and final structures are already done in\n#  previous subworkflows and their standard outputs are written into\n#  \"vasp_neb_initial.out\" and \"vasp_neb_final.out\" files respectively.\n#  These outputs are here copied into initial (00) and final (0N)\n#  directories to calculate the reaction energy profile.\n# ------------------------------------------------------------------ #\n\n{% raw %}\ncd {{ JOB_WORK_DIR }}\n{% endraw %}\n\n# Prepare First Directory\nmkdir -p 00\ncat > 00/POSCAR <<EOF\n{{ input.FIRST_IMAGE }}\nEOF\ncp vasp_neb_initial.out 00/stdout\ncp CONTCAR 00/CONTCAR\n\n# Prepare Last Directory\nmkdir -p 0{{ input.INTERMEDIATE_IMAGES.length + 1 }}\ncat > 0{{ input.INTERMEDIATE_IMAGES.length + 1 }}/POSCAR <<EOF\n{{ input.LAST_IMAGE }}\nEOF\ncp CONTCAR 0{{ input.INTERMEDIATE_IMAGES.length + 1 }}/CONTCAR\ncp vasp_neb_final.out 0{{ input.INTERMEDIATE_IMAGES.length + 1 }}/stdout\n\n{% for IMAGE in input.INTERMEDIATE_IMAGES %}\n# Prepare Intermediate Directory {{ loop.index }}\nmkdir -p 0{{ loop.index }}\ncat > 0{{ loop.index }}/POSCAR <<EOF\n{{ IMAGE }}\nEOF\n{% endfor -%}\n","name":"bash_vasp_prepare_neb_images.sh","contextProviders":[{"name":"VASPNEBInputDataManager"}],"applicationName":"shell","executableName":"sh","rendered":"#!/bin/bash\n\n# ------------------------------------------------------------------ #\n#  This script prepares necessary directories to run VASP NEB\n#  calculation. It puts initial POSCAR into directory 00, final into 0N\n#  and intermediate images in 01 to 0(N-1). It is assumed that SCF\n#  calculations for initial and final structures are already done in\n#  previous subworkflows and their standard outputs are written into\n#  \"vasp_neb_initial.out\" and \"vasp_neb_final.out\" files respectively.\n#  These outputs are here copied into initial (00) and final (0N)\n#  directories to calculate the reaction energy profile.\n# ------------------------------------------------------------------ #\n\n\ncd {{ JOB_WORK_DIR }}\n\n\n# Prepare First Directory\nmkdir -p 00\ncat > 00/POSCAR <<EOF\nSilicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\nEOF\ncp vasp_neb_initial.out 00/stdout\ncp CONTCAR 00/CONTCAR\n\n# Prepare Last Directory\nmkdir -p 01\ncat > 01/POSCAR <<EOF\nSilicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\nEOF\ncp CONTCAR 01/CONTCAR\ncp vasp_neb_final.out 01/stdout\n\n","schemaVersion":"2022.8.16"}]}]},{"isMultiMaterial":true,"_id":"e6215fb9-e60c-541b-b73e-b077d64b3a95","name":"Nudged Elastic Band (NEB)","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["reaction_energy_barrier","reaction_energy_profile"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"vasp_neb","head":true,"results":[{"name":"reaction_energy_barrier"},{"name":"reaction_energy_profile"}],"monitors":[{"name":"standard_output"}],"flowchartId":"9a1660ab-8067-5fad-9fb8-7c039f634636","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"INCAR","templateName":"INCAR_NEB"},{"name":"KPOINTS","templateName":"KPOINTS"}],"results":["reaction_energy_barrier","reaction_energy_profile"],"monitors":["standard_output"],"applicationName":"vasp","executableName":"vasp","name":"vasp_neb","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISTART = 0\nIBRION = 1\nEDIFFG = -0.001\nENCUT = 500\nNELM = 100\nNSW = 100\nIMAGES = {{ input.INTERMEDIATE_IMAGES.length or neb.nImages }}\nSPRING = -5\nISPIN = 2\n","name":"INCAR","contextProviders":[{"name":"NEBFormDataManager"},{"name":"VASPNEBInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISTART = 0\nIBRION = 1\nEDIFFG = -0.001\nENCUT = 500\nNELM = 100\nNSW = 100\nIMAGES = 1\nSPRING = -5\nISPIN = 2\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Initial/Final Total Energies","type":"subworkflow","_id":"792e8c42-86ce-5f01-812a-66378ec4f379","status":"idle","statusTrack":[],"flowchartId":"427b4671-7c37-50f7-82c8-4d781b846fd8","tags":[],"head":true,"next":"8dd252f2-99c2-50c6-8a81-fa5881141985"},{"name":"Prepare Directories","type":"subworkflow","_id":"c9b7ad2a-5207-5e41-9b66-28474a8921f8","status":"idle","statusTrack":[],"flowchartId":"8dd252f2-99c2-50c6-8a81-fa5881141985","tags":[],"head":false,"next":"134c70e2-aeaf-543d-aded-1585cd71b800"},{"name":"Nudged Elastic Band (NEB)","type":"subworkflow","_id":"e6215fb9-e60c-541b-b73e-b077d64b3a95","status":"idle","statusTrack":[],"flowchartId":"134c70e2-aeaf-543d-aded-1585cd71b800","tags":[],"head":false}],"properties":["atomic_forces","atomic_forces","fermi_energy","fermi_energy","pressure","pressure","stress_tensor","stress_tensor","total_energy","total_energy","total_energy_contributions","total_energy_contributions","total_force","total_force"],"_id":"df41740d-5989-553c-b845-0559d6f8f86b","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"vasp"}},"vasp/recalculate_bands.json":{"name":"Recalculate Bands","subworkflows":[{"_id":"12f70885-f81a-5ff4-ae18-7ef4aaa27fc2","name":"Recalculate Bands","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["band_structure"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"vasp_bands","head":true,"results":[{"name":"band_structure"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"1e1de3be-f6e4-513e-afe2-c84e567a8108","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"INCAR","templateName":"INCAR_BANDS"},{"name":"KPOINTS","templateName":"KPOINTS_BANDS"},{"name":"POSCAR","templateName":""}],"results":["band_structure"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp_bands","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA = 0.05\nISTART = 1\nICHARG = 11\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA = 0.05\nISTART = 1\nICHARG = 11\n","schemaVersion":"2022.8.16"},{"content":"kpoints path\n{{kpath.length}}\nreciprocal\n{% for point in kpath -%}\n{% for d in point.coordinates %}{{d}} {% endfor -%}{{point.steps}}\n{% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KPathFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"kpoints path\n11\nreciprocal\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.000000000    0.500000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.375000000    0.375000000    0.750000000 10\n   0.000000000    0.000000000    0.000000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.250000000    0.750000000 10\n   0.500000000    0.500000000    0.500000000 10\n   0.625000000    0.250000000    0.625000000 10\n   0.500000000    0.000000000    0.500000000 10\n\n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Recalculate Bands","type":"subworkflow","_id":"12f70885-f81a-5ff4-ae18-7ef4aaa27fc2","status":"idle","statusTrack":[],"flowchartId":"e8b72a45-765e-565f-ab17-c91a21aec09d","tags":[],"head":true}],"properties":["band_structure"],"_id":"ba449bac-8bef-5315-a667-cd919930ab28","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"vasp"}},"vasp/surface_energy.json":{"name":"Surface Energy","subworkflows":[{"_id":"257d53c6-c3b6-564c-95ce-dd0514d26c63","name":"Surface Energy","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"name":"io-slab","type":"io","subtype":"input","head":true,"results":[],"monitors":[],"flowchartId":"e463ef46-a36e-5168-87dd-e21eb980dfb8","preProcessors":[],"postProcessors":[],"source":"api","input":[{"endpoint":"materials","endpoint_options":{"params":{"query":"{'_id': MATERIAL_ID}","projection":"{}"}},"name":"DATA"}],"next":"ee7abb4e-7848-5aeb-960d-0d441909e2d1","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"slab","type":"assignment","operand":"SLAB","value":"DATA[0]","input":[{"name":"DATA","scope":"e463ef46-a36e-5168-87dd-e21eb980dfb8"}],"head":false,"results":[],"monitors":[],"flowchartId":"ee7abb4e-7848-5aeb-960d-0d441909e2d1","preProcessors":[],"postProcessors":[],"next":"44263820-0c80-5bd1-b854-9da8d198eac1","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"io-bulk","type":"io","subtype":"input","head":false,"results":[],"monitors":[],"flowchartId":"44263820-0c80-5bd1-b854-9da8d198eac1","preProcessors":[],"postProcessors":[],"source":"api","input":[{"endpoint":"materials","endpoint_options":{"params":{"query":"{'_id': SLAB.metadata.bulkId}","projection":"{}"}},"name":"DATA"}],"next":"b70656f1-a394-57f4-b4de-00096969df4b","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"bulk","type":"assignment","operand":"BULK","value":"DATA[0] if DATA else None","input":[{"name":"DATA","scope":"44263820-0c80-5bd1-b854-9da8d198eac1"}],"head":false,"results":[],"monitors":[],"flowchartId":"b70656f1-a394-57f4-b4de-00096969df4b","preProcessors":[],"postProcessors":[],"next":"6ca4006a-e3ae-56ea-91a1-06b9790b5f7e","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"assert-bulk","type":"assertion","statement":"BULK != None","errorMessage":"Bulk material does not exist!","head":false,"results":[],"monitors":[],"flowchartId":"6ca4006a-e3ae-56ea-91a1-06b9790b5f7e","preProcessors":[],"postProcessors":[],"next":"490635e0-c593-5809-9eb2-c794b96cfed1","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"io-e-bulk","type":"io","subtype":"input","head":false,"results":[],"monitors":[],"flowchartId":"490635e0-c593-5809-9eb2-c794b96cfed1","preProcessors":[],"postProcessors":[],"source":"api","input":[{"endpoint":"refined-properties","endpoint_options":{"params":{"query":"{ 'exabyteId': BULK.exabyteId, 'data.name': 'total_energy', 'group': {'$regex': ''.join((SUBWORKFLOW.application.shortName, ':'))} }","projection":"{'sort': {'precision.value': -1}, 'limit': 1}"}},"name":"DATA"}],"next":"bbe13b97-4243-5a85-8f61-a279d0b797aa","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"e-bulk","type":"assignment","operand":"E_BULK","value":"DATA[0].data.value if DATA else None","input":[{"name":"DATA","scope":"490635e0-c593-5809-9eb2-c794b96cfed1"}],"head":false,"results":[],"monitors":[],"flowchartId":"bbe13b97-4243-5a85-8f61-a279d0b797aa","preProcessors":[],"postProcessors":[],"next":"a06c9f43-7670-5fd0-ac42-7028a472235a","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"assert-e-bulk","type":"assertion","statement":"E_BULK != None","errorMessage":"E_BULK does not exist!","head":false,"results":[],"monitors":[],"flowchartId":"a06c9f43-7670-5fd0-ac42-7028a472235a","preProcessors":[],"postProcessors":[],"next":"cdf210be-26ed-585a-b4ac-d55795ba2975","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"surface","type":"assignment","operand":"A","value":"np.linalg.norm(np.cross(SLAB.lattice.vectors.a, SLAB.lattice.vectors.b))","input":[],"head":false,"results":[],"monitors":[],"flowchartId":"cdf210be-26ed-585a-b4ac-d55795ba2975","preProcessors":[],"postProcessors":[],"next":"ffa8e43d-096a-555b-b8d0-6d283365ef47","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"n-bulk","type":"assignment","operand":"N_BULK","value":"len(BULK.basis.elements)","input":[],"head":false,"results":[],"monitors":[],"flowchartId":"ffa8e43d-096a-555b-b8d0-6d283365ef47","preProcessors":[],"postProcessors":[],"next":"a0336ec5-a6da-5e4c-bb48-82b70cf5245f","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"n-slab","type":"assignment","operand":"N_SLAB","value":"len(SLAB.basis.elements)","input":[],"head":false,"results":[],"monitors":[],"flowchartId":"a0336ec5-a6da-5e4c-bb48-82b70cf5245f","preProcessors":[],"postProcessors":[],"next":"913f756d-fbe1-548f-b3fc-f82ac46f1015","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"type":"execution","name":"vasp_symprec","head":false,"results":[{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"pressure"},{"name":"fermi_energy"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"913f756d-fbe1-548f-b3fc-f82ac46f1015","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"INCAR","templateName":"INCAR_SYMPREC"},{"name":"KPOINTS"},{"name":"POSCAR"}],"results":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp_symprec","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n# To avoid errors with high precision structures: \"internal error in subroutine SGRCON\"\nSYMPREC = 1e-6\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n# To avoid errors with high precision structures: \"internal error in subroutine SGRCON\"\nSYMPREC = 1e-6\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}],"next":"fcd88119-817c-5ac1-a430-ba892ac743eb"},{"name":"e-slab","type":"assignment","operand":"E_SLAB","value":"total_energy","input":[{"name":"total_energy","scope":"913f756d-fbe1-548f-b3fc-f82ac46f1015"}],"head":false,"results":[],"monitors":[],"flowchartId":"fcd88119-817c-5ac1-a430-ba892ac743eb","preProcessors":[],"postProcessors":[],"next":"542ea9ad-8a07-5a76-b233-f72fb27c4fc6","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]},{"name":"surface-energy","type":"assignment","operand":"SURFACE_ENERGY","value":"1 / (2 * A) * (E_SLAB - E_BULK * (N_SLAB/N_BULK))","input":[],"head":false,"results":[{"name":"surface_energy"}],"monitors":[],"flowchartId":"542ea9ad-8a07-5a76-b233-f72fb27c4fc6","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[]}]}],"units":[{"name":"Surface Energy","type":"subworkflow","_id":"257d53c6-c3b6-564c-95ce-dd0514d26c63","status":"idle","statusTrack":[],"flowchartId":"d81dc9ce-bb50-5bc6-af1d-e5ede03bb0a6","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","surface_energy","total_energy","total_energy_contributions","total_force"],"_id":"24b4e6d1-0846-55dd-ae27-624bab5057b4","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"vasp"}},"vasp/total_energy.json":{"name":"Total Energy","subworkflows":[{"_id":"1cd988fa-03f2-5b8c-aa72-8d7e50554988","name":"Total Energy","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"vasp","head":true,"results":[{"name":"total_energy"},{"name":"total_energy_contributions"},{"name":"pressure"},{"name":"fermi_energy"},{"name":"atomic_forces"},{"name":"total_force"},{"name":"stress_tensor"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"}],"flowchartId":"9cb87769-bf20-56bf-a8b3-5a164e3bf541","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"isDefault":true,"input":[{"name":"INCAR"},{"name":"KPOINTS"},{"name":"POSCAR"}],"results":["total_energy","total_energy_contributions","pressure","fermi_energy","atomic_forces","total_force","stress_tensor"],"monitors":["standard_output","convergence_electronic"],"applicationName":"vasp","executableName":"vasp","name":"vasp","schemaVersion":"2022.8.16"},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA  = 0.05\nLORBIT = 11\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Total Energy","type":"subworkflow","_id":"1cd988fa-03f2-5b8c-aa72-8d7e50554988","status":"idle","statusTrack":[],"flowchartId":"6059d61a-6a92-5657-9130-02208639aff8","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_energy_contributions","total_force"],"_id":"7a65612a-d06b-5c80-bb24-55e2b969a262","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"vasp"}},"vasp/variable_cell_relaxation.json":{"name":"Variable-cell Relaxation","subworkflows":[{"systemName":"vasp-variable-cell-relaxation","_id":"542f7e87-cf65-5579-952c-ddd9611ac558","name":"Variable-cell Relaxation","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","atomic_forces","fermi_energy","pressure","stress_tensor","total_force","final_structure"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"vasp_vc_relax","head":true,"results":[{"name":"total_energy"},{"name":"atomic_forces"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"stress_tensor"},{"name":"total_force"},{"name":"final_structure"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"},{"name":"convergence_ionic"}],"flowchartId":"26d53101-7288-547d-a994-e244417568d6","preProcessors":[],"postProcessors":[{"name":"prepare_restart"}],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"INCAR","templateName":"INCAR_VC_RELAX"},{"name":"KPOINTS","templateName":"KPOINTS"},{"name":"POSCAR","templateName":"POSCAR"}],"results":["total_energy","atomic_forces","fermi_energy","pressure","stress_tensor","total_force","final_structure"],"monitors":["standard_output","convergence_electronic","convergence_ionic"],"postProcessors":["prepare_restart"],"applicationName":"vasp","executableName":"vasp","name":"vasp_vc_relax","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 0\nSIGMA = 0.05\nISIF = 3\nIBRION = 2\nNSW = 300\nLWAVE = .FALSE.\nLCHARG = .FALSE.\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 0\nSIGMA = 0.05\nISIF = 3\nIBRION = 2\nNSW = 300\nLWAVE = .FALSE.\nLCHARG = .FALSE.\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Variable-cell Relaxation","type":"subworkflow","_id":"542f7e87-cf65-5579-952c-ddd9611ac558","status":"idle","statusTrack":[],"flowchartId":"8f6e9590-6a87-584b-abd7-1fb98253054c","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","final_structure","pressure","stress_tensor","total_energy","total_force"],"_id":"6edf0e69-36dd-5206-a331-320becf75266","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"tags":["variable-cell_relaxation"],"application":{"name":"vasp"}},"vasp/zero_point_energy.json":{"name":"Zero Point Energy","subworkflows":[{"_id":"2667054e-3c04-50a9-bd95-55c530d727c9","name":"Zero Point Energy","application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"properties":["total_energy","fermi_energy","pressure","atomic_forces","stress_tensor","total_force","zero_point_energy"],"model":{"type":"dft","subtype":"gga","method":{"type":"pseudopotential","subtype":"paw","data":{}},"functional":{"slug":"pbe"},"refiners":[],"modifiers":[]},"units":[{"type":"execution","name":"vasp_zpe","head":true,"results":[{"name":"total_energy"},{"name":"fermi_energy"},{"name":"pressure"},{"name":"atomic_forces"},{"name":"stress_tensor"},{"name":"total_force"},{"name":"zero_point_energy"}],"monitors":[{"name":"standard_output"},{"name":"convergence_electronic"},{"name":"convergence_ionic"}],"flowchartId":"c205541a-c734-5c4a-b0ca-a07d05c3e0ea","preProcessors":[],"postProcessors":[],"application":{"name":"vasp","shortName":"vasp","summary":"Vienna Ab-initio Simulation Package","isLicensed":true,"build":"GNU","version":"5.4.4","isDefault":true,"schemaVersion":"2022.8.16"},"executable":{"isDefault":true,"postProcessors":["error_handler","prepare_restart","remove_non_zero_weight_kpoints"],"monitors":["standard_output","convergence_ionic","convergence_electronic"],"name":"vasp","schemaVersion":"2022.8.16"},"flavor":{"input":[{"name":"INCAR","templateName":"INCAR_ZPE"},{"name":"KPOINTS","templateName":"KPOINTS"},{"name":"POSCAR","templateName":"POSCAR"}],"results":["total_energy","fermi_energy","pressure","atomic_forces","stress_tensor","total_force","zero_point_energy"],"monitors":["standard_output","convergence_electronic","convergence_ionic"],"applicationName":"vasp","executableName":"vasp","name":"vasp_zpe","schemaVersion":"2022.8.16","isDefault":false},"status":"idle","statusTrack":[],"tags":[],"input":[{"content":"ISMEAR = 1\nSIGMA = 0.1\nIBRION = 5\n","name":"INCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"ISMEAR = 1\nSIGMA = 0.1\nIBRION = 5\n","schemaVersion":"2022.8.16"},{"content":"Automatic mesh\n0\nGamma\n  {% for d in kgrid.dimensions %}{{d}} {% endfor %}\n  {% for s in kgrid.shifts %}{{s}} {% endfor %}\n","name":"KPOINTS","contextProviders":[{"name":"KGridFormDataManager"},{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Automatic mesh\n0\nGamma\n  2 2 2 \n  0 0 0 \n","schemaVersion":"2022.8.16"},{"content":"{{ input.POSCAR }}\n","name":"POSCAR","contextProviders":[{"name":"VASPInputDataManager"}],"applicationName":"vasp","executableName":"vasp","rendered":"Silicon FCC\n1.0\n   3.348920000\t   0.000000000\t   1.933500000\n   1.116307000\t   3.157392000\t   1.933500000\n   0.000000000\t   0.000000000\t   3.867000000\nSi\n2\ndirect\n   0.000000000    0.000000000    0.000000000  Si\n   0.250000000    0.250000000    0.250000000  Si\n","schemaVersion":"2022.8.16"}]}]}],"units":[{"name":"Zero Point Energy","type":"subworkflow","_id":"2667054e-3c04-50a9-bd95-55c530d727c9","status":"idle","statusTrack":[],"flowchartId":"d906bd20-eb92-5a01-a0e2-c81a2d9b2a41","tags":[],"head":true}],"properties":["atomic_forces","fermi_energy","pressure","stress_tensor","total_energy","total_force","zero_point_energy"],"_id":"f25b44b7-74ba-59ca-b86a-abcc53530e5f","workflows":[],"schemaVersion":"2022.8.16","isDefault":false,"application":{"name":"vasp"}}}}''')
