"use strict";
(self["webpackChunkecojupyter"] = self["webpackChunkecojupyter"] || []).push([["node_modules_visx_event_esm_index_js"],{

/***/ "./node_modules/@visx/event/esm/getXAndYFromEvent.js":
/*!***********************************************************!*\
  !*** ./node_modules/@visx/event/esm/getXAndYFromEvent.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getXAndYFromEvent)
/* harmony export */ });
/* harmony import */ var _typeGuards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./typeGuards */ "./node_modules/@visx/event/esm/typeGuards.js");
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var DEFAULT_POINT = {
  x: 0,
  y: 0
};
function getXAndYFromEvent(event) {
  if (!event) return _extends({}, DEFAULT_POINT);
  if ((0,_typeGuards__WEBPACK_IMPORTED_MODULE_0__.isTouchEvent)(event)) {
    return event.changedTouches.length > 0 ? {
      x: event.changedTouches[0].clientX,
      y: event.changedTouches[0].clientY
    } : _extends({}, DEFAULT_POINT);
  }
  if ((0,_typeGuards__WEBPACK_IMPORTED_MODULE_0__.isMouseEvent)(event)) {
    return {
      x: event.clientX,
      y: event.clientY
    };
  }

  // for focus events try to extract the center position of the target element
  var target = event == null ? void 0 : event.target;
  var boundingClientRect = target && 'getBoundingClientRect' in target ? target.getBoundingClientRect() : null;
  if (!boundingClientRect) return _extends({}, DEFAULT_POINT);
  return {
    x: boundingClientRect.x + boundingClientRect.width / 2,
    y: boundingClientRect.y + boundingClientRect.height / 2
  };
}

/***/ }),

/***/ "./node_modules/@visx/event/esm/index.js":
/*!***********************************************!*\
  !*** ./node_modules/@visx/event/esm/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   localPoint: () => (/* reexport safe */ _localPoint__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   touchPoint: () => (/* reexport safe */ _touchPoint__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _localPoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./localPoint */ "./node_modules/@visx/event/esm/localPoint.js");
/* harmony import */ var _touchPoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./touchPoint */ "./node_modules/@visx/event/esm/localPointGeneric.js");



/***/ }),

/***/ "./node_modules/@visx/event/esm/localPoint.js":
/*!****************************************************!*\
  !*** ./node_modules/@visx/event/esm/localPoint.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ localPoint)
/* harmony export */ });
/* harmony import */ var _localPointGeneric__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localPointGeneric */ "./node_modules/@visx/event/esm/localPointGeneric.js");
/* harmony import */ var _typeGuards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./typeGuards */ "./node_modules/@visx/event/esm/typeGuards.js");



/** Handles two signatures for backwards compatibility. */
function localPoint(nodeOrEvent, maybeEvent) {
  // localPoint(node, event)
  if ((0,_typeGuards__WEBPACK_IMPORTED_MODULE_0__.isElement)(nodeOrEvent) && maybeEvent) {
    return (0,_localPointGeneric__WEBPACK_IMPORTED_MODULE_1__["default"])(nodeOrEvent, maybeEvent);
  }
  // localPoint(event)
  if ((0,_typeGuards__WEBPACK_IMPORTED_MODULE_0__.isEvent)(nodeOrEvent)) {
    var event = nodeOrEvent;
    var node = event.target;
    if (node) return (0,_localPointGeneric__WEBPACK_IMPORTED_MODULE_1__["default"])(node, event);
  }
  return null;
}

/***/ }),

/***/ "./node_modules/@visx/event/esm/localPointGeneric.js":
/*!***********************************************************!*\
  !*** ./node_modules/@visx/event/esm/localPointGeneric.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ localPoint)
/* harmony export */ });
/* harmony import */ var _visx_point__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @visx/point */ "./node_modules/@visx/point/esm/Point.js");
/* harmony import */ var _typeGuards__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./typeGuards */ "./node_modules/@visx/event/esm/typeGuards.js");
/* harmony import */ var _getXAndYFromEvent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getXAndYFromEvent */ "./node_modules/@visx/event/esm/getXAndYFromEvent.js");



function localPoint(node, event) {
  if (!node || !event) return null;
  var coords = (0,_getXAndYFromEvent__WEBPACK_IMPORTED_MODULE_0__["default"])(event);

  // find top-most SVG
  var svg = (0,_typeGuards__WEBPACK_IMPORTED_MODULE_1__.isSVGElement)(node) ? node.ownerSVGElement : node;
  var screenCTM = (0,_typeGuards__WEBPACK_IMPORTED_MODULE_1__.isSVGGraphicsElement)(svg) ? svg.getScreenCTM() : null;
  if ((0,_typeGuards__WEBPACK_IMPORTED_MODULE_1__.isSVGSVGElement)(svg) && screenCTM) {
    var point = svg.createSVGPoint();
    point.x = coords.x;
    point.y = coords.y;
    point = point.matrixTransform(screenCTM.inverse());
    return new _visx_point__WEBPACK_IMPORTED_MODULE_2__["default"]({
      x: point.x,
      y: point.y
    });
  }

  // fall back to bounding box
  var rect = node.getBoundingClientRect();
  return new _visx_point__WEBPACK_IMPORTED_MODULE_2__["default"]({
    x: coords.x - rect.left - node.clientLeft,
    y: coords.y - rect.top - node.clientTop
  });
}

/***/ }),

/***/ "./node_modules/@visx/event/esm/typeGuards.js":
/*!****************************************************!*\
  !*** ./node_modules/@visx/event/esm/typeGuards.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isElement: () => (/* binding */ isElement),
/* harmony export */   isEvent: () => (/* binding */ isEvent),
/* harmony export */   isMouseEvent: () => (/* binding */ isMouseEvent),
/* harmony export */   isSVGElement: () => (/* binding */ isSVGElement),
/* harmony export */   isSVGGraphicsElement: () => (/* binding */ isSVGGraphicsElement),
/* harmony export */   isSVGSVGElement: () => (/* binding */ isSVGSVGElement),
/* harmony export */   isTouchEvent: () => (/* binding */ isTouchEvent)
/* harmony export */ });
function isElement(elem) {
  return !!elem && elem instanceof Element;
}

// functional definition of isSVGElement. Note that SVGSVGElements are HTMLElements
function isSVGElement(elem) {
  return !!elem && (elem instanceof SVGElement || 'ownerSVGElement' in elem);
}

// functional definition of SVGGElement
function isSVGSVGElement(elem) {
  return !!elem && 'createSVGPoint' in elem;
}
function isSVGGraphicsElement(elem) {
  return !!elem && 'getScreenCTM' in elem;
}

// functional definition of TouchEvent
function isTouchEvent(event) {
  return !!event && 'changedTouches' in event;
}

// functional definition of MouseEvent
function isMouseEvent(event) {
  return !!event && 'clientX' in event;
}

// functional definition of event
function isEvent(event) {
  return !!event && (event instanceof Event || 'nativeEvent' in event && event.nativeEvent instanceof Event);
}

/***/ }),

/***/ "./node_modules/@visx/point/esm/Point.js":
/*!***********************************************!*\
  !*** ./node_modules/@visx/point/esm/Point.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Point)
/* harmony export */ });
var Point = /*#__PURE__*/function () {
  function Point(_ref) {
    var _ref$x = _ref.x,
      x = _ref$x === void 0 ? 0 : _ref$x,
      _ref$y = _ref.y,
      y = _ref$y === void 0 ? 0 : _ref$y;
    this.x = 0;
    this.y = 0;
    this.x = x;
    this.y = y;
  }
  var _proto = Point.prototype;
  _proto.value = function value() {
    return {
      x: this.x,
      y: this.y
    };
  };
  _proto.toArray = function toArray() {
    return [this.x, this.y];
  };
  return Point;
}();


/***/ })

}]);
//# sourceMappingURL=node_modules_visx_event_esm_index_js.93bc365bfa9feef681b7.js.map