# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'BigquerySemanticLayerCredentialConfigurationArgs',
    'BigquerySemanticLayerCredentialConfigurationArgsDict',
    'BigquerySemanticLayerCredentialCredentialArgs',
    'BigquerySemanticLayerCredentialCredentialArgsDict',
    'DatabricksSemanticLayerCredentialConfigurationArgs',
    'DatabricksSemanticLayerCredentialConfigurationArgsDict',
    'DatabricksSemanticLayerCredentialCredentialArgs',
    'DatabricksSemanticLayerCredentialCredentialArgsDict',
    'GlobalConnectionApacheSparkArgs',
    'GlobalConnectionApacheSparkArgsDict',
    'GlobalConnectionAthenaArgs',
    'GlobalConnectionAthenaArgsDict',
    'GlobalConnectionBigqueryArgs',
    'GlobalConnectionBigqueryArgsDict',
    'GlobalConnectionDatabricksArgs',
    'GlobalConnectionDatabricksArgsDict',
    'GlobalConnectionFabricArgs',
    'GlobalConnectionFabricArgsDict',
    'GlobalConnectionPostgresArgs',
    'GlobalConnectionPostgresArgsDict',
    'GlobalConnectionPostgresSshTunnelArgs',
    'GlobalConnectionPostgresSshTunnelArgsDict',
    'GlobalConnectionRedshiftArgs',
    'GlobalConnectionRedshiftArgsDict',
    'GlobalConnectionRedshiftSshTunnelArgs',
    'GlobalConnectionRedshiftSshTunnelArgsDict',
    'GlobalConnectionSnowflakeArgs',
    'GlobalConnectionSnowflakeArgsDict',
    'GlobalConnectionStarburstArgs',
    'GlobalConnectionStarburstArgsDict',
    'GlobalConnectionSynapseArgs',
    'GlobalConnectionSynapseArgsDict',
    'GlobalConnectionTeradataArgs',
    'GlobalConnectionTeradataArgsDict',
    'GroupGroupPermissionArgs',
    'GroupGroupPermissionArgsDict',
    'GroupPartialPermissionsGroupPermissionArgs',
    'GroupPartialPermissionsGroupPermissionArgsDict',
    'IpRestrictionsRuleCidrArgs',
    'IpRestrictionsRuleCidrArgsDict',
    'JobJobCompletionTriggerConditionArgs',
    'JobJobCompletionTriggerConditionArgsDict',
    'JobTriggersArgs',
    'JobTriggersArgsDict',
    'PostgresSemanticLayerCredentialConfigurationArgs',
    'PostgresSemanticLayerCredentialConfigurationArgsDict',
    'PostgresSemanticLayerCredentialCredentialArgs',
    'PostgresSemanticLayerCredentialCredentialArgsDict',
    'RedshiftSemanticLayerCredentialConfigurationArgs',
    'RedshiftSemanticLayerCredentialConfigurationArgsDict',
    'RedshiftSemanticLayerCredentialCredentialArgs',
    'RedshiftSemanticLayerCredentialCredentialArgsDict',
    'ServiceTokenServiceTokenPermissionArgs',
    'ServiceTokenServiceTokenPermissionArgsDict',
    'SnowflakeSemanticLayerCredentialConfigurationArgs',
    'SnowflakeSemanticLayerCredentialConfigurationArgsDict',
    'SnowflakeSemanticLayerCredentialCredentialArgs',
    'SnowflakeSemanticLayerCredentialCredentialArgsDict',
    'GetJobJobCompletionTriggerConditionArgs',
    'GetJobJobCompletionTriggerConditionArgsDict',
    'GetRunsFilterArgs',
    'GetRunsFilterArgsDict',
    'GetServiceTokenServiceTokenPermissionArgs',
    'GetServiceTokenServiceTokenPermissionArgsDict',
]

MYPY = False

if not MYPY:
    class BigquerySemanticLayerCredentialConfigurationArgsDict(TypedDict):
        adapter_version: pulumi.Input[builtins.str]
        """
        The adapter version
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the configuration
        """
        project_id: pulumi.Input[builtins.int]
        """
        The ID of the project
        """
elif False:
    BigquerySemanticLayerCredentialConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BigquerySemanticLayerCredentialConfigurationArgs:
    def __init__(__self__, *,
                 adapter_version: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] adapter_version: The adapter version
        :param pulumi.Input[builtins.str] name: The name of the configuration
        :param pulumi.Input[builtins.int] project_id: The ID of the project
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> pulumi.Input[builtins.str]:
        """
        The adapter version
        """
        return pulumi.get(self, "adapter_version")

    @adapter_version.setter
    def adapter_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "adapter_version", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)


if not MYPY:
    class BigquerySemanticLayerCredentialCredentialArgsDict(TypedDict):
        dataset: pulumi.Input[builtins.str]
        """
        Default dataset name
        """
        num_threads: pulumi.Input[builtins.int]
        """
        Number of threads to use
        """
        project_id: pulumi.Input[builtins.int]
        """
        Project ID to create the BigQuery credential in
        """
        credential_id: NotRequired[pulumi.Input[builtins.int]]
        """
        The internal credential ID
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        is_active: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the BigQuery credential is active
        """
elif False:
    BigquerySemanticLayerCredentialCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BigquerySemanticLayerCredentialCredentialArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[builtins.str],
                 num_threads: pulumi.Input[builtins.int],
                 project_id: pulumi.Input[builtins.int],
                 credential_id: Optional[pulumi.Input[builtins.int]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] dataset: Default dataset name
        :param pulumi.Input[builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[builtins.int] project_id: Project ID to create the BigQuery credential in
        :param pulumi.Input[builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[builtins.str] id: The ID of this resource. Contains the project ID and the credential ID.
        :param pulumi.Input[builtins.bool] is_active: Whether the BigQuery credential is active
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "num_threads", num_threads)
        pulumi.set(__self__, "project_id", project_id)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[builtins.str]:
        """
        Default dataset name
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> pulumi.Input[builtins.int]:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "num_threads", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        Project ID to create the BigQuery credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the BigQuery credential is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_active", value)


if not MYPY:
    class DatabricksSemanticLayerCredentialConfigurationArgsDict(TypedDict):
        adapter_version: pulumi.Input[builtins.str]
        """
        The adapter version
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the configuration
        """
        project_id: pulumi.Input[builtins.int]
        """
        The ID of the project
        """
elif False:
    DatabricksSemanticLayerCredentialConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabricksSemanticLayerCredentialConfigurationArgs:
    def __init__(__self__, *,
                 adapter_version: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] adapter_version: The adapter version
        :param pulumi.Input[builtins.str] name: The name of the configuration
        :param pulumi.Input[builtins.int] project_id: The ID of the project
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> pulumi.Input[builtins.str]:
        """
        The adapter version
        """
        return pulumi.get(self, "adapter_version")

    @adapter_version.setter
    def adapter_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "adapter_version", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)


if not MYPY:
    class DatabricksSemanticLayerCredentialCredentialArgsDict(TypedDict):
        project_id: pulumi.Input[builtins.int]
        """
        Project ID to create the Databricks credential in
        """
        token: pulumi.Input[builtins.str]
        """
        Token for Databricks user
        """
        adapter_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of the adapter (databricks or spark). Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        catalog: NotRequired[pulumi.Input[builtins.str]]
        """
        The catalog where to create models (only for the databricks adapter)
        """
        credential_id: NotRequired[pulumi.Input[builtins.int]]
        """
        The system Databricks credential ID
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        schema: NotRequired[pulumi.Input[builtins.str]]
        """
        The schema where to create models. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        semantic_layer_credential: NotRequired[pulumi.Input[builtins.bool]]
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Databricks credential for the Semantic Layer.
        """
        target_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Target name
        """
elif False:
    DatabricksSemanticLayerCredentialCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabricksSemanticLayerCredentialCredentialArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[builtins.int],
                 token: pulumi.Input[builtins.str],
                 adapter_type: Optional[pulumi.Input[builtins.str]] = None,
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 credential_id: Optional[pulumi.Input[builtins.int]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 semantic_layer_credential: Optional[pulumi.Input[builtins.bool]] = None,
                 target_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Databricks credential in
        :param pulumi.Input[builtins.str] token: Token for Databricks user
        :param pulumi.Input[builtins.str] adapter_type: The type of the adapter (databricks or spark). Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param pulumi.Input[builtins.str] catalog: The catalog where to create models (only for the databricks adapter)
        :param pulumi.Input[builtins.int] credential_id: The system Databricks credential ID
        :param pulumi.Input[builtins.str] id: The ID of this resource. Contains the project ID and the credential ID.
        :param pulumi.Input[builtins.str] schema: The schema where to create models. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param pulumi.Input[builtins.bool] semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Databricks credential for the Semantic Layer.
        :param pulumi.Input[builtins.str] target_name: Target name
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "token", token)
        if adapter_type is not None:
            pulumi.set(__self__, "adapter_type", adapter_type)
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if semantic_layer_credential is not None:
            pulumi.set(__self__, "semantic_layer_credential", semantic_layer_credential)
        if target_name is not None:
            warnings.warn("""This field is deprecated at the environment level (it was never possible to set it in the UI) and will be removed in a future release. Please remove it and set the target name at the job level or leverage environment variables.""", DeprecationWarning)
            pulumi.log.warn("""target_name is deprecated: This field is deprecated at the environment level (it was never possible to set it in the UI) and will be removed in a future release. Please remove it and set the target name at the job level or leverage environment variables.""")
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        Project ID to create the Databricks credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[builtins.str]:
        """
        Token for Databricks user
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="adapterType")
    def adapter_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the adapter (databricks or spark). Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "adapter_type")

    @adapter_type.setter
    def adapter_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "adapter_type", value)

    @property
    @pulumi.getter
    def catalog(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The catalog where to create models (only for the databricks adapter)
        """
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog", value)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The system Databricks credential ID
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The schema where to create models. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="semanticLayerCredential")
    def semantic_layer_credential(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Databricks credential for the Semantic Layer.
        """
        return pulumi.get(self, "semantic_layer_credential")

    @semantic_layer_credential.setter
    def semantic_layer_credential(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "semantic_layer_credential", value)

    @property
    @pulumi.getter(name="targetName")
    @_utilities.deprecated("""This field is deprecated at the environment level (it was never possible to set it in the UI) and will be removed in a future release. Please remove it and set the target name at the job level or leverage environment variables.""")
    def target_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Target name
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_name", value)


if not MYPY:
    class GlobalConnectionApacheSparkArgsDict(TypedDict):
        cluster: pulumi.Input[builtins.str]
        """
        Spark cluster for the connection
        """
        host: pulumi.Input[builtins.str]
        """
        Hostname of the connection
        """
        method: pulumi.Input[builtins.str]
        """
        Authentication method for the connection (http or thrift).
        """
        auth: NotRequired[pulumi.Input[builtins.str]]
        """
        Auth
        """
        connect_retries: NotRequired[pulumi.Input[builtins.int]]
        """
        Connection retries. Default=0
        """
        connect_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        Connection time out in seconds. Default=10
        """
        organization: NotRequired[pulumi.Input[builtins.str]]
        """
        Organization ID
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        Port for the connection. Default=443
        """
        user: NotRequired[pulumi.Input[builtins.str]]
        """
        User
        """
elif False:
    GlobalConnectionApacheSparkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionApacheSparkArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[builtins.str],
                 host: pulumi.Input[builtins.str],
                 method: pulumi.Input[builtins.str],
                 auth: Optional[pulumi.Input[builtins.str]] = None,
                 connect_retries: Optional[pulumi.Input[builtins.int]] = None,
                 connect_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] cluster: Spark cluster for the connection
        :param pulumi.Input[builtins.str] host: Hostname of the connection
        :param pulumi.Input[builtins.str] method: Authentication method for the connection (http or thrift).
        :param pulumi.Input[builtins.str] auth: Auth
        :param pulumi.Input[builtins.int] connect_retries: Connection retries. Default=0
        :param pulumi.Input[builtins.int] connect_timeout: Connection time out in seconds. Default=10
        :param pulumi.Input[builtins.str] organization: Organization ID
        :param pulumi.Input[builtins.int] port: Port for the connection. Default=443
        :param pulumi.Input[builtins.str] user: User
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "method", method)
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if connect_retries is not None:
            pulumi.set(__self__, "connect_retries", connect_retries)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[builtins.str]:
        """
        Spark cluster for the connection
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[builtins.str]:
        """
        Hostname of the connection
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def method(self) -> pulumi.Input[builtins.str]:
        """
        Authentication method for the connection (http or thrift).
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Auth
        """
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter(name="connectRetries")
    def connect_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Connection retries. Default=0
        """
        return pulumi.get(self, "connect_retries")

    @connect_retries.setter
    def connect_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connect_retries", value)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Connection time out in seconds. Default=10
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connect_timeout", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization ID
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port for the connection. Default=443
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


if not MYPY:
    class GlobalConnectionAthenaArgsDict(TypedDict):
        database: pulumi.Input[builtins.str]
        """
        Specify the database (data catalog) to build models into (lowercase only).
        """
        region_name: pulumi.Input[builtins.str]
        """
        AWS region of your Athena instance.
        """
        s3_staging_dir: pulumi.Input[builtins.str]
        """
        S3 location to store Athena query results and metadata.
        """
        num_boto3_retries: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of times to retry boto3 requests (e.g. deleting S3 files for materialized tables).
        """
        num_iceberg_retries: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of times to retry iceberg commit queries to fix ICEBERG*COMMIT*ERROR.
        """
        num_retries: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of times to retry a failing query.
        """
        poll_interval: NotRequired[pulumi.Input[builtins.int]]
        """
        Interval in seconds to use for polling the status of query results in Athena.
        """
        s3_data_dir: NotRequired[pulumi.Input[builtins.str]]
        """
        Prefix for storing tables, if different from the connection's S3 staging directory.
        """
        s3_data_naming: NotRequired[pulumi.Input[builtins.str]]
        """
        How to generate table paths in the S3 data directory.
        """
        s3_tmp_table_dir: NotRequired[pulumi.Input[builtins.str]]
        """
        Prefix for storing temporary tables, if different from the connection's S3 data directory.
        """
        spark_work_group: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier of Athena Spark workgroup for running Python models.
        """
        work_group: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier of Athena workgroup.
        """
elif False:
    GlobalConnectionAthenaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionAthenaArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[builtins.str],
                 region_name: pulumi.Input[builtins.str],
                 s3_staging_dir: pulumi.Input[builtins.str],
                 num_boto3_retries: Optional[pulumi.Input[builtins.int]] = None,
                 num_iceberg_retries: Optional[pulumi.Input[builtins.int]] = None,
                 num_retries: Optional[pulumi.Input[builtins.int]] = None,
                 poll_interval: Optional[pulumi.Input[builtins.int]] = None,
                 s3_data_dir: Optional[pulumi.Input[builtins.str]] = None,
                 s3_data_naming: Optional[pulumi.Input[builtins.str]] = None,
                 s3_tmp_table_dir: Optional[pulumi.Input[builtins.str]] = None,
                 spark_work_group: Optional[pulumi.Input[builtins.str]] = None,
                 work_group: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] database: Specify the database (data catalog) to build models into (lowercase only).
        :param pulumi.Input[builtins.str] region_name: AWS region of your Athena instance.
        :param pulumi.Input[builtins.str] s3_staging_dir: S3 location to store Athena query results and metadata.
        :param pulumi.Input[builtins.int] num_boto3_retries: Number of times to retry boto3 requests (e.g. deleting S3 files for materialized tables).
        :param pulumi.Input[builtins.int] num_iceberg_retries: Number of times to retry iceberg commit queries to fix ICEBERG*COMMIT*ERROR.
        :param pulumi.Input[builtins.int] num_retries: Number of times to retry a failing query.
        :param pulumi.Input[builtins.int] poll_interval: Interval in seconds to use for polling the status of query results in Athena.
        :param pulumi.Input[builtins.str] s3_data_dir: Prefix for storing tables, if different from the connection's S3 staging directory.
        :param pulumi.Input[builtins.str] s3_data_naming: How to generate table paths in the S3 data directory.
        :param pulumi.Input[builtins.str] s3_tmp_table_dir: Prefix for storing temporary tables, if different from the connection's S3 data directory.
        :param pulumi.Input[builtins.str] spark_work_group: Identifier of Athena Spark workgroup for running Python models.
        :param pulumi.Input[builtins.str] work_group: Identifier of Athena workgroup.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "s3_staging_dir", s3_staging_dir)
        if num_boto3_retries is not None:
            pulumi.set(__self__, "num_boto3_retries", num_boto3_retries)
        if num_iceberg_retries is not None:
            pulumi.set(__self__, "num_iceberg_retries", num_iceberg_retries)
        if num_retries is not None:
            pulumi.set(__self__, "num_retries", num_retries)
        if poll_interval is not None:
            pulumi.set(__self__, "poll_interval", poll_interval)
        if s3_data_dir is not None:
            pulumi.set(__self__, "s3_data_dir", s3_data_dir)
        if s3_data_naming is not None:
            pulumi.set(__self__, "s3_data_naming", s3_data_naming)
        if s3_tmp_table_dir is not None:
            pulumi.set(__self__, "s3_tmp_table_dir", s3_tmp_table_dir)
        if spark_work_group is not None:
            pulumi.set(__self__, "spark_work_group", spark_work_group)
        if work_group is not None:
            pulumi.set(__self__, "work_group", work_group)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[builtins.str]:
        """
        Specify the database (data catalog) to build models into (lowercase only).
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Input[builtins.str]:
        """
        AWS region of your Athena instance.
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region_name", value)

    @property
    @pulumi.getter(name="s3StagingDir")
    def s3_staging_dir(self) -> pulumi.Input[builtins.str]:
        """
        S3 location to store Athena query results and metadata.
        """
        return pulumi.get(self, "s3_staging_dir")

    @s3_staging_dir.setter
    def s3_staging_dir(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "s3_staging_dir", value)

    @property
    @pulumi.getter(name="numBoto3Retries")
    def num_boto3_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of times to retry boto3 requests (e.g. deleting S3 files for materialized tables).
        """
        return pulumi.get(self, "num_boto3_retries")

    @num_boto3_retries.setter
    def num_boto3_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_boto3_retries", value)

    @property
    @pulumi.getter(name="numIcebergRetries")
    def num_iceberg_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of times to retry iceberg commit queries to fix ICEBERG*COMMIT*ERROR.
        """
        return pulumi.get(self, "num_iceberg_retries")

    @num_iceberg_retries.setter
    def num_iceberg_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_iceberg_retries", value)

    @property
    @pulumi.getter(name="numRetries")
    def num_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of times to retry a failing query.
        """
        return pulumi.get(self, "num_retries")

    @num_retries.setter
    def num_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_retries", value)

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Interval in seconds to use for polling the status of query results in Athena.
        """
        return pulumi.get(self, "poll_interval")

    @poll_interval.setter
    def poll_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "poll_interval", value)

    @property
    @pulumi.getter(name="s3DataDir")
    def s3_data_dir(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prefix for storing tables, if different from the connection's S3 staging directory.
        """
        return pulumi.get(self, "s3_data_dir")

    @s3_data_dir.setter
    def s3_data_dir(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_data_dir", value)

    @property
    @pulumi.getter(name="s3DataNaming")
    def s3_data_naming(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How to generate table paths in the S3 data directory.
        """
        return pulumi.get(self, "s3_data_naming")

    @s3_data_naming.setter
    def s3_data_naming(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_data_naming", value)

    @property
    @pulumi.getter(name="s3TmpTableDir")
    def s3_tmp_table_dir(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prefix for storing temporary tables, if different from the connection's S3 data directory.
        """
        return pulumi.get(self, "s3_tmp_table_dir")

    @s3_tmp_table_dir.setter
    def s3_tmp_table_dir(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_tmp_table_dir", value)

    @property
    @pulumi.getter(name="sparkWorkGroup")
    def spark_work_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of Athena Spark workgroup for running Python models.
        """
        return pulumi.get(self, "spark_work_group")

    @spark_work_group.setter
    def spark_work_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spark_work_group", value)

    @property
    @pulumi.getter(name="workGroup")
    def work_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of Athena workgroup.
        """
        return pulumi.get(self, "work_group")

    @work_group.setter
    def work_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "work_group", value)


if not MYPY:
    class GlobalConnectionBigqueryArgsDict(TypedDict):
        auth_provider_x509_cert_url: pulumi.Input[builtins.str]
        """
        Auth Provider X509 Cert URL for the Service Account
        """
        auth_uri: pulumi.Input[builtins.str]
        """
        Auth URI for the Service Account
        """
        client_email: pulumi.Input[builtins.str]
        """
        Service Account email
        """
        client_id: pulumi.Input[builtins.str]
        """
        Client ID of the Service Account
        """
        client_x509_cert_url: pulumi.Input[builtins.str]
        """
        Client X509 Cert URL for the Service Account
        """
        gcp_project_id: pulumi.Input[builtins.str]
        """
        The GCP project ID to use for the connection
        """
        private_key: pulumi.Input[builtins.str]
        """
        Private Key for the Service Account
        """
        private_key_id: pulumi.Input[builtins.str]
        """
        Private Key ID for the Service Account
        """
        token_uri: pulumi.Input[builtins.str]
        """
        Token URI for the Service Account
        """
        application_id: NotRequired[pulumi.Input[builtins.str]]
        """
        OAuth Client ID
        """
        application_secret: NotRequired[pulumi.Input[builtins.str]]
        """
        OAuth Client Secret
        """
        dataproc_cluster_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Dataproc cluster name for PySpark workloads
        """
        dataproc_region: NotRequired[pulumi.Input[builtins.str]]
        """
        Google Cloud region for PySpark workloads on Dataproc
        """
        execution_project: NotRequired[pulumi.Input[builtins.str]]
        """
        Project to bill for query execution
        """
        gcs_bucket: NotRequired[pulumi.Input[builtins.str]]
        """
        URI for a Google Cloud Storage bucket to host Python code executed via Datapro
        """
        impersonate_service_account: NotRequired[pulumi.Input[builtins.str]]
        """
        Service Account to impersonate when running queries
        """
        job_creation_timeout_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Maximum timeout for the job creation step
        """
        job_retry_deadline_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Total number of seconds to wait while retrying the same query
        """
        location: NotRequired[pulumi.Input[builtins.str]]
        """
        Location to create new Datasets in
        """
        maximum_bytes_billed: NotRequired[pulumi.Input[builtins.int]]
        """
        Max number of bytes that can be billed for a given BigQuery query
        """
        priority: NotRequired[pulumi.Input[builtins.str]]
        """
        The priority with which to execute BigQuery queries (batch or interactive)
        """
        retries: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of retries for queries
        """
        scopes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        OAuth scopes for the BigQuery connection
        """
        timeout_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Timeout in seconds for queries
        """
elif False:
    GlobalConnectionBigqueryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionBigqueryArgs:
    def __init__(__self__, *,
                 auth_provider_x509_cert_url: pulumi.Input[builtins.str],
                 auth_uri: pulumi.Input[builtins.str],
                 client_email: pulumi.Input[builtins.str],
                 client_id: pulumi.Input[builtins.str],
                 client_x509_cert_url: pulumi.Input[builtins.str],
                 gcp_project_id: pulumi.Input[builtins.str],
                 private_key: pulumi.Input[builtins.str],
                 private_key_id: pulumi.Input[builtins.str],
                 token_uri: pulumi.Input[builtins.str],
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 application_secret: Optional[pulumi.Input[builtins.str]] = None,
                 dataproc_cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 dataproc_region: Optional[pulumi.Input[builtins.str]] = None,
                 execution_project: Optional[pulumi.Input[builtins.str]] = None,
                 gcs_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 impersonate_service_account: Optional[pulumi.Input[builtins.str]] = None,
                 job_creation_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 job_retry_deadline_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maximum_bytes_billed: Optional[pulumi.Input[builtins.int]] = None,
                 priority: Optional[pulumi.Input[builtins.str]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout_seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] auth_provider_x509_cert_url: Auth Provider X509 Cert URL for the Service Account
        :param pulumi.Input[builtins.str] auth_uri: Auth URI for the Service Account
        :param pulumi.Input[builtins.str] client_email: Service Account email
        :param pulumi.Input[builtins.str] client_id: Client ID of the Service Account
        :param pulumi.Input[builtins.str] client_x509_cert_url: Client X509 Cert URL for the Service Account
        :param pulumi.Input[builtins.str] gcp_project_id: The GCP project ID to use for the connection
        :param pulumi.Input[builtins.str] private_key: Private Key for the Service Account
        :param pulumi.Input[builtins.str] private_key_id: Private Key ID for the Service Account
        :param pulumi.Input[builtins.str] token_uri: Token URI for the Service Account
        :param pulumi.Input[builtins.str] application_id: OAuth Client ID
        :param pulumi.Input[builtins.str] application_secret: OAuth Client Secret
        :param pulumi.Input[builtins.str] dataproc_cluster_name: Dataproc cluster name for PySpark workloads
        :param pulumi.Input[builtins.str] dataproc_region: Google Cloud region for PySpark workloads on Dataproc
        :param pulumi.Input[builtins.str] execution_project: Project to bill for query execution
        :param pulumi.Input[builtins.str] gcs_bucket: URI for a Google Cloud Storage bucket to host Python code executed via Datapro
        :param pulumi.Input[builtins.str] impersonate_service_account: Service Account to impersonate when running queries
        :param pulumi.Input[builtins.int] job_creation_timeout_seconds: Maximum timeout for the job creation step
        :param pulumi.Input[builtins.int] job_retry_deadline_seconds: Total number of seconds to wait while retrying the same query
        :param pulumi.Input[builtins.str] location: Location to create new Datasets in
        :param pulumi.Input[builtins.int] maximum_bytes_billed: Max number of bytes that can be billed for a given BigQuery query
        :param pulumi.Input[builtins.str] priority: The priority with which to execute BigQuery queries (batch or interactive)
        :param pulumi.Input[builtins.int] retries: Number of retries for queries
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: OAuth scopes for the BigQuery connection
        :param pulumi.Input[builtins.int] timeout_seconds: Timeout in seconds for queries
        """
        pulumi.set(__self__, "auth_provider_x509_cert_url", auth_provider_x509_cert_url)
        pulumi.set(__self__, "auth_uri", auth_uri)
        pulumi.set(__self__, "client_email", client_email)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_x509_cert_url", client_x509_cert_url)
        pulumi.set(__self__, "gcp_project_id", gcp_project_id)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "private_key_id", private_key_id)
        pulumi.set(__self__, "token_uri", token_uri)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_secret is not None:
            pulumi.set(__self__, "application_secret", application_secret)
        if dataproc_cluster_name is not None:
            pulumi.set(__self__, "dataproc_cluster_name", dataproc_cluster_name)
        if dataproc_region is not None:
            pulumi.set(__self__, "dataproc_region", dataproc_region)
        if execution_project is not None:
            pulumi.set(__self__, "execution_project", execution_project)
        if gcs_bucket is not None:
            pulumi.set(__self__, "gcs_bucket", gcs_bucket)
        if impersonate_service_account is not None:
            pulumi.set(__self__, "impersonate_service_account", impersonate_service_account)
        if job_creation_timeout_seconds is not None:
            pulumi.set(__self__, "job_creation_timeout_seconds", job_creation_timeout_seconds)
        if job_retry_deadline_seconds is not None:
            pulumi.set(__self__, "job_retry_deadline_seconds", job_retry_deadline_seconds)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_bytes_billed is not None:
            pulumi.set(__self__, "maximum_bytes_billed", maximum_bytes_billed)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="authProviderX509CertUrl")
    def auth_provider_x509_cert_url(self) -> pulumi.Input[builtins.str]:
        """
        Auth Provider X509 Cert URL for the Service Account
        """
        return pulumi.get(self, "auth_provider_x509_cert_url")

    @auth_provider_x509_cert_url.setter
    def auth_provider_x509_cert_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "auth_provider_x509_cert_url", value)

    @property
    @pulumi.getter(name="authUri")
    def auth_uri(self) -> pulumi.Input[builtins.str]:
        """
        Auth URI for the Service Account
        """
        return pulumi.get(self, "auth_uri")

    @auth_uri.setter
    def auth_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "auth_uri", value)

    @property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Input[builtins.str]:
        """
        Service Account email
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_email", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        Client ID of the Service Account
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientX509CertUrl")
    def client_x509_cert_url(self) -> pulumi.Input[builtins.str]:
        """
        Client X509 Cert URL for the Service Account
        """
        return pulumi.get(self, "client_x509_cert_url")

    @client_x509_cert_url.setter
    def client_x509_cert_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_x509_cert_url", value)

    @property
    @pulumi.getter(name="gcpProjectId")
    def gcp_project_id(self) -> pulumi.Input[builtins.str]:
        """
        The GCP project ID to use for the connection
        """
        return pulumi.get(self, "gcp_project_id")

    @gcp_project_id.setter
    def gcp_project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "gcp_project_id", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[builtins.str]:
        """
        Private Key for the Service Account
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> pulumi.Input[builtins.str]:
        """
        Private Key ID for the Service Account
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "private_key_id", value)

    @property
    @pulumi.getter(name="tokenUri")
    def token_uri(self) -> pulumi.Input[builtins.str]:
        """
        Token URI for the Service Account
        """
        return pulumi.get(self, "token_uri")

    @token_uri.setter
    def token_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token_uri", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OAuth Client ID
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OAuth Client Secret
        """
        return pulumi.get(self, "application_secret")

    @application_secret.setter
    def application_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_secret", value)

    @property
    @pulumi.getter(name="dataprocClusterName")
    def dataproc_cluster_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Dataproc cluster name for PySpark workloads
        """
        return pulumi.get(self, "dataproc_cluster_name")

    @dataproc_cluster_name.setter
    def dataproc_cluster_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataproc_cluster_name", value)

    @property
    @pulumi.getter(name="dataprocRegion")
    def dataproc_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Google Cloud region for PySpark workloads on Dataproc
        """
        return pulumi.get(self, "dataproc_region")

    @dataproc_region.setter
    def dataproc_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataproc_region", value)

    @property
    @pulumi.getter(name="executionProject")
    def execution_project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Project to bill for query execution
        """
        return pulumi.get(self, "execution_project")

    @execution_project.setter
    def execution_project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_project", value)

    @property
    @pulumi.getter(name="gcsBucket")
    def gcs_bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URI for a Google Cloud Storage bucket to host Python code executed via Datapro
        """
        return pulumi.get(self, "gcs_bucket")

    @gcs_bucket.setter
    def gcs_bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gcs_bucket", value)

    @property
    @pulumi.getter(name="impersonateServiceAccount")
    def impersonate_service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service Account to impersonate when running queries
        """
        return pulumi.get(self, "impersonate_service_account")

    @impersonate_service_account.setter
    def impersonate_service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "impersonate_service_account", value)

    @property
    @pulumi.getter(name="jobCreationTimeoutSeconds")
    def job_creation_timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum timeout for the job creation step
        """
        return pulumi.get(self, "job_creation_timeout_seconds")

    @job_creation_timeout_seconds.setter
    def job_creation_timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "job_creation_timeout_seconds", value)

    @property
    @pulumi.getter(name="jobRetryDeadlineSeconds")
    def job_retry_deadline_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total number of seconds to wait while retrying the same query
        """
        return pulumi.get(self, "job_retry_deadline_seconds")

    @job_retry_deadline_seconds.setter
    def job_retry_deadline_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "job_retry_deadline_seconds", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location to create new Datasets in
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maximumBytesBilled")
    def maximum_bytes_billed(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Max number of bytes that can be billed for a given BigQuery query
        """
        return pulumi.get(self, "maximum_bytes_billed")

    @maximum_bytes_billed.setter
    def maximum_bytes_billed(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum_bytes_billed", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The priority with which to execute BigQuery queries (batch or interactive)
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of retries for queries
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        OAuth scopes for the BigQuery connection
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Timeout in seconds for queries
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout_seconds", value)


if not MYPY:
    class GlobalConnectionDatabricksArgsDict(TypedDict):
        host: pulumi.Input[builtins.str]
        """
        The hostname of the Databricks cluster or SQL warehouse.
        """
        http_path: pulumi.Input[builtins.str]
        """
        The HTTP path of the Databricks cluster or SQL warehouse.
        """
        catalog: NotRequired[pulumi.Input[builtins.str]]
        """
        Catalog name if Unity Catalog is enabled in your Databricks workspace.
        """
        client_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Required to enable Databricks OAuth authentication for IDE developers.
        """
        client_secret: NotRequired[pulumi.Input[builtins.str]]
        """
        Required to enable Databricks OAuth authentication for IDE developers.
        """
elif False:
    GlobalConnectionDatabricksArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionDatabricksArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[builtins.str],
                 http_path: pulumi.Input[builtins.str],
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] host: The hostname of the Databricks cluster or SQL warehouse.
        :param pulumi.Input[builtins.str] http_path: The HTTP path of the Databricks cluster or SQL warehouse.
        :param pulumi.Input[builtins.str] catalog: Catalog name if Unity Catalog is enabled in your Databricks workspace.
        :param pulumi.Input[builtins.str] client_id: Required to enable Databricks OAuth authentication for IDE developers.
        :param pulumi.Input[builtins.str] client_secret: Required to enable Databricks OAuth authentication for IDE developers.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "http_path", http_path)
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[builtins.str]:
        """
        The hostname of the Databricks cluster or SQL warehouse.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> pulumi.Input[builtins.str]:
        """
        The HTTP path of the Databricks cluster or SQL warehouse.
        """
        return pulumi.get(self, "http_path")

    @http_path.setter
    def http_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "http_path", value)

    @property
    @pulumi.getter
    def catalog(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Catalog name if Unity Catalog is enabled in your Databricks workspace.
        """
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required to enable Databricks OAuth authentication for IDE developers.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required to enable Databricks OAuth authentication for IDE developers.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)


if not MYPY:
    class GlobalConnectionFabricArgsDict(TypedDict):
        database: pulumi.Input[builtins.str]
        """
        The database to connect to for this connection.
        """
        server: pulumi.Input[builtins.str]
        """
        The server hostname.
        """
        login_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port to connect to for this connection. Default=1433
        """
        query_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        retries: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
elif False:
    GlobalConnectionFabricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionFabricArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[builtins.str],
                 server: pulumi.Input[builtins.str],
                 login_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 query_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] database: The database to connect to for this connection.
        :param pulumi.Input[builtins.str] server: The server hostname.
        :param pulumi.Input[builtins.int] login_timeout: The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param pulumi.Input[builtins.int] port: The port to connect to for this connection. Default=1433
        :param pulumi.Input[builtins.int] query_timeout: The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param pulumi.Input[builtins.int] retries: The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "server", server)
        if login_timeout is not None:
            pulumi.set(__self__, "login_timeout", login_timeout)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if query_timeout is not None:
            pulumi.set(__self__, "query_timeout", query_timeout)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[builtins.str]:
        """
        The database to connect to for this connection.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def server(self) -> pulumi.Input[builtins.str]:
        """
        The server hostname.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="loginTimeout")
    def login_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "login_timeout")

    @login_timeout.setter
    def login_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "login_timeout", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port to connect to for this connection. Default=1433
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="queryTimeout")
    def query_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "query_timeout")

    @query_timeout.setter
    def query_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "query_timeout", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)


if not MYPY:
    class GlobalConnectionPostgresArgsDict(TypedDict):
        dbname: pulumi.Input[builtins.str]
        """
        The database name for this connection.
        """
        hostname: pulumi.Input[builtins.str]
        """
        The hostname of the database.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port to connect to for this connection. Default=5432
        """
        ssh_tunnel: NotRequired[pulumi.Input['GlobalConnectionPostgresSshTunnelArgsDict']]
        """
        PostgreSQL SSH Tunnel configuration
        """
elif False:
    GlobalConnectionPostgresArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionPostgresArgs:
    def __init__(__self__, *,
                 dbname: pulumi.Input[builtins.str],
                 hostname: pulumi.Input[builtins.str],
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 ssh_tunnel: Optional[pulumi.Input['GlobalConnectionPostgresSshTunnelArgs']] = None):
        """
        :param pulumi.Input[builtins.str] dbname: The database name for this connection.
        :param pulumi.Input[builtins.str] hostname: The hostname of the database.
        :param pulumi.Input[builtins.int] port: The port to connect to for this connection. Default=5432
        :param pulumi.Input['GlobalConnectionPostgresSshTunnelArgs'] ssh_tunnel: PostgreSQL SSH Tunnel configuration
        """
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "hostname", hostname)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)

    @property
    @pulumi.getter
    def dbname(self) -> pulumi.Input[builtins.str]:
        """
        The database name for this connection.
        """
        return pulumi.get(self, "dbname")

    @dbname.setter
    def dbname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dbname", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        The hostname of the database.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port to connect to for this connection. Default=5432
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional[pulumi.Input['GlobalConnectionPostgresSshTunnelArgs']]:
        """
        PostgreSQL SSH Tunnel configuration
        """
        return pulumi.get(self, "ssh_tunnel")

    @ssh_tunnel.setter
    def ssh_tunnel(self, value: Optional[pulumi.Input['GlobalConnectionPostgresSshTunnelArgs']]):
        pulumi.set(self, "ssh_tunnel", value)


if not MYPY:
    class GlobalConnectionPostgresSshTunnelArgsDict(TypedDict):
        hostname: pulumi.Input[builtins.str]
        """
        The hostname for the SSH tunnel.
        """
        port: pulumi.Input[builtins.int]
        """
        The HTTP port for the SSH tunnel.
        """
        username: pulumi.Input[builtins.str]
        """
        The username to use for the SSH tunnel.
        """
        id: NotRequired[pulumi.Input[builtins.int]]
        """
        The ID of the SSH tunnel connection.
        """
        public_key: NotRequired[pulumi.Input[builtins.str]]
        """
        The SSH public key generated to allow connecting via SSH tunnel.
        """
elif False:
    GlobalConnectionPostgresSshTunnelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionPostgresSshTunnelArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[builtins.str],
                 port: pulumi.Input[builtins.int],
                 username: pulumi.Input[builtins.str],
                 id: Optional[pulumi.Input[builtins.int]] = None,
                 public_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] hostname: The hostname for the SSH tunnel.
        :param pulumi.Input[builtins.int] port: The HTTP port for the SSH tunnel.
        :param pulumi.Input[builtins.str] username: The username to use for the SSH tunnel.
        :param pulumi.Input[builtins.int] id: The ID of the SSH tunnel connection.
        :param pulumi.Input[builtins.str] public_key: The SSH public key generated to allow connecting via SSH tunnel.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        The hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[builtins.int]:
        """
        The HTTP port for the SSH tunnel.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        The username to use for the SSH tunnel.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The ID of the SSH tunnel connection.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SSH public key generated to allow connecting via SSH tunnel.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_key", value)


if not MYPY:
    class GlobalConnectionRedshiftArgsDict(TypedDict):
        dbname: pulumi.Input[builtins.str]
        """
        The database name for this connection.
        """
        hostname: pulumi.Input[builtins.str]
        """
        The hostname of the data warehouse.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port to connect to for this connection. Default=5432
        """
        ssh_tunnel: NotRequired[pulumi.Input['GlobalConnectionRedshiftSshTunnelArgsDict']]
        """
        Redshift SSH Tunnel configuration
        """
elif False:
    GlobalConnectionRedshiftArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionRedshiftArgs:
    def __init__(__self__, *,
                 dbname: pulumi.Input[builtins.str],
                 hostname: pulumi.Input[builtins.str],
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 ssh_tunnel: Optional[pulumi.Input['GlobalConnectionRedshiftSshTunnelArgs']] = None):
        """
        :param pulumi.Input[builtins.str] dbname: The database name for this connection.
        :param pulumi.Input[builtins.str] hostname: The hostname of the data warehouse.
        :param pulumi.Input[builtins.int] port: The port to connect to for this connection. Default=5432
        :param pulumi.Input['GlobalConnectionRedshiftSshTunnelArgs'] ssh_tunnel: Redshift SSH Tunnel configuration
        """
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "hostname", hostname)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)

    @property
    @pulumi.getter
    def dbname(self) -> pulumi.Input[builtins.str]:
        """
        The database name for this connection.
        """
        return pulumi.get(self, "dbname")

    @dbname.setter
    def dbname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dbname", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        The hostname of the data warehouse.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port to connect to for this connection. Default=5432
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional[pulumi.Input['GlobalConnectionRedshiftSshTunnelArgs']]:
        """
        Redshift SSH Tunnel configuration
        """
        return pulumi.get(self, "ssh_tunnel")

    @ssh_tunnel.setter
    def ssh_tunnel(self, value: Optional[pulumi.Input['GlobalConnectionRedshiftSshTunnelArgs']]):
        pulumi.set(self, "ssh_tunnel", value)


if not MYPY:
    class GlobalConnectionRedshiftSshTunnelArgsDict(TypedDict):
        hostname: pulumi.Input[builtins.str]
        """
        The hostname for the SSH tunnel.
        """
        port: pulumi.Input[builtins.int]
        """
        The HTTP port for the SSH tunnel.
        """
        username: pulumi.Input[builtins.str]
        """
        The username to use for the SSH tunnel.
        """
        id: NotRequired[pulumi.Input[builtins.int]]
        """
        The ID of the SSH tunnel connection.
        """
        public_key: NotRequired[pulumi.Input[builtins.str]]
        """
        The SSH public key generated to allow connecting via SSH tunnel.
        """
elif False:
    GlobalConnectionRedshiftSshTunnelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionRedshiftSshTunnelArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[builtins.str],
                 port: pulumi.Input[builtins.int],
                 username: pulumi.Input[builtins.str],
                 id: Optional[pulumi.Input[builtins.int]] = None,
                 public_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] hostname: The hostname for the SSH tunnel.
        :param pulumi.Input[builtins.int] port: The HTTP port for the SSH tunnel.
        :param pulumi.Input[builtins.str] username: The username to use for the SSH tunnel.
        :param pulumi.Input[builtins.int] id: The ID of the SSH tunnel connection.
        :param pulumi.Input[builtins.str] public_key: The SSH public key generated to allow connecting via SSH tunnel.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        The hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[builtins.int]:
        """
        The HTTP port for the SSH tunnel.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        The username to use for the SSH tunnel.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The ID of the SSH tunnel connection.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SSH public key generated to allow connecting via SSH tunnel.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_key", value)


if not MYPY:
    class GlobalConnectionSnowflakeArgsDict(TypedDict):
        account: pulumi.Input[builtins.str]
        """
        The Snowflake account name
        """
        database: pulumi.Input[builtins.str]
        """
        The default database for the connection
        """
        warehouse: pulumi.Input[builtins.str]
        """
        The default Snowflake Warehouse to use for the connection
        """
        allow_sso: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to allow Snowflake OAuth for the connection. If true, the `oauth_client_id` and `oauth_client_secret` fields must be set
        """
        client_session_keep_alive: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, the snowflake client will keep connections for longer than the default 4 hours. This is helpful when particularly long-running queries are executing (> 4 hours)
        """
        oauth_client_id: NotRequired[pulumi.Input[builtins.str]]
        """
        OAuth Client ID. Required to allow OAuth between dbt Cloud and Snowflake
        """
        oauth_client_secret: NotRequired[pulumi.Input[builtins.str]]
        """
        OAuth Client Secret. Required to allow OAuth between dbt Cloud and Snowflake
        """
        role: NotRequired[pulumi.Input[builtins.str]]
        """
        The Snowflake role to use when running queries on the connection
        """
elif False:
    GlobalConnectionSnowflakeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionSnowflakeArgs:
    def __init__(__self__, *,
                 account: pulumi.Input[builtins.str],
                 database: pulumi.Input[builtins.str],
                 warehouse: pulumi.Input[builtins.str],
                 allow_sso: Optional[pulumi.Input[builtins.bool]] = None,
                 client_session_keep_alive: Optional[pulumi.Input[builtins.bool]] = None,
                 oauth_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 oauth_client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] account: The Snowflake account name
        :param pulumi.Input[builtins.str] database: The default database for the connection
        :param pulumi.Input[builtins.str] warehouse: The default Snowflake Warehouse to use for the connection
        :param pulumi.Input[builtins.bool] allow_sso: Whether to allow Snowflake OAuth for the connection. If true, the `oauth_client_id` and `oauth_client_secret` fields must be set
        :param pulumi.Input[builtins.bool] client_session_keep_alive: If true, the snowflake client will keep connections for longer than the default 4 hours. This is helpful when particularly long-running queries are executing (> 4 hours)
        :param pulumi.Input[builtins.str] oauth_client_id: OAuth Client ID. Required to allow OAuth between dbt Cloud and Snowflake
        :param pulumi.Input[builtins.str] oauth_client_secret: OAuth Client Secret. Required to allow OAuth between dbt Cloud and Snowflake
        :param pulumi.Input[builtins.str] role: The Snowflake role to use when running queries on the connection
        """
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "warehouse", warehouse)
        if allow_sso is not None:
            pulumi.set(__self__, "allow_sso", allow_sso)
        if client_session_keep_alive is not None:
            pulumi.set(__self__, "client_session_keep_alive", client_session_keep_alive)
        if oauth_client_id is not None:
            pulumi.set(__self__, "oauth_client_id", oauth_client_id)
        if oauth_client_secret is not None:
            pulumi.set(__self__, "oauth_client_secret", oauth_client_secret)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def account(self) -> pulumi.Input[builtins.str]:
        """
        The Snowflake account name
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account", value)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[builtins.str]:
        """
        The default database for the connection
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def warehouse(self) -> pulumi.Input[builtins.str]:
        """
        The default Snowflake Warehouse to use for the connection
        """
        return pulumi.get(self, "warehouse")

    @warehouse.setter
    def warehouse(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "warehouse", value)

    @property
    @pulumi.getter(name="allowSso")
    def allow_sso(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow Snowflake OAuth for the connection. If true, the `oauth_client_id` and `oauth_client_secret` fields must be set
        """
        return pulumi.get(self, "allow_sso")

    @allow_sso.setter
    def allow_sso(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_sso", value)

    @property
    @pulumi.getter(name="clientSessionKeepAlive")
    def client_session_keep_alive(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the snowflake client will keep connections for longer than the default 4 hours. This is helpful when particularly long-running queries are executing (> 4 hours)
        """
        return pulumi.get(self, "client_session_keep_alive")

    @client_session_keep_alive.setter
    def client_session_keep_alive(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "client_session_keep_alive", value)

    @property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OAuth Client ID. Required to allow OAuth between dbt Cloud and Snowflake
        """
        return pulumi.get(self, "oauth_client_id")

    @oauth_client_id.setter
    def oauth_client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oauth_client_id", value)

    @property
    @pulumi.getter(name="oauthClientSecret")
    def oauth_client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OAuth Client Secret. Required to allow OAuth between dbt Cloud and Snowflake
        """
        return pulumi.get(self, "oauth_client_secret")

    @oauth_client_secret.setter
    def oauth_client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oauth_client_secret", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Snowflake role to use when running queries on the connection
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)


if not MYPY:
    class GlobalConnectionStarburstArgsDict(TypedDict):
        host: pulumi.Input[builtins.str]
        """
        The hostname of the account to connect to.
        """
        method: NotRequired[pulumi.Input[builtins.str]]
        """
        The authentication method. Only LDAP for now.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port to connect to for this connection. Default=443
        """
elif False:
    GlobalConnectionStarburstArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionStarburstArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[builtins.str],
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] host: The hostname of the account to connect to.
        :param pulumi.Input[builtins.str] method: The authentication method. Only LDAP for now.
        :param pulumi.Input[builtins.int] port: The port to connect to for this connection. Default=443
        """
        pulumi.set(__self__, "host", host)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[builtins.str]:
        """
        The hostname of the account to connect to.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The authentication method. Only LDAP for now.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port to connect to for this connection. Default=443
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class GlobalConnectionSynapseArgsDict(TypedDict):
        database: pulumi.Input[builtins.str]
        """
        The database to connect to for this connection.
        """
        host: pulumi.Input[builtins.str]
        """
        The server hostname.
        """
        login_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port to connect to for this connection. Default=1433
        """
        query_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        retries: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
elif False:
    GlobalConnectionSynapseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionSynapseArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[builtins.str],
                 host: pulumi.Input[builtins.str],
                 login_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 query_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] database: The database to connect to for this connection.
        :param pulumi.Input[builtins.str] host: The server hostname.
        :param pulumi.Input[builtins.int] login_timeout: The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param pulumi.Input[builtins.int] port: The port to connect to for this connection. Default=1433
        :param pulumi.Input[builtins.int] query_timeout: The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param pulumi.Input[builtins.int] retries: The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        if login_timeout is not None:
            pulumi.set(__self__, "login_timeout", login_timeout)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if query_timeout is not None:
            pulumi.set(__self__, "query_timeout", query_timeout)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[builtins.str]:
        """
        The database to connect to for this connection.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[builtins.str]:
        """
        The server hostname.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="loginTimeout")
    def login_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "login_timeout")

    @login_timeout.setter
    def login_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "login_timeout", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port to connect to for this connection. Default=1433
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="queryTimeout")
    def query_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "query_timeout")

    @query_timeout.setter
    def query_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "query_timeout", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)


if not MYPY:
    class GlobalConnectionTeradataArgsDict(TypedDict):
        host: pulumi.Input[builtins.str]
        """
        The hostname of the database.
        """
        tmode: pulumi.Input[builtins.str]
        """
        The transaction mode to use for the connection.
        """
        port: NotRequired[pulumi.Input[builtins.str]]
        """
        The port to connect to for this connection. Default=1025
        """
        request_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        retries: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
elif False:
    GlobalConnectionTeradataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalConnectionTeradataArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[builtins.str],
                 tmode: pulumi.Input[builtins.str],
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] host: The hostname of the database.
        :param pulumi.Input[builtins.str] tmode: The transaction mode to use for the connection.
        :param pulumi.Input[builtins.str] port: The port to connect to for this connection. Default=1025
        :param pulumi.Input[builtins.int] request_timeout: The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param pulumi.Input[builtins.int] retries: The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "tmode", tmode)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[builtins.str]:
        """
        The hostname of the database.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def tmode(self) -> pulumi.Input[builtins.str]:
        """
        The transaction mode to use for the connection.
        """
        return pulumi.get(self, "tmode")

    @tmode.setter
    def tmode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tmode", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The port to connect to for this connection. Default=1025
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "request_timeout", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)


if not MYPY:
    class GroupGroupPermissionArgsDict(TypedDict):
        all_projects: pulumi.Input[builtins.bool]
        """
        Whether access should be provided for all projects or not.
        """
        permission_set: pulumi.Input[builtins.str]
        """
        Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        """
        project_id: NotRequired[pulumi.Input[builtins.int]]
        """
        Project ID to apply this permission to for this group.
        """
        writable_environment_categories: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
elif False:
    GroupGroupPermissionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GroupGroupPermissionArgs:
    def __init__(__self__, *,
                 all_projects: pulumi.Input[builtins.bool],
                 permission_set: pulumi.Input[builtins.str],
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 writable_environment_categories: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.bool] all_projects: Whether access should be provided for all projects or not.
        :param pulumi.Input[builtins.str] permission_set: Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        :param pulumi.Input[builtins.int] project_id: Project ID to apply this permission to for this group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] writable_environment_categories: What types of environments to apply Write permissions to.
               Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
               The values allowed are `all`, `development`, `staging`, `production` and `other`.
               Not setting a value is the same as selecting `all`.
               Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        pulumi.set(__self__, "all_projects", all_projects)
        pulumi.set(__self__, "permission_set", permission_set)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if writable_environment_categories is not None:
            pulumi.set(__self__, "writable_environment_categories", writable_environment_categories)

    @property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> pulumi.Input[builtins.bool]:
        """
        Whether access should be provided for all projects or not.
        """
        return pulumi.get(self, "all_projects")

    @all_projects.setter
    def all_projects(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "all_projects", value)

    @property
    @pulumi.getter(name="permissionSet")
    def permission_set(self) -> pulumi.Input[builtins.str]:
        """
        Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        """
        return pulumi.get(self, "permission_set")

    @permission_set.setter
    def permission_set(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "permission_set", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Project ID to apply this permission to for this group.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="writableEnvironmentCategories")
    def writable_environment_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        return pulumi.get(self, "writable_environment_categories")

    @writable_environment_categories.setter
    def writable_environment_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "writable_environment_categories", value)


if not MYPY:
    class GroupPartialPermissionsGroupPermissionArgsDict(TypedDict):
        all_projects: pulumi.Input[builtins.bool]
        """
        Whether access should be provided for all projects or not.
        """
        permission_set: pulumi.Input[builtins.str]
        """
        Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        """
        project_id: NotRequired[pulumi.Input[builtins.int]]
        """
        Project ID to apply this permission to for this group.
        """
        writable_environment_categories: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
elif False:
    GroupPartialPermissionsGroupPermissionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GroupPartialPermissionsGroupPermissionArgs:
    def __init__(__self__, *,
                 all_projects: pulumi.Input[builtins.bool],
                 permission_set: pulumi.Input[builtins.str],
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 writable_environment_categories: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.bool] all_projects: Whether access should be provided for all projects or not.
        :param pulumi.Input[builtins.str] permission_set: Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        :param pulumi.Input[builtins.int] project_id: Project ID to apply this permission to for this group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] writable_environment_categories: What types of environments to apply Write permissions to.
               Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
               The values allowed are `all`, `development`, `staging`, `production` and `other`.
               Not setting a value is the same as selecting `all`.
               Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        pulumi.set(__self__, "all_projects", all_projects)
        pulumi.set(__self__, "permission_set", permission_set)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if writable_environment_categories is not None:
            pulumi.set(__self__, "writable_environment_categories", writable_environment_categories)

    @property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> pulumi.Input[builtins.bool]:
        """
        Whether access should be provided for all projects or not.
        """
        return pulumi.get(self, "all_projects")

    @all_projects.setter
    def all_projects(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "all_projects", value)

    @property
    @pulumi.getter(name="permissionSet")
    def permission_set(self) -> pulumi.Input[builtins.str]:
        """
        Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        """
        return pulumi.get(self, "permission_set")

    @permission_set.setter
    def permission_set(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "permission_set", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Project ID to apply this permission to for this group.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="writableEnvironmentCategories")
    def writable_environment_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        return pulumi.get(self, "writable_environment_categories")

    @writable_environment_categories.setter
    def writable_environment_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "writable_environment_categories", value)


if not MYPY:
    class IpRestrictionsRuleCidrArgsDict(TypedDict):
        cidr: NotRequired[pulumi.Input[builtins.str]]
        """
        IP CIDR range (can be IPv4 or IPv6)
        """
        cidr_ipv6: NotRequired[pulumi.Input[builtins.str]]
        """
        IPv6 CIDR range (read-only)
        """
        id: NotRequired[pulumi.Input[builtins.int]]
        """
        ID of the CIDR range
        """
        ip_restriction_rule_id: NotRequired[pulumi.Input[builtins.int]]
        """
        ID of the IP restriction rule
        """
elif False:
    IpRestrictionsRuleCidrArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IpRestrictionsRuleCidrArgs:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_ipv6: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.int]] = None,
                 ip_restriction_rule_id: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] cidr: IP CIDR range (can be IPv4 or IPv6)
        :param pulumi.Input[builtins.str] cidr_ipv6: IPv6 CIDR range (read-only)
        :param pulumi.Input[builtins.int] id: ID of the CIDR range
        :param pulumi.Input[builtins.int] ip_restriction_rule_id: ID of the IP restriction rule
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if cidr_ipv6 is not None:
            pulumi.set(__self__, "cidr_ipv6", cidr_ipv6)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_restriction_rule_id is not None:
            pulumi.set(__self__, "ip_restriction_rule_id", ip_restriction_rule_id)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP CIDR range (can be IPv4 or IPv6)
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="cidrIpv6")
    def cidr_ipv6(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 CIDR range (read-only)
        """
        return pulumi.get(self, "cidr_ipv6")

    @cidr_ipv6.setter
    def cidr_ipv6(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr_ipv6", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ID of the CIDR range
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipRestrictionRuleId")
    def ip_restriction_rule_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ID of the IP restriction rule
        """
        return pulumi.get(self, "ip_restriction_rule_id")

    @ip_restriction_rule_id.setter
    def ip_restriction_rule_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ip_restriction_rule_id", value)


if not MYPY:
    class JobJobCompletionTriggerConditionArgsDict(TypedDict):
        job_id: pulumi.Input[builtins.int]
        """
        The ID of the job that would trigger this job after completion.
        """
        project_id: pulumi.Input[builtins.int]
        """
        The ID of the project where the trigger job is running in.
        """
        statuses: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        List of statuses to trigger the job on. Possible values are `success`, `error` and `canceled`.
        """
elif False:
    JobJobCompletionTriggerConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobJobCompletionTriggerConditionArgs:
    def __init__(__self__, *,
                 job_id: pulumi.Input[builtins.int],
                 project_id: pulumi.Input[builtins.int],
                 statuses: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[builtins.int] job_id: The ID of the job that would trigger this job after completion.
        :param pulumi.Input[builtins.int] project_id: The ID of the project where the trigger job is running in.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] statuses: List of statuses to trigger the job on. Possible values are `success`, `error` and `canceled`.
        """
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Input[builtins.int]:
        """
        The ID of the job that would trigger this job after completion.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        The ID of the project where the trigger job is running in.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of statuses to trigger the job on. Possible values are `success`, `error` and `canceled`.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "statuses", value)


if not MYPY:
    class JobTriggersArgsDict(TypedDict):
        git_provider_webhook: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the job runs automatically on PR creation
        """
        github_webhook: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the job runs automatically on PR creation
        """
        on_merge: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the job runs automatically once a PR is merged
        """
        schedule: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the job runs on a schedule
        """
elif False:
    JobTriggersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTriggersArgs:
    def __init__(__self__, *,
                 git_provider_webhook: Optional[pulumi.Input[builtins.bool]] = None,
                 github_webhook: Optional[pulumi.Input[builtins.bool]] = None,
                 on_merge: Optional[pulumi.Input[builtins.bool]] = None,
                 schedule: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] git_provider_webhook: Whether the job runs automatically on PR creation
        :param pulumi.Input[builtins.bool] github_webhook: Whether the job runs automatically on PR creation
        :param pulumi.Input[builtins.bool] on_merge: Whether the job runs automatically once a PR is merged
        :param pulumi.Input[builtins.bool] schedule: Whether the job runs on a schedule
        """
        if git_provider_webhook is not None:
            pulumi.set(__self__, "git_provider_webhook", git_provider_webhook)
        if github_webhook is not None:
            pulumi.set(__self__, "github_webhook", github_webhook)
        if on_merge is not None:
            pulumi.set(__self__, "on_merge", on_merge)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter(name="gitProviderWebhook")
    def git_provider_webhook(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the job runs automatically on PR creation
        """
        return pulumi.get(self, "git_provider_webhook")

    @git_provider_webhook.setter
    def git_provider_webhook(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "git_provider_webhook", value)

    @property
    @pulumi.getter(name="githubWebhook")
    def github_webhook(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the job runs automatically on PR creation
        """
        return pulumi.get(self, "github_webhook")

    @github_webhook.setter
    def github_webhook(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "github_webhook", value)

    @property
    @pulumi.getter(name="onMerge")
    def on_merge(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the job runs automatically once a PR is merged
        """
        return pulumi.get(self, "on_merge")

    @on_merge.setter
    def on_merge(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "on_merge", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the job runs on a schedule
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "schedule", value)


if not MYPY:
    class PostgresSemanticLayerCredentialConfigurationArgsDict(TypedDict):
        adapter_version: pulumi.Input[builtins.str]
        """
        The adapter version
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the configuration
        """
        project_id: pulumi.Input[builtins.int]
        """
        The ID of the project
        """
elif False:
    PostgresSemanticLayerCredentialConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PostgresSemanticLayerCredentialConfigurationArgs:
    def __init__(__self__, *,
                 adapter_version: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] adapter_version: The adapter version
        :param pulumi.Input[builtins.str] name: The name of the configuration
        :param pulumi.Input[builtins.int] project_id: The ID of the project
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> pulumi.Input[builtins.str]:
        """
        The adapter version
        """
        return pulumi.get(self, "adapter_version")

    @adapter_version.setter
    def adapter_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "adapter_version", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)


if not MYPY:
    class PostgresSemanticLayerCredentialCredentialArgsDict(TypedDict):
        project_id: pulumi.Input[builtins.int]
        """
        Project ID to create the Postgres/Redshift/AlloyDB credential in.
        """
        username: pulumi.Input[builtins.str]
        """
        Username for Postgres/Redshift/AlloyDB
        """
        credential_id: NotRequired[pulumi.Input[builtins.int]]
        """
        The system Postgres/Redshift/AlloyDB credential ID.
        """
        default_schema: NotRequired[pulumi.Input[builtins.str]]
        """
        Default schema name. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        is_active: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the Postgres/Redshift/AlloyDB credential is active
        """
        num_threads: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of threads to use (required for Redshift)
        """
        password: NotRequired[pulumi.Input[builtins.str]]
        """
        Password for Postgres/Redshift/AlloyDB
        """
        semantic_layer_credential: NotRequired[pulumi.Input[builtins.bool]]
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.
        """
        target_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Default schema name
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type of connection. One of (postgres/redshift). Use postgres for alloydb connections. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
elif False:
    PostgresSemanticLayerCredentialCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PostgresSemanticLayerCredentialCredentialArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[builtins.int],
                 username: pulumi.Input[builtins.str],
                 credential_id: Optional[pulumi.Input[builtins.int]] = None,
                 default_schema: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[builtins.int]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 semantic_layer_credential: Optional[pulumi.Input[builtins.bool]] = None,
                 target_name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Postgres/Redshift/AlloyDB credential in.
        :param pulumi.Input[builtins.str] username: Username for Postgres/Redshift/AlloyDB
        :param pulumi.Input[builtins.int] credential_id: The system Postgres/Redshift/AlloyDB credential ID.
        :param pulumi.Input[builtins.str] default_schema: Default schema name. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param pulumi.Input[builtins.str] id: The ID of this resource. Contains the project ID and the credential ID.
        :param pulumi.Input[builtins.bool] is_active: Whether the Postgres/Redshift/AlloyDB credential is active
        :param pulumi.Input[builtins.int] num_threads: Number of threads to use (required for Redshift)
        :param pulumi.Input[builtins.str] password: Password for Postgres/Redshift/AlloyDB
        :param pulumi.Input[builtins.bool] semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.
        :param pulumi.Input[builtins.str] target_name: Default schema name
        :param pulumi.Input[builtins.str] type: Type of connection. One of (postgres/redshift). Use postgres for alloydb connections. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "username", username)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if default_schema is not None:
            pulumi.set(__self__, "default_schema", default_schema)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if num_threads is not None:
            pulumi.set(__self__, "num_threads", num_threads)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if semantic_layer_credential is not None:
            pulumi.set(__self__, "semantic_layer_credential", semantic_layer_credential)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        Project ID to create the Postgres/Redshift/AlloyDB credential in.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        Username for Postgres/Redshift/AlloyDB
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The system Postgres/Redshift/AlloyDB credential ID.
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Default schema name. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "default_schema")

    @default_schema.setter
    def default_schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_schema", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Postgres/Redshift/AlloyDB credential is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of threads to use (required for Redshift)
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_threads", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password for Postgres/Redshift/AlloyDB
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="semanticLayerCredential")
    def semantic_layer_credential(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.
        """
        return pulumi.get(self, "semantic_layer_credential")

    @semantic_layer_credential.setter
    def semantic_layer_credential(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "semantic_layer_credential", value)

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Default schema name
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of connection. One of (postgres/redshift). Use postgres for alloydb connections. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class RedshiftSemanticLayerCredentialConfigurationArgsDict(TypedDict):
        adapter_version: pulumi.Input[builtins.str]
        """
        The adapter version
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the configuration
        """
        project_id: pulumi.Input[builtins.int]
        """
        The ID of the project
        """
elif False:
    RedshiftSemanticLayerCredentialConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RedshiftSemanticLayerCredentialConfigurationArgs:
    def __init__(__self__, *,
                 adapter_version: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] adapter_version: The adapter version
        :param pulumi.Input[builtins.str] name: The name of the configuration
        :param pulumi.Input[builtins.int] project_id: The ID of the project
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> pulumi.Input[builtins.str]:
        """
        The adapter version
        """
        return pulumi.get(self, "adapter_version")

    @adapter_version.setter
    def adapter_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "adapter_version", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)


if not MYPY:
    class RedshiftSemanticLayerCredentialCredentialArgsDict(TypedDict):
        default_schema: pulumi.Input[builtins.str]
        """
        Default schema name
        """
        num_threads: pulumi.Input[builtins.int]
        """
        Number of threads to use
        """
        project_id: pulumi.Input[builtins.int]
        """
        Project ID to create the Redshift credential in
        """
        credential_id: NotRequired[pulumi.Input[builtins.int]]
        """
        The internal credential ID
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        is_active: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the Redshift credential is active
        """
        password: NotRequired[pulumi.Input[builtins.str]]
        """
        The password for the Redshift account
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        The username for the Redshift account.
        """
elif False:
    RedshiftSemanticLayerCredentialCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RedshiftSemanticLayerCredentialCredentialArgs:
    def __init__(__self__, *,
                 default_schema: pulumi.Input[builtins.str],
                 num_threads: pulumi.Input[builtins.int],
                 project_id: pulumi.Input[builtins.int],
                 credential_id: Optional[pulumi.Input[builtins.int]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] default_schema: Default schema name
        :param pulumi.Input[builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Redshift credential in
        :param pulumi.Input[builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[builtins.str] id: The ID of this resource. Contains the project ID and the credential ID.
        :param pulumi.Input[builtins.bool] is_active: Whether the Redshift credential is active
        :param pulumi.Input[builtins.str] password: The password for the Redshift account
        :param pulumi.Input[builtins.str] username: The username for the Redshift account.
        """
        pulumi.set(__self__, "default_schema", default_schema)
        pulumi.set(__self__, "num_threads", num_threads)
        pulumi.set(__self__, "project_id", project_id)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> pulumi.Input[builtins.str]:
        """
        Default schema name
        """
        return pulumi.get(self, "default_schema")

    @default_schema.setter
    def default_schema(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "default_schema", value)

    @property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> pulumi.Input[builtins.int]:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "num_threads", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        Project ID to create the Redshift credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Redshift credential is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password for the Redshift account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username for the Redshift account.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ServiceTokenServiceTokenPermissionArgsDict(TypedDict):
        all_projects: pulumi.Input[builtins.bool]
        """
        Whether or not to apply this permission to all projects for this service token
        """
        permission_set: pulumi.Input[builtins.str]
        """
        Set of permissions to apply
        """
        project_id: NotRequired[pulumi.Input[builtins.int]]
        """
        Project ID to apply this permission to for this service token
        """
        writable_environment_categories: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
elif False:
    ServiceTokenServiceTokenPermissionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceTokenServiceTokenPermissionArgs:
    def __init__(__self__, *,
                 all_projects: pulumi.Input[builtins.bool],
                 permission_set: pulumi.Input[builtins.str],
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 writable_environment_categories: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.bool] all_projects: Whether or not to apply this permission to all projects for this service token
        :param pulumi.Input[builtins.str] permission_set: Set of permissions to apply
        :param pulumi.Input[builtins.int] project_id: Project ID to apply this permission to for this service token
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] writable_environment_categories: What types of environments to apply Write permissions to.
               Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
               The values allowed are `all`, `development`, `staging`, `production` and `other`.
               Not setting a value is the same as selecting `all`.
               Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        pulumi.set(__self__, "all_projects", all_projects)
        pulumi.set(__self__, "permission_set", permission_set)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if writable_environment_categories is not None:
            pulumi.set(__self__, "writable_environment_categories", writable_environment_categories)

    @property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> pulumi.Input[builtins.bool]:
        """
        Whether or not to apply this permission to all projects for this service token
        """
        return pulumi.get(self, "all_projects")

    @all_projects.setter
    def all_projects(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "all_projects", value)

    @property
    @pulumi.getter(name="permissionSet")
    def permission_set(self) -> pulumi.Input[builtins.str]:
        """
        Set of permissions to apply
        """
        return pulumi.get(self, "permission_set")

    @permission_set.setter
    def permission_set(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "permission_set", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Project ID to apply this permission to for this service token
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="writableEnvironmentCategories")
    def writable_environment_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        return pulumi.get(self, "writable_environment_categories")

    @writable_environment_categories.setter
    def writable_environment_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "writable_environment_categories", value)


if not MYPY:
    class SnowflakeSemanticLayerCredentialConfigurationArgsDict(TypedDict):
        adapter_version: pulumi.Input[builtins.str]
        """
        The adapter version
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the configuration
        """
        project_id: pulumi.Input[builtins.int]
        """
        The ID of the project
        """
elif False:
    SnowflakeSemanticLayerCredentialConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SnowflakeSemanticLayerCredentialConfigurationArgs:
    def __init__(__self__, *,
                 adapter_version: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] adapter_version: The adapter version
        :param pulumi.Input[builtins.str] name: The name of the configuration
        :param pulumi.Input[builtins.int] project_id: The ID of the project
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> pulumi.Input[builtins.str]:
        """
        The adapter version
        """
        return pulumi.get(self, "adapter_version")

    @adapter_version.setter
    def adapter_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "adapter_version", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)


if not MYPY:
    class SnowflakeSemanticLayerCredentialCredentialArgsDict(TypedDict):
        auth_type: pulumi.Input[builtins.str]
        """
        The type of Snowflake credential ('password' or 'keypair')
        """
        num_threads: pulumi.Input[builtins.int]
        """
        Number of threads to use
        """
        project_id: pulumi.Input[builtins.int]
        """
        Project ID to create the Snowflake credential in
        """
        credential_id: NotRequired[pulumi.Input[builtins.int]]
        """
        The internal credential ID
        """
        database: NotRequired[pulumi.Input[builtins.str]]
        """
        The catalog to connect use
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        is_active: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the Snowflake credential is active
        """
        password: NotRequired[pulumi.Input[builtins.str]]
        """
        The password for the Snowflake account
        """
        private_key: NotRequired[pulumi.Input[builtins.str]]
        """
        The private key for the Snowflake account
        """
        private_key_passphrase: NotRequired[pulumi.Input[builtins.str]]
        """
        The passphrase for the private key
        """
        role: NotRequired[pulumi.Input[builtins.str]]
        """
        The role to assume
        """
        schema: NotRequired[pulumi.Input[builtins.str]]
        """
        The schema where to create models. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        """
        semantic_layer_credential: NotRequired[pulumi.Input[builtins.bool]]
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.
        """
        user: NotRequired[pulumi.Input[builtins.str]]
        """
        The username for the Snowflake account. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        """
        warehouse: NotRequired[pulumi.Input[builtins.str]]
        """
        The warehouse to use
        """
elif False:
    SnowflakeSemanticLayerCredentialCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SnowflakeSemanticLayerCredentialCredentialArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[builtins.str],
                 num_threads: pulumi.Input[builtins.int],
                 project_id: pulumi.Input[builtins.int],
                 credential_id: Optional[pulumi.Input[builtins.int]] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 semantic_layer_credential: Optional[pulumi.Input[builtins.bool]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 warehouse: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] auth_type: The type of Snowflake credential ('password' or 'keypair')
        :param pulumi.Input[builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Snowflake credential in
        :param pulumi.Input[builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[builtins.str] database: The catalog to connect use
        :param pulumi.Input[builtins.str] id: The ID of this resource. Contains the project ID and the credential ID.
        :param pulumi.Input[builtins.bool] is_active: Whether the Snowflake credential is active
        :param pulumi.Input[builtins.str] password: The password for the Snowflake account
        :param pulumi.Input[builtins.str] private_key: The private key for the Snowflake account
        :param pulumi.Input[builtins.str] private_key_passphrase: The passphrase for the private key
        :param pulumi.Input[builtins.str] role: The role to assume
        :param pulumi.Input[builtins.str] schema: The schema where to create models. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        :param pulumi.Input[builtins.bool] semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.
        :param pulumi.Input[builtins.str] user: The username for the Snowflake account. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        :param pulumi.Input[builtins.str] warehouse: The warehouse to use
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "num_threads", num_threads)
        pulumi.set(__self__, "project_id", project_id)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_passphrase is not None:
            pulumi.set(__self__, "private_key_passphrase", private_key_passphrase)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if semantic_layer_credential is not None:
            pulumi.set(__self__, "semantic_layer_credential", semantic_layer_credential)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if warehouse is not None:
            pulumi.set(__self__, "warehouse", warehouse)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of Snowflake credential ('password' or 'keypair')
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> pulumi.Input[builtins.int]:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "num_threads", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        Project ID to create the Snowflake credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The catalog to connect use
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Snowflake credential is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password for the Snowflake account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private key for the Snowflake account
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The passphrase for the private key
        """
        return pulumi.get(self, "private_key_passphrase")

    @private_key_passphrase.setter
    def private_key_passphrase(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key_passphrase", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The role to assume
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The schema where to create models. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="semanticLayerCredential")
    def semantic_layer_credential(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.
        """
        return pulumi.get(self, "semantic_layer_credential")

    @semantic_layer_credential.setter
    def semantic_layer_credential(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "semantic_layer_credential", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username for the Snowflake account. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def warehouse(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The warehouse to use
        """
        return pulumi.get(self, "warehouse")

    @warehouse.setter
    def warehouse(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "warehouse", value)


if not MYPY:
    class GetJobJobCompletionTriggerConditionArgsDict(TypedDict):
        job_id: builtins.int
        """
        The ID of the job that would trigger this job after completion.
        """
        project_id: builtins.int
        """
        The ID of the project where the trigger job is running in.
        """
        statuses: Sequence[builtins.str]
        """
        List of statuses to trigger the job on.
        """
elif False:
    GetJobJobCompletionTriggerConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetJobJobCompletionTriggerConditionArgs:
    def __init__(__self__, *,
                 job_id: builtins.int,
                 project_id: builtins.int,
                 statuses: Sequence[builtins.str]):
        """
        :param builtins.int job_id: The ID of the job that would trigger this job after completion.
        :param builtins.int project_id: The ID of the project where the trigger job is running in.
        :param Sequence[builtins.str] statuses: List of statuses to trigger the job on.
        """
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> builtins.int:
        """
        The ID of the job that would trigger this job after completion.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: builtins.int):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.int:
        """
        The ID of the project where the trigger job is running in.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: builtins.int):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def statuses(self) -> Sequence[builtins.str]:
        """
        List of statuses to trigger the job on.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Sequence[builtins.str]):
        pulumi.set(self, "statuses", value)


if not MYPY:
    class GetRunsFilterArgsDict(TypedDict):
        environment_id: NotRequired[builtins.int]
        """
        The ID of the environment
        """
        job_definition_id: NotRequired[builtins.int]
        """
        The ID of the job definition
        """
        limit: NotRequired[builtins.int]
        """
        The limit of the runs
        """
        project_id: NotRequired[builtins.int]
        """
        The ID of the project
        """
        pull_request_id: NotRequired[builtins.int]
        """
        The ID of the pull request
        """
        status: NotRequired[builtins.int]
        """
        The status of the run
        """
        status_in: NotRequired[builtins.str]
        """
        The status of the run
        """
        trigger_id: NotRequired[builtins.int]
        """
        The ID of the trigger
        """
elif False:
    GetRunsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetRunsFilterArgs:
    def __init__(__self__, *,
                 environment_id: Optional[builtins.int] = None,
                 job_definition_id: Optional[builtins.int] = None,
                 limit: Optional[builtins.int] = None,
                 project_id: Optional[builtins.int] = None,
                 pull_request_id: Optional[builtins.int] = None,
                 status: Optional[builtins.int] = None,
                 status_in: Optional[builtins.str] = None,
                 trigger_id: Optional[builtins.int] = None):
        """
        :param builtins.int environment_id: The ID of the environment
        :param builtins.int job_definition_id: The ID of the job definition
        :param builtins.int limit: The limit of the runs
        :param builtins.int project_id: The ID of the project
        :param builtins.int pull_request_id: The ID of the pull request
        :param builtins.int status: The status of the run
        :param builtins.str status_in: The status of the run
        :param builtins.int trigger_id: The ID of the trigger
        """
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if job_definition_id is not None:
            pulumi.set(__self__, "job_definition_id", job_definition_id)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if pull_request_id is not None:
            pulumi.set(__self__, "pull_request_id", pull_request_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_in is not None:
            pulumi.set(__self__, "status_in", status_in)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[builtins.int]:
        """
        The ID of the environment
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[builtins.int]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="jobDefinitionId")
    def job_definition_id(self) -> Optional[builtins.int]:
        """
        The ID of the job definition
        """
        return pulumi.get(self, "job_definition_id")

    @job_definition_id.setter
    def job_definition_id(self, value: Optional[builtins.int]):
        pulumi.set(self, "job_definition_id", value)

    @property
    @pulumi.getter
    def limit(self) -> Optional[builtins.int]:
        """
        The limit of the runs
        """
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: Optional[builtins.int]):
        pulumi.set(self, "limit", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.int]:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="pullRequestId")
    def pull_request_id(self) -> Optional[builtins.int]:
        """
        The ID of the pull request
        """
        return pulumi.get(self, "pull_request_id")

    @pull_request_id.setter
    def pull_request_id(self, value: Optional[builtins.int]):
        pulumi.set(self, "pull_request_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.int]:
        """
        The status of the run
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[builtins.int]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusIn")
    def status_in(self) -> Optional[builtins.str]:
        """
        The status of the run
        """
        return pulumi.get(self, "status_in")

    @status_in.setter
    def status_in(self, value: Optional[builtins.str]):
        pulumi.set(self, "status_in", value)

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[builtins.int]:
        """
        The ID of the trigger
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[builtins.int]):
        pulumi.set(self, "trigger_id", value)


if not MYPY:
    class GetServiceTokenServiceTokenPermissionArgsDict(TypedDict):
        all_projects: builtins.bool
        """
        Whether or not to apply this permission to all projects for this service token
        """
        permission_set: builtins.str
        """
        Set of permissions to apply
        """
        project_id: builtins.int
        """
        Project ID to apply this permission to for this service token
        """
        writable_environment_categories: Sequence[builtins.str]
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
elif False:
    GetServiceTokenServiceTokenPermissionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetServiceTokenServiceTokenPermissionArgs:
    def __init__(__self__, *,
                 all_projects: builtins.bool,
                 permission_set: builtins.str,
                 project_id: builtins.int,
                 writable_environment_categories: Sequence[builtins.str]):
        """
        :param builtins.bool all_projects: Whether or not to apply this permission to all projects for this service token
        :param builtins.str permission_set: Set of permissions to apply
        :param builtins.int project_id: Project ID to apply this permission to for this service token
        :param Sequence[builtins.str] writable_environment_categories: What types of environments to apply Write permissions to.
               Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
               The values allowed are `all`, `development`, `staging`, `production` and `other`.
               Not setting a value is the same as selecting `all`.
               Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        pulumi.set(__self__, "all_projects", all_projects)
        pulumi.set(__self__, "permission_set", permission_set)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "writable_environment_categories", writable_environment_categories)

    @property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> builtins.bool:
        """
        Whether or not to apply this permission to all projects for this service token
        """
        return pulumi.get(self, "all_projects")

    @all_projects.setter
    def all_projects(self, value: builtins.bool):
        pulumi.set(self, "all_projects", value)

    @property
    @pulumi.getter(name="permissionSet")
    def permission_set(self) -> builtins.str:
        """
        Set of permissions to apply
        """
        return pulumi.get(self, "permission_set")

    @permission_set.setter
    def permission_set(self, value: builtins.str):
        pulumi.set(self, "permission_set", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.int:
        """
        Project ID to apply this permission to for this service token
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: builtins.int):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="writableEnvironmentCategories")
    def writable_environment_categories(self) -> Sequence[builtins.str]:
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        return pulumi.get(self, "writable_environment_categories")

    @writable_environment_categories.setter
    def writable_environment_categories(self, value: Sequence[builtins.str]):
        pulumi.set(self, "writable_environment_categories", value)


