# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AthenaCredentialArgs', 'AthenaCredential']

@pulumi.input_type
class AthenaCredentialArgs:
    def __init__(__self__, *,
                 aws_access_key_id: pulumi.Input[builtins.str],
                 aws_secret_access_key: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.int],
                 schema: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a AthenaCredential resource.
        :param pulumi.Input[builtins.str] aws_access_key_id: AWS access key ID for Athena user
        :param pulumi.Input[builtins.str] aws_secret_access_key: AWS secret access key for Athena user
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Athena credential in
        :param pulumi.Input[builtins.str] schema: The schema where to create models
        """
        pulumi.set(__self__, "aws_access_key_id", aws_access_key_id)
        pulumi.set(__self__, "aws_secret_access_key", aws_secret_access_key)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> pulumi.Input[builtins.str]:
        """
        AWS access key ID for Athena user
        """
        return pulumi.get(self, "aws_access_key_id")

    @aws_access_key_id.setter
    def aws_access_key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "aws_access_key_id", value)

    @property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> pulumi.Input[builtins.str]:
        """
        AWS secret access key for Athena user
        """
        return pulumi.get(self, "aws_secret_access_key")

    @aws_secret_access_key.setter
    def aws_secret_access_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "aws_secret_access_key", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        Project ID to create the Athena credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Input[builtins.str]:
        """
        The schema where to create models
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "schema", value)


@pulumi.input_type
class _AthenaCredentialState:
    def __init__(__self__, *,
                 aws_access_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 credential_id: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AthenaCredential resources.
        :param pulumi.Input[builtins.str] aws_access_key_id: AWS access key ID for Athena user
        :param pulumi.Input[builtins.str] aws_secret_access_key: AWS secret access key for Athena user
        :param pulumi.Input[builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Athena credential in
        :param pulumi.Input[builtins.str] schema: The schema where to create models
        """
        if aws_access_key_id is not None:
            pulumi.set(__self__, "aws_access_key_id", aws_access_key_id)
        if aws_secret_access_key is not None:
            pulumi.set(__self__, "aws_secret_access_key", aws_secret_access_key)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS access key ID for Athena user
        """
        return pulumi.get(self, "aws_access_key_id")

    @aws_access_key_id.setter
    def aws_access_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_access_key_id", value)

    @property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS secret access key for Athena user
        """
        return pulumi.get(self, "aws_secret_access_key")

    @aws_secret_access_key.setter
    def aws_secret_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_secret_access_key", value)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Project ID to create the Athena credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The schema where to create models
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema", value)


@pulumi.type_token("dbtcloud:index/athenaCredential:AthenaCredential")
class AthenaCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_access_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Athena credential resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        example = dbtcloud.AthenaCredential("example",
            project_id=example_dbtcloud_project["id"],
            aws_access_key_id="your-access-key-id",
            aws_secret_access_key="your-secret-access-key",
            schema="your_schema")
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_athena_credential.my_athena_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_athena_credential.my_athena_credential

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/athenaCredential:AthenaCredential my_athena_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/athenaCredential:AthenaCredential my_athena_credential 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] aws_access_key_id: AWS access key ID for Athena user
        :param pulumi.Input[builtins.str] aws_secret_access_key: AWS secret access key for Athena user
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Athena credential in
        :param pulumi.Input[builtins.str] schema: The schema where to create models
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AthenaCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Athena credential resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        example = dbtcloud.AthenaCredential("example",
            project_id=example_dbtcloud_project["id"],
            aws_access_key_id="your-access-key-id",
            aws_secret_access_key="your-secret-access-key",
            schema="your_schema")
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_athena_credential.my_athena_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_athena_credential.my_athena_credential

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/athenaCredential:AthenaCredential my_athena_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/athenaCredential:AthenaCredential my_athena_credential 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param AthenaCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AthenaCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_access_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AthenaCredentialArgs.__new__(AthenaCredentialArgs)

            if aws_access_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'aws_access_key_id'")
            __props__.__dict__["aws_access_key_id"] = None if aws_access_key_id is None else pulumi.Output.secret(aws_access_key_id)
            if aws_secret_access_key is None and not opts.urn:
                raise TypeError("Missing required property 'aws_secret_access_key'")
            __props__.__dict__["aws_secret_access_key"] = None if aws_secret_access_key is None else pulumi.Output.secret(aws_secret_access_key)
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["credential_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["awsAccessKeyId", "awsSecretAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AthenaCredential, __self__).__init__(
            'dbtcloud:index/athenaCredential:AthenaCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_access_key_id: Optional[pulumi.Input[builtins.str]] = None,
            aws_secret_access_key: Optional[pulumi.Input[builtins.str]] = None,
            credential_id: Optional[pulumi.Input[builtins.int]] = None,
            project_id: Optional[pulumi.Input[builtins.int]] = None,
            schema: Optional[pulumi.Input[builtins.str]] = None) -> 'AthenaCredential':
        """
        Get an existing AthenaCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] aws_access_key_id: AWS access key ID for Athena user
        :param pulumi.Input[builtins.str] aws_secret_access_key: AWS secret access key for Athena user
        :param pulumi.Input[builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Athena credential in
        :param pulumi.Input[builtins.str] schema: The schema where to create models
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AthenaCredentialState.__new__(_AthenaCredentialState)

        __props__.__dict__["aws_access_key_id"] = aws_access_key_id
        __props__.__dict__["aws_secret_access_key"] = aws_secret_access_key
        __props__.__dict__["credential_id"] = credential_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["schema"] = schema
        return AthenaCredential(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> pulumi.Output[builtins.str]:
        """
        AWS access key ID for Athena user
        """
        return pulumi.get(self, "aws_access_key_id")

    @property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> pulumi.Output[builtins.str]:
        """
        AWS secret access key for Athena user
        """
        return pulumi.get(self, "aws_secret_access_key")

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[builtins.int]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.int]:
        """
        Project ID to create the Athena credential in
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[builtins.str]:
        """
        The schema where to create models
        """
        return pulumi.get(self, "schema")

