# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EnvironmentVariableJobOverrideArgs', 'EnvironmentVariableJobOverride']

@pulumi.input_type
class EnvironmentVariableJobOverrideArgs:
    def __init__(__self__, *,
                 job_definition_id: pulumi.Input[builtins.int],
                 project_id: pulumi.Input[builtins.int],
                 raw_value: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EnvironmentVariableJobOverride resource.
        :param pulumi.Input[builtins.int] job_definition_id: The job ID for which the environment variable is being overridden
        :param pulumi.Input[builtins.int] project_id: Project ID to create the environment variable job override in
        :param pulumi.Input[builtins.str] raw_value: The value for the override of the environment variable
        :param pulumi.Input[builtins.str] name: The environment variable name to override
        """
        pulumi.set(__self__, "job_definition_id", job_definition_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "raw_value", raw_value)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="jobDefinitionId")
    def job_definition_id(self) -> pulumi.Input[builtins.int]:
        """
        The job ID for which the environment variable is being overridden
        """
        return pulumi.get(self, "job_definition_id")

    @job_definition_id.setter
    def job_definition_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "job_definition_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        Project ID to create the environment variable job override in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="rawValue")
    def raw_value(self) -> pulumi.Input[builtins.str]:
        """
        The value for the override of the environment variable
        """
        return pulumi.get(self, "raw_value")

    @raw_value.setter
    def raw_value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "raw_value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The environment variable name to override
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _EnvironmentVariableJobOverrideState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.int]] = None,
                 environment_variable_job_override_id: Optional[pulumi.Input[builtins.int]] = None,
                 job_definition_id: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 raw_value: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvironmentVariableJobOverride resources.
        :param pulumi.Input[builtins.int] account_id: The account id
        :param pulumi.Input[builtins.int] environment_variable_job_override_id: The internal ID of this resource. Contains the project ID and the environment variable job override ID.
        :param pulumi.Input[builtins.int] job_definition_id: The job ID for which the environment variable is being overridden
        :param pulumi.Input[builtins.str] name: The environment variable name to override
        :param pulumi.Input[builtins.int] project_id: Project ID to create the environment variable job override in
        :param pulumi.Input[builtins.str] raw_value: The value for the override of the environment variable
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if environment_variable_job_override_id is not None:
            pulumi.set(__self__, "environment_variable_job_override_id", environment_variable_job_override_id)
        if job_definition_id is not None:
            pulumi.set(__self__, "job_definition_id", job_definition_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if raw_value is not None:
            pulumi.set(__self__, "raw_value", raw_value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The account id
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="environmentVariableJobOverrideId")
    def environment_variable_job_override_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The internal ID of this resource. Contains the project ID and the environment variable job override ID.
        """
        return pulumi.get(self, "environment_variable_job_override_id")

    @environment_variable_job_override_id.setter
    def environment_variable_job_override_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "environment_variable_job_override_id", value)

    @property
    @pulumi.getter(name="jobDefinitionId")
    def job_definition_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The job ID for which the environment variable is being overridden
        """
        return pulumi.get(self, "job_definition_id")

    @job_definition_id.setter
    def job_definition_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "job_definition_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The environment variable name to override
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Project ID to create the environment variable job override in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="rawValue")
    def raw_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value for the override of the environment variable
        """
        return pulumi.get(self, "raw_value")

    @raw_value.setter
    def raw_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "raw_value", value)


@pulumi.type_token("dbtcloud:index/environmentVariableJobOverride:EnvironmentVariableJobOverride")
class EnvironmentVariableJobOverride(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 job_definition_id: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 raw_value: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Environment variable job override resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        my_env_var_job_override = dbtcloud.EnvironmentVariableJobOverride("my_env_var_job_override",
            name=dbt_my_env_var["name"],
            project_id=dbt_project["id"],
            job_definition_id=daily_job["id"],
            raw_value="my_override_value")
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_environment_variable_job_override.test_environment_variable_job_override

          id = "project_id:job_id:environment_variable_override_id"

        }

        import {

          to = dbtcloud_environment_variable_job_override.test_environment_variable_job_override

          id = "12345:678:123456"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/environmentVariableJobOverride:EnvironmentVariableJobOverride test_environment_variable_job_override "project_id:job_id:environment_variable_override_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/environmentVariableJobOverride:EnvironmentVariableJobOverride test_environment_variable_job_override 12345:678:123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] job_definition_id: The job ID for which the environment variable is being overridden
        :param pulumi.Input[builtins.str] name: The environment variable name to override
        :param pulumi.Input[builtins.int] project_id: Project ID to create the environment variable job override in
        :param pulumi.Input[builtins.str] raw_value: The value for the override of the environment variable
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentVariableJobOverrideArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Environment variable job override resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        my_env_var_job_override = dbtcloud.EnvironmentVariableJobOverride("my_env_var_job_override",
            name=dbt_my_env_var["name"],
            project_id=dbt_project["id"],
            job_definition_id=daily_job["id"],
            raw_value="my_override_value")
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_environment_variable_job_override.test_environment_variable_job_override

          id = "project_id:job_id:environment_variable_override_id"

        }

        import {

          to = dbtcloud_environment_variable_job_override.test_environment_variable_job_override

          id = "12345:678:123456"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/environmentVariableJobOverride:EnvironmentVariableJobOverride test_environment_variable_job_override "project_id:job_id:environment_variable_override_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/environmentVariableJobOverride:EnvironmentVariableJobOverride test_environment_variable_job_override 12345:678:123456
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentVariableJobOverrideArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentVariableJobOverrideArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 job_definition_id: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 raw_value: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentVariableJobOverrideArgs.__new__(EnvironmentVariableJobOverrideArgs)

            if job_definition_id is None and not opts.urn:
                raise TypeError("Missing required property 'job_definition_id'")
            __props__.__dict__["job_definition_id"] = job_definition_id
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if raw_value is None and not opts.urn:
                raise TypeError("Missing required property 'raw_value'")
            __props__.__dict__["raw_value"] = raw_value
            __props__.__dict__["account_id"] = None
            __props__.__dict__["environment_variable_job_override_id"] = None
        super(EnvironmentVariableJobOverride, __self__).__init__(
            'dbtcloud:index/environmentVariableJobOverride:EnvironmentVariableJobOverride',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.int]] = None,
            environment_variable_job_override_id: Optional[pulumi.Input[builtins.int]] = None,
            job_definition_id: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.int]] = None,
            raw_value: Optional[pulumi.Input[builtins.str]] = None) -> 'EnvironmentVariableJobOverride':
        """
        Get an existing EnvironmentVariableJobOverride resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] account_id: The account id
        :param pulumi.Input[builtins.int] environment_variable_job_override_id: The internal ID of this resource. Contains the project ID and the environment variable job override ID.
        :param pulumi.Input[builtins.int] job_definition_id: The job ID for which the environment variable is being overridden
        :param pulumi.Input[builtins.str] name: The environment variable name to override
        :param pulumi.Input[builtins.int] project_id: Project ID to create the environment variable job override in
        :param pulumi.Input[builtins.str] raw_value: The value for the override of the environment variable
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentVariableJobOverrideState.__new__(_EnvironmentVariableJobOverrideState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["environment_variable_job_override_id"] = environment_variable_job_override_id
        __props__.__dict__["job_definition_id"] = job_definition_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["raw_value"] = raw_value
        return EnvironmentVariableJobOverride(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.int]:
        """
        The account id
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="environmentVariableJobOverrideId")
    def environment_variable_job_override_id(self) -> pulumi.Output[builtins.int]:
        """
        The internal ID of this resource. Contains the project ID and the environment variable job override ID.
        """
        return pulumi.get(self, "environment_variable_job_override_id")

    @property
    @pulumi.getter(name="jobDefinitionId")
    def job_definition_id(self) -> pulumi.Output[builtins.int]:
        """
        The job ID for which the environment variable is being overridden
        """
        return pulumi.get(self, "job_definition_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The environment variable name to override
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.int]:
        """
        Project ID to create the environment variable job override in
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="rawValue")
    def raw_value(self) -> pulumi.Output[builtins.str]:
        """
        The value for the override of the environment variable
        """
        return pulumi.get(self, "raw_value")

