# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAzureDevOpsRepositoryResult',
    'AwaitableGetAzureDevOpsRepositoryResult',
    'get_azure_dev_ops_repository',
    'get_azure_dev_ops_repository_output',
]

@pulumi.output_type
class GetAzureDevOpsRepositoryResult:
    """
    A collection of values returned by getAzureDevOpsRepository.
    """
    def __init__(__self__, azure_dev_ops_project_id=None, default_branch=None, details_url=None, id=None, name=None, remote_url=None, web_url=None):
        if azure_dev_ops_project_id and not isinstance(azure_dev_ops_project_id, str):
            raise TypeError("Expected argument 'azure_dev_ops_project_id' to be a str")
        pulumi.set(__self__, "azure_dev_ops_project_id", azure_dev_ops_project_id)
        if default_branch and not isinstance(default_branch, str):
            raise TypeError("Expected argument 'default_branch' to be a str")
        pulumi.set(__self__, "default_branch", default_branch)
        if details_url and not isinstance(details_url, str):
            raise TypeError("Expected argument 'details_url' to be a str")
        pulumi.set(__self__, "details_url", details_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if remote_url and not isinstance(remote_url, str):
            raise TypeError("Expected argument 'remote_url' to be a str")
        pulumi.set(__self__, "remote_url", remote_url)
        if web_url and not isinstance(web_url, str):
            raise TypeError("Expected argument 'web_url' to be a str")
        pulumi.set(__self__, "web_url", web_url)

    @property
    @pulumi.getter(name="azureDevOpsProjectId")
    def azure_dev_ops_project_id(self) -> builtins.str:
        """
        The internal Azure Dev Ops ID of the ADO Project. Can be retrieved using the data source dbtcloud*azure*dev*ops*project and the project name
        """
        return pulumi.get(self, "azure_dev_ops_project_id")

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> builtins.str:
        """
        The default branch of the ADO repository
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter(name="detailsUrl")
    def details_url(self) -> builtins.str:
        """
        The URL of the ADO repository showing details about the repository and its attributes
        """
        return pulumi.get(self, "details_url")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The internal Azure Dev Ops ID of the ADO Repository
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the ADO repository
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="remoteUrl")
    def remote_url(self) -> builtins.str:
        """
        The HTTP URL of the ADO repository used to connect to dbt Cloud
        """
        return pulumi.get(self, "remote_url")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> builtins.str:
        """
        The URL of the ADO repository accessible in the browser
        """
        return pulumi.get(self, "web_url")


class AwaitableGetAzureDevOpsRepositoryResult(GetAzureDevOpsRepositoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAzureDevOpsRepositoryResult(
            azure_dev_ops_project_id=self.azure_dev_ops_project_id,
            default_branch=self.default_branch,
            details_url=self.details_url,
            id=self.id,
            name=self.name,
            remote_url=self.remote_url,
            web_url=self.web_url)


def get_azure_dev_ops_repository(azure_dev_ops_project_id: Optional[builtins.str] = None,
                                 name: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAzureDevOpsRepositoryResult:
    """
    Use this data source to retrieve the ID and details of an Azure Dev Ops repository
    based on its name and the ID of the Azure Dev Ops project it belongs to.

    This data source requires connecting with a user token and doesn't work with a service token.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    my_ado_repository = dbtcloud.get_azure_dev_ops_repository(name="my-repo-name",
        azure_dev_ops_project_id=my_ado_project["id"])
    ```


    :param builtins.str azure_dev_ops_project_id: The internal Azure Dev Ops ID of the ADO Project. Can be retrieved using the data source dbtcloud*azure*dev*ops*project and the project name
    :param builtins.str name: The name of the ADO repository
    """
    __args__ = dict()
    __args__['azureDevOpsProjectId'] = azure_dev_ops_project_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getAzureDevOpsRepository:getAzureDevOpsRepository', __args__, opts=opts, typ=GetAzureDevOpsRepositoryResult).value

    return AwaitableGetAzureDevOpsRepositoryResult(
        azure_dev_ops_project_id=pulumi.get(__ret__, 'azure_dev_ops_project_id'),
        default_branch=pulumi.get(__ret__, 'default_branch'),
        details_url=pulumi.get(__ret__, 'details_url'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        remote_url=pulumi.get(__ret__, 'remote_url'),
        web_url=pulumi.get(__ret__, 'web_url'))
def get_azure_dev_ops_repository_output(azure_dev_ops_project_id: Optional[pulumi.Input[builtins.str]] = None,
                                        name: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAzureDevOpsRepositoryResult]:
    """
    Use this data source to retrieve the ID and details of an Azure Dev Ops repository
    based on its name and the ID of the Azure Dev Ops project it belongs to.

    This data source requires connecting with a user token and doesn't work with a service token.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    my_ado_repository = dbtcloud.get_azure_dev_ops_repository(name="my-repo-name",
        azure_dev_ops_project_id=my_ado_project["id"])
    ```


    :param builtins.str azure_dev_ops_project_id: The internal Azure Dev Ops ID of the ADO Project. Can be retrieved using the data source dbtcloud*azure*dev*ops*project and the project name
    :param builtins.str name: The name of the ADO repository
    """
    __args__ = dict()
    __args__['azureDevOpsProjectId'] = azure_dev_ops_project_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getAzureDevOpsRepository:getAzureDevOpsRepository', __args__, opts=opts, typ=GetAzureDevOpsRepositoryResult)
    return __ret__.apply(lambda __response__: GetAzureDevOpsRepositoryResult(
        azure_dev_ops_project_id=pulumi.get(__response__, 'azure_dev_ops_project_id'),
        default_branch=pulumi.get(__response__, 'default_branch'),
        details_url=pulumi.get(__response__, 'details_url'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        remote_url=pulumi.get(__response__, 'remote_url'),
        web_url=pulumi.get(__response__, 'web_url')))
