# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetJobsResult',
    'AwaitableGetJobsResult',
    'get_jobs',
    'get_jobs_output',
]

@pulumi.output_type
class GetJobsResult:
    """
    A collection of values returned by getJobs.
    """
    def __init__(__self__, environment_id=None, id=None, jobs=None, project_id=None):
        if environment_id and not isinstance(environment_id, int):
            raise TypeError("Expected argument 'environment_id' to be a int")
        pulumi.set(__self__, "environment_id", environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if jobs and not isinstance(jobs, list):
            raise TypeError("Expected argument 'jobs' to be a list")
        pulumi.set(__self__, "jobs", jobs)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[builtins.int]:
        """
        The ID of the environment for which we want to retrieve the jobs (one of `project_id` or `environment_id` must be set)
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def jobs(self) -> Sequence['outputs.GetJobsJobResult']:
        """
        Set of jobs with their details
        """
        return pulumi.get(self, "jobs")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.int]:
        """
        The ID of the project for which we want to retrieve the jobs (one of `project_id` or `environment_id` must be set)
        """
        return pulumi.get(self, "project_id")


class AwaitableGetJobsResult(GetJobsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobsResult(
            environment_id=self.environment_id,
            id=self.id,
            jobs=self.jobs,
            project_id=self.project_id)


def get_jobs(environment_id: Optional[builtins.int] = None,
             project_id: Optional[builtins.int] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    # we can search all jobs by project
    test_all_jobs_in_project = dbtcloud.get_jobs(project_id=1234)
    # or by environment
    test_all_jobs_in_environment = dbtcloud.get_jobs(environment_id=1234)
    my_jobs_prod = [job for job in test_all_jobs_in_project.jobs if job.environment.deployment_type == "production"]
    ```


    :param builtins.int environment_id: The ID of the environment for which we want to retrieve the jobs (one of `project_id` or `environment_id` must be set)
    :param builtins.int project_id: The ID of the project for which we want to retrieve the jobs (one of `project_id` or `environment_id` must be set)
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getJobs:getJobs', __args__, opts=opts, typ=GetJobsResult).value

    return AwaitableGetJobsResult(
        environment_id=pulumi.get(__ret__, 'environment_id'),
        id=pulumi.get(__ret__, 'id'),
        jobs=pulumi.get(__ret__, 'jobs'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_jobs_output(environment_id: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                    project_id: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJobsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    # we can search all jobs by project
    test_all_jobs_in_project = dbtcloud.get_jobs(project_id=1234)
    # or by environment
    test_all_jobs_in_environment = dbtcloud.get_jobs(environment_id=1234)
    my_jobs_prod = [job for job in test_all_jobs_in_project.jobs if job.environment.deployment_type == "production"]
    ```


    :param builtins.int environment_id: The ID of the environment for which we want to retrieve the jobs (one of `project_id` or `environment_id` must be set)
    :param builtins.int project_id: The ID of the project for which we want to retrieve the jobs (one of `project_id` or `environment_id` must be set)
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getJobs:getJobs', __args__, opts=opts, typ=GetJobsResult)
    return __ret__.apply(lambda __response__: GetJobsResult(
        environment_id=pulumi.get(__response__, 'environment_id'),
        id=pulumi.get(__response__, 'id'),
        jobs=pulumi.get(__response__, 'jobs'),
        project_id=pulumi.get(__response__, 'project_id')))
