# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPrivatelinkEndpointResult',
    'AwaitableGetPrivatelinkEndpointResult',
    'get_privatelink_endpoint',
    'get_privatelink_endpoint_output',
]

@pulumi.output_type
class GetPrivatelinkEndpointResult:
    """
    A collection of values returned by getPrivatelinkEndpoint.
    """
    def __init__(__self__, cidr_range=None, id=None, name=None, private_link_endpoint_url=None, type=None):
        if cidr_range and not isinstance(cidr_range, str):
            raise TypeError("Expected argument 'cidr_range' to be a str")
        pulumi.set(__self__, "cidr_range", cidr_range)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if private_link_endpoint_url and not isinstance(private_link_endpoint_url, str):
            raise TypeError("Expected argument 'private_link_endpoint_url' to be a str")
        pulumi.set(__self__, "private_link_endpoint_url", private_link_endpoint_url)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cidrRange")
    def cidr_range(self) -> builtins.str:
        """
        CIDR range of the PrivateLink Endpoint
        """
        return pulumi.get(self, "cidr_range")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The internal ID of the PrivateLink Endpoint
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Given descriptive name for the PrivateLink Endpoint (name and/or private*link*endpoint_url need to be provided to return data for the datasource)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkEndpointUrl")
    def private_link_endpoint_url(self) -> Optional[builtins.str]:
        """
        URL of the PrivateLink Endpoint (name and/or private*link*endpoint_url need to be provided to return data for the datasource)
        """
        return pulumi.get(self, "private_link_endpoint_url")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the PrivateLink Endpoint
        """
        return pulumi.get(self, "type")


class AwaitableGetPrivatelinkEndpointResult(GetPrivatelinkEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivatelinkEndpointResult(
            cidr_range=self.cidr_range,
            id=self.id,
            name=self.name,
            private_link_endpoint_url=self.private_link_endpoint_url,
            type=self.type)


def get_privatelink_endpoint(name: Optional[builtins.str] = None,
                             private_link_endpoint_url: Optional[builtins.str] = None,
                             type: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivatelinkEndpointResult:
    """
    Privatelink endpoint data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    test_with_name = dbtcloud.get_privatelink_endpoint(name="My Endpoint Name")
    test_with_url = dbtcloud.get_privatelink_endpoint(private_link_endpoint_url="abc.privatelink.def.com")
    # in case multiple endpoints have the same name or URL
    test_with_name_and_url = dbtcloud.get_privatelink_endpoint(name="My Endpoint Name",
        private_link_endpoint_url="abc.privatelink.def.com")
    ```


    :param builtins.str name: Given descriptive name for the PrivateLink Endpoint (name and/or private*link*endpoint_url need to be provided to return data for the datasource)
    :param builtins.str private_link_endpoint_url: URL of the PrivateLink Endpoint (name and/or private*link*endpoint_url need to be provided to return data for the datasource)
    :param builtins.str type: Type of the PrivateLink Endpoint
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['privateLinkEndpointUrl'] = private_link_endpoint_url
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getPrivatelinkEndpoint:getPrivatelinkEndpoint', __args__, opts=opts, typ=GetPrivatelinkEndpointResult).value

    return AwaitableGetPrivatelinkEndpointResult(
        cidr_range=pulumi.get(__ret__, 'cidr_range'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        private_link_endpoint_url=pulumi.get(__ret__, 'private_link_endpoint_url'),
        type=pulumi.get(__ret__, 'type'))
def get_privatelink_endpoint_output(name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    private_link_endpoint_url: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrivatelinkEndpointResult]:
    """
    Privatelink endpoint data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    test_with_name = dbtcloud.get_privatelink_endpoint(name="My Endpoint Name")
    test_with_url = dbtcloud.get_privatelink_endpoint(private_link_endpoint_url="abc.privatelink.def.com")
    # in case multiple endpoints have the same name or URL
    test_with_name_and_url = dbtcloud.get_privatelink_endpoint(name="My Endpoint Name",
        private_link_endpoint_url="abc.privatelink.def.com")
    ```


    :param builtins.str name: Given descriptive name for the PrivateLink Endpoint (name and/or private*link*endpoint_url need to be provided to return data for the datasource)
    :param builtins.str private_link_endpoint_url: URL of the PrivateLink Endpoint (name and/or private*link*endpoint_url need to be provided to return data for the datasource)
    :param builtins.str type: Type of the PrivateLink Endpoint
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['privateLinkEndpointUrl'] = private_link_endpoint_url
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getPrivatelinkEndpoint:getPrivatelinkEndpoint', __args__, opts=opts, typ=GetPrivatelinkEndpointResult)
    return __ret__.apply(lambda __response__: GetPrivatelinkEndpointResult(
        cidr_range=pulumi.get(__response__, 'cidr_range'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        private_link_endpoint_url=pulumi.get(__response__, 'private_link_endpoint_url'),
        type=pulumi.get(__response__, 'type')))
