# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetTeradataCredentialResult',
    'AwaitableGetTeradataCredentialResult',
    'get_teradata_credential',
    'get_teradata_credential_output',
]

@pulumi.output_type
class GetTeradataCredentialResult:
    """
    A collection of values returned by getTeradataCredential.
    """
    def __init__(__self__, credential_id=None, id=None, password=None, project_id=None, schema=None, threads=None, user=None):
        if credential_id and not isinstance(credential_id, int):
            raise TypeError("Expected argument 'credential_id' to be a int")
        pulumi.set(__self__, "credential_id", credential_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)
        if threads and not isinstance(threads, int):
            raise TypeError("Expected argument 'threads' to be a int")
        pulumi.set(__self__, "threads", threads)
        if user and not isinstance(user, str):
            raise TypeError("Expected argument 'user' to be a str")
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> builtins.int:
        """
        Credential ID
        """
        return pulumi.get(self, "credential_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        The password for the Teradata account
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.int:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def schema(self) -> builtins.str:
        """
        The schema where to create models
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def threads(self) -> builtins.int:
        """
        The number of threads to use. Default is 1
        """
        return pulumi.get(self, "threads")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        The username for the Teradata account
        """
        return pulumi.get(self, "user")


class AwaitableGetTeradataCredentialResult(GetTeradataCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTeradataCredentialResult(
            credential_id=self.credential_id,
            id=self.id,
            password=self.password,
            project_id=self.project_id,
            schema=self.schema,
            threads=self.threads,
            user=self.user)


def get_teradata_credential(credential_id: Optional[builtins.int] = None,
                            project_id: Optional[builtins.int] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTeradataCredentialResult:
    """
    Teradata credential data source


    :param builtins.int credential_id: Credential ID
    :param builtins.int project_id: Project ID
    """
    __args__ = dict()
    __args__['credentialId'] = credential_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getTeradataCredential:getTeradataCredential', __args__, opts=opts, typ=GetTeradataCredentialResult).value

    return AwaitableGetTeradataCredentialResult(
        credential_id=pulumi.get(__ret__, 'credential_id'),
        id=pulumi.get(__ret__, 'id'),
        password=pulumi.get(__ret__, 'password'),
        project_id=pulumi.get(__ret__, 'project_id'),
        schema=pulumi.get(__ret__, 'schema'),
        threads=pulumi.get(__ret__, 'threads'),
        user=pulumi.get(__ret__, 'user'))
def get_teradata_credential_output(credential_id: Optional[pulumi.Input[builtins.int]] = None,
                                   project_id: Optional[pulumi.Input[builtins.int]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTeradataCredentialResult]:
    """
    Teradata credential data source


    :param builtins.int credential_id: Credential ID
    :param builtins.int project_id: Project ID
    """
    __args__ = dict()
    __args__['credentialId'] = credential_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getTeradataCredential:getTeradataCredential', __args__, opts=opts, typ=GetTeradataCredentialResult)
    return __ret__.apply(lambda __response__: GetTeradataCredentialResult(
        credential_id=pulumi.get(__response__, 'credential_id'),
        id=pulumi.get(__response__, 'id'),
        password=pulumi.get(__response__, 'password'),
        project_id=pulumi.get(__response__, 'project_id'),
        schema=pulumi.get(__response__, 'schema'),
        threads=pulumi.get(__response__, 'threads'),
        user=pulumi.get(__response__, 'user')))
