# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 assign_by_default: Optional[pulumi.Input[builtins.bool]] = None,
                 group_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['GroupGroupPermissionArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sso_mapping_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[builtins.bool] assign_by_default: Whether the group will be assigned by default to users. The value needs to be the same for all partial permissions for the same group.
        :param pulumi.Input[Sequence[pulumi.Input['GroupGroupPermissionArgs']]] group_permissions: Partial permissions for the group. Those permissions will be added/removed when config is added/removed.
        :param pulumi.Input[builtins.str] name: The name of the group. This is used to identify an existing group
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sso_mapping_groups: Mapping groups from the IdP. At the moment the complete list needs to be provided in each partial permission for the same group.
        """
        if assign_by_default is not None:
            pulumi.set(__self__, "assign_by_default", assign_by_default)
        if group_permissions is not None:
            pulumi.set(__self__, "group_permissions", group_permissions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sso_mapping_groups is not None:
            pulumi.set(__self__, "sso_mapping_groups", sso_mapping_groups)

    @property
    @pulumi.getter(name="assignByDefault")
    def assign_by_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the group will be assigned by default to users. The value needs to be the same for all partial permissions for the same group.
        """
        return pulumi.get(self, "assign_by_default")

    @assign_by_default.setter
    def assign_by_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "assign_by_default", value)

    @property
    @pulumi.getter(name="groupPermissions")
    def group_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupGroupPermissionArgs']]]]:
        """
        Partial permissions for the group. Those permissions will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "group_permissions")

    @group_permissions.setter
    def group_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupGroupPermissionArgs']]]]):
        pulumi.set(self, "group_permissions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the group. This is used to identify an existing group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ssoMappingGroups")
    def sso_mapping_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Mapping groups from the IdP. At the moment the complete list needs to be provided in each partial permission for the same group.
        """
        return pulumi.get(self, "sso_mapping_groups")

    @sso_mapping_groups.setter
    def sso_mapping_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sso_mapping_groups", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 assign_by_default: Optional[pulumi.Input[builtins.bool]] = None,
                 group_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['GroupGroupPermissionArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sso_mapping_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[builtins.bool] assign_by_default: Whether the group will be assigned by default to users. The value needs to be the same for all partial permissions for the same group.
        :param pulumi.Input[Sequence[pulumi.Input['GroupGroupPermissionArgs']]] group_permissions: Partial permissions for the group. Those permissions will be added/removed when config is added/removed.
        :param pulumi.Input[builtins.str] name: The name of the group. This is used to identify an existing group
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sso_mapping_groups: Mapping groups from the IdP. At the moment the complete list needs to be provided in each partial permission for the same group.
        """
        if assign_by_default is not None:
            pulumi.set(__self__, "assign_by_default", assign_by_default)
        if group_permissions is not None:
            pulumi.set(__self__, "group_permissions", group_permissions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sso_mapping_groups is not None:
            pulumi.set(__self__, "sso_mapping_groups", sso_mapping_groups)

    @property
    @pulumi.getter(name="assignByDefault")
    def assign_by_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the group will be assigned by default to users. The value needs to be the same for all partial permissions for the same group.
        """
        return pulumi.get(self, "assign_by_default")

    @assign_by_default.setter
    def assign_by_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "assign_by_default", value)

    @property
    @pulumi.getter(name="groupPermissions")
    def group_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupGroupPermissionArgs']]]]:
        """
        Partial permissions for the group. Those permissions will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "group_permissions")

    @group_permissions.setter
    def group_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupGroupPermissionArgs']]]]):
        pulumi.set(self, "group_permissions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the group. This is used to identify an existing group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ssoMappingGroups")
    def sso_mapping_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Mapping groups from the IdP. At the moment the complete list needs to be provided in each partial permission for the same group.
        """
        return pulumi.get(self, "sso_mapping_groups")

    @sso_mapping_groups.setter
    def sso_mapping_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sso_mapping_groups", value)


@pulumi.type_token("dbtcloud:index/group:Group")
class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_by_default: Optional[pulumi.Input[builtins.bool]] = None,
                 group_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupGroupPermissionArgs', 'GroupGroupPermissionArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sso_mapping_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        tf_group1 = dbtcloud.Group("tf_group_1",
            name="TF Group 1",
            group_permissions=[
                {
                    "permission_set": "member",
                    "all_projects": True,
                },
                {
                    "permission_set": "developer",
                    "all_projects": False,
                    "project_id": dbt_project["id"],
                    "writable_environment_categories": [
                        "development",
                        "staging",
                    ],
                },
            ])
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_group.my_group

          id = "group_id"

        }

        import {

          to = dbtcloud_group.my_group

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/group:Group my_group "group_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/group:Group my_group 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] assign_by_default: Whether the group will be assigned by default to users. The value needs to be the same for all partial permissions for the same group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupGroupPermissionArgs', 'GroupGroupPermissionArgsDict']]]] group_permissions: Partial permissions for the group. Those permissions will be added/removed when config is added/removed.
        :param pulumi.Input[builtins.str] name: The name of the group. This is used to identify an existing group
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sso_mapping_groups: Mapping groups from the IdP. At the moment the complete list needs to be provided in each partial permission for the same group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        tf_group1 = dbtcloud.Group("tf_group_1",
            name="TF Group 1",
            group_permissions=[
                {
                    "permission_set": "member",
                    "all_projects": True,
                },
                {
                    "permission_set": "developer",
                    "all_projects": False,
                    "project_id": dbt_project["id"],
                    "writable_environment_categories": [
                        "development",
                        "staging",
                    ],
                },
            ])
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_group.my_group

          id = "group_id"

        }

        import {

          to = dbtcloud_group.my_group

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/group:Group my_group "group_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/group:Group my_group 12345
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_by_default: Optional[pulumi.Input[builtins.bool]] = None,
                 group_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupGroupPermissionArgs', 'GroupGroupPermissionArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sso_mapping_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["assign_by_default"] = assign_by_default
            __props__.__dict__["group_permissions"] = group_permissions
            __props__.__dict__["name"] = name
            __props__.__dict__["sso_mapping_groups"] = sso_mapping_groups
        super(Group, __self__).__init__(
            'dbtcloud:index/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assign_by_default: Optional[pulumi.Input[builtins.bool]] = None,
            group_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupGroupPermissionArgs', 'GroupGroupPermissionArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            sso_mapping_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] assign_by_default: Whether the group will be assigned by default to users. The value needs to be the same for all partial permissions for the same group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupGroupPermissionArgs', 'GroupGroupPermissionArgsDict']]]] group_permissions: Partial permissions for the group. Those permissions will be added/removed when config is added/removed.
        :param pulumi.Input[builtins.str] name: The name of the group. This is used to identify an existing group
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sso_mapping_groups: Mapping groups from the IdP. At the moment the complete list needs to be provided in each partial permission for the same group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["assign_by_default"] = assign_by_default
        __props__.__dict__["group_permissions"] = group_permissions
        __props__.__dict__["name"] = name
        __props__.__dict__["sso_mapping_groups"] = sso_mapping_groups
        return Group(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assignByDefault")
    def assign_by_default(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the group will be assigned by default to users. The value needs to be the same for all partial permissions for the same group.
        """
        return pulumi.get(self, "assign_by_default")

    @property
    @pulumi.getter(name="groupPermissions")
    def group_permissions(self) -> pulumi.Output[Optional[Sequence['outputs.GroupGroupPermission']]]:
        """
        Partial permissions for the group. Those permissions will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "group_permissions")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the group. This is used to identify an existing group
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ssoMappingGroups")
    def sso_mapping_groups(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Mapping groups from the IdP. At the moment the complete list needs to be provided in each partial permission for the same group.
        """
        return pulumi.get(self, "sso_mapping_groups")

