# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LicenseMapArgs', 'LicenseMap']

@pulumi.input_type
class LicenseMapArgs:
    def __init__(__self__, *,
                 license_type: pulumi.Input[builtins.str],
                 sso_license_mapping_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a LicenseMap resource.
        :param pulumi.Input[builtins.str] license_type: License type
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sso_license_mapping_groups: SSO license mapping group names for this group
        """
        pulumi.set(__self__, "license_type", license_type)
        if sso_license_mapping_groups is not None:
            pulumi.set(__self__, "sso_license_mapping_groups", sso_license_mapping_groups)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Input[builtins.str]:
        """
        License type
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="ssoLicenseMappingGroups")
    def sso_license_mapping_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        SSO license mapping group names for this group
        """
        return pulumi.get(self, "sso_license_mapping_groups")

    @sso_license_mapping_groups.setter
    def sso_license_mapping_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sso_license_mapping_groups", value)


@pulumi.input_type
class _LicenseMapState:
    def __init__(__self__, *,
                 license_type: Optional[pulumi.Input[builtins.str]] = None,
                 sso_license_mapping_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LicenseMap resources.
        :param pulumi.Input[builtins.str] license_type: License type
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sso_license_mapping_groups: SSO license mapping group names for this group
        """
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if sso_license_mapping_groups is not None:
            pulumi.set(__self__, "sso_license_mapping_groups", sso_license_mapping_groups)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        License type
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="ssoLicenseMappingGroups")
    def sso_license_mapping_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        SSO license mapping group names for this group
        """
        return pulumi.get(self, "sso_license_mapping_groups")

    @sso_license_mapping_groups.setter
    def sso_license_mapping_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sso_license_mapping_groups", value)


@pulumi.type_token("dbtcloud:index/licenseMap:LicenseMap")
class LicenseMap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 license_type: Optional[pulumi.Input[builtins.str]] = None,
                 sso_license_mapping_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Maps SSO groups to a given license type

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        # Developer license group mapping
        dev_license_map = dbtcloud.LicenseMap("dev_license_map",
            license_type="developer",
            sso_license_mapping_groups=["DEV-SSO-GROUP"])
        # Read-only license mapping
        read_only_license_map = dbtcloud.LicenseMap("read_only_license_map",
            license_type="read_only",
            sso_license_mapping_groups=["READ-ONLY-SSO-GROUP"])
        # IT license mapping
        it_license_map = dbtcloud.LicenseMap("it_license_map",
            license_type="it",
            sso_license_mapping_groups=["IT-SSO-GROUP"])
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_license_map.my_license_map

          id = "license_map_id"

        }

        import {

          to = dbtcloud_license_map.my_license_map

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/licenseMap:LicenseMap my_license_map "license_map_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/licenseMap:LicenseMap my_license_map 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] license_type: License type
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sso_license_mapping_groups: SSO license mapping group names for this group
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LicenseMapArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Maps SSO groups to a given license type

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        # Developer license group mapping
        dev_license_map = dbtcloud.LicenseMap("dev_license_map",
            license_type="developer",
            sso_license_mapping_groups=["DEV-SSO-GROUP"])
        # Read-only license mapping
        read_only_license_map = dbtcloud.LicenseMap("read_only_license_map",
            license_type="read_only",
            sso_license_mapping_groups=["READ-ONLY-SSO-GROUP"])
        # IT license mapping
        it_license_map = dbtcloud.LicenseMap("it_license_map",
            license_type="it",
            sso_license_mapping_groups=["IT-SSO-GROUP"])
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_license_map.my_license_map

          id = "license_map_id"

        }

        import {

          to = dbtcloud_license_map.my_license_map

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/licenseMap:LicenseMap my_license_map "license_map_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/licenseMap:LicenseMap my_license_map 12345
        ```

        :param str resource_name: The name of the resource.
        :param LicenseMapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LicenseMapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 license_type: Optional[pulumi.Input[builtins.str]] = None,
                 sso_license_mapping_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LicenseMapArgs.__new__(LicenseMapArgs)

            if license_type is None and not opts.urn:
                raise TypeError("Missing required property 'license_type'")
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["sso_license_mapping_groups"] = sso_license_mapping_groups
        super(LicenseMap, __self__).__init__(
            'dbtcloud:index/licenseMap:LicenseMap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            license_type: Optional[pulumi.Input[builtins.str]] = None,
            sso_license_mapping_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'LicenseMap':
        """
        Get an existing LicenseMap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] license_type: License type
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sso_license_mapping_groups: SSO license mapping group names for this group
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LicenseMapState.__new__(_LicenseMapState)

        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["sso_license_mapping_groups"] = sso_license_mapping_groups
        return LicenseMap(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[builtins.str]:
        """
        License type
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="ssoLicenseMappingGroups")
    def sso_license_mapping_groups(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        SSO license mapping group names for this group
        """
        return pulumi.get(self, "sso_license_mapping_groups")

