# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LineageIntegrationArgs', 'LineageIntegration']

@pulumi.input_type
class LineageIntegrationArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.int],
                 site_id: pulumi.Input[builtins.str],
                 token: pulumi.Input[builtins.str],
                 token_name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a LineageIntegration resource.
        :param pulumi.Input[builtins.str] host: The URL of the BI server (see docs for more details)
        :param pulumi.Input[builtins.int] project_id: The dbt Cloud project ID for the integration
        :param pulumi.Input[builtins.str] site_id: The sitename for the collections of dashboards (see docs for more details)
        :param pulumi.Input[builtins.str] token: The secret token value to use to authenticate to the BI server
        :param pulumi.Input[builtins.str] token_name: The token to use to authenticate to the BI server
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "token_name", token_name)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[builtins.str]:
        """
        The URL of the BI server (see docs for more details)
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        The dbt Cloud project ID for the integration
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[builtins.str]:
        """
        The sitename for the collections of dashboards (see docs for more details)
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[builtins.str]:
        """
        The secret token value to use to authenticate to the BI server
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="tokenName")
    def token_name(self) -> pulumi.Input[builtins.str]:
        """
        The token to use to authenticate to the BI server
        """
        return pulumi.get(self, "token_name")

    @token_name.setter
    def token_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token_name", value)


@pulumi.input_type
class _LineageIntegrationState:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 lineage_integration_id: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 token_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LineageIntegration resources.
        :param pulumi.Input[builtins.str] host: The URL of the BI server (see docs for more details)
        :param pulumi.Input[builtins.int] lineage_integration_id: The ID of the lineage integration
        :param pulumi.Input[builtins.str] name: The integration type. Today only 'tableau' is supported
        :param pulumi.Input[builtins.int] project_id: The dbt Cloud project ID for the integration
        :param pulumi.Input[builtins.str] site_id: The sitename for the collections of dashboards (see docs for more details)
        :param pulumi.Input[builtins.str] token: The secret token value to use to authenticate to the BI server
        :param pulumi.Input[builtins.str] token_name: The token to use to authenticate to the BI server
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if lineage_integration_id is not None:
            pulumi.set(__self__, "lineage_integration_id", lineage_integration_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if token_name is not None:
            pulumi.set(__self__, "token_name", token_name)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the BI server (see docs for more details)
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="lineageIntegrationId")
    def lineage_integration_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The ID of the lineage integration
        """
        return pulumi.get(self, "lineage_integration_id")

    @lineage_integration_id.setter
    def lineage_integration_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "lineage_integration_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The integration type. Today only 'tableau' is supported
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The dbt Cloud project ID for the integration
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The sitename for the collections of dashboards (see docs for more details)
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret token value to use to authenticate to the BI server
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="tokenName")
    def token_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The token to use to authenticate to the BI server
        """
        return pulumi.get(self, "token_name")

    @token_name.setter
    def token_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token_name", value)


@pulumi.type_token("dbtcloud:index/lineageIntegration:LineageIntegration")
class LineageIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 token_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Setup lineage integration for dbt Cloud to automatically fetch lineage from external BI tools in dbt Explorer. Currently supports Tableau.

        This resource requires having an environment tagged as production already created for you project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        # the resource can only be configured when a Prod environment has been set
        # so, you might want to explicitly set the dependency on your Prod environment resource
        my_lineage = dbtcloud.LineageIntegration("my_lineage",
            project_id=my_project["id"],
            host="my.host.com",
            site_id="mysiteid",
            token_name="my-token-name",
            token="my-sensitive-token",
            opts = pulumi.ResourceOptions(depends_on=[my_prod_env]))
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_lineage_integration.my_lineage_integration

          id = "projet_id:lineage_integration_id"

        }

        import {

          to = dbtcloud_lineage_integration.my_lineage_integration

          id = "123:4567"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/lineageIntegration:LineageIntegration my_lineage_integration "projet_id:lineage_integration_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/lineageIntegration:LineageIntegration my_lineage_integration 123:4567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] host: The URL of the BI server (see docs for more details)
        :param pulumi.Input[builtins.int] project_id: The dbt Cloud project ID for the integration
        :param pulumi.Input[builtins.str] site_id: The sitename for the collections of dashboards (see docs for more details)
        :param pulumi.Input[builtins.str] token: The secret token value to use to authenticate to the BI server
        :param pulumi.Input[builtins.str] token_name: The token to use to authenticate to the BI server
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LineageIntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Setup lineage integration for dbt Cloud to automatically fetch lineage from external BI tools in dbt Explorer. Currently supports Tableau.

        This resource requires having an environment tagged as production already created for you project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        # the resource can only be configured when a Prod environment has been set
        # so, you might want to explicitly set the dependency on your Prod environment resource
        my_lineage = dbtcloud.LineageIntegration("my_lineage",
            project_id=my_project["id"],
            host="my.host.com",
            site_id="mysiteid",
            token_name="my-token-name",
            token="my-sensitive-token",
            opts = pulumi.ResourceOptions(depends_on=[my_prod_env]))
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_lineage_integration.my_lineage_integration

          id = "projet_id:lineage_integration_id"

        }

        import {

          to = dbtcloud_lineage_integration.my_lineage_integration

          id = "123:4567"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/lineageIntegration:LineageIntegration my_lineage_integration "projet_id:lineage_integration_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/lineageIntegration:LineageIntegration my_lineage_integration 123:4567
        ```

        :param str resource_name: The name of the resource.
        :param LineageIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LineageIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 token_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LineageIntegrationArgs.__new__(LineageIntegrationArgs)

            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            if token is None and not opts.urn:
                raise TypeError("Missing required property 'token'")
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            if token_name is None and not opts.urn:
                raise TypeError("Missing required property 'token_name'")
            __props__.__dict__["token_name"] = token_name
            __props__.__dict__["lineage_integration_id"] = None
            __props__.__dict__["name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LineageIntegration, __self__).__init__(
            'dbtcloud:index/lineageIntegration:LineageIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            host: Optional[pulumi.Input[builtins.str]] = None,
            lineage_integration_id: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.int]] = None,
            site_id: Optional[pulumi.Input[builtins.str]] = None,
            token: Optional[pulumi.Input[builtins.str]] = None,
            token_name: Optional[pulumi.Input[builtins.str]] = None) -> 'LineageIntegration':
        """
        Get an existing LineageIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] host: The URL of the BI server (see docs for more details)
        :param pulumi.Input[builtins.int] lineage_integration_id: The ID of the lineage integration
        :param pulumi.Input[builtins.str] name: The integration type. Today only 'tableau' is supported
        :param pulumi.Input[builtins.int] project_id: The dbt Cloud project ID for the integration
        :param pulumi.Input[builtins.str] site_id: The sitename for the collections of dashboards (see docs for more details)
        :param pulumi.Input[builtins.str] token: The secret token value to use to authenticate to the BI server
        :param pulumi.Input[builtins.str] token_name: The token to use to authenticate to the BI server
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LineageIntegrationState.__new__(_LineageIntegrationState)

        __props__.__dict__["host"] = host
        __props__.__dict__["lineage_integration_id"] = lineage_integration_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["token"] = token
        __props__.__dict__["token_name"] = token_name
        return LineageIntegration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the BI server (see docs for more details)
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="lineageIntegrationId")
    def lineage_integration_id(self) -> pulumi.Output[builtins.int]:
        """
        The ID of the lineage integration
        """
        return pulumi.get(self, "lineage_integration_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The integration type. Today only 'tableau' is supported
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.int]:
        """
        The dbt Cloud project ID for the integration
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[builtins.str]:
        """
        The sitename for the collections of dashboards (see docs for more details)
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[builtins.str]:
        """
        The secret token value to use to authenticate to the BI server
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="tokenName")
    def token_name(self) -> pulumi.Output[builtins.str]:
        """
        The token to use to authenticate to the BI server
        """
        return pulumi.get(self, "token_name")

