# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OauthConfigurationArgs', 'OauthConfiguration']

@pulumi.input_type
class OauthConfigurationArgs:
    def __init__(__self__, *,
                 authorize_url: pulumi.Input[builtins.str],
                 client_id: pulumi.Input[builtins.str],
                 client_secret: pulumi.Input[builtins.str],
                 redirect_uri: pulumi.Input[builtins.str],
                 token_url: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 application_id_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a OauthConfiguration resource.
        :param pulumi.Input[builtins.str] authorize_url: The Authorize URL for the OAuth integration
        :param pulumi.Input[builtins.str] client_id: The Client ID for the OAuth integration
        :param pulumi.Input[builtins.str] client_secret: The Client secret for the OAuth integration
        :param pulumi.Input[builtins.str] redirect_uri: The redirect URL for the OAuth integration
        :param pulumi.Input[builtins.str] token_url: The Token URL for the OAuth integration
        :param pulumi.Input[builtins.str] type: The type of OAuth integration (`entra` or `okta`)
        :param pulumi.Input[builtins.str] application_id_uri: The Application ID URI for the OAuth integration. Only for Entra
        :param pulumi.Input[builtins.str] name: The name of OAuth integration
        """
        pulumi.set(__self__, "authorize_url", authorize_url)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "redirect_uri", redirect_uri)
        pulumi.set(__self__, "token_url", token_url)
        pulumi.set(__self__, "type", type)
        if application_id_uri is not None:
            pulumi.set(__self__, "application_id_uri", application_id_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="authorizeUrl")
    def authorize_url(self) -> pulumi.Input[builtins.str]:
        """
        The Authorize URL for the OAuth integration
        """
        return pulumi.get(self, "authorize_url")

    @authorize_url.setter
    def authorize_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authorize_url", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        The Client ID for the OAuth integration
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[builtins.str]:
        """
        The Client secret for the OAuth integration
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="redirectUri")
    def redirect_uri(self) -> pulumi.Input[builtins.str]:
        """
        The redirect URL for the OAuth integration
        """
        return pulumi.get(self, "redirect_uri")

    @redirect_uri.setter
    def redirect_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "redirect_uri", value)

    @property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> pulumi.Input[builtins.str]:
        """
        The Token URL for the OAuth integration
        """
        return pulumi.get(self, "token_url")

    @token_url.setter
    def token_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token_url", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of OAuth integration (`entra` or `okta`)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="applicationIdUri")
    def application_id_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Application ID URI for the OAuth integration. Only for Entra
        """
        return pulumi.get(self, "application_id_uri")

    @application_id_uri.setter
    def application_id_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id_uri", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of OAuth integration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _OauthConfigurationState:
    def __init__(__self__, *,
                 application_id_uri: Optional[pulumi.Input[builtins.str]] = None,
                 authorize_url: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_uri: Optional[pulumi.Input[builtins.str]] = None,
                 token_url: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OauthConfiguration resources.
        :param pulumi.Input[builtins.str] application_id_uri: The Application ID URI for the OAuth integration. Only for Entra
        :param pulumi.Input[builtins.str] authorize_url: The Authorize URL for the OAuth integration
        :param pulumi.Input[builtins.str] client_id: The Client ID for the OAuth integration
        :param pulumi.Input[builtins.str] client_secret: The Client secret for the OAuth integration
        :param pulumi.Input[builtins.str] name: The name of OAuth integration
        :param pulumi.Input[builtins.str] redirect_uri: The redirect URL for the OAuth integration
        :param pulumi.Input[builtins.str] token_url: The Token URL for the OAuth integration
        :param pulumi.Input[builtins.str] type: The type of OAuth integration (`entra` or `okta`)
        """
        if application_id_uri is not None:
            pulumi.set(__self__, "application_id_uri", application_id_uri)
        if authorize_url is not None:
            pulumi.set(__self__, "authorize_url", authorize_url)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_uri is not None:
            pulumi.set(__self__, "redirect_uri", redirect_uri)
        if token_url is not None:
            pulumi.set(__self__, "token_url", token_url)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="applicationIdUri")
    def application_id_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Application ID URI for the OAuth integration. Only for Entra
        """
        return pulumi.get(self, "application_id_uri")

    @application_id_uri.setter
    def application_id_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id_uri", value)

    @property
    @pulumi.getter(name="authorizeUrl")
    def authorize_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Authorize URL for the OAuth integration
        """
        return pulumi.get(self, "authorize_url")

    @authorize_url.setter
    def authorize_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorize_url", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Client ID for the OAuth integration
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Client secret for the OAuth integration
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of OAuth integration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redirectUri")
    def redirect_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The redirect URL for the OAuth integration
        """
        return pulumi.get(self, "redirect_uri")

    @redirect_uri.setter
    def redirect_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redirect_uri", value)

    @property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Token URL for the OAuth integration
        """
        return pulumi.get(self, "token_url")

    @token_url.setter
    def token_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token_url", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of OAuth integration (`entra` or `okta`)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("dbtcloud:index/oauthConfiguration:OauthConfiguration")
class OauthConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id_uri: Optional[pulumi.Input[builtins.str]] = None,
                 authorize_url: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_uri: Optional[pulumi.Input[builtins.str]] = None,
                 token_url: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Configure an external OAuth integration for the data warehouse. Currently supports Okta and Entra ID (i.e. Azure AD) for Snowflake.

        See the [documentation](https://docs.getdbt.com/docs/cloud/manage-access/external-oauth) for more information on how to configure it.

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_oauth_configuration.my_external_oauth

          id = "external_oauth_id"

        }

        import {

          to = dbtcloud_oauth_configuration.my_external_oauth

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/oauthConfiguration:OauthConfiguration my_external_oauth "external_oauth_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/oauthConfiguration:OauthConfiguration my_external_oauth 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id_uri: The Application ID URI for the OAuth integration. Only for Entra
        :param pulumi.Input[builtins.str] authorize_url: The Authorize URL for the OAuth integration
        :param pulumi.Input[builtins.str] client_id: The Client ID for the OAuth integration
        :param pulumi.Input[builtins.str] client_secret: The Client secret for the OAuth integration
        :param pulumi.Input[builtins.str] name: The name of OAuth integration
        :param pulumi.Input[builtins.str] redirect_uri: The redirect URL for the OAuth integration
        :param pulumi.Input[builtins.str] token_url: The Token URL for the OAuth integration
        :param pulumi.Input[builtins.str] type: The type of OAuth integration (`entra` or `okta`)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OauthConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Configure an external OAuth integration for the data warehouse. Currently supports Okta and Entra ID (i.e. Azure AD) for Snowflake.

        See the [documentation](https://docs.getdbt.com/docs/cloud/manage-access/external-oauth) for more information on how to configure it.

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_oauth_configuration.my_external_oauth

          id = "external_oauth_id"

        }

        import {

          to = dbtcloud_oauth_configuration.my_external_oauth

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/oauthConfiguration:OauthConfiguration my_external_oauth "external_oauth_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/oauthConfiguration:OauthConfiguration my_external_oauth 12345
        ```

        :param str resource_name: The name of the resource.
        :param OauthConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OauthConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id_uri: Optional[pulumi.Input[builtins.str]] = None,
                 authorize_url: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_uri: Optional[pulumi.Input[builtins.str]] = None,
                 token_url: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OauthConfigurationArgs.__new__(OauthConfigurationArgs)

            __props__.__dict__["application_id_uri"] = application_id_uri
            if authorize_url is None and not opts.urn:
                raise TypeError("Missing required property 'authorize_url'")
            __props__.__dict__["authorize_url"] = authorize_url
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if client_secret is None and not opts.urn:
                raise TypeError("Missing required property 'client_secret'")
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["name"] = name
            if redirect_uri is None and not opts.urn:
                raise TypeError("Missing required property 'redirect_uri'")
            __props__.__dict__["redirect_uri"] = redirect_uri
            if token_url is None and not opts.urn:
                raise TypeError("Missing required property 'token_url'")
            __props__.__dict__["token_url"] = token_url
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OauthConfiguration, __self__).__init__(
            'dbtcloud:index/oauthConfiguration:OauthConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id_uri: Optional[pulumi.Input[builtins.str]] = None,
            authorize_url: Optional[pulumi.Input[builtins.str]] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            client_secret: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            redirect_uri: Optional[pulumi.Input[builtins.str]] = None,
            token_url: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'OauthConfiguration':
        """
        Get an existing OauthConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id_uri: The Application ID URI for the OAuth integration. Only for Entra
        :param pulumi.Input[builtins.str] authorize_url: The Authorize URL for the OAuth integration
        :param pulumi.Input[builtins.str] client_id: The Client ID for the OAuth integration
        :param pulumi.Input[builtins.str] client_secret: The Client secret for the OAuth integration
        :param pulumi.Input[builtins.str] name: The name of OAuth integration
        :param pulumi.Input[builtins.str] redirect_uri: The redirect URL for the OAuth integration
        :param pulumi.Input[builtins.str] token_url: The Token URL for the OAuth integration
        :param pulumi.Input[builtins.str] type: The type of OAuth integration (`entra` or `okta`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OauthConfigurationState.__new__(_OauthConfigurationState)

        __props__.__dict__["application_id_uri"] = application_id_uri
        __props__.__dict__["authorize_url"] = authorize_url
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["name"] = name
        __props__.__dict__["redirect_uri"] = redirect_uri
        __props__.__dict__["token_url"] = token_url
        __props__.__dict__["type"] = type
        return OauthConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationIdUri")
    def application_id_uri(self) -> pulumi.Output[builtins.str]:
        """
        The Application ID URI for the OAuth integration. Only for Entra
        """
        return pulumi.get(self, "application_id_uri")

    @property
    @pulumi.getter(name="authorizeUrl")
    def authorize_url(self) -> pulumi.Output[builtins.str]:
        """
        The Authorize URL for the OAuth integration
        """
        return pulumi.get(self, "authorize_url")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[builtins.str]:
        """
        The Client ID for the OAuth integration
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[builtins.str]:
        """
        The Client secret for the OAuth integration
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of OAuth integration
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="redirectUri")
    def redirect_uri(self) -> pulumi.Output[builtins.str]:
        """
        The redirect URL for the OAuth integration
        """
        return pulumi.get(self, "redirect_uri")

    @property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> pulumi.Output[builtins.str]:
        """
        The Token URL for the OAuth integration
        """
        return pulumi.get(self, "token_url")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of OAuth integration (`entra` or `okta`)
        """
        return pulumi.get(self, "type")

