# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PostgresSemanticLayerCredentialArgs', 'PostgresSemanticLayerCredential']

@pulumi.input_type
class PostgresSemanticLayerCredentialArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input['PostgresSemanticLayerCredentialConfigurationArgs'],
                 credential: pulumi.Input['PostgresSemanticLayerCredentialCredentialArgs']):
        """
        The set of arguments for constructing a PostgresSemanticLayerCredential resource.
        :param pulumi.Input['PostgresSemanticLayerCredentialConfigurationArgs'] configuration: Semantic Layer credential configuration details.
        :param pulumi.Input['PostgresSemanticLayerCredentialCredentialArgs'] credential: Postgres credential details, but used in the context of the Semantic Layer.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "credential", credential)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input['PostgresSemanticLayerCredentialConfigurationArgs']:
        """
        Semantic Layer credential configuration details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input['PostgresSemanticLayerCredentialConfigurationArgs']):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Input['PostgresSemanticLayerCredentialCredentialArgs']:
        """
        Postgres credential details, but used in the context of the Semantic Layer.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: pulumi.Input['PostgresSemanticLayerCredentialCredentialArgs']):
        pulumi.set(self, "credential", value)


@pulumi.input_type
class _PostgresSemanticLayerCredentialState:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input['PostgresSemanticLayerCredentialConfigurationArgs']] = None,
                 credential: Optional[pulumi.Input['PostgresSemanticLayerCredentialCredentialArgs']] = None):
        """
        Input properties used for looking up and filtering PostgresSemanticLayerCredential resources.
        :param pulumi.Input['PostgresSemanticLayerCredentialConfigurationArgs'] configuration: Semantic Layer credential configuration details.
        :param pulumi.Input['PostgresSemanticLayerCredentialCredentialArgs'] credential: Postgres credential details, but used in the context of the Semantic Layer.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['PostgresSemanticLayerCredentialConfigurationArgs']]:
        """
        Semantic Layer credential configuration details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['PostgresSemanticLayerCredentialConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input['PostgresSemanticLayerCredentialCredentialArgs']]:
        """
        Postgres credential details, but used in the context of the Semantic Layer.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input['PostgresSemanticLayerCredentialCredentialArgs']]):
        pulumi.set(self, "credential", value)


@pulumi.type_token("dbtcloud:index/postgresSemanticLayerCredential:PostgresSemanticLayerCredential")
class PostgresSemanticLayerCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['PostgresSemanticLayerCredentialConfigurationArgs', 'PostgresSemanticLayerCredentialConfigurationArgsDict']]] = None,
                 credential: Optional[pulumi.Input[Union['PostgresSemanticLayerCredentialCredentialArgs', 'PostgresSemanticLayerCredentialCredentialArgsDict']]] = None,
                 __props__=None):
        """
        Postgres credential resource. This resource is composed of a Postgres credential and a Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.

        ## Import

        using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_postgres_semantic_layer_credential.example

          id = "credential_id"

        }

        import {

          to = dbtcloud_postgres_semantic_layer_credential.example

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/postgresSemanticLayerCredential:PostgresSemanticLayerCredential example "credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/postgresSemanticLayerCredential:PostgresSemanticLayerCredential example 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PostgresSemanticLayerCredentialConfigurationArgs', 'PostgresSemanticLayerCredentialConfigurationArgsDict']] configuration: Semantic Layer credential configuration details.
        :param pulumi.Input[Union['PostgresSemanticLayerCredentialCredentialArgs', 'PostgresSemanticLayerCredentialCredentialArgsDict']] credential: Postgres credential details, but used in the context of the Semantic Layer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PostgresSemanticLayerCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Postgres credential resource. This resource is composed of a Postgres credential and a Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.

        ## Import

        using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_postgres_semantic_layer_credential.example

          id = "credential_id"

        }

        import {

          to = dbtcloud_postgres_semantic_layer_credential.example

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/postgresSemanticLayerCredential:PostgresSemanticLayerCredential example "credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/postgresSemanticLayerCredential:PostgresSemanticLayerCredential example 12345
        ```

        :param str resource_name: The name of the resource.
        :param PostgresSemanticLayerCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PostgresSemanticLayerCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['PostgresSemanticLayerCredentialConfigurationArgs', 'PostgresSemanticLayerCredentialConfigurationArgsDict']]] = None,
                 credential: Optional[pulumi.Input[Union['PostgresSemanticLayerCredentialCredentialArgs', 'PostgresSemanticLayerCredentialCredentialArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PostgresSemanticLayerCredentialArgs.__new__(PostgresSemanticLayerCredentialArgs)

            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            if credential is None and not opts.urn:
                raise TypeError("Missing required property 'credential'")
            __props__.__dict__["credential"] = credential
        super(PostgresSemanticLayerCredential, __self__).__init__(
            'dbtcloud:index/postgresSemanticLayerCredential:PostgresSemanticLayerCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration: Optional[pulumi.Input[Union['PostgresSemanticLayerCredentialConfigurationArgs', 'PostgresSemanticLayerCredentialConfigurationArgsDict']]] = None,
            credential: Optional[pulumi.Input[Union['PostgresSemanticLayerCredentialCredentialArgs', 'PostgresSemanticLayerCredentialCredentialArgsDict']]] = None) -> 'PostgresSemanticLayerCredential':
        """
        Get an existing PostgresSemanticLayerCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PostgresSemanticLayerCredentialConfigurationArgs', 'PostgresSemanticLayerCredentialConfigurationArgsDict']] configuration: Semantic Layer credential configuration details.
        :param pulumi.Input[Union['PostgresSemanticLayerCredentialCredentialArgs', 'PostgresSemanticLayerCredentialCredentialArgsDict']] credential: Postgres credential details, but used in the context of the Semantic Layer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PostgresSemanticLayerCredentialState.__new__(_PostgresSemanticLayerCredentialState)

        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["credential"] = credential
        return PostgresSemanticLayerCredential(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.PostgresSemanticLayerCredentialConfiguration']:
        """
        Semantic Layer credential configuration details.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Output['outputs.PostgresSemanticLayerCredentialCredential']:
        """
        Postgres credential details, but used in the context of the Semantic Layer.
        """
        return pulumi.get(self, "credential")

