# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectRepositoryArgs', 'ProjectRepository']

@pulumi.input_type
class ProjectRepositoryArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[builtins.int],
                 repository_id: pulumi.Input[builtins.int]):
        """
        The set of arguments for constructing a ProjectRepository resource.
        :param pulumi.Input[builtins.int] project_id: Project ID
        :param pulumi.Input[builtins.int] repository_id: Repository ID
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "repository_id", repository_id)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[builtins.int]:
        """
        Repository ID
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "repository_id", value)


@pulumi.input_type
class _ProjectRepositoryState:
    def __init__(__self__, *,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 repository_id: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ProjectRepository resources.
        :param pulumi.Input[builtins.int] project_id: Project ID
        :param pulumi.Input[builtins.int] repository_id: Repository ID
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Repository ID
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "repository_id", value)


@pulumi.type_token("dbtcloud:index/projectRepository:ProjectRepository")
class ProjectRepository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 repository_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Manages a dbt Cloud project repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        dbt_project_repository = dbtcloud.ProjectRepository("dbt_project_repository",
            project_id=dbt_project["id"],
            repository_id=dbt_repository["repositoryId"])
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_project_repository.my_project

          id = "project_id:repository_id"

        }

        import {

          to = dbtcloud_project_repository.my_project

          id = "12345:5678"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/projectRepository:ProjectRepository my_project "project_id:repository_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/projectRepository:ProjectRepository my_project 12345:5678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] project_id: Project ID
        :param pulumi.Input[builtins.int] repository_id: Repository ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectRepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a dbt Cloud project repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        dbt_project_repository = dbtcloud.ProjectRepository("dbt_project_repository",
            project_id=dbt_project["id"],
            repository_id=dbt_repository["repositoryId"])
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_project_repository.my_project

          id = "project_id:repository_id"

        }

        import {

          to = dbtcloud_project_repository.my_project

          id = "12345:5678"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/projectRepository:ProjectRepository my_project "project_id:repository_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/projectRepository:ProjectRepository my_project 12345:5678
        ```

        :param str resource_name: The name of the resource.
        :param ProjectRepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectRepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 repository_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectRepositoryArgs.__new__(ProjectRepositoryArgs)

            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
        super(ProjectRepository, __self__).__init__(
            'dbtcloud:index/projectRepository:ProjectRepository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            project_id: Optional[pulumi.Input[builtins.int]] = None,
            repository_id: Optional[pulumi.Input[builtins.int]] = None) -> 'ProjectRepository':
        """
        Get an existing ProjectRepository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] project_id: Project ID
        :param pulumi.Input[builtins.int] repository_id: Repository ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectRepositoryState.__new__(_ProjectRepositoryState)

        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["repository_id"] = repository_id
        return ProjectRepository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.int]:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[builtins.int]:
        """
        Repository ID
        """
        return pulumi.get(self, "repository_id")

