# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.int]] = None,
                 host_url: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[builtins.int] account_id: Account identifier for your dbt Cloud implementation. Instead of setting the parameter, you can set the environment
               variable `DBT_CLOUD_ACCOUNT_ID`
        :param pulumi.Input[builtins.str] host_url: URL for your dbt Cloud deployment. Instead of setting the parameter, you can set the environment variable
               `DBT_CLOUD_HOST_URL` - Defaults to https://cloud.getdbt.com/api
        :param pulumi.Input[builtins.str] token: API token for your dbt Cloud. Instead of setting the parameter, you can set the environment variable `DBT_CLOUD_TOKEN`
        """
        if account_id is None:
            account_id = _utilities.get_env_int('DBT_CLOUD_ACCOUNT_ID')
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if host_url is None:
            host_url = (_utilities.get_env('DBT_CLOUD_HOST_URL') or 'https://cloud.getdbt.com/api')
        if host_url is not None:
            pulumi.set(__self__, "host_url", host_url)
        if token is None:
            token = _utilities.get_env('DBT_CLOUD_TOKEN')
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Account identifier for your dbt Cloud implementation. Instead of setting the parameter, you can set the environment
        variable `DBT_CLOUD_ACCOUNT_ID`
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="hostUrl")
    def host_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL for your dbt Cloud deployment. Instead of setting the parameter, you can set the environment variable
        `DBT_CLOUD_HOST_URL` - Defaults to https://cloud.getdbt.com/api
        """
        return pulumi.get(self, "host_url")

    @host_url.setter
    def host_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_url", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API token for your dbt Cloud. Instead of setting the parameter, you can set the environment variable `DBT_CLOUD_TOKEN`
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token", value)


@pulumi.type_token("pulumi:providers:dbtcloud")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.int]] = None,
                 host_url: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the dbtcloud package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] account_id: Account identifier for your dbt Cloud implementation. Instead of setting the parameter, you can set the environment
               variable `DBT_CLOUD_ACCOUNT_ID`
        :param pulumi.Input[builtins.str] host_url: URL for your dbt Cloud deployment. Instead of setting the parameter, you can set the environment variable
               `DBT_CLOUD_HOST_URL` - Defaults to https://cloud.getdbt.com/api
        :param pulumi.Input[builtins.str] token: API token for your dbt Cloud. Instead of setting the parameter, you can set the environment variable `DBT_CLOUD_TOKEN`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the dbtcloud package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.int]] = None,
                 host_url: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if account_id is None:
                account_id = _utilities.get_env_int('DBT_CLOUD_ACCOUNT_ID')
            __props__.__dict__["account_id"] = pulumi.Output.from_input(account_id).apply(pulumi.runtime.to_json) if account_id is not None else None
            if host_url is None:
                host_url = (_utilities.get_env('DBT_CLOUD_HOST_URL') or 'https://cloud.getdbt.com/api')
            __props__.__dict__["host_url"] = host_url
            if token is None:
                token = _utilities.get_env('DBT_CLOUD_TOKEN')
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'dbtcloud',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="hostUrl")
    def host_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL for your dbt Cloud deployment. Instead of setting the parameter, you can set the environment variable
        `DBT_CLOUD_HOST_URL` - Defaults to https://cloud.getdbt.com/api
        """
        return pulumi.get(self, "host_url")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        API token for your dbt Cloud. Instead of setting the parameter, you can set the environment variable `DBT_CLOUD_TOKEN`
        """
        return pulumi.get(self, "token")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:dbtcloud/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

