# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceTokenArgs', 'ServiceToken']

@pulumi.input_type
class ServiceTokenArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_token_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTokenServiceTokenPermissionArgs']]]] = None,
                 state: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a ServiceToken resource.
        :param pulumi.Input[builtins.str] name: Service token name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTokenServiceTokenPermissionArgs']]] service_token_permissions: Permissions set for the service token
        :param pulumi.Input[builtins.int] state: Service token state (1 is active, 2 is inactive)
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_token_permissions is not None:
            pulumi.set(__self__, "service_token_permissions", service_token_permissions)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service token name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceTokenPermissions")
    def service_token_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTokenServiceTokenPermissionArgs']]]]:
        """
        Permissions set for the service token
        """
        return pulumi.get(self, "service_token_permissions")

    @service_token_permissions.setter
    def service_token_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTokenServiceTokenPermissionArgs']]]]):
        pulumi.set(self, "service_token_permissions", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Service token state (1 is active, 2 is inactive)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _ServiceTokenState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_token_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTokenServiceTokenPermissionArgs']]]] = None,
                 state: Optional[pulumi.Input[builtins.int]] = None,
                 token_string: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceToken resources.
        :param pulumi.Input[builtins.str] name: Service token name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTokenServiceTokenPermissionArgs']]] service_token_permissions: Permissions set for the service token
        :param pulumi.Input[builtins.int] state: Service token state (1 is active, 2 is inactive)
        :param pulumi.Input[builtins.str] token_string: Service token secret value (only accessible on creation))
        :param pulumi.Input[builtins.str] uid: Service token UID (part of the token)
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_token_permissions is not None:
            pulumi.set(__self__, "service_token_permissions", service_token_permissions)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if token_string is not None:
            pulumi.set(__self__, "token_string", token_string)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service token name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceTokenPermissions")
    def service_token_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTokenServiceTokenPermissionArgs']]]]:
        """
        Permissions set for the service token
        """
        return pulumi.get(self, "service_token_permissions")

    @service_token_permissions.setter
    def service_token_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTokenServiceTokenPermissionArgs']]]]):
        pulumi.set(self, "service_token_permissions", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Service token state (1 is active, 2 is inactive)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="tokenString")
    def token_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service token secret value (only accessible on creation))
        """
        return pulumi.get(self, "token_string")

    @token_string.setter
    def token_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token_string", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service token UID (part of the token)
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("dbtcloud:index/serviceToken:ServiceToken")
class ServiceToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_token_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceTokenServiceTokenPermissionArgs', 'ServiceTokenServiceTokenPermissionArgsDict']]]]] = None,
                 state: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        test_service_token = dbtcloud.ServiceToken("test_service_token",
            name="Test Service Token",
            service_token_permissions=[
                {
                    "permission_set": "git_admin",
                    "all_projects": True,
                },
                {
                    "permission_set": "job_admin",
                    "all_projects": False,
                    "project_id": dbt_project["id"],
                },
                {
                    "permission_set": "developer",
                    "all_projects": True,
                    "writable_environment_categories": [
                        "development",
                        "staging",
                    ],
                },
            ])
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_service_token.my_service_token

          id = "service_token_id"

        }

        import {

          to = dbtcloud_service_token.my_service_token

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/serviceToken:ServiceToken my_service_token "service_token_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/serviceToken:ServiceToken my_service_token 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Service token name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceTokenServiceTokenPermissionArgs', 'ServiceTokenServiceTokenPermissionArgsDict']]]] service_token_permissions: Permissions set for the service token
        :param pulumi.Input[builtins.int] state: Service token state (1 is active, 2 is inactive)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServiceTokenArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        test_service_token = dbtcloud.ServiceToken("test_service_token",
            name="Test Service Token",
            service_token_permissions=[
                {
                    "permission_set": "git_admin",
                    "all_projects": True,
                },
                {
                    "permission_set": "job_admin",
                    "all_projects": False,
                    "project_id": dbt_project["id"],
                },
                {
                    "permission_set": "developer",
                    "all_projects": True,
                    "writable_environment_categories": [
                        "development",
                        "staging",
                    ],
                },
            ])
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_service_token.my_service_token

          id = "service_token_id"

        }

        import {

          to = dbtcloud_service_token.my_service_token

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/serviceToken:ServiceToken my_service_token "service_token_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/serviceToken:ServiceToken my_service_token 12345
        ```

        :param str resource_name: The name of the resource.
        :param ServiceTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_token_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceTokenServiceTokenPermissionArgs', 'ServiceTokenServiceTokenPermissionArgsDict']]]]] = None,
                 state: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceTokenArgs.__new__(ServiceTokenArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["service_token_permissions"] = service_token_permissions
            __props__.__dict__["state"] = state
            __props__.__dict__["token_string"] = None
            __props__.__dict__["uid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["tokenString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceToken, __self__).__init__(
            'dbtcloud:index/serviceToken:ServiceToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            service_token_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceTokenServiceTokenPermissionArgs', 'ServiceTokenServiceTokenPermissionArgsDict']]]]] = None,
            state: Optional[pulumi.Input[builtins.int]] = None,
            token_string: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceToken':
        """
        Get an existing ServiceToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Service token name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceTokenServiceTokenPermissionArgs', 'ServiceTokenServiceTokenPermissionArgsDict']]]] service_token_permissions: Permissions set for the service token
        :param pulumi.Input[builtins.int] state: Service token state (1 is active, 2 is inactive)
        :param pulumi.Input[builtins.str] token_string: Service token secret value (only accessible on creation))
        :param pulumi.Input[builtins.str] uid: Service token UID (part of the token)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceTokenState.__new__(_ServiceTokenState)

        __props__.__dict__["name"] = name
        __props__.__dict__["service_token_permissions"] = service_token_permissions
        __props__.__dict__["state"] = state
        __props__.__dict__["token_string"] = token_string
        __props__.__dict__["uid"] = uid
        return ServiceToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Service token name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceTokenPermissions")
    def service_token_permissions(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceTokenServiceTokenPermission']]]:
        """
        Permissions set for the service token
        """
        return pulumi.get(self, "service_token_permissions")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.int]:
        """
        Service token state (1 is active, 2 is inactive)
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tokenString")
    def token_string(self) -> pulumi.Output[builtins.str]:
        """
        Service token secret value (only accessible on creation))
        """
        return pulumi.get(self, "token_string")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Service token UID (part of the token)
        """
        return pulumi.get(self, "uid")

