# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WebhookArgs', 'Webhook']

@pulumi.input_type
class WebhookArgs:
    def __init__(__self__, *,
                 client_url: pulumi.Input[builtins.str],
                 event_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 job_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Webhook resource.
        :param pulumi.Input[builtins.str] client_url: Webhooks Client URL
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] event_types: Webhooks Event Types
        :param pulumi.Input[builtins.bool] active: Webhooks active flag
        :param pulumi.Input[builtins.str] description: Webhooks Description
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] job_ids: List of job IDs to trigger the webhook. When null or empty, the webhook will trigger on all jobs
        :param pulumi.Input[builtins.str] name: Webhooks Name
        """
        pulumi.set(__self__, "client_url", client_url)
        pulumi.set(__self__, "event_types", event_types)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if job_ids is not None:
            pulumi.set(__self__, "job_ids", job_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="clientUrl")
    def client_url(self) -> pulumi.Input[builtins.str]:
        """
        Webhooks Client URL
        """
        return pulumi.get(self, "client_url")

    @client_url.setter
    def client_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_url", value)

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Webhooks Event Types
        """
        return pulumi.get(self, "event_types")

    @event_types.setter
    def event_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "event_types", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Webhooks active flag
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Webhooks Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="jobIds")
    def job_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        List of job IDs to trigger the webhook. When null or empty, the webhook will trigger on all jobs
        """
        return pulumi.get(self, "job_ids")

    @job_ids.setter
    def job_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "job_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Webhooks Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _WebhookState:
    def __init__(__self__, *,
                 account_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 client_url: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 event_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 hmac_secret: Optional[pulumi.Input[builtins.str]] = None,
                 http_status_code: Optional[pulumi.Input[builtins.str]] = None,
                 job_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Webhook resources.
        :param pulumi.Input[builtins.str] account_identifier: Webhooks Account Identifier
        :param pulumi.Input[builtins.bool] active: Webhooks active flag
        :param pulumi.Input[builtins.str] client_url: Webhooks Client URL
        :param pulumi.Input[builtins.str] description: Webhooks Description
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] event_types: Webhooks Event Types
        :param pulumi.Input[builtins.str] hmac_secret: Secret key for the webhook. Can be used to validate the authenticity of the webhook.
        :param pulumi.Input[builtins.str] http_status_code: Latest HTTP status of the webhook
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] job_ids: List of job IDs to trigger the webhook. When null or empty, the webhook will trigger on all jobs
        :param pulumi.Input[builtins.str] name: Webhooks Name
        :param pulumi.Input[builtins.str] webhook_id: Webhook's ID
        """
        if account_identifier is not None:
            pulumi.set(__self__, "account_identifier", account_identifier)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if client_url is not None:
            pulumi.set(__self__, "client_url", client_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_types is not None:
            pulumi.set(__self__, "event_types", event_types)
        if hmac_secret is not None:
            pulumi.set(__self__, "hmac_secret", hmac_secret)
        if http_status_code is not None:
            pulumi.set(__self__, "http_status_code", http_status_code)
        if job_ids is not None:
            pulumi.set(__self__, "job_ids", job_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if webhook_id is not None:
            warnings.warn("""Use `id` instead""", DeprecationWarning)
            pulumi.log.warn("""webhook_id is deprecated: Use `id` instead""")
        if webhook_id is not None:
            pulumi.set(__self__, "webhook_id", webhook_id)

    @property
    @pulumi.getter(name="accountIdentifier")
    def account_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Webhooks Account Identifier
        """
        return pulumi.get(self, "account_identifier")

    @account_identifier.setter
    def account_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_identifier", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Webhooks active flag
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="clientUrl")
    def client_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Webhooks Client URL
        """
        return pulumi.get(self, "client_url")

    @client_url.setter
    def client_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_url", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Webhooks Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Webhooks Event Types
        """
        return pulumi.get(self, "event_types")

    @event_types.setter
    def event_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "event_types", value)

    @property
    @pulumi.getter(name="hmacSecret")
    def hmac_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secret key for the webhook. Can be used to validate the authenticity of the webhook.
        """
        return pulumi.get(self, "hmac_secret")

    @hmac_secret.setter
    def hmac_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hmac_secret", value)

    @property
    @pulumi.getter(name="httpStatusCode")
    def http_status_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Latest HTTP status of the webhook
        """
        return pulumi.get(self, "http_status_code")

    @http_status_code.setter
    def http_status_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_status_code", value)

    @property
    @pulumi.getter(name="jobIds")
    def job_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        List of job IDs to trigger the webhook. When null or empty, the webhook will trigger on all jobs
        """
        return pulumi.get(self, "job_ids")

    @job_ids.setter
    def job_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "job_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Webhooks Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="webhookId")
    @_utilities.deprecated("""Use `id` instead""")
    def webhook_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Webhook's ID
        """
        return pulumi.get(self, "webhook_id")

    @webhook_id.setter
    def webhook_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "webhook_id", value)


@pulumi.type_token("dbtcloud:index/webhook:Webhook")
class Webhook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 client_url: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 event_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 job_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Webhook details

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        test_webhook = dbtcloud.Webhook("test_webhook",
            name="test-webhook",
            description="Test webhook",
            client_url="http://localhost/nothing",
            event_types=[
                "job.run.started",
                "job.run.completed",
            ],
            job_ids=[
                1234,
                5678,
            ])
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_webhook.my_webhook

          id = "webhook_id"

        }

        import {

          to = dbtcloud_webhook.my_webhook

          id = "wsu_abcdefg"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/webhook:Webhook my_webhook "webhook_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/webhook:Webhook my_webhook wsu_abcdefg
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: Webhooks active flag
        :param pulumi.Input[builtins.str] client_url: Webhooks Client URL
        :param pulumi.Input[builtins.str] description: Webhooks Description
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] event_types: Webhooks Event Types
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] job_ids: List of job IDs to trigger the webhook. When null or empty, the webhook will trigger on all jobs
        :param pulumi.Input[builtins.str] name: Webhooks Name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebhookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Webhook details

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        test_webhook = dbtcloud.Webhook("test_webhook",
            name="test-webhook",
            description="Test webhook",
            client_url="http://localhost/nothing",
            event_types=[
                "job.run.started",
                "job.run.completed",
            ],
            job_ids=[
                1234,
                5678,
            ])
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_webhook.my_webhook

          id = "webhook_id"

        }

        import {

          to = dbtcloud_webhook.my_webhook

          id = "wsu_abcdefg"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/webhook:Webhook my_webhook "webhook_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/webhook:Webhook my_webhook wsu_abcdefg
        ```

        :param str resource_name: The name of the resource.
        :param WebhookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebhookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 client_url: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 event_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 job_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebhookArgs.__new__(WebhookArgs)

            __props__.__dict__["active"] = active
            if client_url is None and not opts.urn:
                raise TypeError("Missing required property 'client_url'")
            __props__.__dict__["client_url"] = client_url
            __props__.__dict__["description"] = description
            if event_types is None and not opts.urn:
                raise TypeError("Missing required property 'event_types'")
            __props__.__dict__["event_types"] = event_types
            __props__.__dict__["job_ids"] = job_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["account_identifier"] = None
            __props__.__dict__["hmac_secret"] = None
            __props__.__dict__["http_status_code"] = None
            __props__.__dict__["webhook_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["hmacSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Webhook, __self__).__init__(
            'dbtcloud:index/webhook:Webhook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_identifier: Optional[pulumi.Input[builtins.str]] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            client_url: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            event_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            hmac_secret: Optional[pulumi.Input[builtins.str]] = None,
            http_status_code: Optional[pulumi.Input[builtins.str]] = None,
            job_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            webhook_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Webhook':
        """
        Get an existing Webhook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_identifier: Webhooks Account Identifier
        :param pulumi.Input[builtins.bool] active: Webhooks active flag
        :param pulumi.Input[builtins.str] client_url: Webhooks Client URL
        :param pulumi.Input[builtins.str] description: Webhooks Description
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] event_types: Webhooks Event Types
        :param pulumi.Input[builtins.str] hmac_secret: Secret key for the webhook. Can be used to validate the authenticity of the webhook.
        :param pulumi.Input[builtins.str] http_status_code: Latest HTTP status of the webhook
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] job_ids: List of job IDs to trigger the webhook. When null or empty, the webhook will trigger on all jobs
        :param pulumi.Input[builtins.str] name: Webhooks Name
        :param pulumi.Input[builtins.str] webhook_id: Webhook's ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebhookState.__new__(_WebhookState)

        __props__.__dict__["account_identifier"] = account_identifier
        __props__.__dict__["active"] = active
        __props__.__dict__["client_url"] = client_url
        __props__.__dict__["description"] = description
        __props__.__dict__["event_types"] = event_types
        __props__.__dict__["hmac_secret"] = hmac_secret
        __props__.__dict__["http_status_code"] = http_status_code
        __props__.__dict__["job_ids"] = job_ids
        __props__.__dict__["name"] = name
        __props__.__dict__["webhook_id"] = webhook_id
        return Webhook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountIdentifier")
    def account_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Webhooks Account Identifier
        """
        return pulumi.get(self, "account_identifier")

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[builtins.bool]:
        """
        Webhooks active flag
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="clientUrl")
    def client_url(self) -> pulumi.Output[builtins.str]:
        """
        Webhooks Client URL
        """
        return pulumi.get(self, "client_url")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Webhooks Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Webhooks Event Types
        """
        return pulumi.get(self, "event_types")

    @property
    @pulumi.getter(name="hmacSecret")
    def hmac_secret(self) -> pulumi.Output[builtins.str]:
        """
        Secret key for the webhook. Can be used to validate the authenticity of the webhook.
        """
        return pulumi.get(self, "hmac_secret")

    @property
    @pulumi.getter(name="httpStatusCode")
    def http_status_code(self) -> pulumi.Output[builtins.str]:
        """
        Latest HTTP status of the webhook
        """
        return pulumi.get(self, "http_status_code")

    @property
    @pulumi.getter(name="jobIds")
    def job_ids(self) -> pulumi.Output[Optional[Sequence[builtins.int]]]:
        """
        List of job IDs to trigger the webhook. When null or empty, the webhook will trigger on all jobs
        """
        return pulumi.get(self, "job_ids")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Webhooks Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="webhookId")
    @_utilities.deprecated("""Use `id` instead""")
    def webhook_id(self) -> pulumi.Output[builtins.str]:
        """
        Webhook's ID
        """
        return pulumi.get(self, "webhook_id")

