# kfp-server-api
This file contains REST API specification for Kubeflow Pipelines. The file is autogenerated from the swagger definition.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.14.6
- Package version: 2.14.6
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.google.com](https://www.google.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import kfp_server_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import kfp_server_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import kfp_server_api
from kfp_server_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = kfp_server_api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer
configuration = kfp_server_api.Configuration(
    host = "http://localhost",
    api_key = {
        'authorization': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['authorization'] = 'Bearer'


# Enter a context with an instance of the API client
with kfp_server_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = kfp_server_api.AuthServiceApi(api_client)
    namespace = 'namespace_example' # str | Namespace the resource belongs to. (optional)
resources = 'UNASSIGNED_RESOURCES' # str | Resource type asking for authorization. (optional) (default to 'UNASSIGNED_RESOURCES')
verb = 'UNASSIGNED_VERB' # str | Verb on the resource asking for authorization. (optional) (default to 'UNASSIGNED_VERB')

    try:
        api_response = api_instance.auth_service_authorize(namespace=namespace, resources=resources, verb=verb)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AuthServiceApi->auth_service_authorize: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthServiceApi* | [**auth_service_authorize**](docs/AuthServiceApi.md#auth_service_authorize) | **GET** /apis/v2beta1/auth | 
*ExperimentServiceApi* | [**experiment_service_archive_experiment**](docs/ExperimentServiceApi.md#experiment_service_archive_experiment) | **POST** /apis/v2beta1/experiments/{experiment_id}:archive | Archives an experiment and the experiment&#39;s runs and recurring runs.
*ExperimentServiceApi* | [**experiment_service_create_experiment**](docs/ExperimentServiceApi.md#experiment_service_create_experiment) | **POST** /apis/v2beta1/experiments | Creates a new experiment.
*ExperimentServiceApi* | [**experiment_service_delete_experiment**](docs/ExperimentServiceApi.md#experiment_service_delete_experiment) | **DELETE** /apis/v2beta1/experiments/{experiment_id} | Deletes an experiment without deleting the experiment&#39;s runs and recurring  runs. To avoid unexpected behaviors, delete an experiment&#39;s runs and recurring  runs before deleting the experiment.
*ExperimentServiceApi* | [**experiment_service_get_experiment**](docs/ExperimentServiceApi.md#experiment_service_get_experiment) | **GET** /apis/v2beta1/experiments/{experiment_id} | Finds a specific experiment by ID.
*ExperimentServiceApi* | [**experiment_service_list_experiments**](docs/ExperimentServiceApi.md#experiment_service_list_experiments) | **GET** /apis/v2beta1/experiments | Finds all experiments. Supports pagination, and sorting on certain fields.
*ExperimentServiceApi* | [**experiment_service_unarchive_experiment**](docs/ExperimentServiceApi.md#experiment_service_unarchive_experiment) | **POST** /apis/v2beta1/experiments/{experiment_id}:unarchive | Restores an archived experiment. The experiment&#39;s archived runs and recurring runs will stay archived.
*HealthzServiceApi* | [**healthz_service_get_healthz**](docs/HealthzServiceApi.md#healthz_service_get_healthz) | **GET** /apis/v2beta1/healthz | Get healthz data.
*PipelineServiceApi* | [**pipeline_service_create_pipeline**](docs/PipelineServiceApi.md#pipeline_service_create_pipeline) | **POST** /apis/v2beta1/pipelines | Creates a pipeline.
*PipelineServiceApi* | [**pipeline_service_create_pipeline_and_version**](docs/PipelineServiceApi.md#pipeline_service_create_pipeline_and_version) | **POST** /apis/v2beta1/pipelines/create | Creates a new pipeline and a new pipeline version in a single transaction.
*PipelineServiceApi* | [**pipeline_service_create_pipeline_version**](docs/PipelineServiceApi.md#pipeline_service_create_pipeline_version) | **POST** /apis/v2beta1/pipelines/{pipeline_id}/versions | Adds a pipeline version to the specified pipeline ID.
*PipelineServiceApi* | [**pipeline_service_delete_pipeline**](docs/PipelineServiceApi.md#pipeline_service_delete_pipeline) | **DELETE** /apis/v2beta1/pipelines/{pipeline_id} | Deletes a pipeline by ID. If cascade is false (default), it returns an error if the pipeline has any versions. If cascade is true, it will also delete all pipeline versions.
*PipelineServiceApi* | [**pipeline_service_delete_pipeline_version**](docs/PipelineServiceApi.md#pipeline_service_delete_pipeline_version) | **DELETE** /apis/v2beta1/pipelines/{pipeline_id}/versions/{pipeline_version_id} | Deletes a specific pipeline version by pipeline version ID and pipeline ID.
*PipelineServiceApi* | [**pipeline_service_get_pipeline**](docs/PipelineServiceApi.md#pipeline_service_get_pipeline) | **GET** /apis/v2beta1/pipelines/{pipeline_id} | Finds a specific pipeline by ID.
*PipelineServiceApi* | [**pipeline_service_get_pipeline_by_name**](docs/PipelineServiceApi.md#pipeline_service_get_pipeline_by_name) | **GET** /apis/v2beta1/pipelines/names/{name} | Finds a specific pipeline by name and namespace.
*PipelineServiceApi* | [**pipeline_service_get_pipeline_version**](docs/PipelineServiceApi.md#pipeline_service_get_pipeline_version) | **GET** /apis/v2beta1/pipelines/{pipeline_id}/versions/{pipeline_version_id} | Gets a pipeline version by pipeline version ID and pipeline ID.
*PipelineServiceApi* | [**pipeline_service_list_pipeline_versions**](docs/PipelineServiceApi.md#pipeline_service_list_pipeline_versions) | **GET** /apis/v2beta1/pipelines/{pipeline_id}/versions | Lists all pipeline versions of a given pipeline ID.
*PipelineServiceApi* | [**pipeline_service_list_pipelines**](docs/PipelineServiceApi.md#pipeline_service_list_pipelines) | **GET** /apis/v2beta1/pipelines | Finds all pipelines within a namespace.
*PipelineUploadServiceApi* | [**upload_pipeline**](docs/PipelineUploadServiceApi.md#upload_pipeline) | **POST** /apis/v2beta1/pipelines/upload | 
*PipelineUploadServiceApi* | [**upload_pipeline_version**](docs/PipelineUploadServiceApi.md#upload_pipeline_version) | **POST** /apis/v2beta1/pipelines/upload_version | 
*RecurringRunServiceApi* | [**recurring_run_service_create_recurring_run**](docs/RecurringRunServiceApi.md#recurring_run_service_create_recurring_run) | **POST** /apis/v2beta1/recurringruns | Creates a new recurring run in an experiment, given the experiment ID.
*RecurringRunServiceApi* | [**recurring_run_service_delete_recurring_run**](docs/RecurringRunServiceApi.md#recurring_run_service_delete_recurring_run) | **DELETE** /apis/v2beta1/recurringruns/{recurring_run_id} | Deletes a recurring run.
*RecurringRunServiceApi* | [**recurring_run_service_disable_recurring_run**](docs/RecurringRunServiceApi.md#recurring_run_service_disable_recurring_run) | **POST** /apis/v2beta1/recurringruns/{recurring_run_id}:disable | Stops a recurring run and all its associated runs. The recurring run is not deleted.
*RecurringRunServiceApi* | [**recurring_run_service_enable_recurring_run**](docs/RecurringRunServiceApi.md#recurring_run_service_enable_recurring_run) | **POST** /apis/v2beta1/recurringruns/{recurring_run_id}:enable | Restarts a recurring run that was previously stopped. All runs associated with the  recurring run will continue.
*RecurringRunServiceApi* | [**recurring_run_service_get_recurring_run**](docs/RecurringRunServiceApi.md#recurring_run_service_get_recurring_run) | **GET** /apis/v2beta1/recurringruns/{recurring_run_id} | Finds a specific recurring run by ID.
*RecurringRunServiceApi* | [**recurring_run_service_list_recurring_runs**](docs/RecurringRunServiceApi.md#recurring_run_service_list_recurring_runs) | **GET** /apis/v2beta1/recurringruns | Finds all recurring runs given experiment and namespace.  If experiment ID is not specified, find all recurring runs across all experiments.
*ReportServiceApi* | [**report_service_report_scheduled_workflow**](docs/ReportServiceApi.md#report_service_report_scheduled_workflow) | **POST** /apis/v2beta1/scheduledworkflows | 
*ReportServiceApi* | [**report_service_report_workflow**](docs/ReportServiceApi.md#report_service_report_workflow) | **POST** /apis/v2beta1/workflows | 
*RunServiceApi* | [**run_service_archive_run**](docs/RunServiceApi.md#run_service_archive_run) | **POST** /apis/v2beta1/runs/{run_id}:archive | Archives a run in an experiment given by run ID and experiment ID.
*RunServiceApi* | [**run_service_create_run**](docs/RunServiceApi.md#run_service_create_run) | **POST** /apis/v2beta1/runs | Creates a new run in an experiment specified by experiment ID. If experiment ID is not specified, the run is created in the default experiment.
*RunServiceApi* | [**run_service_delete_run**](docs/RunServiceApi.md#run_service_delete_run) | **DELETE** /apis/v2beta1/runs/{run_id} | Deletes a run in an experiment given by run ID and experiment ID.
*RunServiceApi* | [**run_service_get_run**](docs/RunServiceApi.md#run_service_get_run) | **GET** /apis/v2beta1/runs/{run_id} | Finds a specific run by ID.
*RunServiceApi* | [**run_service_list_runs**](docs/RunServiceApi.md#run_service_list_runs) | **GET** /apis/v2beta1/runs | Finds all runs in an experiment given by experiment ID. If experiment id is not specified, finds all runs across all experiments.
*RunServiceApi* | [**run_service_read_artifact**](docs/RunServiceApi.md#run_service_read_artifact) | **GET** /apis/v2beta1/runs/{run_id}/nodes/{node_id}/artifacts/{artifact_name}:read | Finds artifact data in a run.
*RunServiceApi* | [**run_service_retry_run**](docs/RunServiceApi.md#run_service_retry_run) | **POST** /apis/v2beta1/runs/{run_id}:retry | Re-initiates a failed or terminated run.
*RunServiceApi* | [**run_service_terminate_run**](docs/RunServiceApi.md#run_service_terminate_run) | **POST** /apis/v2beta1/runs/{run_id}:terminate | Terminates an active run.
*RunServiceApi* | [**run_service_unarchive_run**](docs/RunServiceApi.md#run_service_unarchive_run) | **POST** /apis/v2beta1/runs/{run_id}:unarchive | Restores an archived run in an experiment given by run ID and experiment ID.
*VisualizationServiceApi* | [**visualization_service_create_visualization_v1**](docs/VisualizationServiceApi.md#visualization_service_create_visualization_v1) | **POST** /apis/v2beta1/visualizations/{namespace} | 


## Documentation For Models

 - [AuthorizeRequestResources](docs/AuthorizeRequestResources.md)
 - [AuthorizeRequestVerb](docs/AuthorizeRequestVerb.md)
 - [GooglerpcStatus](docs/GooglerpcStatus.md)
 - [PipelineTaskDetailChildTask](docs/PipelineTaskDetailChildTask.md)
 - [PredicateIntValues](docs/PredicateIntValues.md)
 - [PredicateLongValues](docs/PredicateLongValues.md)
 - [PredicateStringValues](docs/PredicateStringValues.md)
 - [ProtobufAny](docs/ProtobufAny.md)
 - [ProtobufNullValue](docs/ProtobufNullValue.md)
 - [RecurringRunMode](docs/RecurringRunMode.md)
 - [V2beta1ArtifactList](docs/V2beta1ArtifactList.md)
 - [V2beta1CreatePipelineAndVersionRequest](docs/V2beta1CreatePipelineAndVersionRequest.md)
 - [V2beta1CronSchedule](docs/V2beta1CronSchedule.md)
 - [V2beta1Experiment](docs/V2beta1Experiment.md)
 - [V2beta1ExperimentStorageState](docs/V2beta1ExperimentStorageState.md)
 - [V2beta1Filter](docs/V2beta1Filter.md)
 - [V2beta1GetHealthzResponse](docs/V2beta1GetHealthzResponse.md)
 - [V2beta1ListExperimentsResponse](docs/V2beta1ListExperimentsResponse.md)
 - [V2beta1ListPipelineVersionsResponse](docs/V2beta1ListPipelineVersionsResponse.md)
 - [V2beta1ListPipelinesResponse](docs/V2beta1ListPipelinesResponse.md)
 - [V2beta1ListRecurringRunsResponse](docs/V2beta1ListRecurringRunsResponse.md)
 - [V2beta1ListRunsResponse](docs/V2beta1ListRunsResponse.md)
 - [V2beta1PeriodicSchedule](docs/V2beta1PeriodicSchedule.md)
 - [V2beta1Pipeline](docs/V2beta1Pipeline.md)
 - [V2beta1PipelineTaskDetail](docs/V2beta1PipelineTaskDetail.md)
 - [V2beta1PipelineTaskExecutorDetail](docs/V2beta1PipelineTaskExecutorDetail.md)
 - [V2beta1PipelineVersion](docs/V2beta1PipelineVersion.md)
 - [V2beta1PipelineVersionReference](docs/V2beta1PipelineVersionReference.md)
 - [V2beta1Predicate](docs/V2beta1Predicate.md)
 - [V2beta1PredicateOperation](docs/V2beta1PredicateOperation.md)
 - [V2beta1ReadArtifactResponse](docs/V2beta1ReadArtifactResponse.md)
 - [V2beta1RecurringRun](docs/V2beta1RecurringRun.md)
 - [V2beta1RecurringRunStatus](docs/V2beta1RecurringRunStatus.md)
 - [V2beta1Run](docs/V2beta1Run.md)
 - [V2beta1RunDetails](docs/V2beta1RunDetails.md)
 - [V2beta1RunStorageState](docs/V2beta1RunStorageState.md)
 - [V2beta1RuntimeConfig](docs/V2beta1RuntimeConfig.md)
 - [V2beta1RuntimeState](docs/V2beta1RuntimeState.md)
 - [V2beta1RuntimeStatus](docs/V2beta1RuntimeStatus.md)
 - [V2beta1Trigger](docs/V2beta1Trigger.md)
 - [V2beta1Url](docs/V2beta1Url.md)
 - [V2beta1Visualization](docs/V2beta1Visualization.md)
 - [V2beta1VisualizationType](docs/V2beta1VisualizationType.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: authorization
- **Location**: HTTP header


## Author

kubeflow-pipelines@google.com


